/*
 * ===================================================================
 *  TS 26.104
 *  REL-5 V5.4.0 2004-03
 *  REL-6 V6.1.0 2004-03
 *  3GPP AMR Floating-point Speech Codec
 * ===================================================================
 *
 */

/*
 * rom_enc.h
 *
 *
 * Project:
 *    AMR Floating-Point Codec
 *
 * Contains:
 *    This file contains all the tables needed by AMR encoder functions.
 *
 */
#ifndef _ROM_ENC_H_
#define _ROM_ENC_H_


#include "typedef.h"
#include "sp_enc.h"
#include "fixed.h"

#define M               10    /* Order of LP filter */
#define MP1             (M+1) /* Order of LP filter + 1 */
#define L_WINDOW        240   /* Window size in LP analysis */
#define L_NEXT          40    /* Overhead in LP analysis */
#define LTPG_MEM_SIZE   5     /* number of stored past LTP coding gains + 1 */
#define N_FRAME         7     /* old pitch gains in average calculation */
#define DTX_HIST_SIZE   8     /* DTX history size */
#define L_TOTAL         320   /* Total size of speech buffer. */
#define L_FRAME         160   /* Frame size */
#define L_FRAME_BY2     80    /* Frame size divided by 2 */
#define L_SUBFR         40    /* Subframe size */
#define L_CODE          40    /* codevector length */
#define PIT_MAX         143   /* Maximum pitch lag */
#define PIT_MIN         20    /* Minimum pitch lag */
#define PIT_MIN_MR122   18    /* Minimum pitch lag (MR122 mode) */
#define L_INTERPOL      (10+1)/* Length of filter for interpolation */
#define NPRED           4     /* number of prediction taps */
#define SHARPMIN        0     /* Minimum value of pitch sharpening */
#define MAX_PRM_SIZE    57    /* max. num. of params */
#define L_INTER_SRCH    4     /* Length of filter for CL LTP search interpolation */
#define GP_CLIP         REAL_CONST(0.95F) /* Pitch gain clipping */
#define UP_SAMP_MAX     6
#define NB_TRACK        5     /* number of tracks */
#define NB_TRACK_MR102  4     /* number of tracks mode mr102 */
#define STEP            5     /* codebook step size */
#define STEP_MR102      4     /* codebook step size mode mr102 */
#define NC              M/2   /* Order of LP filter divided by 2 */

#define SCALE_LSP_FREQ  REAL_CONST(4000.0/3.141592654)
#define SCALE_FREQ_LSP  REAL_CONST(3.141592654/4000.0)
#define SLOPE1_WGHT_LSF REAL_CONST((3.347-1.8)/(450.0-0.0))
#define SLOPE2_WGHT_LSF REAL_CONST((1.8-1.0)/(1500.0-450.0))

#define FRAME_LEN 160    /* Length (samples) of the input frame          */
#define COMPLEN 9        /* Number of sub-bands used by VAD              */
#define INV_COMPLEN 3641 /* 1.0/COMPLEN*2^15                             */
#define LOOKAHEAD 40     /* length of the lookahead used by speech coder */

#define UNITY 512        /* Scaling used with SNR calculation            */
#define UNIRSHFT 6       /* = log2(MAX_16/UNITY)                         */

#define TONE_THR REAL_CONST(0.65F)   /* Threshold for tone detection   */

/* Constants for background spectrum update */
#define ALPHA_UP1   (Float32)(1.0 - 0.95)  /* Normal update, upwards:   */
#define ALPHA_DOWN1 (Float32)(1.0 - 0.936) /* Normal update, downwards  */
#define ALPHA_UP2   (Float32)(1.0 - 0.985) /* Forced update, upwards    */
#define ALPHA_DOWN2 (Float32)(1.0 - 0.943) /* Forced update, downwards  */
#define ALPHA3      (Float32)(1.0 - 0.95)  /* Update downwards          */
#define ALPHA4      (Float32)(1.0 - 0.9)   /* For stationary estimation */
#define ALPHA5      (Float32)(1.0 - 0.5)   /* For stationary estimation */

/* Constants for VAD threshold */
#define VAD_THR_HIGH 1260 /* Highest threshold                 */
#define VAD_THR_LOW  720  /* Lowest threshold                  */
#define VAD_P1 0          /* Noise level for highest threshold */
#define VAD_P2 6300       /* Noise level for lowest threshold  */
#define VAD_SLOPE (float)(VAD_THR_LOW-VAD_THR_HIGH)/(float)(VAD_P2-VAD_P1)

/* Parameters for background spectrum recovery function */
#define STAT_COUNT 20         /* threshold of stationary detection counter         */
#define STAT_COUNT_BY_2 10    /* threshold of stationary detection counter         */
#define CAD_MIN_STAT_COUNT 5  /* threshold of stationary detection counter         */

#define STAT_THR_LEVEL 184    /* Threshold level for stationarity detection        */
#define STAT_THR 1000         /* Threshold for stationarity detection              */

/* Limits for background noise estimate */
#define NOISE_MIN 40          /* minimum */
#define NOISE_MAX 16000       /* maximum */
#define NOISE_INIT 150        /* initial */

/* Constants for VAD hangover addition */
#define HANG_NOISE_THR 100
#define BURST_LEN_HIGH_NOISE 4
#define HANG_LEN_HIGH_NOISE 7
#define BURST_LEN_LOW_NOISE 5
#define HANG_LEN_LOW_NOISE 4

/* Thresholds for signal power */
#define VAD_POW_LOW (Word32)15000/2    /* If input power is lower,                    */
                                       /*     VAD is set to 0                         */
#define POW_PITCH_THR (Word32)343040/2 /* If input power is lower, pitch              */
                                       /*     detection is ignored                    */

#define POW_COMPLEX_THR (Word32)15000/2/* If input power is lower, complex            */
                                       /* flags  value for previous frame  is un-set  */
/*
 * VAD Constants
 */

/* Constants for the filter bank */
#define LEVEL_SHIFT 0                     /* scaling                                  */
#define COEFF3   (Float32)13363/32768     /* coefficient for the 3rd order filter     */
#define COEFF5_1 (Float32)21955/32768     /* 1st coefficient the for 5th order filter */
#define COEFF5_2 (Float32)6390/32768      /* 2nd coefficient the for 5th order filter */

/* Constants for pitch detection */
#define LTHRESH 4
#define NTHRESH 4

/* Constants for complex signal VAD  */
#define CVAD_THRESH_ADAPT_HIGH  0.6F            /* threshold for adapt stopping high */
#define CVAD_THRESH_ADAPT_LOW  0.5F             /* threshold for adapt stopping low */
#define CVAD_THRESH_IN_NOISE  0.65F * 32768.0F  /* threshold going into speech on
                                                   a short term basis */
#define CVAD_THRESH_HANG  0.70F           /* threshold */
#define CVAD_HANG_LIMIT  (Word16)(100)    /* 2 second estimation time */
#define CVAD_HANG_LENGTH  (Word16)(250)   /* 5 second hangover */

#define CVAD_LOWPOW_RESET 0.40F  /* init in low power segment */
#define CVAD_MIN_CORR 0.40F      /* lowest adaptation value */

#define CVAD_BURST 20                        /* speech burst length for speech reset */
#define CVAD_ADAPT_SLOW 1.0F - 0.98F         /* threshold for slow adaption */
#define CVAD_ADAPT_FAST 1.0F - 0.92F         /* threshold for fast adaption */
#define CVAD_ADAPT_REALLY_FAST 1.0F - 0.80F  /* threshold for really fast adaption */

/* track table for algebraic code book search (MR475, MR515) */
#if 0
static Word8 trackTable[4 * 5] =
   {
      /* subframe 1; track to code; -1 do not code this position */ 0,
      1,
      0,
      1,
      - 1,
      /* subframe 2 */ 0,
      - 1,
      1,
      0,
      1,
      /* subframe 3 */ 0,
      1,
      0,
      - 1,
      1,
      /* subframe 4 */ 0,
      1,
      - 1,
      0,
      1
   };
#endif

static const real_t gamma1[M] =
{
   REAL_CONST(0.9400024414063F),
   REAL_CONST(0.8836059570313F),
   REAL_CONST(0.8305969238281F),
   REAL_CONST(0.78076171875F),
   REAL_CONST(0.7339172363281F),
   REAL_CONST(0.6898803710938F),
   REAL_CONST(0.6484985351563F),
   REAL_CONST(0.6095886230469F),
   REAL_CONST(0.5730285644531F),
   REAL_CONST(0.5386352539063F)
};

/*
 *  gamma1 for the 12k2 coder
 */
static const real_t gamma1_12k2[M] =
{
   REAL_CONST(0.8999938964844F),
   REAL_CONST(0.8099975585938F),
   REAL_CONST(0.72900390625F),
   REAL_CONST(0.6560974121094F),
   REAL_CONST(0.5904846191406F),
   REAL_CONST(0.5314331054688F),
   REAL_CONST(0.478271484375F),
   REAL_CONST(0.4304504394531F),
   REAL_CONST(0.3873901367188F),
   REAL_CONST(0.3486633300781F)
};

static const real_t gamma2[M] =
{
   REAL_CONST(0.6000061035156F),
   REAL_CONST(0.3600158691406F),
   REAL_CONST(0.2160034179688F),
   REAL_CONST(0.1296081542969F),
   REAL_CONST(0.0777587890625F),
   REAL_CONST(0.04666137695313F),
   REAL_CONST(0.02798461914063F),
   REAL_CONST(0.01678466796875F),
   REAL_CONST(0.01007080078125F),
   REAL_CONST(0.00604248046875F)
};

/* 1/6 resolution interpolation filter  (-3 dB at 3600 Hz)
 * Note: the 1/3 resolution filter is simply a subsampled
 *       version of the 1/6 resolution filter, i.e. it uses
 *       every second coefficient:
 *
 *       inter_6(1/3)[k] = inter_6(1/3)[2*k], 0 <= k <= 3*L_INTER10
 */
#if 0
static Float32 b60[UP_SAMP_MAX*(L_INTERPOL-1)+1] =
{
   0.898529F,
   0.865051F,
   0.769257F,
   0.624054F,
   0.448639F,
   0.265289F,
   0.0959167F,
   - 0.0412598F,
   - 0.134338F,
   - 0.178986F,
   - 0.178528F,
   - 0.142609F,
   - 0.0849304F,
   - 0.0205078F,
   0.0369568F,
   0.0773926F,
   0.0955200F,
   0.0912781F,
   0.0689392F,
   0.0357056F,
   0.000000F,
   - 0.0305481F,
   - 0.0504150F,
   - 0.0570068F,
   - 0.0508423F,
   - 0.0350037F,
   - 0.0141602F,
   0.00665283F,
   0.0230713F,
   0.0323486F,
   0.0335388F,
   0.0275879F,
   0.0167847F,
   0.00411987F,
   - 0.00747681F,
   - 0.0156860F,
   - 0.0193481F,
   - 0.0183716F,
   - 0.0137634F,
   - 0.00704956F,
   0.000000F,
   0.00582886F,
   0.00939941F,
   0.0103760F,
   0.00903320F,
   0.00604248F,
   0.00238037F,
   - 0.00109863F,
   - 0.00366211F,
   - 0.00497437F,
   - 0.00503540F,
   - 0.00402832F,
   - 0.00241089F,
   - 0.000579834F,
   0.00103760F,
   0.00222778F,
   0.00277710F,
   0.00271606F,
   0.00213623F,
   0.00115967F,
   0.000000F
};
#endif

/* same in fixed-point */
static const Word32 inter6[61] =
{
   29443,
   28346,
   25207,
   20449,
   14701,
   8693,
   3143,
   - 1352,
   - 4402,
   - 5865,
   - 5850,
   - 4673,
   - 2783,
   - 672,
   1211,
   2536,
   3130,
   2991,
   2259,
   1170,
   0,
   - 1001,
   - 1652,
   - 1868,
   - 1666,
   - 1147,
   - 464,
   218,
   756,
   1060,
   1099,
   904,
   550,
   135,
   - 245,
   - 514,
   - 634,
   - 602,
   - 451,
   - 231,
   0,
   191,
   308,
   340,
   296,
   198,
   78,
   - 36,
   - 120,
   - 163,
   - 165,
   - 132,
   - 79,
   - 19,
   34,
   73,
   91,
   89,
   70,
   38,
   0
};

static const Word16 startPos1[2] =
   {
      1,
      3
   };

static const Word16 startPos2[4] =
   {
      0,
      1,
      2,
      4
   };

static const Word16 startPos[2 * 4 * 2] =
   {
      0,
      2,
      0,
      3,
      0,
      2,
      0,
      3,
      1,
      3,
      2,
      4,
      1,
      4,
      1,
      4
   };

/* Scalar quantization tables of the pitch gain and the codebook gain. */
#define NB_QUA_PITCH 16

static const real_t qua_gain_pitch[NB_QUA_PITCH] =
{
    REAL_CONST(0.0F),
    REAL_CONST(0.20001220703125F),
    REAL_CONST(0.400146484375F),
    REAL_CONST(0.5F),
    REAL_CONST(0.5999755859375F),
    REAL_CONST(0.70001220703125F),
    REAL_CONST(0.75F),
    REAL_CONST(0.79998779296875F),
    REAL_CONST(0.8499755859375F),
    REAL_CONST(0.9000244140625F),
    REAL_CONST(0.95001220703125F),
    REAL_CONST(1.0F),
    REAL_CONST(1.04998779296875F),
    REAL_CONST(1.0999755859375F),
    REAL_CONST(1.1500244140625F),
    REAL_CONST(1.20001220703125F)
};

static const real_t qua_gain_pitch_MR122[NB_QUA_PITCH] =
{
    REAL_CONST(0.0F),
    REAL_CONST(0.199951171875F),
    REAL_CONST(0.400146484375F),
    REAL_CONST(0.5F),
    REAL_CONST(0.599853515625F),
    REAL_CONST(0.699951171875F),
    REAL_CONST(0.75F),
    REAL_CONST(0.7998046875F),
    REAL_CONST(0.849853515625F),
    REAL_CONST(0.89990234375F),
    REAL_CONST(0.949951171875F),
    REAL_CONST(1.0F),
    REAL_CONST(1.0498046875F),
    REAL_CONST(1.099853515625F),
    REAL_CONST(1.14990234375F),
    REAL_CONST(1.199951171875F)
};

#define NB_QUA_CODE 32
static const real_t gain_factor[NB_QUA_CODE] =
{
/* gain factor (g_fac) */
   REAL_CONST(0.0776367F),
   REAL_CONST(0.100586F),
   REAL_CONST(0.130859F),
   REAL_CONST(0.170410F),
   REAL_CONST(0.204590F),
   REAL_CONST(0.235352F),
   REAL_CONST(0.270508F),
   REAL_CONST(0.311035F),
   REAL_CONST(0.357910F),
   REAL_CONST(0.411133F),
   REAL_CONST(0.473145F),
   REAL_CONST(0.543945F),
   REAL_CONST(0.625488F),
   REAL_CONST(0.719238F),
   REAL_CONST(0.827148F),
   REAL_CONST(0.951172F),
   REAL_CONST(1.09424F),
   REAL_CONST(1.25830F),
   REAL_CONST(1.44678F),
   REAL_CONST(1.66406F),
   REAL_CONST(1.91357F),
   REAL_CONST(2.20068F),
   REAL_CONST(2.53076F),
   REAL_CONST(2.91016F),
   REAL_CONST(3.34717F),
   REAL_CONST(3.84912F),
   REAL_CONST(4.42627F),
   REAL_CONST(5.09033F),
   REAL_CONST(6.10840F),
   REAL_CONST(7.94092F),
   REAL_CONST(10.3232F),
   REAL_CONST(13.4204F)
};

static const Word8 gray[8] =
   {
      0,
      1,
      3,
      2,
      6,
      4,
      5,
      7
   };

/*
 * grid[0] = 1.0;
 * grid[61] = -1.0;
 * for (i = 1; i < 61; i++)
 *    grid[i] = (Float32)cos((6.283185307*i)/(2.0*60));
 */
static const real_t grid[61] =
{
   REAL_CONST(1.00000F),
   REAL_CONST(0.998630F),
   REAL_CONST(0.994522F),
   REAL_CONST(0.987688F),
   REAL_CONST(0.978148F),
   REAL_CONST(0.965926F),
   REAL_CONST(0.951057F),
   REAL_CONST(0.933580F),
   REAL_CONST(0.913545F),
   REAL_CONST(0.891007F),
   REAL_CONST(0.866025F),
   REAL_CONST(0.838671F),
   REAL_CONST(0.809017F),
   REAL_CONST(0.777146F),
   REAL_CONST(0.743145F),
   REAL_CONST(0.707107F),
   REAL_CONST(0.669131F),
   REAL_CONST(0.629320F),
   REAL_CONST(0.587785F),
   REAL_CONST(0.544639F),
   REAL_CONST(0.500000F),
   REAL_CONST(0.453990F),
   REAL_CONST(0.406737F),
   REAL_CONST(0.358368F),
   REAL_CONST(0.309017F),
   REAL_CONST(0.258819F),
   REAL_CONST(0.207912F),
   REAL_CONST(0.156434F),
   REAL_CONST(0.104528F),
   REAL_CONST(0.0523360F),
   REAL_CONST(4.48966e-011F),
   REAL_CONST(- 0.0523360F),
   REAL_CONST(- 0.104528F),
   REAL_CONST(- 0.156434F),
   REAL_CONST(- 0.207912F),
   REAL_CONST(- 0.258819F),
   REAL_CONST(- 0.309017F),
   REAL_CONST(- 0.358368F),
   REAL_CONST(- 0.406737F),
   REAL_CONST(- 0.453990F),
   REAL_CONST(- 0.500000F),
   REAL_CONST(- 0.544639F),
   REAL_CONST(- 0.587785F),
   REAL_CONST(- 0.629320F),
   REAL_CONST(- 0.669131F),
   REAL_CONST(- 0.707107F),
   REAL_CONST(- 0.743145F),
   REAL_CONST(- 0.777146F),
   REAL_CONST(- 0.809017F),
   REAL_CONST(- 0.838671F),
   REAL_CONST(- 0.866025F),
   REAL_CONST(- 0.891007F),
   REAL_CONST(- 0.913545F),
   REAL_CONST(- 0.933580F),
   REAL_CONST(- 0.951057F),
   REAL_CONST(- 0.965926F),
   REAL_CONST(- 0.978148F),
   REAL_CONST(- 0.987688F),
   REAL_CONST(- 0.994522F),
   REAL_CONST(- 0.998630F),
   REAL_CONST(- 1.00000F)
};

/*
 * 1/6 resolution interpolation filter  (-3 dB at 3600 Hz)
 * Note: The IS641 (7.4) 1/3 resolution filter is simply a subsampled
 *       version of the 1/6 resolution filter, i.e. it uses
 *       every second coefficient:
 *
 *       b24[k](1/3) = b24[2*k](1/6), 0 <= k <= 3*L_INTER_SRCH
 */
static const real_t b24[UP_SAMP_MAX*L_INTER_SRCH+1] =
{
   REAL_CONST(0.900848F),
   REAL_CONST(0.864136F),
   REAL_CONST(0.760071F),
   REAL_CONST(0.605408F),
   REAL_CONST(0.424072F),
   REAL_CONST(0.242462F),
   REAL_CONST(0.0840759F),
   REAL_CONST(- 0.0343933F),
   REAL_CONST(- 0.105560F),
   REAL_CONST(- 0.131348F),
   REAL_CONST(- 0.121124F),
   REAL_CONST(- 0.0884705F),
   REAL_CONST(- 0.0476379F),
   REAL_CONST(- 0.0102539F),
   REAL_CONST(0.0162964F),
   REAL_CONST(0.0296021F),
   REAL_CONST(0.0312195F),
   REAL_CONST(0.0251160F),
   REAL_CONST(0.0157471F),
   REAL_CONST(0.00671387F),
   REAL_CONST(0.000000F),
   REAL_CONST(- 0.00399780F),
   REAL_CONST(- 0.00592041F),
   REAL_CONST(- 0.00656128F),
   REAL_CONST(0.000000F)
};

/*
 * Exponential Window coefficients used to weight the autocorrelation
 * coefficients for 60 Hz bandwidth expansion of high pitched voice
 * before Levinson-Durbin recursion to compute the LPC coefficients.
 *
 * lagwindow[i] =  exp( -0.5*(2*pi*F0*(i+1)/Fs)^2 ); i = 0,...,9
 * F0 = 60 Hz, Fs = 8000 Hz
 */
static real_32_t lag_wind[M] =
{
   REAL_CONST(0.99889028F),
   REAL_CONST(0.99556851F),
   REAL_CONST(0.99005681F),
   REAL_CONST(0.98239160F),
   REAL_CONST(0.97262347F),
   REAL_CONST(0.96081644F),
   REAL_CONST(0.94704735F),
   REAL_CONST(0.93140495F),
   REAL_CONST(0.91398895F),
   REAL_CONST(0.89490914F)
};

/* initialization table for lsp history in DTX */
static const real_32_t lsp_init_data[M] =
{
    REAL_CONST(0.9595F),
    REAL_CONST(0.8413F),
    REAL_CONST(0.6549F),
    REAL_CONST(0.4154F),
    REAL_CONST(0.1423F),
    REAL_CONST(-0.1423F),
    REAL_CONST(-0.4154F),
    REAL_CONST(-0.6549F),
    REAL_CONST(-0.8413F),
    REAL_CONST(-0.9595F)
};


#define PAST_RQ_INIT_SIZE 8

/* initalization table for MA predictor in dtx mode */
static const real_t past_rq_init[80] =
{
    REAL_CONST(-62.9883F),
    REAL_CONST(-77.6367F),
    REAL_CONST(-107.178F),
    REAL_CONST(-154.785F),
    REAL_CONST(-160.156F),
    REAL_CONST(-188.721F),
    REAL_CONST(-173.584F),
    REAL_CONST(-122.559F),
    REAL_CONST(-65.4297F),
    REAL_CONST(-47.1191F),
    REAL_CONST(-0.488281F),
    REAL_CONST(30.5176F),
    REAL_CONST(29.7852F),
    REAL_CONST(-9.52148F),
    REAL_CONST(-2.19727F),
    REAL_CONST(25.6348F),
    REAL_CONST(31.4941F),
    REAL_CONST(69.0918F),
    REAL_CONST(90.8203F),
    REAL_CONST(140.381F),
    REAL_CONST(-67.627F),
    REAL_CONST(-79.1016F),
    REAL_CONST(-48.0957F),
    REAL_CONST(-118.896F),
    REAL_CONST(-108.643F),
    REAL_CONST(-88.3789F),
    REAL_CONST(-71.2891F),
    REAL_CONST(-6.5918F),
    REAL_CONST(43.2129F),
    REAL_CONST(132.568F),
    REAL_CONST(83.4961F),
    REAL_CONST(126.221F),
    REAL_CONST(125.977F),
    REAL_CONST(31.7383F),
    REAL_CONST(6.5918F),
    REAL_CONST(-25.3906F),
    REAL_CONST(-29.2969F),
    REAL_CONST(-34.1797F),
    REAL_CONST(-18.0664F),
    REAL_CONST(-13.6719F),
    REAL_CONST(-137.695F),
    REAL_CONST(-230.225F),
    REAL_CONST(-371.094F),
    REAL_CONST(-235.596F),
    REAL_CONST(-198.73F),
    REAL_CONST(-128.418F),
    REAL_CONST(-78.6133F),
    REAL_CONST(-0.488281F),
    REAL_CONST(38.8184F),
    REAL_CONST(160.4F),
    REAL_CONST(-76.1719F),
    REAL_CONST(-69.3359F),
    REAL_CONST(-94.2383F),
    REAL_CONST(-145.752F),
    REAL_CONST(-120.361F),
    REAL_CONST(-128.418F),
    REAL_CONST(-102.051F),
    REAL_CONST(-55.9082F),
    REAL_CONST(25.6348F),
    REAL_CONST(109.619F),
    REAL_CONST(-135.986F),
    REAL_CONST(-212.402F),
    REAL_CONST(-262.451F),
    REAL_CONST(-224.365F),
    REAL_CONST(-231.934F),
    REAL_CONST(-183.594F),
    REAL_CONST(-173.096F),
    REAL_CONST(-77.1484F),
    REAL_CONST(15.1367F),
    REAL_CONST(118.652F),
    REAL_CONST(-76.6602F),
    REAL_CONST(-46.6309F),
    REAL_CONST(-49.5605F),
    REAL_CONST(-80.5664F),
    REAL_CONST(-39.0625F),
    REAL_CONST(-25.1465F),
    REAL_CONST(-12.4512F),
    REAL_CONST(31.9824F),
    REAL_CONST(82.5195F),
    REAL_CONST(125.732F)
};

/* LSF means ->normalize frequency domain */

static const real_32_t mean_lsf_3[10] =
{
    REAL_CONST(377.441F),
    REAL_CONST(554.688F),
    REAL_CONST(922.363F),
    REAL_CONST(1339.84F),
    REAL_CONST(1702.15F),
    REAL_CONST(2046.39F),
    REAL_CONST(2452.88F),
    REAL_CONST(2741.46F),
    REAL_CONST(3116.70F),
    REAL_CONST(3348.14F)
};

static const real_32_t mean_lsf_5[10] =
{
    REAL_CONST(337.891F),
    REAL_CONST(507.080F),
    REAL_CONST(834.961F),
    REAL_CONST(1247.07F),
    REAL_CONST(1646.00F),
    REAL_CONST(1982.91F),
    REAL_CONST(2407.96F),
    REAL_CONST(2708.01F),
    REAL_CONST(3104.00F),
    REAL_CONST(3344.97F)
};

/* LSF prediction factors (not in MR122) */
static const real_t pred_fac[10] =
{
    REAL_CONST(0.291626F),
    REAL_CONST(0.328644F),
    REAL_CONST(0.383636F),
    REAL_CONST(0.405640F),
    REAL_CONST(0.438873F),
    REAL_CONST(0.355560F),
    REAL_CONST(0.323120F),
    REAL_CONST(0.298065F),
    REAL_CONST(0.262238F),
    REAL_CONST(0.197876F)
};

/* codebooks from IS641 */
#define DICO1_SIZE_3  256
#define DICO2_SIZE_3  512
#define DICO3_SIZE_3  512
static const real_32_t dico1_lsf_3[] =
{
    REAL_CONST(1.46484F),
    REAL_CONST(20.0195F),
    REAL_CONST(-31.9824F),
    REAL_CONST(37.5977F),
    REAL_CONST(-13.6719F),
    REAL_CONST(-179.443F),
    REAL_CONST(44.6777F),
    REAL_CONST(-15.8691F),
    REAL_CONST(-64.6973F),
    REAL_CONST(2.19727F),
    REAL_CONST(-51.2695F),
    REAL_CONST(-88.1348F),
    REAL_CONST(27.5879F),
    REAL_CONST(175.293F),
    REAL_CONST(443.604F),
    REAL_CONST(246.582F),
    REAL_CONST(296.387F),
    REAL_CONST(384.033F),
    REAL_CONST(209.229F),
    REAL_CONST(325.439F),
    REAL_CONST(555.664F),
    REAL_CONST(201.904F),
    REAL_CONST(382.813F),
    REAL_CONST(471.924F),
    REAL_CONST(175.049F),
    REAL_CONST(485.596F),
    REAL_CONST(538.574F),
    REAL_CONST(204.590F),
    REAL_CONST(286.133F),
    REAL_CONST(445.068F),
    REAL_CONST(176.025F),
    REAL_CONST(244.141F),
    REAL_CONST(525.879F),
    REAL_CONST(69.8242F),
    REAL_CONST(116.211F),
    REAL_CONST(368.408F),
    REAL_CONST(-60.3027F),
    REAL_CONST(-129.639F),
    REAL_CONST(56.1523F),
    REAL_CONST(35.8887F),
    REAL_CONST(-20.0195F),
    REAL_CONST(138.916F),
    REAL_CONST(6.34766F),
    REAL_CONST(-43.2129F),
    REAL_CONST(-230.469F),
    REAL_CONST(-6.59180F),
    REAL_CONST(-66.6504F),
    REAL_CONST(168.945F),
    REAL_CONST(-40.0391F),
    REAL_CONST(-64.4531F),
    REAL_CONST(-44.6777F),
    REAL_CONST(54.6875F),
    REAL_CONST(192.871F),
    REAL_CONST(253.662F),
    REAL_CONST(219.482F),
    REAL_CONST(230.957F),
    REAL_CONST(146.729F),
    REAL_CONST(118.408F),
    REAL_CONST(188.232F),
    REAL_CONST(280.762F),
    REAL_CONST(127.930F),
    REAL_CONST(165.283F),
    REAL_CONST(220.459F),
    REAL_CONST(-34.1797F),
    REAL_CONST(91.5527F),
    REAL_CONST(189.941F),
    REAL_CONST(100.098F),
    REAL_CONST(165.039F),
    REAL_CONST(104.736F),
    REAL_CONST(73.4863F),
    REAL_CONST(129.395F),
    REAL_CONST(246.338F),
    REAL_CONST(175.537F),
    REAL_CONST(157.715F),
    REAL_CONST(9.27734F),
    REAL_CONST(55.1758F),
    REAL_CONST(89.5996F),
    REAL_CONST(9.76563F),
    REAL_CONST(35.4004F),
    REAL_CONST(-10.9863F),
    REAL_CONST(-123.291F),
    REAL_CONST(70.8008F),
    REAL_CONST(29.5410F),
    REAL_CONST(-29.5410F),
    REAL_CONST(73.7305F),
    REAL_CONST(31.0059F),
    REAL_CONST(40.5273F),
    REAL_CONST(-30.2734F),
    REAL_CONST(-93.5059F),
    REAL_CONST(-233.398F),
    REAL_CONST(-87.4023F),
    REAL_CONST(-111.084F),
    REAL_CONST(-238.525F),
    REAL_CONST(174.561F),
    REAL_CONST(214.355F),
    REAL_CONST(218.262F),
    REAL_CONST(238.770F),
    REAL_CONST(225.342F),
    REAL_CONST(51.5137F),
    REAL_CONST(116.455F),
    REAL_CONST(66.4063F),
    REAL_CONST(15.6250F),
    REAL_CONST(45.8984F),
    REAL_CONST(-19.0430F),
    REAL_CONST(4.15039F),
    REAL_CONST(-34.9121F),
    REAL_CONST(-15.8691F),
    REAL_CONST(9.27734F),
    REAL_CONST(156.982F),
    REAL_CONST(143.066F),
    REAL_CONST(151.611F),
    REAL_CONST(-32.7148F),
    REAL_CONST(-104.004F),
    REAL_CONST(-158.936F),
    REAL_CONST(84.7168F),
    REAL_CONST(133.057F),
    REAL_CONST(688.477F),
    REAL_CONST(290.039F),
    REAL_CONST(665.527F),
    REAL_CONST(596.191F),
    REAL_CONST(34.6680F),
    REAL_CONST(-19.5313F),
    REAL_CONST(423.584F),
    REAL_CONST(69.0918F),
    REAL_CONST(31.7383F),
    REAL_CONST(112.549F),
    REAL_CONST(-63.9648F),
    REAL_CONST(-97.4121F),
    REAL_CONST(-279.541F),
    REAL_CONST(-100.342F),
    REAL_CONST(37.8418F),
    REAL_CONST(104.980F),
    REAL_CONST(80.3223F),
    REAL_CONST(91.5527F),
    REAL_CONST(190.186F),
    REAL_CONST(12.9395F),
    REAL_CONST(-55.1758F),
    REAL_CONST(-33.9355F),
    REAL_CONST(-31.4941F),
    REAL_CONST(-57.6172F),
    REAL_CONST(410.645F),
    REAL_CONST(69.5801F),
    REAL_CONST(181.641F),
    REAL_CONST(323.975F),
    REAL_CONST(180.176F),
    REAL_CONST(170.166F),
    REAL_CONST(406.250F),
    REAL_CONST(76.1719F),
    REAL_CONST(99.8535F),
    REAL_CONST(64.9414F),
    REAL_CONST(79.3457F),
    REAL_CONST(175.781F),
    REAL_CONST(32.9590F),
    REAL_CONST(0.244141F),
    REAL_CONST(53.9551F),
    REAL_CONST(110.596F),
    REAL_CONST(1.95313F),
    REAL_CONST(49.5605F),
    REAL_CONST(35.4004F),
    REAL_CONST(72.9980F),
    REAL_CONST(156.250F),
    REAL_CONST(185.547F),
    REAL_CONST(7.08008F),
    REAL_CONST(114.258F),
    REAL_CONST(155.762F),
    REAL_CONST(25.1465F),
    REAL_CONST(104.736F),
    REAL_CONST(92.5293F),
    REAL_CONST(102.539F),
    REAL_CONST(232.910F),
    REAL_CONST(227.539F),
    REAL_CONST(323.730F),
    REAL_CONST(295.410F),
    REAL_CONST(307.129F),
    REAL_CONST(171.875F),
    REAL_CONST(247.070F),
    REAL_CONST(281.250F),
    REAL_CONST(-40.5273F),
    REAL_CONST(-108.398F),
    REAL_CONST(-64.9414F),
    REAL_CONST(-77.1484F),
    REAL_CONST(-31.7383F),
    REAL_CONST(-91.7969F),
    REAL_CONST(46.6309F),
    REAL_CONST(281.006F),
    REAL_CONST(464.844F),
    REAL_CONST(-58.5938F),
    REAL_CONST(-132.568F),
    REAL_CONST(-307.617F),
    REAL_CONST(-27.3438F),
    REAL_CONST(65.4297F),
    REAL_CONST(294.678F),
    REAL_CONST(17.0898F),
    REAL_CONST(259.277F),
    REAL_CONST(386.475F),
    REAL_CONST(67.8711F),
    REAL_CONST(332.031F),
    REAL_CONST(384.277F),
    REAL_CONST(-62.9883F),
    REAL_CONST(-66.4063F),
    REAL_CONST(-187.500F),
    REAL_CONST(4.63867F),
    REAL_CONST(137.451F),
    REAL_CONST(546.875F),
    REAL_CONST(-0.732422F),
    REAL_CONST(-64.6973F),
    REAL_CONST(32.9590F),
    REAL_CONST(-72.0215F),
    REAL_CONST(-144.287F),
    REAL_CONST(-94.7266F),
    REAL_CONST(34.1797F),
    REAL_CONST(86.4258F),
    REAL_CONST(-50.2930F),
    REAL_CONST(-63.4766F),
    REAL_CONST(-123.047F),
    REAL_CONST(-194.092F),
    REAL_CONST(-105.713F),
    REAL_CONST(-175.293F),
    REAL_CONST(-322.021F),
    REAL_CONST(26.6113F),
    REAL_CONST(80.8105F),
    REAL_CONST(234.863F),
    REAL_CONST(-104.736F),
    REAL_CONST(-21.2402F),
    REAL_CONST(159.180F),
    REAL_CONST(-72.2656F),
    REAL_CONST(104.004F),
    REAL_CONST(248.779F),
    REAL_CONST(-58.3496F),
    REAL_CONST(189.209F),
    REAL_CONST(207.764F),
    REAL_CONST(119.385F),
    REAL_CONST(325.684F),
    REAL_CONST(261.963F),
    REAL_CONST(-81.5430F),
    REAL_CONST(-81.0547F),
    REAL_CONST(6.10352F),
    REAL_CONST(132.568F),
    REAL_CONST(294.434F),
    REAL_CONST(441.162F),
    REAL_CONST(79.5898F),
    REAL_CONST(14.8926F),
    REAL_CONST(177.490F),
    REAL_CONST(141.113F),
    REAL_CONST(207.275F),
    REAL_CONST(343.018F),
    REAL_CONST(-50.7813F),
    REAL_CONST(-67.6270F),
    REAL_CONST(80.3223F),
    REAL_CONST(-37.1094F),
    REAL_CONST(15.6250F),
    REAL_CONST(163.330F),
    REAL_CONST(-105.957F),
    REAL_CONST(-165.527F),
    REAL_CONST(-177.490F),
    REAL_CONST(-110.840F),
    REAL_CONST(-17.3340F),
    REAL_CONST(61.2793F),
    REAL_CONST(147.705F),
    REAL_CONST(117.188F),
    REAL_CONST(62.0117F),
    REAL_CONST(-117.676F),
    REAL_CONST(2.68555F),
    REAL_CONST(243.164F),
    REAL_CONST(-70.5566F),
    REAL_CONST(96.4355F),
    REAL_CONST(118.652F),
    REAL_CONST(176.270F),
    REAL_CONST(256.104F),
    REAL_CONST(351.563F),
    REAL_CONST(-7.32422F),
    REAL_CONST(-77.1484F),
    REAL_CONST(-191.895F),
    REAL_CONST(-25.8789F),
    REAL_CONST(-28.0762F),
    REAL_CONST(-151.123F),
    REAL_CONST(210.205F),
    REAL_CONST(359.863F),
    REAL_CONST(344.727F),
    REAL_CONST(257.568F),
    REAL_CONST(333.496F),
    REAL_CONST(289.063F),
    REAL_CONST(198.242F),
    REAL_CONST(302.002F),
    REAL_CONST(225.830F),
    REAL_CONST(10.2539F),
    REAL_CONST(-61.2793F),
    REAL_CONST(-140.625F),
    REAL_CONST(83.4961F),
    REAL_CONST(34.4238F),
    REAL_CONST(-110.840F),
    REAL_CONST(-41.0156F),
    REAL_CONST(-19.5313F),
    REAL_CONST(331.787F),
    REAL_CONST(-83.4961F),
    REAL_CONST(-160.156F),
    REAL_CONST(-430.420F),
    REAL_CONST(24.4141F),
    REAL_CONST(200.439F),
    REAL_CONST(177.002F),
    REAL_CONST(241.699F),
    REAL_CONST(182.373F),
    REAL_CONST(195.313F),
    REAL_CONST(81.0547F),
    REAL_CONST(107.422F),
    REAL_CONST(138.672F),
    REAL_CONST(161.865F),
    REAL_CONST(92.5293F),
    REAL_CONST(208.008F),
    REAL_CONST(27.3438F),
    REAL_CONST(40.2832F),
    REAL_CONST(-90.0879F),
    REAL_CONST(145.752F),
    REAL_CONST(222.168F),
    REAL_CONST(68.8477F),
    REAL_CONST(-1.95313F),
    REAL_CONST(203.613F),
    REAL_CONST(312.744F),
    REAL_CONST(-85.9375F),
    REAL_CONST(139.648F),
    REAL_CONST(169.678F),
    REAL_CONST(112.793F),
    REAL_CONST(548.340F),
    REAL_CONST(440.918F),
    REAL_CONST(84.2285F),
    REAL_CONST(46.3867F),
    REAL_CONST(335.449F),
    REAL_CONST(101.563F),
    REAL_CONST(223.389F),
    REAL_CONST(528.809F),
    REAL_CONST(41.0156F),
    REAL_CONST(-20.0195F),
    REAL_CONST(68.3594F),
    REAL_CONST(-125.977F),
    REAL_CONST(-108.887F),
    REAL_CONST(205.078F),
    REAL_CONST(11.4746F),
    REAL_CONST(130.127F),
    REAL_CONST(10.7422F),
    REAL_CONST(-88.3789F),
    REAL_CONST(-173.584F),
    REAL_CONST(-279.053F),
    REAL_CONST(5.37109F),
    REAL_CONST(47.1191F),
    REAL_CONST(359.375F),
    REAL_CONST(-20.7520F),
    REAL_CONST(56.8848F),
    REAL_CONST(442.627F),
    REAL_CONST(-15.1367F),
    REAL_CONST(141.357F),
    REAL_CONST(367.188F),
    REAL_CONST(134.277F),
    REAL_CONST(230.469F),
    REAL_CONST(427.002F),
    REAL_CONST(176.514F),
    REAL_CONST(158.691F),
    REAL_CONST(280.273F),
    REAL_CONST(237.305F),
    REAL_CONST(215.820F),
    REAL_CONST(340.576F),
    REAL_CONST(-103.760F),
    REAL_CONST(156.982F),
    REAL_CONST(0.000000F),
    REAL_CONST(244.141F),
    REAL_CONST(232.422F),
    REAL_CONST(268.066F),
    REAL_CONST(60.7910F),
    REAL_CONST(353.027F),
    REAL_CONST(164.063F),
    REAL_CONST(-81.5430F),
    REAL_CONST(-21.2402F),
    REAL_CONST(530.273F),
    REAL_CONST(-135.254F),
    REAL_CONST(459.473F),
    REAL_CONST(652.344F),
    REAL_CONST(34.1797F),
    REAL_CONST(445.801F),
    REAL_CONST(452.393F),
    REAL_CONST(224.609F),
    REAL_CONST(427.002F),
    REAL_CONST(632.324F),
    REAL_CONST(262.695F),
    REAL_CONST(471.924F),
    REAL_CONST(497.559F),
    REAL_CONST(-33.4473F),
    REAL_CONST(-108.154F),
    REAL_CONST(-379.639F),
    REAL_CONST(309.814F),
    REAL_CONST(286.621F),
    REAL_CONST(114.258F),
    REAL_CONST(-120.361F),
    REAL_CONST(-29.7852F),
    REAL_CONST(371.338F),
    REAL_CONST(-110.107F),
    REAL_CONST(252.197F),
    REAL_CONST(296.387F),
    REAL_CONST(117.676F),
    REAL_CONST(413.818F),
    REAL_CONST(272.949F),
    REAL_CONST(198.975F),
    REAL_CONST(158.447F),
    REAL_CONST(93.7500F),
    REAL_CONST(-108.887F),
    REAL_CONST(-168.945F),
    REAL_CONST(26.1230F),
    REAL_CONST(-77.8809F),
    REAL_CONST(-147.705F),
    REAL_CONST(-28.8086F),
    REAL_CONST(-50.5371F),
    REAL_CONST(-123.291F),
    REAL_CONST(128.174F),
    REAL_CONST(-114.258F),
    REAL_CONST(-2.92969F),
    REAL_CONST(667.969F),
    REAL_CONST(18.3105F),
    REAL_CONST(472.168F),
    REAL_CONST(318.604F),
    REAL_CONST(214.844F),
    REAL_CONST(575.684F),
    REAL_CONST(553.467F),
    REAL_CONST(313.721F),
    REAL_CONST(384.521F),
    REAL_CONST(489.258F),
    REAL_CONST(-11.7188F),
    REAL_CONST(-74.2188F),
    REAL_CONST(-289.551F),
    REAL_CONST(-106.201F),
    REAL_CONST(-112.549F),
    REAL_CONST(-61.2793F),
    REAL_CONST(-89.3555F),
    REAL_CONST(-98.6328F),
    REAL_CONST(-133.545F),
    REAL_CONST(-70.5566F),
    REAL_CONST(-147.705F),
    REAL_CONST(-145.752F),
    REAL_CONST(-131.348F),
    REAL_CONST(-197.754F),
    REAL_CONST(-40.2832F),
    REAL_CONST(-29.2969F),
    REAL_CONST(0.732422F),
    REAL_CONST(86.9141F),
    REAL_CONST(156.006F),
    REAL_CONST(302.979F),
    REAL_CONST(366.699F),
    REAL_CONST(23.4375F),
    REAL_CONST(43.2129F),
    REAL_CONST(183.105F),
    REAL_CONST(-106.201F),
    REAL_CONST(-142.822F),
    REAL_CONST(-286.621F),
    REAL_CONST(-86.9141F),
    REAL_CONST(26.6113F),
    REAL_CONST(-19.2871F),
    REAL_CONST(-118.408F),
    REAL_CONST(70.3125F),
    REAL_CONST(489.502F),
    REAL_CONST(2.19727F),
    REAL_CONST(272.461F),
    REAL_CONST(178.467F),
    REAL_CONST(214.844F),
    REAL_CONST(520.996F),
    REAL_CONST(230.957F),
    REAL_CONST(-64.6973F),
    REAL_CONST(386.963F),
    REAL_CONST(260.010F),
    REAL_CONST(282.471F),
    REAL_CONST(295.410F),
    REAL_CONST(205.811F),
    REAL_CONST(-121.582F),
    REAL_CONST(-163.086F),
    REAL_CONST(105.225F),
    REAL_CONST(91.3086F),
    REAL_CONST(78.3691F),
    REAL_CONST(-55.9082F),
    REAL_CONST(351.563F),
    REAL_CONST(512.939F),
    REAL_CONST(337.158F),
    REAL_CONST(109.619F),
    REAL_CONST(112.549F),
    REAL_CONST(281.982F),
    REAL_CONST(-25.6348F),
    REAL_CONST(9.52148F),
    REAL_CONST(-93.7500F),
    REAL_CONST(-64.2090F),
    REAL_CONST(89.5996F),
    REAL_CONST(44.4336F),
    REAL_CONST(-90.5762F),
    REAL_CONST(-161.133F),
    REAL_CONST(188.721F),
    REAL_CONST(-45.8984F),
    REAL_CONST(281.006F),
    REAL_CONST(237.061F),
    REAL_CONST(325.439F),
    REAL_CONST(398.438F),
    REAL_CONST(350.342F),
    REAL_CONST(188.965F),
    REAL_CONST(309.326F),
    REAL_CONST(298.096F),
    REAL_CONST(-117.676F),
    REAL_CONST(-203.125F),
    REAL_CONST(-363.525F),
    REAL_CONST(-57.8613F),
    REAL_CONST(-51.2695F),
    REAL_CONST(209.961F),
    REAL_CONST(217.285F),
    REAL_CONST(394.287F),
    REAL_CONST(259.766F),
    REAL_CONST(115.234F),
    REAL_CONST(259.277F),
    REAL_CONST(291.016F),
    REAL_CONST(45.1660F),
    REAL_CONST(262.939F),
    REAL_CONST(241.455F),
    REAL_CONST(-138.672F),
    REAL_CONST(-242.188F),
    REAL_CONST(-416.016F),
    REAL_CONST(-109.619F),
    REAL_CONST(-220.215F),
    REAL_CONST(-498.779F),
    REAL_CONST(-34.6680F),
    REAL_CONST(-92.0410F),
    REAL_CONST(-111.816F),
    REAL_CONST(-51.2695F),
    REAL_CONST(-135.254F),
    REAL_CONST(-251.221F),
    REAL_CONST(-2.68555F),
    REAL_CONST(276.611F),
    REAL_CONST(552.979F),
    REAL_CONST(-80.3223F),
    REAL_CONST(-164.795F),
    REAL_CONST(-218.018F),
    REAL_CONST(-61.0352F),
    REAL_CONST(160.400F),
    REAL_CONST(289.795F),
    REAL_CONST(126.709F),
    REAL_CONST(368.652F),
    REAL_CONST(434.326F),
    REAL_CONST(126.953F),
    REAL_CONST(131.592F),
    REAL_CONST(342.529F),
    REAL_CONST(128.662F),
    REAL_CONST(346.924F),
    REAL_CONST(317.871F),
    REAL_CONST(-137.451F),
    REAL_CONST(-212.646F),
    REAL_CONST(-304.688F),
    REAL_CONST(-35.8887F),
    REAL_CONST(-113.037F),
    REAL_CONST(214.600F),
    REAL_CONST(-18.5547F),
    REAL_CONST(569.824F),
    REAL_CONST(693.359F),
    REAL_CONST(137.451F),
    REAL_CONST(628.174F),
    REAL_CONST(582.275F),
    REAL_CONST(154.297F),
    REAL_CONST(470.215F),
    REAL_CONST(712.891F),
    REAL_CONST(175.537F),
    REAL_CONST(493.896F),
    REAL_CONST(449.219F),
    REAL_CONST(-133.057F),
    REAL_CONST(-176.514F),
    REAL_CONST(270.508F),
    REAL_CONST(31.4941F),
    REAL_CONST(-30.5176F),
    REAL_CONST(215.820F),
    REAL_CONST(345.947F),
    REAL_CONST(398.438F),
    REAL_CONST(225.830F),
    REAL_CONST(-22.9492F),
    REAL_CONST(382.324F),
    REAL_CONST(427.490F),
    REAL_CONST(-83.2520F),
    REAL_CONST(374.268F),
    REAL_CONST(378.662F),
    REAL_CONST(144.287F),
    REAL_CONST(96.4355F),
    REAL_CONST(-66.8945F),
    REAL_CONST(-18.5547F),
    REAL_CONST(239.502F),
    REAL_CONST(691.162F),
    REAL_CONST(37.3535F),
    REAL_CONST(728.760F),
    REAL_CONST(450.195F),
    REAL_CONST(251.953F),
    REAL_CONST(626.221F),
    REAL_CONST(671.143F),
    REAL_CONST(368.164F),
    REAL_CONST(691.406F),
    REAL_CONST(458.740F),
    REAL_CONST(193.115F),
    REAL_CONST(292.725F),
    REAL_CONST(131.348F),
    REAL_CONST(-46.3867F),
    REAL_CONST(-110.596F),
    REAL_CONST(363.525F),
    REAL_CONST(-67.8711F),
    REAL_CONST(-133.789F),
    REAL_CONST(282.715F),
    REAL_CONST(-59.8145F),
    REAL_CONST(473.877F),
    REAL_CONST(499.023F),
    REAL_CONST(250.000F),
    REAL_CONST(380.859F),
    REAL_CONST(402.832F),
    REAL_CONST(125.000F),
    REAL_CONST(61.7676F),
    REAL_CONST(113.770F),
    REAL_CONST(-15.1367F),
    REAL_CONST(-78.8574F),
    REAL_CONST(281.006F),
    REAL_CONST(-115.479F),
    REAL_CONST(-91.7969F),
    REAL_CONST(123.779F),
    REAL_CONST(-105.713F),
    REAL_CONST(336.914F),
    REAL_CONST(527.832F),
    REAL_CONST(219.482F),
    REAL_CONST(474.365F),
    REAL_CONST(352.783F),
    REAL_CONST(32.7148F),
    REAL_CONST(171.875F),
    REAL_CONST(107.422F),
    REAL_CONST(112.305F),
    REAL_CONST(128.174F),
    REAL_CONST(-6.83594F),
    REAL_CONST(-109.863F),
    REAL_CONST(68.1152F),
    REAL_CONST(326.660F),
    REAL_CONST(0.000000F),
    REAL_CONST(237.061F),
    REAL_CONST(61.5234F),
    REAL_CONST(-108.643F),
    REAL_CONST(-153.076F),
    REAL_CONST(-241.943F),
    REAL_CONST(-84.9609F),
    REAL_CONST(-146.973F),
    REAL_CONST(-347.656F),
    REAL_CONST(97.1680F),
    REAL_CONST(173.828F),
    REAL_CONST(404.297F),
    REAL_CONST(-26.1230F),
    REAL_CONST(76.6602F),
    REAL_CONST(-43.4570F),
    REAL_CONST(22.7051F),
    REAL_CONST(543.457F),
    REAL_CONST(546.387F),
    REAL_CONST(126.465F),
    REAL_CONST(207.275F),
    REAL_CONST(160.156F),
    REAL_CONST(-112.793F),
    REAL_CONST(-173.584F),
    REAL_CONST(-109.131F),
    REAL_CONST(42.4805F),
    REAL_CONST(-8.30078F),
    REAL_CONST(290.771F),
    REAL_CONST(-29.0527F),
    REAL_CONST(10.2539F),
    REAL_CONST(245.361F),
    REAL_CONST(-90.8203F),
    REAL_CONST(66.8945F),
    REAL_CONST(185.059F),
    REAL_CONST(252.930F),
    REAL_CONST(574.219F),
    REAL_CONST(448.730F),
    REAL_CONST(164.795F),
    REAL_CONST(420.898F),
    REAL_CONST(365.723F),
    REAL_CONST(104.980F),
    REAL_CONST(313.965F),
    REAL_CONST(520.752F),
    REAL_CONST(-31.4941F),
    REAL_CONST(-107.178F),
    REAL_CONST(0.000000F),
    REAL_CONST(-91.0645F),
    REAL_CONST(195.313F),
    REAL_CONST(523.438F),
    REAL_CONST(1.46484F),
    REAL_CONST(387.451F),
    REAL_CONST(604.980F),
    REAL_CONST(116.699F),
    REAL_CONST(145.508F),
    REAL_CONST(519.531F),
    REAL_CONST(-104.492F),
    REAL_CONST(-179.688F),
    REAL_CONST(367.432F),
    REAL_CONST(93.9941F),
    REAL_CONST(43.4570F),
    REAL_CONST(239.258F),
    REAL_CONST(33.9355F),
    REAL_CONST(109.619F),
    REAL_CONST(299.072F),
    REAL_CONST(-128.418F),
    REAL_CONST(-205.566F),
    REAL_CONST(-239.746F),
    REAL_CONST(35.4004F),
    REAL_CONST(379.395F),
    REAL_CONST(303.223F),
    REAL_CONST(152.100F),
    REAL_CONST(353.516F),
    REAL_CONST(160.156F),
    REAL_CONST(85.2051F),
    REAL_CONST(248.047F),
    REAL_CONST(361.816F),
    REAL_CONST(7.56836F),
    REAL_CONST(-68.3594F),
    REAL_CONST(101.318F),
    REAL_CONST(-77.1484F),
    REAL_CONST(176.758F),
    REAL_CONST(400.635F),
    REAL_CONST(87.8906F),
    REAL_CONST(258.301F),
    REAL_CONST(135.742F),
    REAL_CONST(-106.445F),
    REAL_CONST(-87.4023F),
    REAL_CONST(293.213F),
    REAL_CONST(-86.6699F),
    REAL_CONST(274.170F),
    REAL_CONST(473.389F),
    REAL_CONST(97.9004F),
    REAL_CONST(386.719F),
    REAL_CONST(548.828F),
    REAL_CONST(-128.662F),
    REAL_CONST(-247.070F),
    REAL_CONST(86.6699F),
    REAL_CONST(56.8848F),
    REAL_CONST(58.1055F),
    REAL_CONST(545.166F),
    REAL_CONST(-134.277F),
    REAL_CONST(-218.994F),
    REAL_CONST(-156.006F),
    REAL_CONST(-89.1113F),
    REAL_CONST(-122.314F),
    REAL_CONST(477.783F),
    REAL_CONST(94.9707F),
    REAL_CONST(454.102F),
    REAL_CONST(395.752F),
    REAL_CONST(39.5508F),
    REAL_CONST(276.367F),
    REAL_CONST(308.594F),
    REAL_CONST(-57.8613F),
    REAL_CONST(286.621F),
    REAL_CONST(339.355F),
    REAL_CONST(-156.250F),
    REAL_CONST(-100.342F),
    REAL_CONST(28.3203F),
    REAL_CONST(-55.6641F),
    REAL_CONST(413.574F),
    REAL_CONST(561.035F),
    REAL_CONST(400.146F),
    REAL_CONST(533.691F),
    REAL_CONST(553.467F),
    REAL_CONST(137.207F),
    REAL_CONST(310.791F),
    REAL_CONST(648.926F),
    REAL_CONST(78.8574F),
    REAL_CONST(82.5195F),
    REAL_CONST(433.105F),
    REAL_CONST(141.113F),
    REAL_CONST(270.264F),
    REAL_CONST(208.008F),
    REAL_CONST(5.37109F),
    REAL_CONST(145.020F),
    REAL_CONST(228.027F),
    REAL_CONST(-34.9121F),
    REAL_CONST(175.293F),
    REAL_CONST(108.887F)
};

static const real_32_t dico2_lsf_3[] =
{
    REAL_CONST(12.2070F),
    REAL_CONST(17.3340F),
    REAL_CONST(-2.19727F),
    REAL_CONST(-82.5195F),
    REAL_CONST(-170.410F),
    REAL_CONST(-343.506F),
    REAL_CONST(24.9023F),
    REAL_CONST(-33.6914F),
    REAL_CONST(-200.195F),
    REAL_CONST(-75.6836F),
    REAL_CONST(-114.502F),
    REAL_CONST(-280.029F),
    REAL_CONST(101.074F),
    REAL_CONST(16.3574F),
    REAL_CONST(-65.1855F),
    REAL_CONST(258.789F),
    REAL_CONST(198.730F),
    REAL_CONST(351.807F),
    REAL_CONST(377.930F),
    REAL_CONST(332.031F),
    REAL_CONST(310.547F),
    REAL_CONST(428.223F),
    REAL_CONST(462.646F),
    REAL_CONST(405.518F),
    REAL_CONST(492.920F),
    REAL_CONST(520.752F),
    REAL_CONST(444.336F),
    REAL_CONST(441.406F),
    REAL_CONST(565.918F),
    REAL_CONST(450.439F),
    REAL_CONST(157.227F),
    REAL_CONST(-22.7051F),
    REAL_CONST(110.840F),
    REAL_CONST(209.473F),
    REAL_CONST(80.3223F),
    REAL_CONST(-33.2031F),
    REAL_CONST(119.385F),
    REAL_CONST(-62.9883F),
    REAL_CONST(-31.2500F),
    REAL_CONST(-48.3398F),
    REAL_CONST(-181.885F),
    REAL_CONST(-10.0098F),
    REAL_CONST(-12.6953F),
    REAL_CONST(-64.6973F),
    REAL_CONST(-240.479F),
    REAL_CONST(84.4727F),
    REAL_CONST(33.4473F),
    REAL_CONST(116.943F),
    REAL_CONST(-425.049F),
    REAL_CONST(-182.617F),
    REAL_CONST(-166.992F),
    REAL_CONST(-283.936F),
    REAL_CONST(-421.143F),
    REAL_CONST(-89.5996F),
    REAL_CONST(-218.506F),
    REAL_CONST(-279.541F),
    REAL_CONST(-191.406F),
    REAL_CONST(-119.141F),
    REAL_CONST(-230.957F),
    REAL_CONST(-236.328F),
    REAL_CONST(-20.7520F),
    REAL_CONST(-95.2148F),
    REAL_CONST(-177.002F),
    REAL_CONST(52.4902F),
    REAL_CONST(-83.0078F),
    REAL_CONST(-41.7480F),
    REAL_CONST(249.023F),
    REAL_CONST(223.633F),
    REAL_CONST(480.713F),
    REAL_CONST(137.695F),
    REAL_CONST(43.7012F),
    REAL_CONST(182.129F),
    REAL_CONST(161.621F),
    REAL_CONST(238.525F),
    REAL_CONST(423.340F),
    REAL_CONST(216.553F),
    REAL_CONST(151.855F),
    REAL_CONST(223.145F),
    REAL_CONST(229.248F),
    REAL_CONST(208.984F),
    REAL_CONST(284.424F),
    REAL_CONST(75.4395F),
    REAL_CONST(167.969F),
    REAL_CONST(196.045F),
    REAL_CONST(223.877F),
    REAL_CONST(39.3066F),
    REAL_CONST(139.160F),
    REAL_CONST(28.8086F),
    REAL_CONST(-4.88281F),
    REAL_CONST(-69.0918F),
    REAL_CONST(-199.219F),
    REAL_CONST(-10.2539F),
    REAL_CONST(49.8047F),
    REAL_CONST(-299.805F),
    REAL_CONST(-79.3457F),
    REAL_CONST(-112.793F),
    REAL_CONST(-235.107F),
    REAL_CONST(-49.3164F),
    REAL_CONST(-34.9121F),
    REAL_CONST(-241.211F),
    REAL_CONST(-118.164F),
    REAL_CONST(-88.1348F),
    REAL_CONST(-171.387F),
    REAL_CONST(-238.770F),
    REAL_CONST(-116.455F),
    REAL_CONST(-73.7305F),
    REAL_CONST(-192.871F),
    REAL_CONST(-290.039F),
    REAL_CONST(-24.4141F),
    REAL_CONST(-191.895F),
    REAL_CONST(-265.625F),
    REAL_CONST(-257.324F),
    REAL_CONST(-231.201F),
    REAL_CONST(-411.133F),
    REAL_CONST(-49.3164F),
    REAL_CONST(-205.811F),
    REAL_CONST(-190.918F),
    REAL_CONST(-253.662F),
    REAL_CONST(-336.426F),
    REAL_CONST(-219.971F),
    REAL_CONST(-152.344F),
    REAL_CONST(-26.8555F),
    REAL_CONST(-20.7520F),
    REAL_CONST(86.9141F),
    REAL_CONST(52.0020F),
    REAL_CONST(-2.44141F),
    REAL_CONST(-120.361F),
    REAL_CONST(88.8672F),
    REAL_CONST(188.965F),
    REAL_CONST(103.760F),
    REAL_CONST(200.684F),
    REAL_CONST(116.943F),
    REAL_CONST(-20.2637F),
    REAL_CONST(135.986F),
    REAL_CONST(126.953F),
    REAL_CONST(-242.188F),
    REAL_CONST(-380.859F),
    REAL_CONST(-139.648F),
    REAL_CONST(-147.217F),
    REAL_CONST(-180.908F),
    REAL_CONST(-6.34766F),
    REAL_CONST(-122.559F),
    REAL_CONST(-155.762F),
    REAL_CONST(-220.459F),
    REAL_CONST(51.0254F),
    REAL_CONST(74.7070F),
    REAL_CONST(35.8887F),
    REAL_CONST(-77.1484F),
    REAL_CONST(-144.775F),
    REAL_CONST(-145.508F),
    REAL_CONST(-20.7520F),
    REAL_CONST(-51.5137F),
    REAL_CONST(-54.9316F),
    REAL_CONST(-224.121F),
    REAL_CONST(-129.150F),
    REAL_CONST(28.5645F),
    REAL_CONST(56.8848F),
    REAL_CONST(-107.178F),
    REAL_CONST(-180.176F),
    REAL_CONST(268.799F),
    REAL_CONST(183.350F),
    REAL_CONST(154.541F),
    REAL_CONST(355.713F),
    REAL_CONST(418.945F),
    REAL_CONST(368.896F),
    REAL_CONST(430.908F),
    REAL_CONST(355.713F),
    REAL_CONST(222.168F),
    REAL_CONST(273.926F),
    REAL_CONST(282.227F),
    REAL_CONST(207.275F),
    REAL_CONST(330.566F),
    REAL_CONST(211.914F),
    REAL_CONST(114.746F),
    REAL_CONST(-212.646F),
    REAL_CONST(-280.762F),
    REAL_CONST(-438.477F),
    REAL_CONST(-212.646F),
    REAL_CONST(-210.205F),
    REAL_CONST(-242.188F),
    REAL_CONST(-28.8086F),
    REAL_CONST(37.8418F),
    REAL_CONST(51.7578F),
    REAL_CONST(-256.592F),
    REAL_CONST(-207.275F),
    REAL_CONST(-147.949F),
    REAL_CONST(-272.705F),
    REAL_CONST(-451.416F),
    REAL_CONST(-671.387F),
    REAL_CONST(-248.779F),
    REAL_CONST(-348.389F),
    REAL_CONST(-456.299F),
    REAL_CONST(90.3320F),
    REAL_CONST(-44.9219F),
    REAL_CONST(-101.074F),
    REAL_CONST(234.131F),
    REAL_CONST(120.361F),
    REAL_CONST(25.3906F),
    REAL_CONST(233.887F),
    REAL_CONST(253.662F),
    REAL_CONST(132.568F),
    REAL_CONST(37.5977F),
    REAL_CONST(159.424F),
    REAL_CONST(49.0723F),
    REAL_CONST(304.932F),
    REAL_CONST(123.779F),
    REAL_CONST(36.6211F),
    REAL_CONST(161.865F),
    REAL_CONST(122.803F),
    REAL_CONST(56.1523F),
    REAL_CONST(152.100F),
    REAL_CONST(189.697F),
    REAL_CONST(164.795F),
    REAL_CONST(160.889F),
    REAL_CONST(21.4844F),
    REAL_CONST(-26.8555F),
    REAL_CONST(205.811F),
    REAL_CONST(59.5703F),
    REAL_CONST(54.6875F),
    REAL_CONST(93.2617F),
    REAL_CONST(132.080F),
    REAL_CONST(73.7305F),
    REAL_CONST(176.758F),
    REAL_CONST(105.713F),
    REAL_CONST(162.598F),
    REAL_CONST(284.668F),
    REAL_CONST(179.199F),
    REAL_CONST(83.2520F),
    REAL_CONST(-33.6914F),
    REAL_CONST(4.88281F),
    REAL_CONST(-96.9238F),
    REAL_CONST(-288.818F),
    REAL_CONST(-103.516F),
    REAL_CONST(-11.2305F),
    REAL_CONST(-78.3691F),
    REAL_CONST(-85.9375F),
    REAL_CONST(-30.2734F),
    REAL_CONST(325.439F),
    REAL_CONST(249.268F),
    REAL_CONST(263.672F),
    REAL_CONST(63.9648F),
    REAL_CONST(89.3555F),
    REAL_CONST(176.514F),
    REAL_CONST(225.098F),
    REAL_CONST(69.0918F),
    REAL_CONST(-134.521F),
    REAL_CONST(7.56836F),
    REAL_CONST(-155.273F),
    REAL_CONST(-149.170F),
    REAL_CONST(-168.213F),
    REAL_CONST(-170.166F),
    REAL_CONST(-101.318F),
    REAL_CONST(-232.422F),
    REAL_CONST(-190.186F),
    REAL_CONST(-49.0723F),
    REAL_CONST(-324.463F),
    REAL_CONST(-145.996F),
    REAL_CONST(-87.6465F),
    REAL_CONST(-232.666F),
    REAL_CONST(-313.721F),
    REAL_CONST(40.5273F),
    REAL_CONST(120.361F),
    REAL_CONST(74.4629F),
    REAL_CONST(53.9551F),
    REAL_CONST(206.543F),
    REAL_CONST(171.631F),
    REAL_CONST(148.926F),
    REAL_CONST(205.078F),
    REAL_CONST(228.516F),
    REAL_CONST(188.965F),
    REAL_CONST(-176.514F),
    REAL_CONST(-323.242F),
    REAL_CONST(-307.861F),
    REAL_CONST(-87.1582F),
    REAL_CONST(-250.244F),
    REAL_CONST(-338.867F),
    REAL_CONST(-267.578F),
    REAL_CONST(-335.938F),
    REAL_CONST(-89.1113F),
    REAL_CONST(-345.703F),
    REAL_CONST(-459.229F),
    REAL_CONST(-148.438F),
    REAL_CONST(-438.965F),
    REAL_CONST(-421.631F),
    REAL_CONST(-164.551F),
    REAL_CONST(-133.057F),
    REAL_CONST(-286.377F),
    REAL_CONST(-171.631F),
    REAL_CONST(165.527F),
    REAL_CONST(191.895F),
    REAL_CONST(36.1328F),
    REAL_CONST(-30.0293F),
    REAL_CONST(169.922F),
    REAL_CONST(314.453F),
    REAL_CONST(157.227F),
    REAL_CONST(85.4492F),
    REAL_CONST(-2.44141F),
    REAL_CONST(101.074F),
    REAL_CONST(149.902F),
    REAL_CONST(3.66211F),
    REAL_CONST(33.4473F),
    REAL_CONST(83.9844F),
    REAL_CONST(-51.5137F),
    REAL_CONST(-198.730F),
    REAL_CONST(-369.141F),
    REAL_CONST(-199.951F),
    REAL_CONST(-95.4590F),
    REAL_CONST(-227.051F),
    REAL_CONST(-143.555F),
    REAL_CONST(11.4746F),
    REAL_CONST(-144.287F),
    REAL_CONST(-219.238F),
    REAL_CONST(-221.924F),
    REAL_CONST(-267.822F),
    REAL_CONST(-39.7949F),
    REAL_CONST(-310.547F),
    REAL_CONST(-284.912F),
    REAL_CONST(-38.3301F),
    REAL_CONST(-357.422F),
    REAL_CONST(-372.314F),
    REAL_CONST(-94.9707F),
    REAL_CONST(-311.035F),
    REAL_CONST(-290.039F),
    REAL_CONST(-152.344F),
    REAL_CONST(163.818F),
    REAL_CONST(52.0020F),
    REAL_CONST(110.840F),
    REAL_CONST(30.2734F),
    REAL_CONST(-66.8945F),
    REAL_CONST(-128.174F),
    REAL_CONST(-177.979F),
    REAL_CONST(-121.094F),
    REAL_CONST(-37.1094F),
    REAL_CONST(-328.125F),
    REAL_CONST(29.7852F),
    REAL_CONST(32.9590F),
    REAL_CONST(-709.229F),
    REAL_CONST(-143.799F),
    REAL_CONST(-96.1914F),
    REAL_CONST(-421.875F),
    REAL_CONST(107.666F),
    REAL_CONST(-12.2070F),
    REAL_CONST(360.352F),
    REAL_CONST(220.703F),
    REAL_CONST(192.139F),
    REAL_CONST(77.1484F),
    REAL_CONST(57.6172F),
    REAL_CONST(-107.422F),
    REAL_CONST(-84.7168F),
    REAL_CONST(52.9785F),
    REAL_CONST(100.830F),
    REAL_CONST(-222.412F),
    REAL_CONST(-223.877F),
    REAL_CONST(29.5410F),
    REAL_CONST(-111.084F),
    REAL_CONST(-227.539F),
    REAL_CONST(49.3164F),
    REAL_CONST(-22.4609F),
    REAL_CONST(-113.525F),
    REAL_CONST(-91.5527F),
    REAL_CONST(119.141F),
    REAL_CONST(95.2148F),
    REAL_CONST(115.723F),
    REAL_CONST(213.867F),
    REAL_CONST(177.979F),
    REAL_CONST(77.1484F),
    REAL_CONST(-443.115F),
    REAL_CONST(-320.313F),
    REAL_CONST(-163.330F),
    REAL_CONST(21.2402F),
    REAL_CONST(234.863F),
    REAL_CONST(105.469F),
    REAL_CONST(137.451F),
    REAL_CONST(-60.7910F),
    REAL_CONST(-258.301F),
    REAL_CONST(61.0352F),
    REAL_CONST(69.5801F),
    REAL_CONST(269.775F),
    REAL_CONST(278.564F),
    REAL_CONST(104.248F),
    REAL_CONST(169.922F),
    REAL_CONST(-253.418F),
    REAL_CONST(-406.250F),
    REAL_CONST(-386.230F),
    REAL_CONST(-231.445F),
    REAL_CONST(84.4727F),
    REAL_CONST(39.0625F),
    REAL_CONST(-75.4395F),
    REAL_CONST(-66.4063F),
    REAL_CONST(-209.473F),
    REAL_CONST(163.574F),
    REAL_CONST(152.344F),
    REAL_CONST(305.176F),
    REAL_CONST(-230.469F),
    REAL_CONST(-99.6094F),
    REAL_CONST(-162.598F),
    REAL_CONST(-147.949F),
    REAL_CONST(-78.1250F),
    REAL_CONST(-93.7500F),
    REAL_CONST(-120.117F),
    REAL_CONST(56.1523F),
    REAL_CONST(15.8691F),
    REAL_CONST(81.5430F),
    REAL_CONST(-12.2070F),
    REAL_CONST(-3.90625F),
    REAL_CONST(-3.90625F),
    REAL_CONST(-168.457F),
    REAL_CONST(-341.064F),
    REAL_CONST(437.256F),
    REAL_CONST(418.945F),
    REAL_CONST(341.553F),
    REAL_CONST(604.980F),
    REAL_CONST(503.662F),
    REAL_CONST(342.773F),
    REAL_CONST(303.955F),
    REAL_CONST(359.131F),
    REAL_CONST(348.145F),
    REAL_CONST(-93.2617F),
    REAL_CONST(-253.174F),
    REAL_CONST(-0.488281F),
    REAL_CONST(42.2363F),
    REAL_CONST(-97.1680F),
    REAL_CONST(279.541F),
    REAL_CONST(364.014F),
    REAL_CONST(494.141F),
    REAL_CONST(439.697F),
    REAL_CONST(188.477F),
    REAL_CONST(311.035F),
    REAL_CONST(367.676F),
    REAL_CONST(348.877F),
    REAL_CONST(423.584F),
    REAL_CONST(488.525F),
    REAL_CONST(263.428F),
    REAL_CONST(297.363F),
    REAL_CONST(310.791F),
    REAL_CONST(-281.738F),
    REAL_CONST(-451.904F),
    REAL_CONST(-324.463F),
    REAL_CONST(-197.266F),
    REAL_CONST(-276.611F),
    REAL_CONST(-267.578F),
    REAL_CONST(-110.107F),
    REAL_CONST(-252.197F),
    REAL_CONST(-420.410F),
    REAL_CONST(15.8691F),
    REAL_CONST(141.113F),
    REAL_CONST(-20.5078F),
    REAL_CONST(-360.352F),
    REAL_CONST(-594.238F),
    REAL_CONST(-434.082F),
    REAL_CONST(-186.768F),
    REAL_CONST(-333.496F),
    REAL_CONST(-120.605F),
    REAL_CONST(-53.2227F),
    REAL_CONST(-145.020F),
    REAL_CONST(-227.295F),
    REAL_CONST(82.2754F),
    REAL_CONST(-57.6172F),
    REAL_CONST(137.207F),
    REAL_CONST(575.439F),
    REAL_CONST(649.902F),
    REAL_CONST(473.145F),
    REAL_CONST(363.525F),
    REAL_CONST(311.523F),
    REAL_CONST(213.379F),
    REAL_CONST(46.1426F),
    REAL_CONST(87.4023F),
    REAL_CONST(91.3086F),
    REAL_CONST(-370.850F),
    REAL_CONST(-556.885F),
    REAL_CONST(-572.754F),
    REAL_CONST(-236.084F),
    REAL_CONST(-310.303F),
    REAL_CONST(-511.475F),
    REAL_CONST(-153.320F),
    REAL_CONST(-290.039F),
    REAL_CONST(-376.465F),
    REAL_CONST(405.518F),
    REAL_CONST(254.639F),
    REAL_CONST(133.301F),
    REAL_CONST(137.939F),
    REAL_CONST(259.033F),
    REAL_CONST(178.711F),
    REAL_CONST(-15.6250F),
    REAL_CONST(-204.102F),
    REAL_CONST(-105.957F),
    REAL_CONST(-106.445F),
    REAL_CONST(-23.4375F),
    REAL_CONST(49.5605F),
    REAL_CONST(263.184F),
    REAL_CONST(296.875F),
    REAL_CONST(399.414F),
    REAL_CONST(221.436F),
    REAL_CONST(374.512F),
    REAL_CONST(240.723F),
    REAL_CONST(79.5898F),
    REAL_CONST(235.596F),
    REAL_CONST(206.299F),
    REAL_CONST(34.6680F),
    REAL_CONST(-20.5078F),
    REAL_CONST(48.0957F),
    REAL_CONST(114.746F),
    REAL_CONST(580.811F),
    REAL_CONST(383.301F),
    REAL_CONST(276.611F),
    REAL_CONST(114.746F),
    REAL_CONST(296.387F),
    REAL_CONST(96.4355F),
    REAL_CONST(335.938F),
    REAL_CONST(292.969F),
    REAL_CONST(274.658F),
    REAL_CONST(254.395F),
    REAL_CONST(84.9609F),
    REAL_CONST(-132.568F),
    REAL_CONST(-301.270F),
    REAL_CONST(-91.7969F),
    REAL_CONST(-52.4902F),
    REAL_CONST(-44.1895F),
    REAL_CONST(117.432F),
    REAL_CONST(-475.342F),
    REAL_CONST(-395.752F),
    REAL_CONST(-51.2695F),
    REAL_CONST(-183.105F),
    REAL_CONST(-289.307F),
    REAL_CONST(95.2148F),
    REAL_CONST(7.08008F),
    REAL_CONST(-97.4121F),
    REAL_CONST(6.59180F),
    REAL_CONST(200.195F),
    REAL_CONST(301.758F),
    REAL_CONST(184.326F),
    REAL_CONST(169.678F),
    REAL_CONST(239.014F),
    REAL_CONST(99.8535F),
    REAL_CONST(-42.4805F),
    REAL_CONST(292.236F),
    REAL_CONST(252.686F),
    REAL_CONST(222.656F),
    REAL_CONST(331.055F),
    REAL_CONST(450.684F),
    REAL_CONST(-242.188F),
    REAL_CONST(-350.830F),
    REAL_CONST(118.164F),
    REAL_CONST(-362.549F),
    REAL_CONST(-415.039F),
    REAL_CONST(50.7813F),
    REAL_CONST(-100.586F),
    REAL_CONST(293.945F),
    REAL_CONST(349.609F),
    REAL_CONST(-66.1621F),
    REAL_CONST(218.750F),
    REAL_CONST(279.297F),
    REAL_CONST(-101.563F),
    REAL_CONST(433.838F),
    REAL_CONST(350.098F),
    REAL_CONST(-414.063F),
    REAL_CONST(-645.508F),
    REAL_CONST(-49.8047F),
    REAL_CONST(-436.768F),
    REAL_CONST(-378.662F),
    REAL_CONST(252.197F),
    REAL_CONST(-404.297F),
    REAL_CONST(-380.615F),
    REAL_CONST(318.115F),
    REAL_CONST(-305.908F),
    REAL_CONST(-387.939F),
    REAL_CONST(263.916F),
    REAL_CONST(-163.330F),
    REAL_CONST(-267.334F),
    REAL_CONST(-16.1133F),
    REAL_CONST(-166.504F),
    REAL_CONST(78.1250F),
    REAL_CONST(-84.2285F),
    REAL_CONST(160.889F),
    REAL_CONST(74.4629F),
    REAL_CONST(260.986F),
    REAL_CONST(-315.430F),
    REAL_CONST(-196.289F),
    REAL_CONST(-4.63867F),
    REAL_CONST(-399.170F),
    REAL_CONST(-315.186F),
    REAL_CONST(7.08008F),
    REAL_CONST(-410.889F),
    REAL_CONST(-121.338F),
    REAL_CONST(17.3340F),
    REAL_CONST(-70.0684F),
    REAL_CONST(-1.70898F),
    REAL_CONST(-24.4141F),
    REAL_CONST(-120.605F),
    REAL_CONST(-234.863F),
    REAL_CONST(-57.8613F),
    REAL_CONST(208.008F),
    REAL_CONST(459.229F),
    REAL_CONST(424.805F),
    REAL_CONST(-297.119F),
    REAL_CONST(-338.623F),
    REAL_CONST(55.4199F),
    REAL_CONST(-161.133F),
    REAL_CONST(73.7305F),
    REAL_CONST(91.0645F),
    REAL_CONST(23.4375F),
    REAL_CONST(265.381F),
    REAL_CONST(306.885F),
    REAL_CONST(-262.207F),
    REAL_CONST(-407.471F),
    REAL_CONST(39.0625F),
    REAL_CONST(118.408F),
    REAL_CONST(506.836F),
    REAL_CONST(438.965F),
    REAL_CONST(-228.027F),
    REAL_CONST(-53.7109F),
    REAL_CONST(134.766F),
    REAL_CONST(-145.508F),
    REAL_CONST(-149.414F),
    REAL_CONST(57.8613F),
    REAL_CONST(82.0313F),
    REAL_CONST(419.922F),
    REAL_CONST(214.600F),
    REAL_CONST(156.982F),
    REAL_CONST(153.564F),
    REAL_CONST(105.957F),
    REAL_CONST(309.326F),
    REAL_CONST(127.441F),
    REAL_CONST(398.682F),
    REAL_CONST(3.66211F),
    REAL_CONST(59.5703F),
    REAL_CONST(-107.666F),
    REAL_CONST(360.107F),
    REAL_CONST(175.049F),
    REAL_CONST(44.9219F),
    REAL_CONST(444.092F),
    REAL_CONST(388.184F),
    REAL_CONST(417.236F),
    REAL_CONST(241.211F),
    REAL_CONST(63.7207F),
    REAL_CONST(228.760F),
    REAL_CONST(510.986F),
    REAL_CONST(572.510F),
    REAL_CONST(371.094F),
    REAL_CONST(522.217F),
    REAL_CONST(453.613F),
    REAL_CONST(392.090F),
    REAL_CONST(-140.869F),
    REAL_CONST(-141.357F),
    REAL_CONST(-293.701F),
    REAL_CONST(-233.398F),
    REAL_CONST(32.9590F),
    REAL_CONST(-119.141F),
    REAL_CONST(-113.281F),
    REAL_CONST(12.4512F),
    REAL_CONST(-82.5195F),
    REAL_CONST(-153.564F),
    REAL_CONST(-84.9609F),
    REAL_CONST(-176.514F),
    REAL_CONST(279.785F),
    REAL_CONST(506.104F),
    REAL_CONST(352.051F),
    REAL_CONST(535.156F),
    REAL_CONST(357.910F),
    REAL_CONST(222.412F),
    REAL_CONST(-352.539F),
    REAL_CONST(-383.789F),
    REAL_CONST(-556.152F),
    REAL_CONST(341.797F),
    REAL_CONST(173.340F),
    REAL_CONST(316.650F),
    REAL_CONST(325.928F),
    REAL_CONST(154.541F),
    REAL_CONST(226.563F),
    REAL_CONST(350.098F),
    REAL_CONST(535.645F),
    REAL_CONST(633.301F),
    REAL_CONST(591.309F),
    REAL_CONST(538.086F),
    REAL_CONST(459.229F),
    REAL_CONST(239.746F),
    REAL_CONST(547.363F),
    REAL_CONST(452.637F),
    REAL_CONST(92.7734F),
    REAL_CONST(193.359F),
    REAL_CONST(279.541F),
    REAL_CONST(-15.3809F),
    REAL_CONST(-131.592F),
    REAL_CONST(101.074F),
    REAL_CONST(-61.5234F),
    REAL_CONST(-235.352F),
    REAL_CONST(-76.6602F),
    REAL_CONST(-307.861F),
    REAL_CONST(-166.748F),
    REAL_CONST(-190.430F),
    REAL_CONST(-202.881F),
    REAL_CONST(-128.418F),
    REAL_CONST(-245.361F),
    REAL_CONST(-406.738F),
    REAL_CONST(-277.100F),
    REAL_CONST(-103.516F),
    REAL_CONST(-393.311F),
    REAL_CONST(-110.352F),
    REAL_CONST(-72.9980F),
    REAL_CONST(309.570F),
    REAL_CONST(255.859F),
    REAL_CONST(156.738F),
    REAL_CONST(280.029F),
    REAL_CONST(208.252F),
    REAL_CONST(208.984F),
    REAL_CONST(-164.795F),
    REAL_CONST(-82.0313F),
    REAL_CONST(33.9355F),
    REAL_CONST(553.711F),
    REAL_CONST(327.881F),
    REAL_CONST(346.191F),
    REAL_CONST(7.08008F),
    REAL_CONST(187.500F),
    REAL_CONST(194.580F),
    REAL_CONST(-298.828F),
    REAL_CONST(103.271F),
    REAL_CONST(137.695F),
    REAL_CONST(-321.777F),
    REAL_CONST(-264.160F),
    REAL_CONST(59.8145F),
    REAL_CONST(-317.871F),
    REAL_CONST(-198.242F),
    REAL_CONST(139.893F),
    REAL_CONST(-316.895F),
    REAL_CONST(-394.775F),
    REAL_CONST(157.715F),
    REAL_CONST(-236.328F),
    REAL_CONST(203.613F),
    REAL_CONST(176.514F),
    REAL_CONST(242.432F),
    REAL_CONST(403.320F),
    REAL_CONST(494.873F),
    REAL_CONST(-46.6309F),
    REAL_CONST(-199.463F),
    REAL_CONST(105.469F),
    REAL_CONST(161.621F),
    REAL_CONST(14.6484F),
    REAL_CONST(48.3398F),
    REAL_CONST(152.832F),
    REAL_CONST(243.408F),
    REAL_CONST(324.707F),
    REAL_CONST(402.344F),
    REAL_CONST(479.248F),
    REAL_CONST(314.697F),
    REAL_CONST(-389.893F),
    REAL_CONST(-22.7051F),
    REAL_CONST(-10.9863F),
    REAL_CONST(-265.625F),
    REAL_CONST(9.03320F),
    REAL_CONST(-20.5078F),
    REAL_CONST(403.564F),
    REAL_CONST(636.475F),
    REAL_CONST(570.557F),
    REAL_CONST(260.010F),
    REAL_CONST(498.047F),
    REAL_CONST(580.322F),
    REAL_CONST(278.076F),
    REAL_CONST(567.871F),
    REAL_CONST(517.090F),
    REAL_CONST(209.717F),
    REAL_CONST(87.1582F),
    REAL_CONST(368.652F),
    REAL_CONST(162.109F),
    REAL_CONST(299.561F),
    REAL_CONST(268.311F),
    REAL_CONST(116.943F),
    REAL_CONST(332.031F),
    REAL_CONST(222.656F),
    REAL_CONST(463.135F),
    REAL_CONST(428.223F),
    REAL_CONST(492.920F),
    REAL_CONST(285.156F),
    REAL_CONST(466.064F),
    REAL_CONST(435.547F),
    REAL_CONST(97.4121F),
    REAL_CONST(8.30078F),
    REAL_CONST(62.5000F),
    REAL_CONST(-144.775F),
    REAL_CONST(-74.2188F),
    REAL_CONST(-257.080F),
    REAL_CONST(133.545F),
    REAL_CONST(413.574F),
    REAL_CONST(343.506F),
    REAL_CONST(157.959F),
    REAL_CONST(-24.1699F),
    REAL_CONST(-83.2520F),
    REAL_CONST(364.258F),
    REAL_CONST(402.100F),
    REAL_CONST(290.527F),
    REAL_CONST(9.27734F),
    REAL_CONST(-157.227F),
    REAL_CONST(-51.7578F),
    REAL_CONST(96.4355F),
    REAL_CONST(206.543F),
    REAL_CONST(54.1992F),
    REAL_CONST(-171.875F),
    REAL_CONST(-186.768F),
    REAL_CONST(-174.805F),
    REAL_CONST(-176.758F),
    REAL_CONST(-479.492F),
    REAL_CONST(-684.570F),
    REAL_CONST(-36.6211F),
    REAL_CONST(71.0449F),
    REAL_CONST(-20.0195F),
    REAL_CONST(301.025F),
    REAL_CONST(356.201F),
    REAL_CONST(245.850F),
    REAL_CONST(-34.1797F),
    REAL_CONST(-37.8418F),
    REAL_CONST(37.3535F),
    REAL_CONST(107.178F),
    REAL_CONST(72.5098F),
    REAL_CONST(382.813F),
    REAL_CONST(-373.291F),
    REAL_CONST(-100.098F),
    REAL_CONST(-155.273F),
    REAL_CONST(375.000F),
    REAL_CONST(111.084F),
    REAL_CONST(-57.8613F),
    REAL_CONST(-324.219F),
    REAL_CONST(-33.9355F),
    REAL_CONST(-63.4766F),
    REAL_CONST(129.639F),
    REAL_CONST(135.254F),
    REAL_CONST(211.914F),
    REAL_CONST(65.6738F),
    REAL_CONST(308.594F),
    REAL_CONST(147.949F),
    REAL_CONST(-56.8848F),
    REAL_CONST(215.576F),
    REAL_CONST(113.037F),
    REAL_CONST(181.152F),
    REAL_CONST(146.484F),
    REAL_CONST(-29.2969F),
    REAL_CONST(-17.8223F),
    REAL_CONST(102.783F),
    REAL_CONST(51.7578F),
    REAL_CONST(-107.178F),
    REAL_CONST(-14.1602F),
    REAL_CONST(196.289F),
    REAL_CONST(-313.965F),
    REAL_CONST(-302.979F),
    REAL_CONST(177.734F),
    REAL_CONST(71.7773F),
    REAL_CONST(-119.629F),
    REAL_CONST(12.2070F),
    REAL_CONST(-144.287F),
    REAL_CONST(-220.947F),
    REAL_CONST(-306.152F),
    REAL_CONST(10.2539F),
    REAL_CONST(-167.725F),
    REAL_CONST(35.8887F),
    REAL_CONST(-6.10352F),
    REAL_CONST(66.6504F),
    REAL_CONST(145.508F),
    REAL_CONST(-75.9277F),
    REAL_CONST(296.143F),
    REAL_CONST(146.729F),
    REAL_CONST(-184.082F),
    REAL_CONST(207.275F),
    REAL_CONST(142.578F),
    REAL_CONST(104.736F),
    REAL_CONST(148.193F),
    REAL_CONST(143.311F),
    REAL_CONST(-146.973F),
    REAL_CONST(-40.5273F),
    REAL_CONST(112.549F),
    REAL_CONST(-194.336F),
    REAL_CONST(-200.928F),
    REAL_CONST(189.697F),
    REAL_CONST(336.914F),
    REAL_CONST(222.168F),
    REAL_CONST(428.467F),
    REAL_CONST(29.0527F),
    REAL_CONST(345.947F),
    REAL_CONST(237.305F),
    REAL_CONST(-53.4668F),
    REAL_CONST(-214.844F),
    REAL_CONST(-389.648F),
    REAL_CONST(-256.104F),
    REAL_CONST(-246.582F),
    REAL_CONST(106.934F),
    REAL_CONST(-174.072F),
    REAL_CONST(-336.670F),
    REAL_CONST(19.0430F),
    REAL_CONST(0.000000F),
    REAL_CONST(-109.131F),
    REAL_CONST(-287.842F),
    REAL_CONST(-277.344F),
    REAL_CONST(-322.021F),
    REAL_CONST(-384.033F),
    REAL_CONST(548.828F),
    REAL_CONST(431.396F),
    REAL_CONST(319.580F),
    REAL_CONST(230.957F),
    REAL_CONST(386.475F),
    REAL_CONST(349.609F),
    REAL_CONST(280.762F),
    REAL_CONST(117.676F),
    REAL_CONST(106.445F),
    REAL_CONST(-114.502F),
    REAL_CONST(-270.508F),
    REAL_CONST(150.879F),
    REAL_CONST(-109.131F),
    REAL_CONST(-235.840F),
    REAL_CONST(265.625F),
    REAL_CONST(-305.664F),
    REAL_CONST(-369.873F),
    REAL_CONST(-27.8320F),
    REAL_CONST(-269.531F),
    REAL_CONST(-490.234F),
    REAL_CONST(-141.357F),
    REAL_CONST(51.2695F),
    REAL_CONST(149.658F),
    REAL_CONST(121.338F),
    REAL_CONST(-482.178F),
    REAL_CONST(-350.830F),
    REAL_CONST(156.738F),
    REAL_CONST(-309.814F),
    REAL_CONST(-208.984F),
    REAL_CONST(246.826F),
    REAL_CONST(-401.855F),
    REAL_CONST(-289.307F),
    REAL_CONST(259.521F),
    REAL_CONST(-379.639F),
    REAL_CONST(-164.063F),
    REAL_CONST(293.945F),
    REAL_CONST(-413.086F),
    REAL_CONST(-271.973F),
    REAL_CONST(152.100F),
    REAL_CONST(-239.014F),
    REAL_CONST(-323.730F),
    REAL_CONST(-311.768F),
    REAL_CONST(131.592F),
    REAL_CONST(-35.8887F),
    REAL_CONST(218.262F),
    REAL_CONST(-330.566F),
    REAL_CONST(-218.994F),
    REAL_CONST(-105.957F),
    REAL_CONST(216.797F),
    REAL_CONST(115.967F),
    REAL_CONST(104.492F),
    REAL_CONST(37.3535F),
    REAL_CONST(-93.7500F),
    REAL_CONST(82.5195F),
    REAL_CONST(-364.258F),
    REAL_CONST(-124.756F),
    REAL_CONST(87.6465F),
    REAL_CONST(-237.793F),
    REAL_CONST(-272.217F),
    REAL_CONST(-114.746F),
    REAL_CONST(25.6348F),
    REAL_CONST(-134.277F),
    REAL_CONST(165.283F),
    REAL_CONST(-228.760F),
    REAL_CONST(-279.541F),
    REAL_CONST(214.111F),
    REAL_CONST(92.7734F),
    REAL_CONST(-63.4766F),
    REAL_CONST(51.2695F),
    REAL_CONST(411.377F),
    REAL_CONST(225.586F),
    REAL_CONST(306.641F),
    REAL_CONST(433.350F),
    REAL_CONST(290.527F),
    REAL_CONST(267.334F),
    REAL_CONST(346.436F),
    REAL_CONST(154.053F),
    REAL_CONST(130.127F),
    REAL_CONST(153.076F),
    REAL_CONST(72.9980F),
    REAL_CONST(-84.7168F),
    REAL_CONST(-100.342F),
    REAL_CONST(-130.371F),
    REAL_CONST(157.959F),
    REAL_CONST(-158.691F),
    REAL_CONST(7.08008F),
    REAL_CONST(-145.264F),
    REAL_CONST(-92.2852F),
    REAL_CONST(-333.740F),
    REAL_CONST(381.592F),
    REAL_CONST(342.285F),
    REAL_CONST(273.682F),
    REAL_CONST(357.666F),
    REAL_CONST(265.869F),
    REAL_CONST(344.238F),
    REAL_CONST(158.203F),
    REAL_CONST(-511.719F),
    REAL_CONST(-266.113F),
    REAL_CONST(-1.46484F),
    REAL_CONST(75.9277F),
    REAL_CONST(-47.3633F),
    REAL_CONST(-212.158F),
    REAL_CONST(-156.006F),
    REAL_CONST(-202.881F),
    REAL_CONST(101.563F),
    REAL_CONST(-283.691F),
    REAL_CONST(-298.828F),
    REAL_CONST(329.346F),
    REAL_CONST(-304.443F),
    REAL_CONST(-229.736F),
    REAL_CONST(442.627F),
    REAL_CONST(-535.400F),
    REAL_CONST(-485.107F),
    REAL_CONST(110.596F),
    REAL_CONST(-151.123F),
    REAL_CONST(-333.740F),
    REAL_CONST(-233.398F),
    REAL_CONST(-392.090F),
    REAL_CONST(-481.445F),
    REAL_CONST(-367.920F),
    REAL_CONST(-286.865F),
    REAL_CONST(-258.057F),
    REAL_CONST(-269.531F),
    REAL_CONST(-92.0410F),
    REAL_CONST(146.729F),
    REAL_CONST(49.0723F),
    REAL_CONST(458.008F),
    REAL_CONST(201.416F),
    REAL_CONST(91.3086F),
    REAL_CONST(-104.980F),
    REAL_CONST(-322.998F),
    REAL_CONST(7.08008F),
    REAL_CONST(-341.064F),
    REAL_CONST(-304.932F),
    REAL_CONST(-324.951F),
    REAL_CONST(-245.850F),
    REAL_CONST(-367.188F),
    REAL_CONST(234.375F),
    REAL_CONST(-342.041F),
    REAL_CONST(-490.479F),
    REAL_CONST(48.0957F),
    REAL_CONST(-336.670F),
    REAL_CONST(-475.830F),
    REAL_CONST(-57.6172F),
    REAL_CONST(-262.939F),
    REAL_CONST(30.0293F),
    REAL_CONST(103.027F),
    REAL_CONST(150.146F),
    REAL_CONST(309.814F),
    REAL_CONST(133.301F),
    REAL_CONST(-74.7070F),
    REAL_CONST(372.559F),
    REAL_CONST(220.703F),
    REAL_CONST(291.504F),
    REAL_CONST(436.523F),
    REAL_CONST(287.354F),
    REAL_CONST(-152.832F),
    REAL_CONST(-215.820F),
    REAL_CONST(-372.559F),
    REAL_CONST(48.5840F),
    REAL_CONST(187.012F),
    REAL_CONST(367.188F),
    REAL_CONST(-260.010F),
    REAL_CONST(210.449F),
    REAL_CONST(48.0957F),
    REAL_CONST(-252.441F),
    REAL_CONST(-432.861F),
    REAL_CONST(-216.553F),
    REAL_CONST(-195.313F),
    REAL_CONST(35.4004F),
    REAL_CONST(146.240F),
    REAL_CONST(-276.855F),
    REAL_CONST(-126.709F),
    REAL_CONST(152.832F),
    REAL_CONST(-294.189F),
    REAL_CONST(-470.215F),
    REAL_CONST(122.070F),
    REAL_CONST(-222.168F),
    REAL_CONST(-254.150F),
    REAL_CONST(-340.576F),
    REAL_CONST(-360.352F),
    REAL_CONST(-382.568F),
    REAL_CONST(-236.572F),
    REAL_CONST(-127.686F),
    REAL_CONST(205.566F),
    REAL_CONST(8.30078F),
    REAL_CONST(437.988F),
    REAL_CONST(157.715F),
    REAL_CONST(210.449F),
    REAL_CONST(-294.678F),
    REAL_CONST(-460.938F),
    REAL_CONST(-244.629F),
    REAL_CONST(-19.0430F),
    REAL_CONST(-2.19727F),
    REAL_CONST(-164.063F),
    REAL_CONST(254.883F),
    REAL_CONST(185.303F),
    REAL_CONST(19.5313F),
    REAL_CONST(-146.484F),
    REAL_CONST(278.076F),
    REAL_CONST(248.779F),
    REAL_CONST(13.9160F),
    REAL_CONST(488.281F),
    REAL_CONST(347.168F),
    REAL_CONST(-203.369F),
    REAL_CONST(345.215F),
    REAL_CONST(273.682F),
    REAL_CONST(-293.457F),
    REAL_CONST(397.949F),
    REAL_CONST(307.617F),
    REAL_CONST(-112.549F),
    REAL_CONST(346.680F),
    REAL_CONST(303.711F),
    REAL_CONST(375.244F),
    REAL_CONST(238.037F),
    REAL_CONST(61.7676F),
    REAL_CONST(-69.0918F),
    REAL_CONST(79.1016F),
    REAL_CONST(-87.6465F),
    REAL_CONST(146.240F),
    REAL_CONST(-47.6074F),
    REAL_CONST(25.8789F),
    REAL_CONST(143.555F),
    REAL_CONST(15.1367F),
    REAL_CONST(-143.311F),
    REAL_CONST(-184.814F),
    REAL_CONST(157.471F),
    REAL_CONST(50.0488F),
    REAL_CONST(12.4512F),
    REAL_CONST(293.213F),
    REAL_CONST(185.059F),
    REAL_CONST(-295.166F),
    REAL_CONST(164.307F),
    REAL_CONST(-95.2148F),
    REAL_CONST(-152.344F),
    REAL_CONST(385.986F),
    REAL_CONST(229.736F),
    REAL_CONST(-36.8652F),
    REAL_CONST(249.756F),
    REAL_CONST(179.443F),
    REAL_CONST(688.477F),
    REAL_CONST(317.627F),
    REAL_CONST(168.457F),
    REAL_CONST(-73.7305F),
    REAL_CONST(127.930F),
    REAL_CONST(-24.1699F),
    REAL_CONST(-219.727F),
    REAL_CONST(-387.695F),
    REAL_CONST(-290.283F),
    REAL_CONST(264.648F),
    REAL_CONST(61.2793F),
    REAL_CONST(58.1055F),
    REAL_CONST(491.699F),
    REAL_CONST(437.500F),
    REAL_CONST(246.582F),
    REAL_CONST(303.955F),
    REAL_CONST(398.682F),
    REAL_CONST(425.049F),
    REAL_CONST(-299.561F),
    REAL_CONST(-375.977F),
    REAL_CONST(-294.922F),
    REAL_CONST(-151.611F),
    REAL_CONST(111.328F),
    REAL_CONST(-26.6113F),
    REAL_CONST(9.76563F),
    REAL_CONST(-15.8691F),
    REAL_CONST(192.383F),
    REAL_CONST(-196.533F),
    REAL_CONST(-170.654F),
    REAL_CONST(-329.590F),
    REAL_CONST(-142.334F),
    REAL_CONST(220.703F),
    REAL_CONST(203.125F),
    REAL_CONST(-195.557F),
    REAL_CONST(129.883F),
    REAL_CONST(145.020F),
    REAL_CONST(481.445F),
    REAL_CONST(343.750F),
    REAL_CONST(329.834F),
    REAL_CONST(-287.354F),
    REAL_CONST(-458.984F),
    REAL_CONST(-516.113F),
    REAL_CONST(-188.721F),
    REAL_CONST(138.672F),
    REAL_CONST(231.445F),
    REAL_CONST(-247.803F),
    REAL_CONST(263.428F),
    REAL_CONST(307.617F),
    REAL_CONST(-271.240F),
    REAL_CONST(117.676F),
    REAL_CONST(-31.7383F),
    REAL_CONST(434.082F),
    REAL_CONST(254.883F),
    REAL_CONST(190.430F),
    REAL_CONST(-364.014F),
    REAL_CONST(59.8145F),
    REAL_CONST(222.656F),
    REAL_CONST(-77.1484F),
    REAL_CONST(-278.564F),
    REAL_CONST(-223.877F),
    REAL_CONST(-130.859F),
    REAL_CONST(-352.051F),
    REAL_CONST(-572.754F),
    REAL_CONST(-191.650F),
    REAL_CONST(-377.441F),
    REAL_CONST(-485.352F),
    REAL_CONST(-489.014F),
    REAL_CONST(62.7441F),
    REAL_CONST(221.924F),
    REAL_CONST(-451.416F),
    REAL_CONST(-154.541F),
    REAL_CONST(-295.166F),
    REAL_CONST(-375.488F),
    REAL_CONST(-468.262F),
    REAL_CONST(-257.324F),
    REAL_CONST(392.090F),
    REAL_CONST(546.631F),
    REAL_CONST(384.766F),
    REAL_CONST(-138.428F),
    REAL_CONST(-366.211F),
    REAL_CONST(-376.953F),
    REAL_CONST(-312.256F),
    REAL_CONST(47.6074F),
    REAL_CONST(334.229F),
    REAL_CONST(-199.463F),
    REAL_CONST(71.5332F),
    REAL_CONST(297.607F),
    REAL_CONST(-128.174F),
    REAL_CONST(153.809F),
    REAL_CONST(292.236F),
    REAL_CONST(-414.551F),
    REAL_CONST(-592.041F),
    REAL_CONST(-449.219F),
    REAL_CONST(-73.9746F),
    REAL_CONST(178.467F),
    REAL_CONST(182.373F),
    REAL_CONST(-285.400F),
    REAL_CONST(-61.2793F),
    REAL_CONST(65.6738F),
    REAL_CONST(-231.934F),
    REAL_CONST(-18.3105F),
    REAL_CONST(411.133F),
    REAL_CONST(-288.574F),
    REAL_CONST(-110.596F),
    REAL_CONST(245.361F),
    REAL_CONST(-390.381F),
    REAL_CONST(142.822F),
    REAL_CONST(92.2852F),
    REAL_CONST(-506.592F),
    REAL_CONST(-139.404F),
    REAL_CONST(-104.248F),
    REAL_CONST(-129.150F),
    REAL_CONST(-282.959F),
    REAL_CONST(-285.889F),
    REAL_CONST(-69.0918F),
    REAL_CONST(-50.0488F),
    REAL_CONST(-137.695F),
    REAL_CONST(-194.336F),
    REAL_CONST(304.199F),
    REAL_CONST(175.049F),
    REAL_CONST(555.908F),
    REAL_CONST(226.318F),
    REAL_CONST(131.592F),
    REAL_CONST(-110.840F),
    REAL_CONST(136.475F),
    REAL_CONST(107.422F),
    REAL_CONST(-175.049F),
    REAL_CONST(356.445F),
    REAL_CONST(394.287F),
    REAL_CONST(-251.465F),
    REAL_CONST(256.836F),
    REAL_CONST(393.066F),
    REAL_CONST(-285.400F),
    REAL_CONST(-33.6914F),
    REAL_CONST(206.787F),
    REAL_CONST(55.1758F),
    REAL_CONST(9.52148F),
    REAL_CONST(-149.414F),
    REAL_CONST(-305.420F),
    REAL_CONST(-25.8789F),
    REAL_CONST(-177.979F),
    REAL_CONST(-158.936F),
    REAL_CONST(236.328F),
    REAL_CONST(317.871F),
    REAL_CONST(-174.316F),
    REAL_CONST(-155.273F),
    REAL_CONST(421.631F),
    REAL_CONST(86.1816F),
    REAL_CONST(260.986F),
    REAL_CONST(100.098F),
    REAL_CONST(-194.824F),
    REAL_CONST(-38.0859F),
    REAL_CONST(268.311F),
    REAL_CONST(-140.137F),
    REAL_CONST(224.121F),
    REAL_CONST(108.887F),
    REAL_CONST(-319.824F),
    REAL_CONST(247.070F),
    REAL_CONST(113.770F),
    REAL_CONST(343.750F),
    REAL_CONST(388.428F),
    REAL_CONST(186.768F),
    REAL_CONST(348.877F),
    REAL_CONST(336.914F),
    REAL_CONST(428.955F),
    REAL_CONST(475.830F),
    REAL_CONST(477.539F),
    REAL_CONST(580.566F),
    REAL_CONST(385.254F),
    REAL_CONST(499.756F),
    REAL_CONST(524.414F),
    REAL_CONST(223.633F),
    REAL_CONST(23.9258F),
    REAL_CONST(-1.70898F),
    REAL_CONST(462.158F),
    REAL_CONST(346.191F),
    REAL_CONST(522.705F),
    REAL_CONST(84.9609F),
    REAL_CONST(343.018F),
    REAL_CONST(385.498F),
    REAL_CONST(37.1094F),
    REAL_CONST(276.855F),
    REAL_CONST(439.697F),
    REAL_CONST(-65.1855F),
    REAL_CONST(37.5977F),
    REAL_CONST(340.576F),
    REAL_CONST(-284.668F),
    REAL_CONST(114.502F),
    REAL_CONST(257.324F),
    REAL_CONST(-278.809F),
    REAL_CONST(-98.8770F),
    REAL_CONST(-261.963F),
    REAL_CONST(-327.393F),
    REAL_CONST(-552.734F),
    REAL_CONST(-385.986F),
    REAL_CONST(-88.8672F),
    REAL_CONST(212.158F),
    REAL_CONST(416.504F),
    REAL_CONST(-283.691F),
    REAL_CONST(134.033F),
    REAL_CONST(378.418F),
    REAL_CONST(-299.072F),
    REAL_CONST(-471.680F),
    REAL_CONST(-406.738F),
    REAL_CONST(-362.549F),
    REAL_CONST(-482.666F),
    REAL_CONST(-501.709F),
    REAL_CONST(-421.631F),
    REAL_CONST(-221.191F),
    REAL_CONST(-23.9258F),
    REAL_CONST(-463.135F),
    REAL_CONST(56.8848F),
    REAL_CONST(364.258F),
    REAL_CONST(217.773F),
    REAL_CONST(26.3672F),
    REAL_CONST(-80.8105F),
    REAL_CONST(-421.875F),
    REAL_CONST(-285.645F),
    REAL_CONST(-415.039F),
    REAL_CONST(-258.789F),
    REAL_CONST(483.398F),
    REAL_CONST(437.012F),
    REAL_CONST(-261.230F),
    REAL_CONST(-425.049F),
    REAL_CONST(-466.064F),
    REAL_CONST(-2.68555F),
    REAL_CONST(375.732F),
    REAL_CONST(321.533F),
    REAL_CONST(-390.625F),
    REAL_CONST(22.9492F),
    REAL_CONST(121.338F),
    REAL_CONST(102.783F),
    REAL_CONST(108.154F),
    REAL_CONST(-48.0957F),
    REAL_CONST(-385.254F),
    REAL_CONST(-85.2051F),
    REAL_CONST(-242.676F),
    REAL_CONST(-146.240F),
    REAL_CONST(-131.592F),
    REAL_CONST(278.320F),
    REAL_CONST(-235.596F),
    REAL_CONST(-346.436F),
    REAL_CONST(-31.4941F),
    REAL_CONST(-327.393F),
    REAL_CONST(42.7246F),
    REAL_CONST(-109.131F),
    REAL_CONST(-91.5527F),
    REAL_CONST(320.068F),
    REAL_CONST(501.709F),
    REAL_CONST(-90.5762F),
    REAL_CONST(-158.691F),
    REAL_CONST(-74.9512F),
    REAL_CONST(-261.963F),
    REAL_CONST(147.705F),
    REAL_CONST(89.1113F),
    REAL_CONST(-502.197F),
    REAL_CONST(-27.5879F),
    REAL_CONST(104.980F),
    REAL_CONST(159.180F),
    REAL_CONST(223.145F),
    REAL_CONST(236.084F),
    REAL_CONST(-247.070F),
    REAL_CONST(-387.207F),
    REAL_CONST(-567.139F),
    REAL_CONST(367.432F),
    REAL_CONST(304.688F),
    REAL_CONST(136.475F),
    REAL_CONST(63.9648F),
    REAL_CONST(-118.652F),
    REAL_CONST(-97.9004F),
    REAL_CONST(-421.631F),
    REAL_CONST(327.637F),
    REAL_CONST(377.441F),
    REAL_CONST(12.2070F),
    REAL_CONST(13.6719F),
    REAL_CONST(105.469F),
    REAL_CONST(-80.5664F),
    REAL_CONST(29.0527F),
    REAL_CONST(-147.461F),
    REAL_CONST(-370.361F),
    REAL_CONST(-263.672F),
    REAL_CONST(-197.754F),
    REAL_CONST(230.957F),
    REAL_CONST(275.146F),
    REAL_CONST(257.568F),
    REAL_CONST(-341.797F),
    REAL_CONST(-415.771F),
    REAL_CONST(-417.969F),
    REAL_CONST(-310.059F),
    REAL_CONST(-171.875F),
    REAL_CONST(-321.533F),
    REAL_CONST(197.021F),
    REAL_CONST(444.580F),
    REAL_CONST(279.053F),
    REAL_CONST(673.828F),
    REAL_CONST(392.090F),
    REAL_CONST(530.029F),
    REAL_CONST(273.438F),
    REAL_CONST(99.8535F),
    REAL_CONST(-36.6211F),
    REAL_CONST(-35.8887F),
    REAL_CONST(98.6328F),
    REAL_CONST(234.131F),
    REAL_CONST(595.459F),
    REAL_CONST(466.553F),
    REAL_CONST(534.424F),
    REAL_CONST(-221.191F),
    REAL_CONST(-34.4238F),
    REAL_CONST(-211.426F),
    REAL_CONST(-220.703F),
    REAL_CONST(-34.6680F),
    REAL_CONST(-111.816F),
    REAL_CONST(-135.986F),
    REAL_CONST(-172.852F),
    REAL_CONST(-409.912F),
    REAL_CONST(-202.637F),
    REAL_CONST(-349.365F),
    REAL_CONST(-386.475F),
    REAL_CONST(-449.707F),
    REAL_CONST(-328.613F),
    REAL_CONST(-265.137F),
    REAL_CONST(-391.602F),
    REAL_CONST(-66.4063F),
    REAL_CONST(223.389F),
    REAL_CONST(-291.992F),
    REAL_CONST(188.477F),
    REAL_CONST(257.813F),
    REAL_CONST(-155.762F),
    REAL_CONST(-301.270F),
    REAL_CONST(-463.135F),
    REAL_CONST(-122.070F),
    REAL_CONST(-19.7754F),
    REAL_CONST(-200.684F),
    REAL_CONST(-314.697F),
    REAL_CONST(-393.799F),
    REAL_CONST(-179.443F),
    REAL_CONST(-28.5645F),
    REAL_CONST(191.650F),
    REAL_CONST(41.0156F),
    REAL_CONST(-266.113F),
    REAL_CONST(276.611F),
    REAL_CONST(225.098F),
    REAL_CONST(-267.578F),
    REAL_CONST(-182.129F),
    REAL_CONST(337.891F),
    REAL_CONST(70.0684F),
    REAL_CONST(-133.545F),
    REAL_CONST(-259.521F),
    REAL_CONST(-335.938F),
    REAL_CONST(-537.354F),
    REAL_CONST(-293.945F),
    REAL_CONST(-531.250F),
    REAL_CONST(-383.301F),
    REAL_CONST(-428.955F),
    REAL_CONST(-368.896F),
    REAL_CONST(-547.119F),
    REAL_CONST(-188.232F),
    REAL_CONST(-424.072F),
    REAL_CONST(268.311F),
    REAL_CONST(202.637F),
    REAL_CONST(-387.695F),
    REAL_CONST(176.758F),
    REAL_CONST(303.467F),
    REAL_CONST(-376.465F),
    REAL_CONST(169.189F),
    REAL_CONST(196.533F),
    REAL_CONST(-412.598F),
    REAL_CONST(-58.5938F),
    REAL_CONST(406.494F),
    REAL_CONST(-415.039F),
    REAL_CONST(-0.976563F),
    REAL_CONST(-163.086F),
    REAL_CONST(524.658F),
    REAL_CONST(199.219F),
    REAL_CONST(254.395F),
    REAL_CONST(-199.707F),
    REAL_CONST(-449.463F),
    REAL_CONST(5.37109F),
    REAL_CONST(-186.523F),
    REAL_CONST(-123.779F),
    REAL_CONST(109.619F),
    REAL_CONST(-281.006F),
    REAL_CONST(-150.635F),
    REAL_CONST(70.5566F),
    REAL_CONST(-205.811F),
    REAL_CONST(-389.648F),
    REAL_CONST(-58.5938F),
    REAL_CONST(121.582F),
    REAL_CONST(-57.1289F),
    REAL_CONST(-160.400F),
    REAL_CONST(-183.594F),
    REAL_CONST(117.188F),
    REAL_CONST(409.668F),
    REAL_CONST(-77.8809F),
    REAL_CONST(-117.432F),
    REAL_CONST(47.1191F),
    REAL_CONST(-197.998F),
    REAL_CONST(41.7480F),
    REAL_CONST(-29.0527F),
    REAL_CONST(-519.531F),
    REAL_CONST(-49.3164F),
    REAL_CONST(-207.031F),
    REAL_CONST(419.189F),
    REAL_CONST(278.320F),
    REAL_CONST(415.039F)
};

static const real_32_t dico3_lsf_3[] =
{
    REAL_CONST(16.3574F),
    REAL_CONST(-4.15039F),
    REAL_CONST(16.1133F),
    REAL_CONST(-2.92969F),
    REAL_CONST(-412.598F),
    REAL_CONST(-141.846F),
    REAL_CONST(-25.3906F),
    REAL_CONST(-66.4063F),
    REAL_CONST(-262.695F),
    REAL_CONST(-289.551F),
    REAL_CONST(-450.439F),
    REAL_CONST(-91.7969F),
    REAL_CONST(-278.320F),
    REAL_CONST(-226.074F),
    REAL_CONST(-102.539F),
    REAL_CONST(-14.1602F),
    REAL_CONST(-63.2324F),
    REAL_CONST(-160.156F),
    REAL_CONST(-276.855F),
    REAL_CONST(-135.010F),
    REAL_CONST(436.523F),
    REAL_CONST(299.561F),
    REAL_CONST(111.084F),
    REAL_CONST(31.4941F),
    REAL_CONST(112.793F),
    REAL_CONST(107.666F),
    REAL_CONST(-58.5938F),
    REAL_CONST(-128.906F),
    REAL_CONST(205.078F),
    REAL_CONST(125.488F),
    REAL_CONST(31.7383F),
    REAL_CONST(-18.3105F),
    REAL_CONST(271.973F),
    REAL_CONST(152.100F),
    REAL_CONST(37.3535F),
    REAL_CONST(52.7344F),
    REAL_CONST(260.742F),
    REAL_CONST(137.695F),
    REAL_CONST(-1.46484F),
    REAL_CONST(-67.3828F),
    REAL_CONST(273.193F),
    REAL_CONST(177.490F),
    REAL_CONST(46.3867F),
    REAL_CONST(-16.6016F),
    REAL_CONST(171.875F),
    REAL_CONST(74.7070F),
    REAL_CONST(29.0527F),
    REAL_CONST(-64.4531F),
    REAL_CONST(80.3223F),
    REAL_CONST(14.8926F),
    REAL_CONST(-24.4141F),
    REAL_CONST(38.0859F),
    REAL_CONST(88.8672F),
    REAL_CONST(30.0293F),
    REAL_CONST(44.6777F),
    REAL_CONST(-50.7813F),
    REAL_CONST(-41.7480F),
    REAL_CONST(-30.0293F),
    REAL_CONST(53.7109F),
    REAL_CONST(-15.8691F),
    REAL_CONST(-74.7070F),
    REAL_CONST(-15.1367F),
    REAL_CONST(98.1445F),
    REAL_CONST(4.15039F),
    REAL_CONST(-161.133F),
    REAL_CONST(-229.004F),
    REAL_CONST(-64.9414F),
    REAL_CONST(0.000000F),
    REAL_CONST(93.9941F),
    REAL_CONST(57.3730F),
    REAL_CONST(67.3828F),
    REAL_CONST(69.5801F),
    REAL_CONST(78.1250F),
    REAL_CONST(65.4297F),
    REAL_CONST(-82.0313F),
    REAL_CONST(-48.8281F),
    REAL_CONST(-176.758F),
    REAL_CONST(4.15039F),
    REAL_CONST(-20.5078F),
    REAL_CONST(93.0176F),
    REAL_CONST(-132.813F),
    REAL_CONST(104.736F),
    REAL_CONST(120.605F),
    REAL_CONST(126.709F),
    REAL_CONST(-28.5645F),
    REAL_CONST(70.3125F),
    REAL_CONST(74.2188F),
    REAL_CONST(80.3223F),
    REAL_CONST(156.982F),
    REAL_CONST(38.3301F),
    REAL_CONST(171.143F),
    REAL_CONST(124.023F),
    REAL_CONST(292.969F),
    REAL_CONST(152.588F),
    REAL_CONST(194.336F),
    REAL_CONST(148.438F),
    REAL_CONST(243.652F),
    REAL_CONST(102.783F),
    REAL_CONST(120.117F),
    REAL_CONST(154.297F),
    REAL_CONST(293.945F),
    REAL_CONST(190.430F),
    REAL_CONST(108.887F),
    REAL_CONST(32.2266F),
    REAL_CONST(306.885F),
    REAL_CONST(206.055F),
    REAL_CONST(133.545F),
    REAL_CONST(109.619F),
    REAL_CONST(202.393F),
    REAL_CONST(160.645F),
    REAL_CONST(132.080F),
    REAL_CONST(114.746F),
    REAL_CONST(276.367F),
    REAL_CONST(307.129F),
    REAL_CONST(224.121F),
    REAL_CONST(156.006F),
    REAL_CONST(133.545F),
    REAL_CONST(12.4512F),
    REAL_CONST(103.271F),
    REAL_CONST(68.1152F),
    REAL_CONST(2.19727F),
    REAL_CONST(95.7031F),
    REAL_CONST(20.2637F),
    REAL_CONST(22.9492F),
    REAL_CONST(132.324F),
    REAL_CONST(132.568F),
    REAL_CONST(55.9082F),
    REAL_CONST(-35.8887F),
    REAL_CONST(-48.3398F),
    REAL_CONST(31.4941F),
    REAL_CONST(47.3633F),
    REAL_CONST(-45.1660F),
    REAL_CONST(-210.693F),
    REAL_CONST(-322.510F),
    REAL_CONST(-73.7305F),
    REAL_CONST(7.32422F),
    REAL_CONST(-145.752F),
    REAL_CONST(-153.564F),
    REAL_CONST(-4.63867F),
    REAL_CONST(27.8320F),
    REAL_CONST(-219.727F),
    REAL_CONST(-263.916F),
    REAL_CONST(113.770F),
    REAL_CONST(86.1816F),
    REAL_CONST(-362.061F),
    REAL_CONST(-384.033F),
    REAL_CONST(3.66211F),
    REAL_CONST(-34.9121F),
    REAL_CONST(-416.992F),
    REAL_CONST(-502.686F),
    REAL_CONST(-183.350F),
    REAL_CONST(47.8516F),
    REAL_CONST(-458.008F),
    REAL_CONST(-504.639F),
    REAL_CONST(-156.738F),
    REAL_CONST(-62.9883F),
    REAL_CONST(-570.068F),
    REAL_CONST(-358.887F),
    REAL_CONST(-109.863F),
    REAL_CONST(-137.695F),
    REAL_CONST(-142.578F),
    REAL_CONST(-45.4102F),
    REAL_CONST(-212.891F),
    REAL_CONST(-101.074F),
    REAL_CONST(-440.674F),
    REAL_CONST(-241.211F),
    REAL_CONST(-274.658F),
    REAL_CONST(-319.824F),
    REAL_CONST(-177.246F),
    REAL_CONST(-275.635F),
    REAL_CONST(6.83594F),
    REAL_CONST(41.2598F),
    REAL_CONST(-253.662F),
    REAL_CONST(-210.938F),
    REAL_CONST(-175.293F),
    REAL_CONST(-60.0586F),
    REAL_CONST(118.164F),
    REAL_CONST(8.78906F),
    REAL_CONST(-56.8848F),
    REAL_CONST(-11.9629F),
    REAL_CONST(64.6973F),
    REAL_CONST(16.3574F),
    REAL_CONST(70.5566F),
    REAL_CONST(114.014F),
    REAL_CONST(43.4570F),
    REAL_CONST(132.568F),
    REAL_CONST(197.754F),
    REAL_CONST(131.836F),
    REAL_CONST(20.5078F),
    REAL_CONST(68.8477F),
    REAL_CONST(164.063F),
    REAL_CONST(171.631F),
    REAL_CONST(-238.037F),
    REAL_CONST(-189.697F),
    REAL_CONST(31.4941F),
    REAL_CONST(70.0684F),
    REAL_CONST(-229.004F),
    REAL_CONST(-55.4199F),
    REAL_CONST(233.154F),
    REAL_CONST(145.264F),
    REAL_CONST(-394.775F),
    REAL_CONST(-70.5566F),
    REAL_CONST(204.102F),
    REAL_CONST(158.447F),
    REAL_CONST(-450.928F),
    REAL_CONST(-52.4902F),
    REAL_CONST(270.020F),
    REAL_CONST(175.293F),
    REAL_CONST(-496.582F),
    REAL_CONST(-264.893F),
    REAL_CONST(158.691F),
    REAL_CONST(107.422F),
    REAL_CONST(-512.939F),
    REAL_CONST(-129.150F),
    REAL_CONST(221.436F),
    REAL_CONST(140.381F),
    REAL_CONST(-490.967F),
    REAL_CONST(-82.0313F),
    REAL_CONST(163.574F),
    REAL_CONST(49.8047F),
    REAL_CONST(-583.252F),
    REAL_CONST(-168.945F),
    REAL_CONST(87.8906F),
    REAL_CONST(33.4473F),
    REAL_CONST(-526.367F),
    REAL_CONST(-538.086F),
    REAL_CONST(-2.19727F),
    REAL_CONST(68.3594F),
    REAL_CONST(-64.9414F),
    REAL_CONST(29.0527F),
    REAL_CONST(9.52148F),
    REAL_CONST(47.1191F),
    REAL_CONST(19.0430F),
    REAL_CONST(-14.4043F),
    REAL_CONST(-29.2969F),
    REAL_CONST(55.1758F),
    REAL_CONST(-238.037F),
    REAL_CONST(-209.473F),
    REAL_CONST(-190.674F),
    REAL_CONST(-267.334F),
    REAL_CONST(-151.123F),
    REAL_CONST(-100.830F),
    REAL_CONST(-110.107F),
    REAL_CONST(-205.566F),
    REAL_CONST(-296.875F),
    REAL_CONST(-322.510F),
    REAL_CONST(-198.486F),
    REAL_CONST(-215.576F),
    REAL_CONST(-335.938F),
    REAL_CONST(-394.287F),
    REAL_CONST(-96.1914F),
    REAL_CONST(-104.492F),
    REAL_CONST(-179.932F),
    REAL_CONST(-271.729F),
    REAL_CONST(-134.033F),
    REAL_CONST(-192.871F),
    REAL_CONST(-214.844F),
    REAL_CONST(-238.037F),
    REAL_CONST(-236.084F),
    REAL_CONST(-156.738F),
    REAL_CONST(-240.479F),
    REAL_CONST(-216.309F),
    REAL_CONST(-310.791F),
    REAL_CONST(-332.275F),
    REAL_CONST(-115.479F),
    REAL_CONST(-196.289F),
    REAL_CONST(-342.041F),
    REAL_CONST(-343.506F),
    REAL_CONST(39.0625F),
    REAL_CONST(-64.6973F),
    REAL_CONST(-224.365F),
    REAL_CONST(-67.1387F),
    REAL_CONST(-60.5469F),
    REAL_CONST(-61.0352F),
    REAL_CONST(-175.293F),
    REAL_CONST(-92.7734F),
    REAL_CONST(23.6816F),
    REAL_CONST(-25.1465F),
    REAL_CONST(-91.5527F),
    REAL_CONST(-55.9082F),
    REAL_CONST(-101.318F),
    REAL_CONST(-47.1191F),
    REAL_CONST(-32.9590F),
    REAL_CONST(-135.498F),
    REAL_CONST(153.320F),
    REAL_CONST(88.1348F),
    REAL_CONST(29.0527F),
    REAL_CONST(52.7344F),
    REAL_CONST(141.357F),
    REAL_CONST(88.8672F),
    REAL_CONST(95.4590F),
    REAL_CONST(51.0254F),
    REAL_CONST(154.785F),
    REAL_CONST(127.441F),
    REAL_CONST(-37.5977F),
    REAL_CONST(-36.1328F),
    REAL_CONST(128.418F),
    REAL_CONST(94.9707F),
    REAL_CONST(41.5039F),
    REAL_CONST(8.05664F),
    REAL_CONST(25.6348F),
    REAL_CONST(65.1855F),
    REAL_CONST(15.6250F),
    REAL_CONST(92.7734F),
    REAL_CONST(-366.943F),
    REAL_CONST(-244.141F),
    REAL_CONST(-7.32422F),
    REAL_CONST(-90.0879F),
    REAL_CONST(-261.230F),
    REAL_CONST(14.1602F),
    REAL_CONST(157.959F),
    REAL_CONST(54.4434F),
    REAL_CONST(-371.094F),
    REAL_CONST(-71.0449F),
    REAL_CONST(151.611F),
    REAL_CONST(74.9512F),
    REAL_CONST(-373.779F),
    REAL_CONST(38.0859F),
    REAL_CONST(186.035F),
    REAL_CONST(98.6328F),
    REAL_CONST(-495.361F),
    REAL_CONST(34.4238F),
    REAL_CONST(179.199F),
    REAL_CONST(121.826F),
    REAL_CONST(-451.416F),
    REAL_CONST(-158.691F),
    REAL_CONST(74.7070F),
    REAL_CONST(125.000F),
    REAL_CONST(-45.6543F),
    REAL_CONST(-25.3906F),
    REAL_CONST(-14.4043F),
    REAL_CONST(106.934F),
    REAL_CONST(32.7148F),
    REAL_CONST(-56.1523F),
    REAL_CONST(38.0859F),
    REAL_CONST(-45.4102F),
    REAL_CONST(-14.8926F),
    REAL_CONST(-63.4766F),
    REAL_CONST(-3.90625F),
    REAL_CONST(2.44141F),
    REAL_CONST(-138.916F),
    REAL_CONST(-0.732422F),
    REAL_CONST(-102.783F),
    REAL_CONST(-72.5098F),
    REAL_CONST(-421.143F),
    REAL_CONST(-127.197F),
    REAL_CONST(-84.4727F),
    REAL_CONST(43.4570F),
    REAL_CONST(-332.520F),
    REAL_CONST(-14.4043F),
    REAL_CONST(-10.7422F),
    REAL_CONST(38.3301F),
    REAL_CONST(-523.926F),
    REAL_CONST(-112.549F),
    REAL_CONST(-114.746F),
    REAL_CONST(-85.2051F),
    REAL_CONST(-529.785F),
    REAL_CONST(-0.244141F),
    REAL_CONST(-90.0879F),
    REAL_CONST(-29.5410F),
    REAL_CONST(-385.498F),
    REAL_CONST(-91.0645F),
    REAL_CONST(-219.727F),
    REAL_CONST(-247.803F),
    REAL_CONST(-272.705F),
    REAL_CONST(-144.287F),
    REAL_CONST(-149.658F),
    REAL_CONST(-191.406F),
    REAL_CONST(-136.963F),
    REAL_CONST(29.7852F),
    REAL_CONST(-18.3105F),
    REAL_CONST(-109.619F),
    REAL_CONST(-0.976563F),
    REAL_CONST(-41.7480F),
    REAL_CONST(-30.0293F),
    REAL_CONST(-90.8203F),
    REAL_CONST(46.8750F),
    REAL_CONST(41.0156F),
    REAL_CONST(-18.5547F),
    REAL_CONST(-32.2266F),
    REAL_CONST(61.5234F),
    REAL_CONST(-26.1230F),
    REAL_CONST(83.0078F),
    REAL_CONST(51.2695F),
    REAL_CONST(95.7031F),
    REAL_CONST(124.268F),
    REAL_CONST(66.4063F),
    REAL_CONST(44.1895F),
    REAL_CONST(-26.6113F),
    REAL_CONST(35.4004F),
    REAL_CONST(53.2227F),
    REAL_CONST(29.0527F),
    REAL_CONST(-101.563F),
    REAL_CONST(-64.2090F),
    REAL_CONST(118.408F),
    REAL_CONST(64.6973F),
    REAL_CONST(-44.1895F),
    REAL_CONST(-1.95313F),
    REAL_CONST(-69.8242F),
    REAL_CONST(55.1758F),
    REAL_CONST(-59.5703F),
    REAL_CONST(-53.2227F),
    REAL_CONST(16.8457F),
    REAL_CONST(-70.8008F),
    REAL_CONST(-38.5742F),
    REAL_CONST(46.6309F),
    REAL_CONST(-0.244141F),
    REAL_CONST(-15.6250F),
    REAL_CONST(-144.531F),
    REAL_CONST(-21.9727F),
    REAL_CONST(52.0020F),
    REAL_CONST(-23.4375F),
    REAL_CONST(62.2559F),
    REAL_CONST(106.201F),
    REAL_CONST(43.4570F),
    REAL_CONST(-19.5313F),
    REAL_CONST(-90.0879F),
    REAL_CONST(-4.39453F),
    REAL_CONST(-8.05664F),
    REAL_CONST(-19.5313F),
    REAL_CONST(-10.2539F),
    REAL_CONST(101.318F),
    REAL_CONST(34.1797F),
    REAL_CONST(-54.1992F),
    REAL_CONST(279.053F),
    REAL_CONST(158.936F),
    REAL_CONST(158.447F),
    REAL_CONST(80.3223F),
    REAL_CONST(187.256F),
    REAL_CONST(135.742F),
    REAL_CONST(60.7910F),
    REAL_CONST(57.3730F),
    REAL_CONST(231.445F),
    REAL_CONST(100.830F),
    REAL_CONST(107.910F),
    REAL_CONST(68.1152F),
    REAL_CONST(34.4238F),
    REAL_CONST(82.7637F),
    REAL_CONST(86.9141F),
    REAL_CONST(135.986F),
    REAL_CONST(-114.746F),
    REAL_CONST(-41.5039F),
    REAL_CONST(24.1699F),
    REAL_CONST(57.8613F),
    REAL_CONST(-138.916F),
    REAL_CONST(-195.313F),
    REAL_CONST(85.9375F),
    REAL_CONST(137.939F),
    REAL_CONST(68.8477F),
    REAL_CONST(115.479F),
    REAL_CONST(114.746F),
    REAL_CONST(81.0547F),
    REAL_CONST(-48.5840F),
    REAL_CONST(-168.457F),
    REAL_CONST(-313.477F),
    REAL_CONST(-223.877F),
    REAL_CONST(-47.1191F),
    REAL_CONST(-104.004F),
    REAL_CONST(-195.313F),
    REAL_CONST(-273.926F),
    REAL_CONST(-6.34766F),
    REAL_CONST(-90.5762F),
    REAL_CONST(-119.629F),
    REAL_CONST(-47.1191F),
    REAL_CONST(155.518F),
    REAL_CONST(145.264F),
    REAL_CONST(126.709F),
    REAL_CONST(80.5664F),
    REAL_CONST(99.6094F),
    REAL_CONST(-28.0762F),
    REAL_CONST(19.2871F),
    REAL_CONST(2.92969F),
    REAL_CONST(116.455F),
    REAL_CONST(21.2402F),
    REAL_CONST(-25.1465F),
    REAL_CONST(-91.7969F),
    REAL_CONST(-162.598F),
    REAL_CONST(-84.7168F),
    REAL_CONST(-67.6270F),
    REAL_CONST(-71.0449F),
    REAL_CONST(-124.512F),
    REAL_CONST(-117.432F),
    REAL_CONST(41.2598F),
    REAL_CONST(72.5098F),
    REAL_CONST(-202.393F),
    REAL_CONST(-180.176F),
    REAL_CONST(-50.0488F),
    REAL_CONST(-41.7480F),
    REAL_CONST(-78.1250F),
    REAL_CONST(-131.836F),
    REAL_CONST(80.0781F),
    REAL_CONST(69.0918F),
    REAL_CONST(-209.717F),
    REAL_CONST(-233.887F),
    REAL_CONST(107.910F),
    REAL_CONST(-0.488281F),
    REAL_CONST(135.742F),
    REAL_CONST(167.480F),
    REAL_CONST(31.7383F),
    REAL_CONST(13.6719F),
    REAL_CONST(337.646F),
    REAL_CONST(247.070F),
    REAL_CONST(184.326F),
    REAL_CONST(104.248F),
    REAL_CONST(149.414F),
    REAL_CONST(180.908F),
    REAL_CONST(153.320F),
    REAL_CONST(135.010F),
    REAL_CONST(-82.7637F),
    REAL_CONST(-194.336F),
    REAL_CONST(32.7148F),
    REAL_CONST(67.6270F),
    REAL_CONST(-154.541F),
    REAL_CONST(-264.893F),
    REAL_CONST(-0.488281F),
    REAL_CONST(-60.0586F),
    REAL_CONST(-214.844F),
    REAL_CONST(-252.686F),
    REAL_CONST(-392.334F),
    REAL_CONST(-259.766F),
    REAL_CONST(-242.676F),
    REAL_CONST(-115.723F),
    REAL_CONST(-277.832F),
    REAL_CONST(-119.141F),
    REAL_CONST(-101.074F),
    REAL_CONST(-194.092F),
    REAL_CONST(17.8223F),
    REAL_CONST(-50.2930F),
    REAL_CONST(-1.95313F),
    REAL_CONST(-33.9355F),
    REAL_CONST(107.178F),
    REAL_CONST(49.8047F),
    REAL_CONST(-42.9688F),
    REAL_CONST(-141.113F),
    REAL_CONST(5.61523F),
    REAL_CONST(31.9824F),
    REAL_CONST(-65.6738F),
    REAL_CONST(-184.814F),
    REAL_CONST(-46.6309F),
    REAL_CONST(59.8145F),
    REAL_CONST(-26.6113F),
    REAL_CONST(-82.5195F),
    REAL_CONST(27.3438F),
    REAL_CONST(77.1484F),
    REAL_CONST(29.2969F),
    REAL_CONST(-99.1211F),
    REAL_CONST(-28.8086F),
    REAL_CONST(149.170F),
    REAL_CONST(-43.9453F),
    REAL_CONST(-45.4102F),
    REAL_CONST(-157.471F),
    REAL_CONST(28.0762F),
    REAL_CONST(-42.2363F),
    REAL_CONST(8.30078F),
    REAL_CONST(-126.465F),
    REAL_CONST(-119.385F),
    REAL_CONST(-36.8652F),
    REAL_CONST(14.8926F),
    REAL_CONST(-142.334F),
    REAL_CONST(-206.055F),
    REAL_CONST(53.7109F),
    REAL_CONST(-33.6914F),
    REAL_CONST(-166.260F),
    REAL_CONST(-249.023F),
    REAL_CONST(95.4590F),
    REAL_CONST(-4.15039F),
    REAL_CONST(-145.996F),
    REAL_CONST(-78.3691F),
    REAL_CONST(38.3301F),
    REAL_CONST(-72.0215F),
    REAL_CONST(31.4941F),
    REAL_CONST(37.8418F),
    REAL_CONST(-226.074F),
    REAL_CONST(-213.623F),
    REAL_CONST(-240.967F),
    REAL_CONST(69.5801F),
    REAL_CONST(58.8379F),
    REAL_CONST(-20.2637F),
    REAL_CONST(-30.5176F),
    REAL_CONST(-30.5176F),
    REAL_CONST(151.367F),
    REAL_CONST(145.752F),
    REAL_CONST(105.469F),
    REAL_CONST(22.4609F),
    REAL_CONST(95.9473F),
    REAL_CONST(19.0430F),
    REAL_CONST(99.8535F),
    REAL_CONST(14.8926F),
    REAL_CONST(-95.9473F),
    REAL_CONST(-180.420F),
    REAL_CONST(-100.830F),
    REAL_CONST(-182.617F),
    REAL_CONST(20.2637F),
    REAL_CONST(13.1836F),
    REAL_CONST(88.1348F),
    REAL_CONST(6.59180F),
    REAL_CONST(-264.648F),
    REAL_CONST(31.7383F),
    REAL_CONST(-82.2754F),
    REAL_CONST(-169.434F),
    REAL_CONST(-382.080F),
    REAL_CONST(72.5098F),
    REAL_CONST(77.6367F),
    REAL_CONST(-4.63867F),
    REAL_CONST(-457.275F),
    REAL_CONST(8.78906F),
    REAL_CONST(12.4512F),
    REAL_CONST(-77.3926F),
    REAL_CONST(-567.139F),
    REAL_CONST(-60.0586F),
    REAL_CONST(56.3965F),
    REAL_CONST(-20.5078F),
    REAL_CONST(-562.988F),
    REAL_CONST(-191.162F),
    REAL_CONST(9.76563F),
    REAL_CONST(-43.7012F),
    REAL_CONST(-545.166F),
    REAL_CONST(-227.051F),
    REAL_CONST(-115.723F),
    REAL_CONST(-112.793F),
    REAL_CONST(-184.082F),
    REAL_CONST(-20.9961F),
    REAL_CONST(-70.3125F),
    REAL_CONST(-152.832F),
    REAL_CONST(-588.623F),
    REAL_CONST(-111.084F),
    REAL_CONST(-15.3809F),
    REAL_CONST(41.7480F),
    REAL_CONST(-268.311F),
    REAL_CONST(-267.090F),
    REAL_CONST(-6.34766F),
    REAL_CONST(-34.9121F),
    REAL_CONST(-291.260F),
    REAL_CONST(-111.084F),
    REAL_CONST(-99.1211F),
    REAL_CONST(-93.0176F),
    REAL_CONST(-147.705F),
    REAL_CONST(-51.2695F),
    REAL_CONST(-23.4375F),
    REAL_CONST(-12.4512F),
    REAL_CONST(-141.602F),
    REAL_CONST(-116.211F),
    REAL_CONST(-67.3828F),
    REAL_CONST(-3.66211F),
    REAL_CONST(-291.748F),
    REAL_CONST(-154.785F),
    REAL_CONST(-293.701F),
    REAL_CONST(-215.088F),
    REAL_CONST(-92.2852F),
    REAL_CONST(-53.9551F),
    REAL_CONST(-163.330F),
    REAL_CONST(-232.422F),
    REAL_CONST(145.020F),
    REAL_CONST(43.4570F),
    REAL_CONST(-98.3887F),
    REAL_CONST(-165.039F),
    REAL_CONST(186.279F),
    REAL_CONST(79.8340F),
    REAL_CONST(146.729F),
    REAL_CONST(70.8008F),
    REAL_CONST(41.9922F),
    REAL_CONST(73.2422F),
    REAL_CONST(49.5605F),
    REAL_CONST(38.3301F),
    REAL_CONST(-13.6719F),
    REAL_CONST(-82.0313F),
    REAL_CONST(86.9141F),
    REAL_CONST(5.85938F),
    REAL_CONST(-55.6641F),
    REAL_CONST(-72.2656F),
    REAL_CONST(-63.2324F),
    REAL_CONST(-7.08008F),
    REAL_CONST(-45.4102F),
    REAL_CONST(64.2090F),
    REAL_CONST(101.563F),
    REAL_CONST(3.41797F),
    REAL_CONST(-86.1816F),
    REAL_CONST(91.0645F),
    REAL_CONST(-2.92969F),
    REAL_CONST(-52.7344F),
    REAL_CONST(62.7441F),
    REAL_CONST(23.4375F),
    REAL_CONST(42.4805F),
    REAL_CONST(13.9160F),
    REAL_CONST(-372.559F),
    REAL_CONST(-150.391F),
    REAL_CONST(-232.910F),
    REAL_CONST(-121.826F),
    REAL_CONST(-121.338F),
    REAL_CONST(-37.1094F),
    REAL_CONST(-81.2988F),
    REAL_CONST(30.5176F),
    REAL_CONST(25.6348F),
    REAL_CONST(48.8281F),
    REAL_CONST(43.7012F),
    REAL_CONST(-23.6816F),
    REAL_CONST(-80.8105F),
    REAL_CONST(-54.6875F),
    REAL_CONST(186.768F),
    REAL_CONST(170.166F),
    REAL_CONST(185.547F),
    REAL_CONST(62.5000F),
    REAL_CONST(73.4863F),
    REAL_CONST(14.4043F),
    REAL_CONST(111.084F),
    REAL_CONST(-20.7520F),
    REAL_CONST(49.8047F),
    REAL_CONST(70.3125F),
    REAL_CONST(-125.488F),
    REAL_CONST(58.5938F),
    REAL_CONST(61.2793F),
    REAL_CONST(-26.6113F),
    REAL_CONST(62.5000F),
    REAL_CONST(101.807F),
    REAL_CONST(-8.30078F),
    REAL_CONST(-100.830F),
    REAL_CONST(24.6582F),
    REAL_CONST(104.980F),
    REAL_CONST(93.7500F),
    REAL_CONST(38.0859F),
    REAL_CONST(-7.56836F),
    REAL_CONST(-2.44141F),
    REAL_CONST(50.2930F),
    REAL_CONST(104.004F),
    REAL_CONST(143.799F),
    REAL_CONST(35.4004F),
    REAL_CONST(34.9121F),
    REAL_CONST(17.3340F),
    REAL_CONST(197.266F),
    REAL_CONST(221.191F),
    REAL_CONST(81.2988F),
    REAL_CONST(85.2051F),
    REAL_CONST(240.723F),
    REAL_CONST(229.004F),
    REAL_CONST(143.799F),
    REAL_CONST(80.8105F),
    REAL_CONST(317.383F),
    REAL_CONST(201.172F),
    REAL_CONST(45.6543F),
    REAL_CONST(124.268F),
    REAL_CONST(259.277F),
    REAL_CONST(159.424F),
    REAL_CONST(92.5293F),
    REAL_CONST(113.770F),
    REAL_CONST(356.934F),
    REAL_CONST(228.760F),
    REAL_CONST(97.9004F),
    REAL_CONST(66.8945F),
    REAL_CONST(192.139F),
    REAL_CONST(210.205F),
    REAL_CONST(64.6973F),
    REAL_CONST(0.488281F),
    REAL_CONST(148.682F),
    REAL_CONST(135.010F),
    REAL_CONST(6.83594F),
    REAL_CONST(74.4629F),
    REAL_CONST(226.074F),
    REAL_CONST(83.0078F),
    REAL_CONST(25.8789F),
    REAL_CONST(94.2383F),
    REAL_CONST(58.8379F),
    REAL_CONST(-65.1855F),
    REAL_CONST(-35.8887F),
    REAL_CONST(54.9316F),
    REAL_CONST(-43.4570F),
    REAL_CONST(-130.371F),
    REAL_CONST(84.7168F),
    REAL_CONST(122.559F),
    REAL_CONST(-156.982F),
    REAL_CONST(-93.0176F),
    REAL_CONST(96.9238F),
    REAL_CONST(7.32422F),
    REAL_CONST(-158.936F),
    REAL_CONST(-178.955F),
    REAL_CONST(-106.201F),
    REAL_CONST(97.1680F),
    REAL_CONST(-99.3652F),
    REAL_CONST(-177.246F),
    REAL_CONST(-118.164F),
    REAL_CONST(-60.5469F),
    REAL_CONST(-192.627F),
    REAL_CONST(-223.145F),
    REAL_CONST(-106.934F),
    REAL_CONST(-116.211F),
    REAL_CONST(-121.582F),
    REAL_CONST(-95.2148F),
    REAL_CONST(18.3105F),
    REAL_CONST(-72.0215F),
    REAL_CONST(-235.352F),
    REAL_CONST(-144.043F),
    REAL_CONST(-147.949F),
    REAL_CONST(36.6211F),
    REAL_CONST(-29.5410F),
    REAL_CONST(-11.9629F),
    REAL_CONST(-37.8418F),
    REAL_CONST(-19.0430F),
    REAL_CONST(228.271F),
    REAL_CONST(134.277F),
    REAL_CONST(94.9707F),
    REAL_CONST(9.27734F),
    REAL_CONST(-78.3691F),
    REAL_CONST(31.0059F),
    REAL_CONST(103.516F),
    REAL_CONST(76.9043F),
    REAL_CONST(-69.5801F),
    REAL_CONST(-27.5879F),
    REAL_CONST(69.0918F),
    REAL_CONST(63.2324F),
    REAL_CONST(160.645F),
    REAL_CONST(49.5605F),
    REAL_CONST(78.6133F),
    REAL_CONST(118.652F),
    REAL_CONST(220.459F),
    REAL_CONST(123.291F),
    REAL_CONST(182.617F),
    REAL_CONST(101.807F),
    REAL_CONST(149.170F),
    REAL_CONST(103.271F),
    REAL_CONST(135.498F),
    REAL_CONST(125.000F),
    REAL_CONST(58.3496F),
    REAL_CONST(-20.2637F),
    REAL_CONST(-141.113F),
    REAL_CONST(-4.63867F),
    REAL_CONST(-82.7637F),
    REAL_CONST(-178.467F),
    REAL_CONST(85.2051F),
    REAL_CONST(3.17383F),
    REAL_CONST(-228.027F),
    REAL_CONST(-341.553F),
    REAL_CONST(-27.8320F),
    REAL_CONST(-87.8906F),
    REAL_CONST(26.1230F),
    REAL_CONST(168.945F),
    REAL_CONST(44.4336F),
    REAL_CONST(21.9727F),
    REAL_CONST(-303.467F),
    REAL_CONST(-375.488F),
    REAL_CONST(-378.662F),
    REAL_CONST(-177.002F),
    REAL_CONST(-138.672F),
    REAL_CONST(-220.459F),
    REAL_CONST(-332.764F),
    REAL_CONST(-128.174F),
    REAL_CONST(-126.221F),
    REAL_CONST(-208.252F),
    REAL_CONST(-210.205F),
    REAL_CONST(-245.117F),
    REAL_CONST(-41.0156F),
    REAL_CONST(-168.457F),
    REAL_CONST(-203.857F),
    REAL_CONST(15.3809F),
    REAL_CONST(-33.4473F),
    REAL_CONST(-135.742F),
    REAL_CONST(-133.545F),
    REAL_CONST(35.1563F),
    REAL_CONST(-69.8242F),
    REAL_CONST(-199.463F),
    REAL_CONST(118.408F),
    REAL_CONST(77.8809F),
    REAL_CONST(-35.8887F),
    REAL_CONST(-99.6094F),
    REAL_CONST(128.418F),
    REAL_CONST(60.0586F),
    REAL_CONST(-84.7168F),
    REAL_CONST(-105.957F),
    REAL_CONST(72.5098F),
    REAL_CONST(-6.83594F),
    REAL_CONST(-70.8008F),
    REAL_CONST(-114.990F),
    REAL_CONST(-270.996F),
    REAL_CONST(-313.721F),
    REAL_CONST(-112.305F),
    REAL_CONST(-87.6465F),
    REAL_CONST(-241.211F),
    REAL_CONST(-193.848F),
    REAL_CONST(328.857F),
    REAL_CONST(317.139F),
    REAL_CONST(168.457F),
    REAL_CONST(127.686F),
    REAL_CONST(296.875F),
    REAL_CONST(260.742F),
    REAL_CONST(267.090F),
    REAL_CONST(184.814F),
    REAL_CONST(201.416F),
    REAL_CONST(278.320F),
    REAL_CONST(183.594F),
    REAL_CONST(120.605F),
    REAL_CONST(305.664F),
    REAL_CONST(333.252F),
    REAL_CONST(291.748F),
    REAL_CONST(219.238F),
    REAL_CONST(127.197F),
    REAL_CONST(257.080F),
    REAL_CONST(129.883F),
    REAL_CONST(105.469F),
    REAL_CONST(-81.5430F),
    REAL_CONST(-52.7344F),
    REAL_CONST(-76.4160F),
    REAL_CONST(-64.2090F),
    REAL_CONST(-39.0625F),
    REAL_CONST(12.6953F),
    REAL_CONST(-115.234F),
    REAL_CONST(-37.8418F),
    REAL_CONST(31.0059F),
    REAL_CONST(33.2031F),
    REAL_CONST(-92.7734F),
    REAL_CONST(10.7422F),
    REAL_CONST(207.764F),
    REAL_CONST(100.098F),
    REAL_CONST(-39.5508F),
    REAL_CONST(-119.385F),
    REAL_CONST(30.0293F),
    REAL_CONST(-62.2559F),
    REAL_CONST(-194.336F),
    REAL_CONST(-162.842F),
    REAL_CONST(266.113F),
    REAL_CONST(223.877F),
    REAL_CONST(192.627F),
    REAL_CONST(120.361F),
    REAL_CONST(341.064F),
    REAL_CONST(292.236F),
    REAL_CONST(136.230F),
    REAL_CONST(49.3164F),
    REAL_CONST(-12.4512F),
    REAL_CONST(-28.8086F),
    REAL_CONST(-83.4961F),
    REAL_CONST(-171.143F),
    REAL_CONST(20.2637F),
    REAL_CONST(26.3672F),
    REAL_CONST(-10.2539F),
    REAL_CONST(-107.666F),
    REAL_CONST(14.8926F),
    REAL_CONST(23.1934F),
    REAL_CONST(70.0684F),
    REAL_CONST(62.5000F),
    REAL_CONST(-6.59180F),
    REAL_CONST(21.7285F),
    REAL_CONST(127.930F),
    REAL_CONST(129.639F),
    REAL_CONST(85.6934F),
    REAL_CONST(55.4199F),
    REAL_CONST(144.531F),
    REAL_CONST(133.057F),
    REAL_CONST(170.166F),
    REAL_CONST(37.8418F),
    REAL_CONST(-40.0391F),
    REAL_CONST(74.9512F),
    REAL_CONST(155.762F),
    REAL_CONST(66.8945F),
    REAL_CONST(-119.385F),
    REAL_CONST(-12.2070F),
    REAL_CONST(184.082F),
    REAL_CONST(58.5938F),
    REAL_CONST(-40.5273F),
    REAL_CONST(-30.2734F),
    REAL_CONST(-28.3203F),
    REAL_CONST(-141.357F),
    REAL_CONST(-295.898F),
    REAL_CONST(-15.3809F),
    REAL_CONST(46.3867F),
    REAL_CONST(-72.0215F),
    REAL_CONST(-253.906F),
    REAL_CONST(-316.406F),
    REAL_CONST(35.8887F),
    REAL_CONST(-91.7969F),
    REAL_CONST(-43.2129F),
    REAL_CONST(-27.5879F),
    REAL_CONST(205.322F),
    REAL_CONST(302.979F),
    REAL_CONST(256.592F),
    REAL_CONST(163.086F),
    REAL_CONST(0.488281F),
    REAL_CONST(71.5332F),
    REAL_CONST(134.521F),
    REAL_CONST(74.2188F),
    REAL_CONST(-267.578F),
    REAL_CONST(-232.666F),
    REAL_CONST(-60.5469F),
    REAL_CONST(91.7969F),
    REAL_CONST(-183.105F),
    REAL_CONST(-235.596F),
    REAL_CONST(21.2402F),
    REAL_CONST(125.977F),
    REAL_CONST(-67.1387F),
    REAL_CONST(-125.977F),
    REAL_CONST(168.213F),
    REAL_CONST(95.4590F),
    REAL_CONST(-92.5293F),
    REAL_CONST(-156.982F),
    REAL_CONST(213.867F),
    REAL_CONST(145.020F),
    REAL_CONST(-95.2148F),
    REAL_CONST(-247.314F),
    REAL_CONST(-157.471F),
    REAL_CONST(139.893F),
    REAL_CONST(-26.1230F),
    REAL_CONST(-138.672F),
    REAL_CONST(-168.213F),
    REAL_CONST(-201.660F),
    REAL_CONST(-250.244F),
    REAL_CONST(-6.59180F),
    REAL_CONST(-80.0781F),
    REAL_CONST(-49.5605F),
    REAL_CONST(210.205F),
    REAL_CONST(182.861F),
    REAL_CONST(133.789F),
    REAL_CONST(56.8848F),
    REAL_CONST(-405.273F),
    REAL_CONST(-254.639F),
    REAL_CONST(110.107F),
    REAL_CONST(26.3672F),
    REAL_CONST(-161.133F),
    REAL_CONST(-151.367F),
    REAL_CONST(104.980F),
    REAL_CONST(57.6172F),
    REAL_CONST(5.12695F),
    REAL_CONST(-96.6797F),
    REAL_CONST(-282.715F),
    REAL_CONST(-154.053F),
    REAL_CONST(334.961F),
    REAL_CONST(316.895F),
    REAL_CONST(236.084F),
    REAL_CONST(140.869F),
    REAL_CONST(274.658F),
    REAL_CONST(274.658F),
    REAL_CONST(143.799F),
    REAL_CONST(110.840F),
    REAL_CONST(-78.8574F),
    REAL_CONST(-211.182F),
    REAL_CONST(-114.014F),
    REAL_CONST(37.3535F),
    REAL_CONST(-114.258F),
    REAL_CONST(-170.654F),
    REAL_CONST(-196.289F),
    REAL_CONST(-124.268F),
    REAL_CONST(-95.7031F),
    REAL_CONST(-175.293F),
    REAL_CONST(-49.8047F),
    REAL_CONST(-8.54492F),
    REAL_CONST(-147.217F),
    REAL_CONST(-266.846F),
    REAL_CONST(-138.428F),
    REAL_CONST(-39.5508F),
    REAL_CONST(-123.291F),
    REAL_CONST(-245.117F),
    REAL_CONST(-24.9023F),
    REAL_CONST(85.4492F),
    REAL_CONST(53.4668F),
    REAL_CONST(54.6875F),
    REAL_CONST(103.271F),
    REAL_CONST(61.5234F),
    REAL_CONST(96.4355F),
    REAL_CONST(144.287F),
    REAL_CONST(148.438F),
    REAL_CONST(88.6230F),
    REAL_CONST(-182.129F),
    REAL_CONST(-23.4375F),
    REAL_CONST(91.0645F),
    REAL_CONST(41.9922F),
    REAL_CONST(41.7480F),
    REAL_CONST(72.0215F),
    REAL_CONST(174.316F),
    REAL_CONST(82.7637F),
    REAL_CONST(56.8848F),
    REAL_CONST(18.7988F),
    REAL_CONST(26.1230F),
    REAL_CONST(67.6270F),
    REAL_CONST(38.3301F),
    REAL_CONST(37.3535F),
    REAL_CONST(-121.826F),
    REAL_CONST(-86.9141F),
    REAL_CONST(377.686F),
    REAL_CONST(261.963F),
    REAL_CONST(140.625F),
    REAL_CONST(120.605F),
    REAL_CONST(-71.2891F),
    REAL_CONST(-82.7637F),
    REAL_CONST(-123.047F),
    REAL_CONST(-144.531F),
    REAL_CONST(-220.459F),
    REAL_CONST(-17.5781F),
    REAL_CONST(-151.123F),
    REAL_CONST(-117.432F),
    REAL_CONST(-389.160F),
    REAL_CONST(-272.705F),
    REAL_CONST(-138.428F),
    REAL_CONST(-62.0117F),
    REAL_CONST(-193.604F),
    REAL_CONST(-123.779F),
    REAL_CONST(-137.695F),
    REAL_CONST(-71.0449F),
    REAL_CONST(-120.117F),
    REAL_CONST(-129.883F),
    REAL_CONST(122.559F),
    REAL_CONST(136.719F),
    REAL_CONST(-93.2617F),
    REAL_CONST(104.248F),
    REAL_CONST(146.484F),
    REAL_CONST(56.1523F),
    REAL_CONST(-55.4199F),
    REAL_CONST(116.455F),
    REAL_CONST(61.2793F),
    REAL_CONST(18.3105F),
    REAL_CONST(69.5801F),
    REAL_CONST(205.566F),
    REAL_CONST(198.486F),
    REAL_CONST(116.211F),
    REAL_CONST(-319.824F),
    REAL_CONST(-325.439F),
    REAL_CONST(45.4102F),
    REAL_CONST(92.0410F),
    REAL_CONST(-143.311F),
    REAL_CONST(-223.877F),
    REAL_CONST(156.982F),
    REAL_CONST(93.0176F),
    REAL_CONST(-289.551F),
    REAL_CONST(-135.010F),
    REAL_CONST(100.342F),
    REAL_CONST(20.0195F),
    REAL_CONST(-275.146F),
    REAL_CONST(-200.195F),
    REAL_CONST(-42.4805F),
    REAL_CONST(-131.836F),
    REAL_CONST(-147.461F),
    REAL_CONST(29.0527F),
    REAL_CONST(132.568F),
    REAL_CONST(50.0488F),
    REAL_CONST(-92.7734F),
    REAL_CONST(160.400F),
    REAL_CONST(221.924F),
    REAL_CONST(138.428F),
    REAL_CONST(27.3438F),
    REAL_CONST(-72.7539F),
    REAL_CONST(-91.3086F),
    REAL_CONST(27.8320F),
    REAL_CONST(-209.229F),
    REAL_CONST(-61.2793F),
    REAL_CONST(13.6719F),
    REAL_CONST(38.8184F),
    REAL_CONST(97.9004F),
    REAL_CONST(84.2285F),
    REAL_CONST(-8.30078F),
    REAL_CONST(-34.1797F),
    REAL_CONST(-27.0996F),
    REAL_CONST(-148.193F),
    REAL_CONST(10.0098F),
    REAL_CONST(149.902F),
    REAL_CONST(86.6699F),
    REAL_CONST(-27.8320F),
    REAL_CONST(-18.7988F),
    REAL_CONST(115.723F),
    REAL_CONST(141.113F),
    REAL_CONST(13.6719F),
    REAL_CONST(354.004F),
    REAL_CONST(225.586F),
    REAL_CONST(268.066F),
    REAL_CONST(346.680F),
    REAL_CONST(180.908F),
    REAL_CONST(97.6563F),
    REAL_CONST(60.0586F),
    REAL_CONST(5.37109F),
    REAL_CONST(143.555F),
    REAL_CONST(76.4160F),
    REAL_CONST(-29.5410F),
    REAL_CONST(79.8340F),
    REAL_CONST(202.881F),
    REAL_CONST(115.234F),
    REAL_CONST(-277.832F),
    REAL_CONST(-148.438F),
    REAL_CONST(208.984F),
    REAL_CONST(134.766F),
    REAL_CONST(-302.979F),
    REAL_CONST(-261.719F),
    REAL_CONST(155.762F),
    REAL_CONST(146.484F),
    REAL_CONST(-87.4023F),
    REAL_CONST(62.0117F),
    REAL_CONST(-81.2988F),
    REAL_CONST(-73.9746F),
    REAL_CONST(-157.715F),
    REAL_CONST(180.420F),
    REAL_CONST(87.4023F),
    REAL_CONST(18.0664F),
    REAL_CONST(299.316F),
    REAL_CONST(407.959F),
    REAL_CONST(298.096F),
    REAL_CONST(207.275F),
    REAL_CONST(547.119F),
    REAL_CONST(396.484F),
    REAL_CONST(239.990F),
    REAL_CONST(155.273F),
    REAL_CONST(449.463F),
    REAL_CONST(360.596F),
    REAL_CONST(182.861F),
    REAL_CONST(93.7500F),
    REAL_CONST(85.4492F),
    REAL_CONST(64.2090F),
    REAL_CONST(21.2402F),
    REAL_CONST(31.2500F),
    REAL_CONST(-464.355F),
    REAL_CONST(-229.736F),
    REAL_CONST(-35.1563F),
    REAL_CONST(-15.6250F),
    REAL_CONST(-423.340F),
    REAL_CONST(-62.2559F),
    REAL_CONST(70.3125F),
    REAL_CONST(-7.56836F),
    REAL_CONST(-645.508F),
    REAL_CONST(-302.246F),
    REAL_CONST(89.3555F),
    REAL_CONST(57.3730F),
    REAL_CONST(-401.123F),
    REAL_CONST(-266.602F),
    REAL_CONST(-328.125F),
    REAL_CONST(-74.2188F),
    REAL_CONST(-132.080F),
    REAL_CONST(-262.451F),
    REAL_CONST(-272.461F),
    REAL_CONST(30.0293F),
    REAL_CONST(-287.598F),
    REAL_CONST(-61.5234F),
    REAL_CONST(-199.219F),
    REAL_CONST(-43.9453F),
    REAL_CONST(-248.047F),
    REAL_CONST(130.127F),
    REAL_CONST(137.939F),
    REAL_CONST(56.8848F),
    REAL_CONST(-118.896F),
    REAL_CONST(-104.980F),
    REAL_CONST(-45.8984F),
    REAL_CONST(81.5430F),
    REAL_CONST(211.670F),
    REAL_CONST(301.758F),
    REAL_CONST(130.371F),
    REAL_CONST(41.7480F),
    REAL_CONST(-388.184F),
    REAL_CONST(-392.334F),
    REAL_CONST(155.029F),
    REAL_CONST(153.809F),
    REAL_CONST(-536.133F),
    REAL_CONST(75.6836F),
    REAL_CONST(225.586F),
    REAL_CONST(100.586F),
    REAL_CONST(-575.684F),
    REAL_CONST(-80.0781F),
    REAL_CONST(233.398F),
    REAL_CONST(129.150F),
    REAL_CONST(-644.287F),
    REAL_CONST(-92.0410F),
    REAL_CONST(153.809F),
    REAL_CONST(67.8711F),
    REAL_CONST(-635.254F),
    REAL_CONST(77.3926F),
    REAL_CONST(195.068F),
    REAL_CONST(72.9980F),
    REAL_CONST(-587.402F),
    REAL_CONST(32.4707F),
    REAL_CONST(83.0078F),
    REAL_CONST(7.56836F),
    REAL_CONST(-526.367F),
    REAL_CONST(-358.398F),
    REAL_CONST(31.9824F),
    REAL_CONST(30.5176F),
    REAL_CONST(-289.063F),
    REAL_CONST(-119.629F),
    REAL_CONST(-33.9355F),
    REAL_CONST(11.2305F),
    REAL_CONST(-181.641F),
    REAL_CONST(109.131F),
    REAL_CONST(217.529F),
    REAL_CONST(137.695F),
    REAL_CONST(16.3574F),
    REAL_CONST(-110.107F),
    REAL_CONST(157.715F),
    REAL_CONST(147.461F),
    REAL_CONST(-135.010F),
    REAL_CONST(-104.736F),
    REAL_CONST(-213.867F),
    REAL_CONST(96.6797F),
    REAL_CONST(39.5508F),
    REAL_CONST(-16.1133F),
    REAL_CONST(318.604F),
    REAL_CONST(223.389F),
    REAL_CONST(116.943F),
    REAL_CONST(141.357F),
    REAL_CONST(265.625F),
    REAL_CONST(193.848F),
    REAL_CONST(109.863F),
    REAL_CONST(67.8711F),
    REAL_CONST(138.184F),
    REAL_CONST(79.1016F),
    REAL_CONST(-258.057F),
    REAL_CONST(-37.5977F),
    REAL_CONST(36.1328F),
    REAL_CONST(-43.2129F),
    REAL_CONST(-621.338F),
    REAL_CONST(41.0156F),
    REAL_CONST(261.230F),
    REAL_CONST(144.531F),
    REAL_CONST(-573.975F),
    REAL_CONST(-10.2539F),
    REAL_CONST(199.951F),
    REAL_CONST(84.2285F),
    REAL_CONST(-572.266F),
    REAL_CONST(-172.607F),
    REAL_CONST(176.025F),
    REAL_CONST(61.0352F),
    REAL_CONST(-531.006F),
    REAL_CONST(-365.479F),
    REAL_CONST(-75.4395F),
    REAL_CONST(29.7852F),
    REAL_CONST(-19.0430F),
    REAL_CONST(-17.8223F),
    REAL_CONST(29.2969F),
    REAL_CONST(42.2363F),
    REAL_CONST(-0.976563F),
    REAL_CONST(63.9648F),
    REAL_CONST(-64.2090F),
    REAL_CONST(-63.7207F),
    REAL_CONST(-105.225F),
    REAL_CONST(-15.6250F),
    REAL_CONST(-98.8770F),
    REAL_CONST(-178.711F),
    REAL_CONST(-636.963F),
    REAL_CONST(28.3203F),
    REAL_CONST(-20.2637F),
    REAL_CONST(-47.1191F),
    REAL_CONST(-372.314F),
    REAL_CONST(-230.469F),
    REAL_CONST(-116.455F),
    REAL_CONST(-177.002F),
    REAL_CONST(-124.023F),
    REAL_CONST(74.9512F),
    REAL_CONST(41.5039F),
    REAL_CONST(41.9922F),
    REAL_CONST(203.125F),
    REAL_CONST(101.807F),
    REAL_CONST(203.125F),
    REAL_CONST(167.480F),
    REAL_CONST(-54.9316F),
    REAL_CONST(43.2129F),
    REAL_CONST(218.262F),
    REAL_CONST(199.707F),
    REAL_CONST(-117.676F),
    REAL_CONST(-94.9707F),
    REAL_CONST(312.256F),
    REAL_CONST(253.662F),
    REAL_CONST(-93.5059F),
    REAL_CONST(49.0723F),
    REAL_CONST(-85.4492F),
    REAL_CONST(9.76563F),
    REAL_CONST(178.223F),
    REAL_CONST(155.029F),
    REAL_CONST(55.1758F),
    REAL_CONST(128.418F),
    REAL_CONST(122.803F),
    REAL_CONST(112.793F),
    REAL_CONST(82.5195F),
    REAL_CONST(97.1680F),
    REAL_CONST(130.615F),
    REAL_CONST(174.316F),
    REAL_CONST(9.76563F),
    REAL_CONST(-68.8477F),
    REAL_CONST(361.816F),
    REAL_CONST(359.131F),
    REAL_CONST(264.893F),
    REAL_CONST(178.467F),
    REAL_CONST(381.104F),
    REAL_CONST(261.719F),
    REAL_CONST(221.924F),
    REAL_CONST(169.189F),
    REAL_CONST(346.436F),
    REAL_CONST(312.988F),
    REAL_CONST(217.041F),
    REAL_CONST(214.600F),
    REAL_CONST(281.494F),
    REAL_CONST(177.734F),
    REAL_CONST(289.551F),
    REAL_CONST(205.078F),
    REAL_CONST(-55.1758F),
    REAL_CONST(275.879F),
    REAL_CONST(231.689F),
    REAL_CONST(168.213F),
    REAL_CONST(-120.605F),
    REAL_CONST(-240.723F),
    REAL_CONST(-379.883F),
    REAL_CONST(-31.2500F),
    REAL_CONST(-138.672F),
    REAL_CONST(-176.025F),
    REAL_CONST(-174.072F),
    REAL_CONST(-6.34766F),
    REAL_CONST(77.3926F),
    REAL_CONST(127.930F),
    REAL_CONST(17.0898F),
    REAL_CONST(32.9590F),
    REAL_CONST(-98.8770F),
    REAL_CONST(-211.182F),
    REAL_CONST(-431.152F),
    REAL_CONST(-159.180F),
    REAL_CONST(-42.4805F),
    REAL_CONST(-195.557F),
    REAL_CONST(216.064F),
    REAL_CONST(188.721F),
    REAL_CONST(-37.3535F),
    REAL_CONST(-22.2168F),
    REAL_CONST(268.311F),
    REAL_CONST(183.350F),
    REAL_CONST(-123.535F),
    REAL_CONST(-280.518F),
    REAL_CONST(208.252F),
    REAL_CONST(157.715F),
    REAL_CONST(58.8379F),
    REAL_CONST(190.918F),
    REAL_CONST(126.709F),
    REAL_CONST(131.592F),
    REAL_CONST(452.393F),
    REAL_CONST(415.039F),
    REAL_CONST(268.799F),
    REAL_CONST(166.992F),
    REAL_CONST(-304.932F),
    REAL_CONST(-362.793F),
    REAL_CONST(-113.281F),
    REAL_CONST(45.8984F),
    REAL_CONST(-218.018F),
    REAL_CONST(-343.994F),
    REAL_CONST(-320.313F),
    REAL_CONST(-83.2520F),
    REAL_CONST(-32.9590F),
    REAL_CONST(106.934F),
    REAL_CONST(-42.7246F),
    REAL_CONST(4.39453F),
    REAL_CONST(271.240F),
    REAL_CONST(238.281F),
    REAL_CONST(77.8809F),
    REAL_CONST(50.7813F),
    REAL_CONST(-349.121F),
    REAL_CONST(-431.641F),
    REAL_CONST(20.2637F),
    REAL_CONST(111.816F),
    REAL_CONST(-129.395F),
    REAL_CONST(-244.141F),
    REAL_CONST(74.9512F),
    REAL_CONST(31.4941F),
    REAL_CONST(-205.078F),
    REAL_CONST(-3.66211F),
    REAL_CONST(-7.08008F),
    REAL_CONST(-86.9141F),
    REAL_CONST(-222.412F),
    REAL_CONST(-225.586F),
    REAL_CONST(-280.029F),
    REAL_CONST(-59.0820F),
    REAL_CONST(-29.0527F),
    REAL_CONST(-128.906F),
    REAL_CONST(31.0059F),
    REAL_CONST(-32.4707F),
    REAL_CONST(-185.791F),
    REAL_CONST(-186.768F),
    REAL_CONST(46.3867F),
    REAL_CONST(-20.2637F),
    REAL_CONST(-76.9043F),
    REAL_CONST(218.506F),
    REAL_CONST(127.441F),
    REAL_CONST(56.3965F),
    REAL_CONST(-54.1992F),
    REAL_CONST(24.9023F),
    REAL_CONST(-15.3809F),
    REAL_CONST(-104.492F),
    REAL_CONST(77.1484F),
    REAL_CONST(170.654F),
    REAL_CONST(92.5293F),
    REAL_CONST(17.0898F),
    REAL_CONST(6.10352F),
    REAL_CONST(174.805F),
    REAL_CONST(76.6602F),
    REAL_CONST(-26.3672F),
    REAL_CONST(123.779F),
    REAL_CONST(213.379F),
    REAL_CONST(138.184F),
    REAL_CONST(58.1055F),
    REAL_CONST(26.3672F),
    REAL_CONST(229.736F),
    REAL_CONST(126.709F),
    REAL_CONST(47.6074F),
    REAL_CONST(103.760F),
    REAL_CONST(-14.6484F),
    REAL_CONST(-104.248F),
    REAL_CONST(62.7441F),
    REAL_CONST(33.9355F),
    REAL_CONST(-25.1465F),
    REAL_CONST(-153.809F),
    REAL_CONST(108.887F),
    REAL_CONST(81.5430F),
    REAL_CONST(90.3320F),
    REAL_CONST(100.586F),
    REAL_CONST(11.7188F),
    REAL_CONST(-41.9922F),
    REAL_CONST(-168.457F),
    REAL_CONST(-69.0918F),
    REAL_CONST(135.986F),
    REAL_CONST(45.6543F),
    REAL_CONST(-69.8242F),
    REAL_CONST(38.5742F),
    REAL_CONST(117.920F),
    REAL_CONST(34.1797F),
    REAL_CONST(65.9180F),
    REAL_CONST(-83.9844F),
    REAL_CONST(-154.053F),
    REAL_CONST(225.586F),
    REAL_CONST(141.357F),
    REAL_CONST(-28.3203F),
    REAL_CONST(32.2266F),
    REAL_CONST(34.6680F),
    REAL_CONST(113.770F),
    REAL_CONST(-16.6016F),
    REAL_CONST(-15.6250F),
    REAL_CONST(56.1523F),
    REAL_CONST(-35.4004F),
    REAL_CONST(-73.7305F),
    REAL_CONST(-132.324F),
    REAL_CONST(-196.045F),
    REAL_CONST(-222.656F),
    REAL_CONST(248.535F),
    REAL_CONST(179.932F),
    REAL_CONST(-188.721F),
    REAL_CONST(247.803F),
    REAL_CONST(153.809F),
    REAL_CONST(72.5098F),
    REAL_CONST(-633.789F),
    REAL_CONST(23.1934F),
    REAL_CONST(108.643F),
    REAL_CONST(82.0313F),
    REAL_CONST(-518.066F),
    REAL_CONST(119.873F),
    REAL_CONST(124.512F),
    REAL_CONST(46.6309F),
    REAL_CONST(-305.908F),
    REAL_CONST(39.3066F),
    REAL_CONST(-0.488281F),
    REAL_CONST(-79.1016F),
    REAL_CONST(-354.004F),
    REAL_CONST(-154.541F),
    REAL_CONST(-173.828F),
    REAL_CONST(-25.6348F),
    REAL_CONST(-205.566F),
    REAL_CONST(-62.0117F),
    REAL_CONST(-100.342F),
    REAL_CONST(24.4141F),
    REAL_CONST(-156.250F),
    REAL_CONST(-70.8008F),
    REAL_CONST(246.582F),
    REAL_CONST(186.279F),
    REAL_CONST(-158.691F),
    REAL_CONST(76.4160F),
    REAL_CONST(285.400F),
    REAL_CONST(178.223F),
    REAL_CONST(34.1797F),
    REAL_CONST(123.291F),
    REAL_CONST(251.465F),
    REAL_CONST(187.012F),
    REAL_CONST(188.477F),
    REAL_CONST(70.0684F),
    REAL_CONST(260.498F),
    REAL_CONST(200.928F),
    REAL_CONST(120.850F),
    REAL_CONST(182.861F),
    REAL_CONST(74.4629F),
    REAL_CONST(78.8574F),
    REAL_CONST(-40.0391F),
    REAL_CONST(112.793F),
    REAL_CONST(19.0430F),
    REAL_CONST(97.4121F),
    REAL_CONST(-83.4961F),
    REAL_CONST(-213.379F),
    REAL_CONST(16.8457F),
    REAL_CONST(145.752F),
    REAL_CONST(-3.90625F),
    REAL_CONST(151.367F),
    REAL_CONST(151.611F),
    REAL_CONST(82.2754F),
    REAL_CONST(-33.6914F),
    REAL_CONST(-108.398F),
    REAL_CONST(-64.6973F),
    REAL_CONST(53.2227F),
    REAL_CONST(20.5078F),
    REAL_CONST(-109.863F),
    REAL_CONST(232.666F),
    REAL_CONST(162.598F),
    REAL_CONST(-54.1992F),
    REAL_CONST(-196.045F),
    REAL_CONST(132.080F),
    REAL_CONST(147.461F),
    REAL_CONST(-224.854F),
    REAL_CONST(-335.938F),
    REAL_CONST(59.5703F),
    REAL_CONST(28.3203F),
    REAL_CONST(-205.322F),
    REAL_CONST(-176.514F),
    REAL_CONST(153.809F),
    REAL_CONST(143.555F),
    REAL_CONST(34.1797F),
    REAL_CONST(161.865F),
    REAL_CONST(71.7773F),
    REAL_CONST(89.8438F),
    REAL_CONST(228.271F),
    REAL_CONST(255.371F),
    REAL_CONST(215.088F),
    REAL_CONST(185.303F),
    REAL_CONST(426.270F),
    REAL_CONST(357.422F),
    REAL_CONST(223.633F),
    REAL_CONST(153.320F),
    REAL_CONST(106.445F),
    REAL_CONST(235.107F),
    REAL_CONST(68.6035F),
    REAL_CONST(0.244141F),
    REAL_CONST(-29.0527F),
    REAL_CONST(18.0664F),
    REAL_CONST(132.324F),
    REAL_CONST(52.0020F),
    REAL_CONST(0.244141F),
    REAL_CONST(-138.428F),
    REAL_CONST(73.4863F),
    REAL_CONST(58.8379F),
    REAL_CONST(63.4766F),
    REAL_CONST(106.201F),
    REAL_CONST(54.1992F),
    REAL_CONST(96.6797F),
    REAL_CONST(228.516F),
    REAL_CONST(233.643F),
    REAL_CONST(270.508F),
    REAL_CONST(171.631F),
    REAL_CONST(124.512F),
    REAL_CONST(123.535F),
    REAL_CONST(197.266F),
    REAL_CONST(116.699F),
    REAL_CONST(146.729F),
    REAL_CONST(169.434F),
    REAL_CONST(234.375F),
    REAL_CONST(151.367F),
    REAL_CONST(237.305F),
    REAL_CONST(180.908F),
    REAL_CONST(239.258F),
    REAL_CONST(146.484F),
    REAL_CONST(203.613F),
    REAL_CONST(175.049F),
    REAL_CONST(187.256F),
    REAL_CONST(166.992F),
    REAL_CONST(156.982F),
    REAL_CONST(237.305F),
    REAL_CONST(228.271F),
    REAL_CONST(155.762F),
    REAL_CONST(122.314F),
    REAL_CONST(161.377F),
    REAL_CONST(175.781F),
    REAL_CONST(207.764F),
    REAL_CONST(-25.6348F),
    REAL_CONST(-154.297F),
    REAL_CONST(-73.9746F),
    REAL_CONST(-28.5645F),
    REAL_CONST(-104.736F),
    REAL_CONST(31.7383F),
    REAL_CONST(192.627F),
    REAL_CONST(107.910F),
    REAL_CONST(-127.441F),
    REAL_CONST(-45.8984F),
    REAL_CONST(171.875F),
    REAL_CONST(91.0645F),
    REAL_CONST(-185.303F),
    REAL_CONST(10.2539F),
    REAL_CONST(198.730F),
    REAL_CONST(127.686F),
    REAL_CONST(-129.639F),
    REAL_CONST(-277.588F),
    REAL_CONST(91.0645F),
    REAL_CONST(141.113F),
    REAL_CONST(-166.504F),
    REAL_CONST(-293.701F),
    REAL_CONST(-111.084F),
    REAL_CONST(69.5801F),
    REAL_CONST(-283.936F),
    REAL_CONST(-385.010F),
    REAL_CONST(-268.066F),
    REAL_CONST(10.7422F),
    REAL_CONST(19.7754F),
    REAL_CONST(-20.0195F),
    REAL_CONST(173.828F),
    REAL_CONST(88.6230F),
    REAL_CONST(116.455F),
    REAL_CONST(60.0586F),
    REAL_CONST(232.910F),
    REAL_CONST(151.855F),
    REAL_CONST(391.602F),
    REAL_CONST(395.996F),
    REAL_CONST(311.768F),
    REAL_CONST(217.529F),
    REAL_CONST(343.994F),
    REAL_CONST(209.717F),
    REAL_CONST(225.586F),
    REAL_CONST(217.773F),
    REAL_CONST(188.965F),
    REAL_CONST(254.150F),
    REAL_CONST(231.201F),
    REAL_CONST(278.809F),
    REAL_CONST(9.76563F),
    REAL_CONST(-133.301F),
    REAL_CONST(-18.3105F),
    REAL_CONST(70.3125F),
    REAL_CONST(-150.391F),
    REAL_CONST(-25.8789F),
    REAL_CONST(-170.166F),
    REAL_CONST(-6.34766F),
    REAL_CONST(-41.2598F),
    REAL_CONST(-39.0625F),
    REAL_CONST(-217.529F),
    REAL_CONST(-180.420F),
    REAL_CONST(-68.1152F),
    REAL_CONST(-93.7500F),
    REAL_CONST(-251.221F),
    REAL_CONST(-85.4492F),
    REAL_CONST(434.814F),
    REAL_CONST(319.336F),
    REAL_CONST(255.371F),
    REAL_CONST(199.219F),
    REAL_CONST(385.742F),
    REAL_CONST(374.268F),
    REAL_CONST(359.375F),
    REAL_CONST(287.598F),
    REAL_CONST(367.432F),
    REAL_CONST(262.695F),
    REAL_CONST(296.875F),
    REAL_CONST(219.482F),
    REAL_CONST(217.285F),
    REAL_CONST(220.703F),
    REAL_CONST(137.695F),
    REAL_CONST(159.668F),
    REAL_CONST(224.609F),
    REAL_CONST(168.945F),
    REAL_CONST(249.268F),
    REAL_CONST(208.984F),
    REAL_CONST(-120.361F),
    REAL_CONST(32.2266F),
    REAL_CONST(43.2129F),
    REAL_CONST(123.291F),
    REAL_CONST(17.3340F),
    REAL_CONST(47.6074F),
    REAL_CONST(-6.83594F),
    REAL_CONST(23.6816F),
    REAL_CONST(111.328F),
    REAL_CONST(85.6934F),
    REAL_CONST(-40.0391F),
    REAL_CONST(21.4844F),
    REAL_CONST(107.178F),
    REAL_CONST(67.8711F),
    REAL_CONST(-9.76563F),
    REAL_CONST(85.4492F),
    REAL_CONST(340.576F),
    REAL_CONST(231.689F),
    REAL_CONST(57.1289F),
    REAL_CONST(-23.1934F),
    REAL_CONST(-196.533F),
    REAL_CONST(-115.234F),
    REAL_CONST(9.27734F),
    REAL_CONST(-39.7949F),
    REAL_CONST(89.5996F),
    REAL_CONST(-23.9258F),
    REAL_CONST(119.385F),
    REAL_CONST(127.686F),
    REAL_CONST(250.244F),
    REAL_CONST(287.598F),
    REAL_CONST(295.898F),
    REAL_CONST(221.191F),
    REAL_CONST(77.8809F),
    REAL_CONST(320.801F),
    REAL_CONST(198.730F),
    REAL_CONST(112.549F),
    REAL_CONST(-30.0293F),
    REAL_CONST(-132.568F),
    REAL_CONST(-196.289F),
    REAL_CONST(109.131F),
    REAL_CONST(-182.617F),
    REAL_CONST(-79.1016F),
    REAL_CONST(-218.994F),
    REAL_CONST(-275.146F),
    REAL_CONST(-179.932F),
    REAL_CONST(-122.314F),
    REAL_CONST(-192.627F),
    REAL_CONST(-174.072F),
    REAL_CONST(174.561F),
    REAL_CONST(189.697F),
    REAL_CONST(302.490F),
    REAL_CONST(225.098F),
    REAL_CONST(475.830F),
    REAL_CONST(473.389F),
    REAL_CONST(333.984F),
    REAL_CONST(211.182F),
    REAL_CONST(178.223F),
    REAL_CONST(214.844F),
    REAL_CONST(185.059F),
    REAL_CONST(94.7266F),
    REAL_CONST(-212.646F),
    REAL_CONST(110.840F),
    REAL_CONST(4.15039F),
    REAL_CONST(-61.2793F),
    REAL_CONST(-93.0176F),
    REAL_CONST(-197.754F),
    REAL_CONST(-386.475F),
    REAL_CONST(58.3496F),
    REAL_CONST(-127.197F),
    REAL_CONST(-235.840F),
    REAL_CONST(-193.359F),
    REAL_CONST(63.2324F),
    REAL_CONST(-217.285F),
    REAL_CONST(-331.543F),
    REAL_CONST(-187.988F),
    REAL_CONST(-17.8223F),
    REAL_CONST(40.5273F),
    REAL_CONST(85.2051F),
    REAL_CONST(-51.7578F),
    REAL_CONST(78.8574F),
    REAL_CONST(-205.078F),
    REAL_CONST(-73.4863F),
    REAL_CONST(115.479F),
    REAL_CONST(106.201F),
    REAL_CONST(-165.771F),
    REAL_CONST(-113.281F),
    REAL_CONST(177.734F),
    REAL_CONST(85.6934F),
    REAL_CONST(-38.0859F),
    REAL_CONST(-48.5840F),
    REAL_CONST(162.842F),
    REAL_CONST(105.469F),
    REAL_CONST(7.08008F),
    REAL_CONST(-61.5234F),
    REAL_CONST(101.318F),
    REAL_CONST(117.188F),
    REAL_CONST(-178.467F),
    REAL_CONST(-92.5293F),
    REAL_CONST(35.4004F),
    REAL_CONST(136.475F),
    REAL_CONST(-128.906F),
    REAL_CONST(-154.053F),
    REAL_CONST(-282.715F),
    REAL_CONST(-38.8184F),
    REAL_CONST(108.643F),
    REAL_CONST(66.6504F),
    REAL_CONST(30.0293F),
    REAL_CONST(156.006F),
    REAL_CONST(91.0645F),
    REAL_CONST(-30.7617F),
    REAL_CONST(195.313F),
    REAL_CONST(138.672F),
    REAL_CONST(20.5078F),
    REAL_CONST(-39.5508F),
    REAL_CONST(175.781F),
    REAL_CONST(173.828F),
    REAL_CONST(-202.637F),
    REAL_CONST(-130.859F),
    REAL_CONST(-45.1660F),
    REAL_CONST(54.1992F),
    REAL_CONST(99.6094F),
    REAL_CONST(110.352F),
    REAL_CONST(122.314F),
    REAL_CONST(188.232F),
    REAL_CONST(-218.994F),
    REAL_CONST(-330.811F),
    REAL_CONST(-16.3574F),
    REAL_CONST(107.910F),
    REAL_CONST(-193.359F),
    REAL_CONST(-343.262F),
    REAL_CONST(138.184F),
    REAL_CONST(146.973F),
    REAL_CONST(40.7715F),
    REAL_CONST(-79.5898F),
    REAL_CONST(124.268F),
    REAL_CONST(80.5664F),
    REAL_CONST(-23.1934F),
    REAL_CONST(-152.832F),
    REAL_CONST(-178.223F),
    REAL_CONST(-83.9844F),
    REAL_CONST(407.227F),
    REAL_CONST(297.119F),
    REAL_CONST(190.186F),
    REAL_CONST(111.084F),
    REAL_CONST(321.289F),
    REAL_CONST(202.148F),
    REAL_CONST(142.578F),
    REAL_CONST(175.537F),
    REAL_CONST(98.6328F),
    REAL_CONST(-7.56836F),
    REAL_CONST(247.314F),
    REAL_CONST(192.627F),
    REAL_CONST(21.7285F),
    REAL_CONST(26.1230F),
    REAL_CONST(217.529F),
    REAL_CONST(134.033F),
    REAL_CONST(212.646F),
    REAL_CONST(385.986F),
    REAL_CONST(223.877F),
    REAL_CONST(163.818F),
    REAL_CONST(211.426F),
    REAL_CONST(361.084F),
    REAL_CONST(314.697F),
    REAL_CONST(208.496F),
    REAL_CONST(95.4590F),
    REAL_CONST(260.742F),
    REAL_CONST(273.926F),
    REAL_CONST(198.242F),
    REAL_CONST(19.0430F),
    REAL_CONST(-137.207F),
    REAL_CONST(84.2285F),
    REAL_CONST(137.451F),
    REAL_CONST(104.736F),
    REAL_CONST(-25.1465F),
    REAL_CONST(101.807F),
    REAL_CONST(192.139F),
    REAL_CONST(-29.7852F),
    REAL_CONST(-106.689F),
    REAL_CONST(100.342F),
    REAL_CONST(192.383F),
    REAL_CONST(-222.900F),
    REAL_CONST(-101.807F),
    REAL_CONST(146.973F),
    REAL_CONST(184.082F),
    REAL_CONST(-55.1758F),
    REAL_CONST(-3.90625F),
    REAL_CONST(36.8652F),
    REAL_CONST(185.547F),
    REAL_CONST(-170.898F),
    REAL_CONST(28.8086F),
    REAL_CONST(-25.3906F),
    REAL_CONST(-3.41797F),
    REAL_CONST(-275.391F),
    REAL_CONST(11.7188F),
    REAL_CONST(69.3359F),
    REAL_CONST(95.9473F),
    REAL_CONST(-95.2148F),
    REAL_CONST(-102.295F),
    REAL_CONST(-156.006F),
    REAL_CONST(-28.3203F),
    REAL_CONST(-222.168F),
    REAL_CONST(74.7070F),
    REAL_CONST(77.1484F),
    REAL_CONST(-3.17383F),
    REAL_CONST(294.678F),
    REAL_CONST(240.234F),
    REAL_CONST(200.439F),
    REAL_CONST(163.330F),
    REAL_CONST(-291.748F),
    REAL_CONST(-169.189F),
    REAL_CONST(34.1797F),
    REAL_CONST(-52.0020F),
    REAL_CONST(-215.820F),
    REAL_CONST(-101.563F),
    REAL_CONST(-48.5840F),
    REAL_CONST(-136.230F),
    REAL_CONST(-150.391F),
    REAL_CONST(59.8145F),
    REAL_CONST(-98.6328F),
    REAL_CONST(-162.109F),
    REAL_CONST(63.9648F),
    REAL_CONST(13.6719F),
    REAL_CONST(-150.635F),
    REAL_CONST(-176.758F),
    REAL_CONST(-20.7520F),
    REAL_CONST(-119.873F),
    REAL_CONST(-78.1250F),
    REAL_CONST(-160.156F),
    REAL_CONST(-139.160F),
    REAL_CONST(-202.881F),
    REAL_CONST(-31.4941F),
    REAL_CONST(-128.906F),
    REAL_CONST(-367.676F),
    REAL_CONST(-15.3809F),
    REAL_CONST(-89.5996F),
    REAL_CONST(-93.9941F),
    REAL_CONST(-87.4023F),
    REAL_CONST(-78.3691F),
    REAL_CONST(0.976563F),
    REAL_CONST(12.4512F),
    REAL_CONST(-89.3555F),
    REAL_CONST(-52.2461F),
    REAL_CONST(77.8809F),
    REAL_CONST(124.756F),
    REAL_CONST(35.6445F),
    REAL_CONST(163.818F),
    REAL_CONST(-4.15039F),
    REAL_CONST(-71.0449F),
    REAL_CONST(-26.8555F),
    REAL_CONST(113.281F),
    REAL_CONST(-33.9355F),
    REAL_CONST(-121.094F),
    REAL_CONST(-49.3164F),
    REAL_CONST(53.7109F),
    REAL_CONST(-76.1719F),
    REAL_CONST(-154.053F),
    REAL_CONST(-161.133F),
    REAL_CONST(-17.8223F),
    REAL_CONST(-159.912F),
    REAL_CONST(-200.195F),
    REAL_CONST(-161.621F),
    REAL_CONST(-159.424F),
    REAL_CONST(-314.453F),
    REAL_CONST(-209.229F),
    REAL_CONST(-104.980F),
    REAL_CONST(-232.666F),
    REAL_CONST(-234.131F),
    REAL_CONST(-64.4531F),
    REAL_CONST(-11.9629F),
    REAL_CONST(-114.258F),
    REAL_CONST(-17.5781F),
    REAL_CONST(-93.0176F),
    REAL_CONST(-85.4492F),
    REAL_CONST(-137.451F),
    REAL_CONST(-47.1191F),
    REAL_CONST(-99.3652F),
    REAL_CONST(13.4277F),
    REAL_CONST(-99.6094F),
    REAL_CONST(-196.045F),
    REAL_CONST(2.68555F),
    REAL_CONST(-75.4395F),
    REAL_CONST(158.447F),
    REAL_CONST(45.8984F),
    REAL_CONST(-48.3398F),
    REAL_CONST(-125.000F),
    REAL_CONST(112.549F),
    REAL_CONST(-19.2871F),
    REAL_CONST(-111.816F),
    REAL_CONST(-321.777F),
    REAL_CONST(-64.2090F),
    REAL_CONST(-32.7148F),
    REAL_CONST(-127.686F),
    REAL_CONST(-404.541F),
    REAL_CONST(-106.201F),
    REAL_CONST(-120.850F),
    REAL_CONST(-186.768F),
    REAL_CONST(13.9160F),
    REAL_CONST(-84.7168F),
    REAL_CONST(-101.074F),
    REAL_CONST(105.957F),
    REAL_CONST(-278.564F),
    REAL_CONST(-59.0820F),
    REAL_CONST(-162.109F),
    REAL_CONST(-209.229F),
    REAL_CONST(8.30078F),
    REAL_CONST(-16.6016F),
    REAL_CONST(-172.607F),
    REAL_CONST(-82.5195F)
};

#define MR515_3_SIZE  128

/* third codebook for MR475, MR515 */
static const Float32 mr515_3_lsf[] =
{
   102.295F,
   39.7949F,
   -7.32422F,
   -63.9648F,
   -111.084F,
   -192.627F,
   -349.121F,
   -176.025F,
   245.605F,
   162.109F,
   65.6738F,
   6.10352F,
   151.123F,
   63.4766F,
   44.6777F,
   23.4375F,
   -236.328F,
   -331.543F,
   -94.7266F,
   32.9590F,
   -169.189F,
   203.857F,
   111.328F,
   37.5977F,
   269.775F,
   171.631F,
   138.916F,
   88.6230F,
   396.729F,
   323.730F,
   240.479F,
   182.617F,
   -53.7109F,
   53.4668F,
   18.5547F,
   -50.7813F,
   -355.225F,
   -405.762F,
   11.9629F,
   36.3770F,
   -235.352F,
   -41.9922F,
   -183.594F,
   -82.0313F,
   152.588F,
   51.0254F,
   -61.0352F,
   -16.1133F,
   -248.291F,
   -204.590F,
   -0.488281F,
   77.3926F,
   -529.297F,
   -362.549F,
   -33.6914F,
   30.0293F,
   -458.008F,
   -512.451F,
   -127.197F,
   20.7520F,
   -236.084F,
   -89.3555F,
   -169.678F,
   -215.088F,
   -224.854F,
   -246.826F,
   -186.279F,
   -231.689F,
   -30.2734F,
   -62.5000F,
   -85.9375F,
   -161.133F,
   43.4570F,
   113.037F,
   86.4258F,
   74.2188F,
   -425.781F,
   -144.287F,
   -68.8477F,
   19.2871F,
   -549.072F,
   42.7246F,
   211.670F,
   121.826F,
   -33.6914F,
   -43.9453F,
   -44.1895F,
   -5.12695F,
   -559.326F,
   -302.979F,
   -112.305F,
   -126.953F,
   -188.232F,
   110.107F,
   -2.44141F,
   -75.1953F,
   66.1621F,
   -15.8691F,
   0.976563F,
   52.2461F,
   -68.1152F,
   -106.201F,
   -10.4980F,
   -84.9609F,
   -163.574F,
   8.54492F,
   -15.8691F,
   -51.5137F,
   196.777F,
   130.615F,
   20.7520F,
   72.5098F,
   13.9160F,
   58.3496F,
   176.270F,
   120.361F,
   54.9316F,
   161.377F,
   205.078F,
   133.545F,
   -131.836F,
   -91.7969F,
   3.41797F,
   85.2051F,
   114.502F,
   176.025F,
   80.8105F,
   39.5508F,
   -132.813F,
   -183.594F,
   -15.1367F,
   -2.44141F,
   97.1680F,
   -21.4844F,
   176.758F,
   171.143F,
   -4.63867F,
   -130.127F,
   -22.9492F,
   146.729F,
   33.2031F,
   -17.3340F,
   -166.260F,
   -182.373F,
   -40.5273F,
   -83.9844F,
   63.7207F,
   -12.2070F,
   39.3066F,
   -12.6953F,
   118.408F,
   82.2754F,
   -408.936F,
   12.2070F,
   46.3867F,
   -22.7051F,
   -557.129F,
   -56.3965F,
   -47.3633F,
   -20.0195F,
   -23.1934F,
   -145.264F,
   -37.5977F,
   31.2500F,
   218.262F,
   122.314F,
   143.555F,
   111.572F,
   -84.2285F,
   50.2930F,
   29.7852F,
   26.8555F,
   -154.053F,
   -55.4199F,
   -138.916F,
   0.732422F,
   99.6094F,
   58.3496F,
   96.9238F,
   55.1758F,
   -48.0957F,
   -0.488281F,
   31.2500F,
   119.873F,
   312.744F,
   220.703F,
   71.2891F,
   52.4902F,
   131.348F,
   74.7070F,
   63.2324F,
   124.268F,
   -165.283F,
   -255.615F,
   3.17383F,
   78.3691F,
   -165.771F,
   -143.555F,
   -87.4023F,
   -51.7578F,
   -136.230F,
   59.3262F,
   157.715F,
   116.943F,
   118.652F,
   83.4961F,
   154.785F,
   129.883F,
   26.1230F,
   195.801F,
   80.8105F,
   33.2031F,
   -27.3438F,
   -97.1680F,
   -251.709F,
   -69.8242F,
   -79.5898F,
   -172.119F,
   70.3125F,
   66.4063F,
   317.139F,
   279.297F,
   287.598F,
   209.961F,
   -103.271F,
   29.5410F,
   -93.9941F,
   -36.1328F,
   -72.0215F,
   -73.7305F,
   -203.613F,
   -199.951F,
   3.90625F,
   -5.85938F,
   -49.0723F,
   -116.211F,
   135.498F,
   22.2168F,
   -59.8145F,
   71.7773F,
   -9.27734F,
   -92.5293F,
   -234.863F,
   -298.096F,
   -290.771F,
   -370.605F,
   -66.6504F,
   -96.4355F,
   -95.2148F,
   -247.314F,
   -157.471F,
   139.893F,
   -449.951F,
   -251.465F,
   123.291F,
   114.258F,
   181.641F,
   231.201F,
   148.682F,
   120.361F,
   -168.213F,
   -286.133F,
   -153.320F,
   -32.9590F,
   -250.488F,
   47.6074F,
   100.342F,
   47.8516F,
   386.230F,
   280.029F,
   140.381F,
   82.2754F,
   -302.490F,
   -189.697F,
   -158.203F,
   -34.6680F,
   145.264F,
   201.416F,
   236.084F,
   179.443F,
   -294.434F,
   -236.816F,
   -19.7754F,
   -83.4961F,
   -181.885F,
   3.17383F,
   -17.5781F,
   91.5527F,
   110.840F,
   4.63867F,
   343.506F,
   224.854F,
   -402.100F,
   -41.9922F,
   210.205F,
   137.207F,
   226.563F,
   375.244F,
   259.521F,
   180.664F,
   -603.516F,
   -232.422F,
   64.4531F,
   20.0195F,
   -122.559F,
   -235.596F,
   -325.684F,
   30.0293F,
   211.670F,
   301.758F,
   130.371F,
   41.7480F,
   -566.406F,
   -112.305F,
   190.430F,
   88.6230F,
   -290.527F,
   -150.635F,
   61.5234F,
   -14.8926F,
   -42.4805F,
   8.30078F,
   246.826F,
   192.383F,
   -569.580F,
   60.3027F,
   103.271F,
   37.3535F,
   -3.90625F,
   -86.6699F,
   63.9648F,
   109.619F,
   -384.766F,
   -261.963F,
   -132.813F,
   -90.5762F,
   -150.146F,
   -74.4629F,
   256.592F,
   196.533F,
   167.725F,
   128.906F,
   1.46484F,
   -44.4336F,
   228.271F,
   213.623F,
   244.629F,
   197.510F,
   48.5840F,
   62.7441F,
   30.7617F,
   18.5547F,
   -142.578F,
   -277.832F,
   146.240F,
   135.742F,
   -269.775F,
   -339.600F,
   -388.428F,
   -126.709F,
   -238.525F,
   -323.486F,
   26.3672F,
   84.7168F,
   -176.270F,
   -238.037F,
   89.1113F,
   24.6582F,
   -35.4004F,
   166.260F,
   60.7910F,
   -37.3535F,
   0.000000F,
   -81.5430F,
   -139.160F,
   38.8184F,
   100.586F,
   69.5801F,
   -82.0313F,
   -150.635F,
   -232.666F,
   -235.840F,
   216.553F,
   168.213F,
   -305.420F,
   20.5078F,
   -45.1660F,
   -97.1680F,
   -144.531F,
   105.713F,
   254.883F,
   159.424F,
   20.7520F,
   80.3223F,
   -9.76563F,
   88.1348F,
   -105.713F,
   -172.119F,
   113.770F,
   140.137F,
   -37.5977F,
   159.668F,
   144.531F,
   70.8008F,
   -40.7715F,
   17.5781F,
   85.2051F,
   42.7246F,
   164.551F,
   72.5098F,
   238.525F,
   175.781F,
   301.514F,
   293.945F,
   184.814F,
   119.141F,
   -97.6563F,
   -65.6738F,
   131.348F,
   90.8203F,
   -329.590F,
   -338.623F,
   -291.504F,
   -22.2168F,
   308.105F,
   213.867F,
   189.209F,
   170.898F,
   -146.240F,
   -9.27734F,
   -104.980F,
   -176.270F,
   482.422F,
   397.949F,
   241.943F,
   148.438F,
   27.0996F,
   67.3828F,
   -55.1758F,
   -23.4375F,
   -231.201F,
   -94.7266F,
   -2.68555F,
   -1.70898F,
   -73.9746F,
   -129.639F,
   -204.834F,
   82.5195F,
   423.340F,
   417.480F,
   343.018F,
   247.314F,
   -125.977F,
   -208.740F,
   -157.471F,
   51.2695F,
   -167.969F,
   -101.563F,
   125.244F,
   56.1523F,
   -200.684F,
   -155.518F,
   -279.785F,
   -78.1250F,
   -232.422F,
   -160.645F,
   -169.434F,
   44.6777F,
   -27.8320F,
   -152.100F,
   199.707F,
   164.551F,
   -46.6309F,
   -49.8047F,
   178.467F,
   155.029F,
   12.4512F,
   298.096F,
   215.576F,
   140.625F,
   -232.910F,
   -105.225F,
   201.660F,
   145.996F,
   -83.4961F,
   -184.326F,
   -219.727F,
   -99.3652F,
   -274.902F,
   -86.4258F,
   -50.2930F,
   -125.000F,
   -133.545F,
   -197.754F,
   -87.1582F,
   -151.367F,
   16.1133F,
   125.732F,
   -17.8223F,
   -100.098F,
   -212.891F,
   -230.713F,
   -352.539F,
   -299.561F,
   46.6309F,
   -4.15039F,
   -132.813F,
   -56.3965F,
   -375.977F,
   -132.813F,
   -219.971F,
   -216.309F

};
#define MR795_1_SIZE  512

/* first codebook for MR795 */
static const real_32_t mr795_1_lsf[] =
{
    REAL_CONST(-217.285F),
    REAL_CONST(-378.418F),
    REAL_CONST(-620.361F),
    REAL_CONST(-199.951F),
    REAL_CONST(-236.816F),
    REAL_CONST(42.7246F),
    REAL_CONST(-201.660F),
    REAL_CONST(-301.270F),
    REAL_CONST(-186.035F),
    REAL_CONST(-146.240F),
    REAL_CONST(-5.37109F),
    REAL_CONST(154.785F),
    REAL_CONST(-197.998F),
    REAL_CONST(-240.967F),
    REAL_CONST(-220.215F),
    REAL_CONST(-78.8574F),
    REAL_CONST(49.5605F),
    REAL_CONST(6.34766F),
    REAL_CONST(-93.5059F),
    REAL_CONST(-57.3730F),
    REAL_CONST(-190.674F),
    REAL_CONST(-97.4121F),
    REAL_CONST(308.105F),
    REAL_CONST(221.191F),
    REAL_CONST(-227.539F),
    REAL_CONST(-341.553F),
    REAL_CONST(-336.914F),
    REAL_CONST(-152.344F),
    REAL_CONST(22.7051F),
    REAL_CONST(21.2402F),
    REAL_CONST(-101.074F),
    REAL_CONST(-131.592F),
    REAL_CONST(-168.701F),
    REAL_CONST(9.03320F),
    REAL_CONST(154.541F),
    REAL_CONST(124.512F),
    REAL_CONST(-94.4824F),
    REAL_CONST(-116.211F),
    REAL_CONST(-324.707F),
    REAL_CONST(97.4121F),
    REAL_CONST(16.1133F),
    REAL_CONST(64.2090F),
    REAL_CONST(-99.3652F),
    REAL_CONST(-11.9629F),
    REAL_CONST(-81.7871F),
    REAL_CONST(-101.807F),
    REAL_CONST(254.150F),
    REAL_CONST(455.322F),
    REAL_CONST(-190.186F),
    REAL_CONST(-265.869F),
    REAL_CONST(-351.563F),
    REAL_CONST(-182.129F),
    REAL_CONST(-209.473F),
    REAL_CONST(203.125F),
    REAL_CONST(-141.846F),
    REAL_CONST(-185.303F),
    REAL_CONST(-90.5762F),
    REAL_CONST(-164.307F),
    REAL_CONST(-123.535F),
    REAL_CONST(509.766F),
    REAL_CONST(-136.719F),
    REAL_CONST(-154.785F),
    REAL_CONST(-287.842F),
    REAL_CONST(66.1621F),
    REAL_CONST(58.8379F),
    REAL_CONST(3.41797F),
    REAL_CONST(-106.934F),
    REAL_CONST(-59.5703F),
    REAL_CONST(-96.9238F),
    REAL_CONST(113.037F),
    REAL_CONST(293.457F),
    REAL_CONST(255.615F),
    REAL_CONST(-147.949F),
    REAL_CONST(-194.580F),
    REAL_CONST(-351.074F),
    REAL_CONST(-12.4512F),
    REAL_CONST(-78.8574F),
    REAL_CONST(117.432F),
    REAL_CONST(-54.6875F),
    REAL_CONST(-142.578F),
    REAL_CONST(-128.662F),
    REAL_CONST(120.605F),
    REAL_CONST(215.088F),
    REAL_CONST(166.504F),
    REAL_CONST(-105.713F),
    REAL_CONST(-74.7070F),
    REAL_CONST(-244.629F),
    REAL_CONST(135.254F),
    REAL_CONST(160.889F),
    REAL_CONST(54.1992F),
    REAL_CONST(41.7480F),
    REAL_CONST(-39.0625F),
    REAL_CONST(-86.1816F),
    REAL_CONST(166.260F),
    REAL_CONST(438.965F),
    REAL_CONST(382.080F),
    REAL_CONST(-208.008F),
    REAL_CONST(-288.330F),
    REAL_CONST(-413.818F),
    REAL_CONST(-82.0313F),
    REAL_CONST(-162.598F),
    REAL_CONST(27.8320F),
    REAL_CONST(-141.846F),
    REAL_CONST(-184.570F),
    REAL_CONST(-181.641F),
    REAL_CONST(-47.6074F),
    REAL_CONST(91.5527F),
    REAL_CONST(121.338F),
    REAL_CONST(-113.525F),
    REAL_CONST(-196.289F),
    REAL_CONST(-268.066F),
    REAL_CONST(37.5977F),
    REAL_CONST(68.8477F),
    REAL_CONST(-31.9824F),
    REAL_CONST(-12.2070F),
    REAL_CONST(-46.6309F),
    REAL_CONST(-175.537F),
    REAL_CONST(78.8574F),
    REAL_CONST(178.711F),
    REAL_CONST(376.465F),
    REAL_CONST(-176.270F),
    REAL_CONST(-199.951F),
    REAL_CONST(-342.773F),
    REAL_CONST(25.6348F),
    REAL_CONST(-61.0352F),
    REAL_CONST(45.1660F),
    REAL_CONST(-43.4570F),
    REAL_CONST(-122.559F),
    REAL_CONST(-181.152F),
    REAL_CONST(78.3691F),
    REAL_CONST(124.512F),
    REAL_CONST(271.240F),
    REAL_CONST(-78.8574F),
    REAL_CONST(-138.428F),
    REAL_CONST(-235.840F),
    REAL_CONST(31.0059F),
    REAL_CONST(118.164F),
    REAL_CONST(82.5195F),
    REAL_CONST(-39.0625F),
    REAL_CONST(12.6953F),
    REAL_CONST(-82.5195F),
    REAL_CONST(178.711F),
    REAL_CONST(333.740F),
    REAL_CONST(379.395F),
    REAL_CONST(-152.832F),
    REAL_CONST(-195.801F),
    REAL_CONST(-414.063F),
    REAL_CONST(-69.8242F),
    REAL_CONST(-143.066F),
    REAL_CONST(165.039F),
    REAL_CONST(-169.678F),
    REAL_CONST(-83.7402F),
    REAL_CONST(-90.3320F),
    REAL_CONST(-119.629F),
    REAL_CONST(72.0215F),
    REAL_CONST(462.158F),
    REAL_CONST(-153.809F),
    REAL_CONST(-140.137F),
    REAL_CONST(-247.559F),
    REAL_CONST(-19.5313F),
    REAL_CONST(157.471F),
    REAL_CONST(-16.8457F),
    REAL_CONST(-1.46484F),
    REAL_CONST(-77.6367F),
    REAL_CONST(-88.8672F),
    REAL_CONST(190.918F),
    REAL_CONST(354.004F),
    REAL_CONST(253.418F),
    REAL_CONST(-76.4160F),
    REAL_CONST(-178.955F),
    REAL_CONST(-340.576F),
    REAL_CONST(29.2969F),
    REAL_CONST(14.6484F),
    REAL_CONST(116.455F),
    REAL_CONST(-64.4531F),
    REAL_CONST(-142.822F),
    REAL_CONST(-30.0293F),
    REAL_CONST(173.584F),
    REAL_CONST(303.955F),
    REAL_CONST(154.541F),
    REAL_CONST(-22.2168F),
    REAL_CONST(-86.6699F),
    REAL_CONST(-248.047F),
    REAL_CONST(188.232F),
    REAL_CONST(185.059F),
    REAL_CONST(63.7207F),
    REAL_CONST(61.7676F),
    REAL_CONST(19.7754F),
    REAL_CONST(-115.723F),
    REAL_CONST(227.051F),
    REAL_CONST(540.771F),
    REAL_CONST(419.922F),
    REAL_CONST(-197.266F),
    REAL_CONST(-268.311F),
    REAL_CONST(-469.971F),
    REAL_CONST(-136.719F),
    REAL_CONST(-190.918F),
    REAL_CONST(41.2598F),
    REAL_CONST(-196.289F),
    REAL_CONST(-262.207F),
    REAL_CONST(-45.8984F),
    REAL_CONST(-152.832F),
    REAL_CONST(-13.4277F),
    REAL_CONST(343.018F),
    REAL_CONST(-169.434F),
    REAL_CONST(-174.805F),
    REAL_CONST(-291.504F),
    REAL_CONST(-161.133F),
    REAL_CONST(86.4258F),
    REAL_CONST(80.3223F),
    REAL_CONST(-125.488F),
    REAL_CONST(-13.4277F),
    REAL_CONST(-132.568F),
    REAL_CONST(89.3555F),
    REAL_CONST(252.197F),
    REAL_CONST(288.574F),
    REAL_CONST(-160.645F),
    REAL_CONST(-234.131F),
    REAL_CONST(-331.299F),
    REAL_CONST(-13.4277F),
    REAL_CONST(-44.9219F),
    REAL_CONST(22.7051F),
    REAL_CONST(-147.705F),
    REAL_CONST(-69.8242F),
    REAL_CONST(-161.621F),
    REAL_CONST(98.6328F),
    REAL_CONST(109.619F),
    REAL_CONST(201.904F),
    REAL_CONST(-69.8242F),
    REAL_CONST(-85.4492F),
    REAL_CONST(-308.350F),
    REAL_CONST(153.320F),
    REAL_CONST(74.7070F),
    REAL_CONST(55.4199F),
    REAL_CONST(-3.90625F),
    REAL_CONST(35.8887F),
    REAL_CONST(-152.100F),
    REAL_CONST(45.4102F),
    REAL_CONST(225.342F),
    REAL_CONST(523.926F),
    REAL_CONST(-164.551F),
    REAL_CONST(-217.285F),
    REAL_CONST(-392.090F),
    REAL_CONST(-108.154F),
    REAL_CONST(-55.6641F),
    REAL_CONST(82.7637F),
    REAL_CONST(-90.0879F),
    REAL_CONST(-192.871F),
    REAL_CONST(-99.8535F),
    REAL_CONST(56.3965F),
    REAL_CONST(20.9961F),
    REAL_CONST(358.643F),
    REAL_CONST(-109.375F),
    REAL_CONST(-141.846F),
    REAL_CONST(-259.033F),
    REAL_CONST(145.020F),
    REAL_CONST(109.863F),
    REAL_CONST(-43.2129F),
    REAL_CONST(-30.2734F),
    REAL_CONST(-41.5039F),
    REAL_CONST(-109.131F),
    REAL_CONST(163.818F),
    REAL_CONST(282.959F),
    REAL_CONST(342.773F),
    REAL_CONST(-116.211F),
    REAL_CONST(-162.842F),
    REAL_CONST(-368.896F),
    REAL_CONST(-18.7988F),
    REAL_CONST(-33.6914F),
    REAL_CONST(174.805F),
    REAL_CONST(-43.2129F),
    REAL_CONST(-90.8203F),
    REAL_CONST(-93.0176F),
    REAL_CONST(110.107F),
    REAL_CONST(228.027F),
    REAL_CONST(223.389F),
    REAL_CONST(-61.0352F),
    REAL_CONST(-105.469F),
    REAL_CONST(-200.684F),
    REAL_CONST(66.4063F),
    REAL_CONST(202.148F),
    REAL_CONST(108.887F),
    REAL_CONST(6.34766F),
    REAL_CONST(4.63867F),
    REAL_CONST(-7.56836F),
    REAL_CONST(170.410F),
    REAL_CONST(413.086F),
    REAL_CONST(529.297F),
    REAL_CONST(-157.715F),
    REAL_CONST(-238.525F),
    REAL_CONST(-469.727F),
    REAL_CONST(-43.7012F),
    REAL_CONST(-115.479F),
    REAL_CONST(65.4297F),
    REAL_CONST(-92.5293F),
    REAL_CONST(-181.885F),
    REAL_CONST(-168.701F),
    REAL_CONST(2.68555F),
    REAL_CONST(31.0059F),
    REAL_CONST(252.197F),
    REAL_CONST(-119.141F),
    REAL_CONST(-223.877F),
    REAL_CONST(-201.416F),
    REAL_CONST(14.8926F),
    REAL_CONST(78.8574F),
    REAL_CONST(32.9590F),
    REAL_CONST(35.8887F),
    REAL_CONST(-35.4004F),
    REAL_CONST(-167.480F),
    REAL_CONST(167.236F),
    REAL_CONST(191.895F),
    REAL_CONST(410.645F),
    REAL_CONST(-123.535F),
    REAL_CONST(-207.031F),
    REAL_CONST(-316.650F),
    REAL_CONST(8.54492F),
    REAL_CONST(21.9727F),
    REAL_CONST(54.1992F),
    REAL_CONST(-5.61523F),
    REAL_CONST(-84.4727F),
    REAL_CONST(-163.574F),
    REAL_CONST(111.084F),
    REAL_CONST(144.287F),
    REAL_CONST(314.209F),
    REAL_CONST(-49.5605F),
    REAL_CONST(-144.775F),
    REAL_CONST(-265.137F),
    REAL_CONST(159.180F),
    REAL_CONST(85.9375F),
    REAL_CONST(106.689F),
    REAL_CONST(9.52148F),
    REAL_CONST(15.3809F),
    REAL_CONST(-111.572F),
    REAL_CONST(205.322F),
    REAL_CONST(308.838F),
    REAL_CONST(513.916F),
    REAL_CONST(-126.953F),
    REAL_CONST(-215.332F),
    REAL_CONST(-386.719F),
    REAL_CONST(-80.0781F),
    REAL_CONST(-173.584F),
    REAL_CONST(346.924F),
    REAL_CONST(-145.508F),
    REAL_CONST(-83.4961F),
    REAL_CONST(-17.0898F),
    REAL_CONST(51.0254F),
    REAL_CONST(42.2363F),
    REAL_CONST(470.703F),
    REAL_CONST(-103.271F),
    REAL_CONST(-145.996F),
    REAL_CONST(-224.854F),
    REAL_CONST(102.783F),
    REAL_CONST(147.705F),
    REAL_CONST(-9.27734F),
    REAL_CONST(-0.488281F),
    REAL_CONST(-59.8145F),
    REAL_CONST(-31.0059F),
    REAL_CONST(218.750F),
    REAL_CONST(480.713F),
    REAL_CONST(277.100F),
    REAL_CONST(-92.5293F),
    REAL_CONST(-126.465F),
    REAL_CONST(-385.498F),
    REAL_CONST(42.2363F),
    REAL_CONST(28.8086F),
    REAL_CONST(183.838F),
    REAL_CONST(-13.4277F),
    REAL_CONST(-93.0176F),
    REAL_CONST(-12.6953F),
    REAL_CONST(240.479F),
    REAL_CONST(249.268F),
    REAL_CONST(183.838F),
    REAL_CONST(-0.488281F),
    REAL_CONST(-71.0449F),
    REAL_CONST(-217.529F),
    REAL_CONST(183.838F),
    REAL_CONST(242.188F),
    REAL_CONST(103.271F),
    REAL_CONST(64.4531F),
    REAL_CONST(31.9824F),
    REAL_CONST(-47.8516F),
    REAL_CONST(218.506F),
    REAL_CONST(555.176F),
    REAL_CONST(620.850F),
    REAL_CONST(-155.029F),
    REAL_CONST(-265.625F),
    REAL_CONST(-610.107F),
    REAL_CONST(-129.150F),
    REAL_CONST(-239.746F),
    REAL_CONST(128.418F),
    REAL_CONST(-186.523F),
    REAL_CONST(-202.637F),
    REAL_CONST(-133.789F),
    REAL_CONST(-106.445F),
    REAL_CONST(77.1484F),
    REAL_CONST(146.240F),
    REAL_CONST(-164.795F),
    REAL_CONST(-229.492F),
    REAL_CONST(-182.129F),
    REAL_CONST(-13.9160F),
    REAL_CONST(57.6172F),
    REAL_CONST(-2.68555F),
    REAL_CONST(-49.0723F),
    REAL_CONST(-19.7754F),
    REAL_CONST(-194.824F),
    REAL_CONST(3.90625F),
    REAL_CONST(206.299F),
    REAL_CONST(380.371F),
    REAL_CONST(-179.932F),
    REAL_CONST(-240.479F),
    REAL_CONST(-295.898F),
    REAL_CONST(-114.258F),
    REAL_CONST(4.15039F),
    REAL_CONST(70.8008F),
    REAL_CONST(-68.1152F),
    REAL_CONST(-142.578F),
    REAL_CONST(-170.898F),
    REAL_CONST(44.6777F),
    REAL_CONST(200.684F),
    REAL_CONST(172.119F),
    REAL_CONST(-64.6973F),
    REAL_CONST(-120.117F),
    REAL_CONST(-289.795F),
    REAL_CONST(102.783F),
    REAL_CONST(37.1094F),
    REAL_CONST(114.258F),
    REAL_CONST(-95.2148F),
    REAL_CONST(40.5273F),
    REAL_CONST(-65.4297F),
    REAL_CONST(9.52148F),
    REAL_CONST(378.418F),
    REAL_CONST(456.055F),
    REAL_CONST(-155.029F),
    REAL_CONST(-235.840F),
    REAL_CONST(-383.545F),
    REAL_CONST(-110.596F),
    REAL_CONST(-120.117F),
    REAL_CONST(222.168F),
    REAL_CONST(-69.3359F),
    REAL_CONST(-250.732F),
    REAL_CONST(-18.3105F),
    REAL_CONST(-44.1895F),
    REAL_CONST(-32.4707F),
    REAL_CONST(452.148F),
    REAL_CONST(-108.643F),
    REAL_CONST(-152.344F),
    REAL_CONST(-286.621F),
    REAL_CONST(102.539F),
    REAL_CONST(89.5996F),
    REAL_CONST(-11.9629F),
    REAL_CONST(-94.9707F),
    REAL_CONST(-51.7578F),
    REAL_CONST(-41.2598F),
    REAL_CONST(172.607F),
    REAL_CONST(261.963F),
    REAL_CONST(294.922F),
    REAL_CONST(-131.592F),
    REAL_CONST(-173.340F),
    REAL_CONST(-353.760F),
    REAL_CONST(20.2637F),
    REAL_CONST(-39.7949F),
    REAL_CONST(118.164F),
    REAL_CONST(-57.6172F),
    REAL_CONST(-132.568F),
    REAL_CONST(-86.6699F),
    REAL_CONST(82.5195F),
    REAL_CONST(286.865F),
    REAL_CONST(198.730F),
    REAL_CONST(-60.0586F),
    REAL_CONST(-75.4395F),
    REAL_CONST(-233.887F),
    REAL_CONST(147.949F),
    REAL_CONST(185.547F),
    REAL_CONST(14.6484F),
    REAL_CONST(40.5273F),
    REAL_CONST(-1.95313F),
    REAL_CONST(-39.7949F),
    REAL_CONST(-74.7070F),
    REAL_CONST(451.416F),
    REAL_CONST(625.732F),
    REAL_CONST(-182.373F),
    REAL_CONST(-250.244F),
    REAL_CONST(-435.303F),
    REAL_CONST(-102.295F),
    REAL_CONST(-108.887F),
    REAL_CONST(51.0254F),
    REAL_CONST(-175.293F),
    REAL_CONST(-138.184F),
    REAL_CONST(-130.371F),
    REAL_CONST(-123.535F),
    REAL_CONST(169.189F),
    REAL_CONST(209.229F),
    REAL_CONST(-113.037F),
    REAL_CONST(-170.166F),
    REAL_CONST(-264.160F),
    REAL_CONST(79.3457F),
    REAL_CONST(105.225F),
    REAL_CONST(-50.2930F),
    REAL_CONST(-3.66211F),
    REAL_CONST(-1.95313F),
    REAL_CONST(-186.279F),
    REAL_CONST(133.057F),
    REAL_CONST(224.365F),
    REAL_CONST(370.605F),
    REAL_CONST(-149.170F),
    REAL_CONST(-191.162F),
    REAL_CONST(-320.557F),
    REAL_CONST(62.5000F),
    REAL_CONST(-13.4277F),
    REAL_CONST(50.7813F),
    REAL_CONST(-40.2832F),
    REAL_CONST(-84.9609F),
    REAL_CONST(-161.621F),
    REAL_CONST(78.3691F),
    REAL_CONST(166.016F),
    REAL_CONST(227.051F),
    REAL_CONST(-79.5898F),
    REAL_CONST(-104.736F),
    REAL_CONST(-232.178F),
    REAL_CONST(118.164F),
    REAL_CONST(108.887F),
    REAL_CONST(139.160F),
    REAL_CONST(-48.0957F),
    REAL_CONST(17.5781F),
    REAL_CONST(-17.8223F),
    REAL_CONST(221.924F),
    REAL_CONST(355.225F),
    REAL_CONST(425.049F),
    REAL_CONST(-137.451F),
    REAL_CONST(-179.932F),
    REAL_CONST(-481.934F),
    REAL_CONST(-30.2734F),
    REAL_CONST(-101.563F),
    REAL_CONST(175.293F),
    REAL_CONST(-116.699F),
    REAL_CONST(-98.6328F),
    REAL_CONST(-76.6602F),
    REAL_CONST(-3.90625F),
    REAL_CONST(108.887F),
    REAL_CONST(399.414F),
    REAL_CONST(-134.521F),
    REAL_CONST(-131.104F),
    REAL_CONST(-183.105F),
    REAL_CONST(-14.1602F),
    REAL_CONST(155.762F),
    REAL_CONST(52.2461F),
    REAL_CONST(13.4277F),
    REAL_CONST(-45.1660F),
    REAL_CONST(-66.1621F),
    REAL_CONST(280.273F),
    REAL_CONST(317.627F),
    REAL_CONST(295.898F),
    REAL_CONST(-117.920F),
    REAL_CONST(-163.818F),
    REAL_CONST(-308.594F),
    REAL_CONST(28.5645F),
    REAL_CONST(69.5801F),
    REAL_CONST(132.568F),
    REAL_CONST(-49.8047F),
    REAL_CONST(-95.4590F),
    REAL_CONST(-27.0996F),
    REAL_CONST(125.244F),
    REAL_CONST(375.488F),
    REAL_CONST(208.496F),
    REAL_CONST(-27.8320F),
    REAL_CONST(-46.3867F),
    REAL_CONST(-238.770F),
    REAL_CONST(214.111F),
    REAL_CONST(145.264F),
    REAL_CONST(113.281F),
    REAL_CONST(63.4766F),
    REAL_CONST(63.4766F),
    REAL_CONST(-75.9277F),
    REAL_CONST(182.617F),
    REAL_CONST(557.373F),
    REAL_CONST(541.016F),
    REAL_CONST(-126.221F),
    REAL_CONST(-230.713F),
    REAL_CONST(-530.029F),
    REAL_CONST(-79.5898F),
    REAL_CONST(-172.852F),
    REAL_CONST(92.2852F),
    REAL_CONST(-198.242F),
    REAL_CONST(-168.701F),
    REAL_CONST(-56.6406F),
    REAL_CONST(-136.719F),
    REAL_CONST(167.725F),
    REAL_CONST(343.994F),
    REAL_CONST(-178.711F),
    REAL_CONST(-168.457F),
    REAL_CONST(-204.102F),
    REAL_CONST(-87.6465F),
    REAL_CONST(157.471F),
    REAL_CONST(94.2383F),
    REAL_CONST(-64.6973F),
    REAL_CONST(15.1367F),
    REAL_CONST(-165.527F),
    REAL_CONST(35.4004F),
    REAL_CONST(401.367F),
    REAL_CONST(294.922F),
    REAL_CONST(-135.498F),
    REAL_CONST(-241.211F),
    REAL_CONST(-301.025F),
    REAL_CONST(-19.0430F),
    REAL_CONST(3.41797F),
    REAL_CONST(27.8320F),
    REAL_CONST(-79.8340F),
    REAL_CONST(-87.4023F),
    REAL_CONST(-119.385F),
    REAL_CONST(95.7031F),
    REAL_CONST(165.283F),
    REAL_CONST(170.166F),
    REAL_CONST(-49.0723F),
    REAL_CONST(-57.6172F),
    REAL_CONST(-278.320F),
    REAL_CONST(169.189F),
    REAL_CONST(109.619F),
    REAL_CONST(43.4570F),
    REAL_CONST(-59.3262F),
    REAL_CONST(62.5000F),
    REAL_CONST(-105.713F),
    REAL_CONST(149.170F),
    REAL_CONST(338.135F),
    REAL_CONST(599.609F),
    REAL_CONST(-149.414F),
    REAL_CONST(-219.971F),
    REAL_CONST(-357.422F),
    REAL_CONST(-74.9512F),
    REAL_CONST(-4.15039F),
    REAL_CONST(121.826F),
    REAL_CONST(-76.9043F),
    REAL_CONST(-162.842F),
    REAL_CONST(-62.0117F),
    REAL_CONST(62.5000F),
    REAL_CONST(104.492F),
    REAL_CONST(357.178F),
    REAL_CONST(-118.652F),
    REAL_CONST(-103.027F),
    REAL_CONST(-257.813F),
    REAL_CONST(159.912F),
    REAL_CONST(90.3320F),
    REAL_CONST(4.39453F),
    REAL_CONST(-24.9023F),
    REAL_CONST(-45.1660F),
    REAL_CONST(-67.3828F),
    REAL_CONST(184.326F),
    REAL_CONST(385.254F),
    REAL_CONST(325.928F),
    REAL_CONST(-119.141F),
    REAL_CONST(-147.217F),
    REAL_CONST(-346.191F),
    REAL_CONST(44.4336F),
    REAL_CONST(-22.7051F),
    REAL_CONST(212.402F),
    REAL_CONST(-17.8223F),
    REAL_CONST(-111.816F),
    REAL_CONST(-84.9609F),
    REAL_CONST(203.857F),
    REAL_CONST(210.449F),
    REAL_CONST(233.643F),
    REAL_CONST(-68.8477F),
    REAL_CONST(-81.2988F),
    REAL_CONST(-182.129F),
    REAL_CONST(133.545F),
    REAL_CONST(204.834F),
    REAL_CONST(104.492F),
    REAL_CONST(66.6504F),
    REAL_CONST(-21.7285F),
    REAL_CONST(3.17383F),
    REAL_CONST(229.492F),
    REAL_CONST(416.992F),
    REAL_CONST(628.906F),
    REAL_CONST(-102.051F),
    REAL_CONST(-264.648F),
    REAL_CONST(-429.199F),
    REAL_CONST(-10.7422F),
    REAL_CONST(-87.4023F),
    REAL_CONST(63.2324F),
    REAL_CONST(-121.338F),
    REAL_CONST(-156.982F),
    REAL_CONST(-136.719F),
    REAL_CONST(24.1699F),
    REAL_CONST(135.986F),
    REAL_CONST(234.619F),
    REAL_CONST(-102.783F),
    REAL_CONST(-187.012F),
    REAL_CONST(-223.877F),
    REAL_CONST(72.0215F),
    REAL_CONST(79.5898F),
    REAL_CONST(44.9219F),
    REAL_CONST(42.7246F),
    REAL_CONST(3.66211F),
    REAL_CONST(-152.832F),
    REAL_CONST(129.883F),
    REAL_CONST(214.355F),
    REAL_CONST(483.643F),
    REAL_CONST(-108.154F),
    REAL_CONST(-187.500F),
    REAL_CONST(-311.279F),
    REAL_CONST(53.9551F),
    REAL_CONST(38.0859F),
    REAL_CONST(65.4297F),
    REAL_CONST(9.52148F),
    REAL_CONST(-88.6230F),
    REAL_CONST(-123.291F),
    REAL_CONST(169.678F),
    REAL_CONST(188.477F),
    REAL_CONST(278.320F),
    REAL_CONST(-39.5508F),
    REAL_CONST(-112.061F),
    REAL_CONST(-222.656F),
    REAL_CONST(173.096F),
    REAL_CONST(108.398F),
    REAL_CONST(160.645F),
    REAL_CONST(6.10352F),
    REAL_CONST(73.9746F),
    REAL_CONST(-76.1719F),
    REAL_CONST(309.570F),
    REAL_CONST(344.238F),
    REAL_CONST(418.701F),
    REAL_CONST(-72.5098F),
    REAL_CONST(-187.012F),
    REAL_CONST(-448.242F),
    REAL_CONST(-64.2090F),
    REAL_CONST(-26.3672F),
    REAL_CONST(261.230F),
    REAL_CONST(-99.1211F),
    REAL_CONST(-3.17383F),
    REAL_CONST(-31.4941F),
    REAL_CONST(13.9160F),
    REAL_CONST(106.934F),
    REAL_CONST(667.480F),
    REAL_CONST(-91.3086F),
    REAL_CONST(-118.896F),
    REAL_CONST(-203.857F),
    REAL_CONST(74.2188F),
    REAL_CONST(169.922F),
    REAL_CONST(40.0391F),
    REAL_CONST(25.3906F),
    REAL_CONST(-57.3730F),
    REAL_CONST(1.22070F),
    REAL_CONST(393.311F),
    REAL_CONST(463.867F),
    REAL_CONST(341.553F),
    REAL_CONST(-55.9082F),
    REAL_CONST(-142.090F),
    REAL_CONST(-323.486F),
    REAL_CONST(98.8770F),
    REAL_CONST(46.8750F),
    REAL_CONST(199.463F),
    REAL_CONST(-21.2402F),
    REAL_CONST(-106.934F),
    REAL_CONST(27.0996F),
    REAL_CONST(250.977F),
    REAL_CONST(292.725F),
    REAL_CONST(242.432F),
    REAL_CONST(16.6016F),
    REAL_CONST(-42.7246F),
    REAL_CONST(-228.027F),
    REAL_CONST(252.197F),
    REAL_CONST(272.705F),
    REAL_CONST(110.107F),
    REAL_CONST(116.699F),
    REAL_CONST(48.8281F),
    REAL_CONST(-60.5469F),
    REAL_CONST(519.287F),
    REAL_CONST(658.203F),
    REAL_CONST(498.535F),
    REAL_CONST(-203.857F),
    REAL_CONST(-322.998F),
    REAL_CONST(-520.264F),
    REAL_CONST(-195.068F),
    REAL_CONST(-168.945F),
    REAL_CONST(113.770F),
    REAL_CONST(-198.242F),
    REAL_CONST(-251.953F),
    REAL_CONST(-114.502F),
    REAL_CONST(-151.855F),
    REAL_CONST(70.3125F),
    REAL_CONST(224.609F),
    REAL_CONST(-171.143F),
    REAL_CONST(-205.322F),
    REAL_CONST(-261.230F),
    REAL_CONST(-100.342F),
    REAL_CONST(125.000F),
    REAL_CONST(1.95313F),
    REAL_CONST(-95.2148F),
    REAL_CONST(-22.2168F),
    REAL_CONST(-181.641F),
    REAL_CONST(-7.32422F),
    REAL_CONST(254.639F),
    REAL_CONST(283.447F),
    REAL_CONST(-200.684F),
    REAL_CONST(-280.273F),
    REAL_CONST(-282.227F),
    REAL_CONST(-71.7773F),
    REAL_CONST(-11.2305F),
    REAL_CONST(26.8555F),
    REAL_CONST(-100.342F),
    REAL_CONST(-91.3086F),
    REAL_CONST(-165.527F),
    REAL_CONST(52.2461F),
    REAL_CONST(129.639F),
    REAL_CONST(163.086F),
    REAL_CONST(-99.1211F),
    REAL_CONST(-102.539F),
    REAL_CONST(-291.504F),
    REAL_CONST(118.896F),
    REAL_CONST(56.6406F),
    REAL_CONST(73.9746F),
    REAL_CONST(-77.6367F),
    REAL_CONST(22.2168F),
    REAL_CONST(-115.234F),
    REAL_CONST(30.0293F),
    REAL_CONST(300.781F),
    REAL_CONST(596.924F),
    REAL_CONST(-176.270F),
    REAL_CONST(-232.422F),
    REAL_CONST(-364.990F),
    REAL_CONST(-180.176F),
    REAL_CONST(-164.795F),
    REAL_CONST(325.195F),
    REAL_CONST(-132.568F),
    REAL_CONST(-147.949F),
    REAL_CONST(-51.5137F),
    REAL_CONST(-23.1934F),
    REAL_CONST(-23.9258F),
    REAL_CONST(368.164F),
    REAL_CONST(-134.033F),
    REAL_CONST(-125.488F),
    REAL_CONST(-291.260F),
    REAL_CONST(115.479F),
    REAL_CONST(51.5137F),
    REAL_CONST(17.8223F),
    REAL_CONST(-70.3125F),
    REAL_CONST(-27.3438F),
    REAL_CONST(-94.9707F),
    REAL_CONST(131.104F),
    REAL_CONST(325.195F),
    REAL_CONST(307.129F),
    REAL_CONST(-138.428F),
    REAL_CONST(-184.326F),
    REAL_CONST(-377.197F),
    REAL_CONST(17.3340F),
    REAL_CONST(-69.0918F),
    REAL_CONST(154.297F),
    REAL_CONST(-41.5039F),
    REAL_CONST(-117.432F),
    REAL_CONST(-120.361F),
    REAL_CONST(166.260F),
    REAL_CONST(244.629F),
    REAL_CONST(199.463F),
    REAL_CONST(-86.9141F),
    REAL_CONST(-80.8105F),
    REAL_CONST(-214.111F),
    REAL_CONST(102.295F),
    REAL_CONST(172.363F),
    REAL_CONST(84.4727F),
    REAL_CONST(58.8379F),
    REAL_CONST(-8.30078F),
    REAL_CONST(-79.5898F),
    REAL_CONST(92.0410F),
    REAL_CONST(476.074F),
    REAL_CONST(459.717F),
    REAL_CONST(-177.490F),
    REAL_CONST(-262.451F),
    REAL_CONST(-396.729F),
    REAL_CONST(-56.8848F),
    REAL_CONST(-132.568F),
    REAL_CONST(28.3203F),
    REAL_CONST(-127.930F),
    REAL_CONST(-196.777F),
    REAL_CONST(-142.822F),
    REAL_CONST(-17.8223F),
    REAL_CONST(116.699F),
    REAL_CONST(177.979F),
    REAL_CONST(-70.3125F),
    REAL_CONST(-225.830F),
    REAL_CONST(-279.053F),
    REAL_CONST(42.2363F),
    REAL_CONST(109.131F),
    REAL_CONST(-12.6953F),
    REAL_CONST(16.6016F),
    REAL_CONST(-55.9082F),
    REAL_CONST(-147.949F),
    REAL_CONST(109.619F),
    REAL_CONST(129.150F),
    REAL_CONST(438.721F),
    REAL_CONST(-144.287F),
    REAL_CONST(-213.623F),
    REAL_CONST(-332.764F),
    REAL_CONST(44.6777F),
    REAL_CONST(-35.1563F),
    REAL_CONST(79.1016F),
    REAL_CONST(-25.1465F),
    REAL_CONST(-110.352F),
    REAL_CONST(-162.598F),
    REAL_CONST(152.100F),
    REAL_CONST(119.141F),
    REAL_CONST(287.109F),
    REAL_CONST(-58.1055F),
    REAL_CONST(-124.756F),
    REAL_CONST(-245.117F),
    REAL_CONST(79.5898F),
    REAL_CONST(134.766F),
    REAL_CONST(111.816F),
    REAL_CONST(33.2031F),
    REAL_CONST(26.3672F),
    REAL_CONST(-77.8809F),
    REAL_CONST(152.832F),
    REAL_CONST(327.881F),
    REAL_CONST(459.717F),
    REAL_CONST(-119.629F),
    REAL_CONST(-157.715F),
    REAL_CONST(-422.363F),
    REAL_CONST(-45.4102F),
    REAL_CONST(-109.619F),
    REAL_CONST(240.234F),
    REAL_CONST(-180.176F),
    REAL_CONST(-18.5547F),
    REAL_CONST(-41.5039F),
    REAL_CONST(-134.277F),
    REAL_CONST(184.326F),
    REAL_CONST(625.000F),
    REAL_CONST(-121.094F),
    REAL_CONST(-124.512F),
    REAL_CONST(-231.201F),
    REAL_CONST(51.2695F),
    REAL_CONST(169.434F),
    REAL_CONST(-12.6953F),
    REAL_CONST(20.5078F),
    REAL_CONST(-78.6133F),
    REAL_CONST(-48.5840F),
    REAL_CONST(266.113F),
    REAL_CONST(396.729F),
    REAL_CONST(298.828F),
    REAL_CONST(-91.7969F),
    REAL_CONST(-147.217F),
    REAL_CONST(-340.820F),
    REAL_CONST(83.7402F),
    REAL_CONST(18.0664F),
    REAL_CONST(154.297F),
    REAL_CONST(-42.7246F),
    REAL_CONST(-122.559F),
    REAL_CONST(-7.81250F),
    REAL_CONST(237.305F),
    REAL_CONST(325.195F),
    REAL_CONST(179.199F),
    REAL_CONST(12.6953F),
    REAL_CONST(-72.0215F),
    REAL_CONST(-271.729F),
    REAL_CONST(260.010F),
    REAL_CONST(224.121F),
    REAL_CONST(39.0625F),
    REAL_CONST(95.9473F),
    REAL_CONST(26.1230F),
    REAL_CONST(-96.9238F),
    REAL_CONST(296.387F),
    REAL_CONST(646.729F),
    REAL_CONST(425.049F),
    REAL_CONST(-154.297F),
    REAL_CONST(-293.213F),
    REAL_CONST(-461.670F),
    REAL_CONST(-175.537F),
    REAL_CONST(-67.6270F),
    REAL_CONST(86.1816F),
    REAL_CONST(-158.936F),
    REAL_CONST(-214.844F),
    REAL_CONST(-29.7852F),
    REAL_CONST(-51.5137F),
    REAL_CONST(51.0254F),
    REAL_CONST(326.660F),
    REAL_CONST(-137.207F),
    REAL_CONST(-174.316F),
    REAL_CONST(-258.545F),
    REAL_CONST(-50.7813F),
    REAL_CONST(94.7266F),
    REAL_CONST(38.8184F),
    REAL_CONST(-78.1250F),
    REAL_CONST(-14.8926F),
    REAL_CONST(-134.521F),
    REAL_CONST(71.5332F),
    REAL_CONST(266.602F),
    REAL_CONST(352.295F),
    REAL_CONST(-158.203F),
    REAL_CONST(-211.182F),
    REAL_CONST(-305.908F),
    REAL_CONST(-11.9629F),
    REAL_CONST(-34.9121F),
    REAL_CONST(74.4629F),
    REAL_CONST(-97.9004F),
    REAL_CONST(-55.4199F),
    REAL_CONST(-142.822F),
    REAL_CONST(136.963F),
    REAL_CONST(129.883F),
    REAL_CONST(226.318F),
    REAL_CONST(-28.5645F),
    REAL_CONST(-108.154F),
    REAL_CONST(-290.039F),
    REAL_CONST(123.779F),
    REAL_CONST(106.445F),
    REAL_CONST(71.2891F),
    REAL_CONST(-19.2871F),
    REAL_CONST(56.8848F),
    REAL_CONST(-111.816F),
    REAL_CONST(163.818F),
    REAL_CONST(250.244F),
    REAL_CONST(584.961F),
    REAL_CONST(-154.541F),
    REAL_CONST(-205.566F),
    REAL_CONST(-372.314F),
    REAL_CONST(-75.1953F),
    REAL_CONST(-69.8242F),
    REAL_CONST(156.250F),
    REAL_CONST(-91.0645F),
    REAL_CONST(-151.611F),
    REAL_CONST(-99.3652F),
    REAL_CONST(102.051F),
    REAL_CONST(61.7676F),
    REAL_CONST(318.604F),
    REAL_CONST(-76.9043F),
    REAL_CONST(-141.846F),
    REAL_CONST(-277.588F),
    REAL_CONST(139.648F),
    REAL_CONST(167.236F),
    REAL_CONST(-68.6035F),
    REAL_CONST(14.8926F),
    REAL_CONST(-16.6016F),
    REAL_CONST(-90.5762F),
    REAL_CONST(241.943F),
    REAL_CONST(268.799F),
    REAL_CONST(365.723F),
    REAL_CONST(-120.361F),
    REAL_CONST(-166.748F),
    REAL_CONST(-332.520F),
    REAL_CONST(-11.4746F),
    REAL_CONST(40.0391F),
    REAL_CONST(171.875F),
    REAL_CONST(-62.5000F),
    REAL_CONST(-76.6602F),
    REAL_CONST(-65.4297F),
    REAL_CONST(154.053F),
    REAL_CONST(231.689F),
    REAL_CONST(256.836F),
    REAL_CONST(-28.8086F),
    REAL_CONST(-84.9609F),
    REAL_CONST(-203.369F),
    REAL_CONST(16.6016F),
    REAL_CONST(288.086F),
    REAL_CONST(138.672F),
    REAL_CONST(37.1094F),
    REAL_CONST(28.5645F),
    REAL_CONST(8.30078F),
    REAL_CONST(271.729F),
    REAL_CONST(464.355F),
    REAL_CONST(546.631F),
    REAL_CONST(-146.729F),
    REAL_CONST(-234.131F),
    REAL_CONST(-416.504F),
    REAL_CONST(-34.9121F),
    REAL_CONST(-119.385F),
    REAL_CONST(117.188F),
    REAL_CONST(-81.0547F),
    REAL_CONST(-159.912F),
    REAL_CONST(-140.137F),
    REAL_CONST(13.1836F),
    REAL_CONST(86.1816F),
    REAL_CONST(291.016F),
    REAL_CONST(-112.793F),
    REAL_CONST(-159.180F),
    REAL_CONST(-194.336F),
    REAL_CONST(36.6211F),
    REAL_CONST(134.033F),
    REAL_CONST(27.3438F),
    REAL_CONST(47.6074F),
    REAL_CONST(-27.0996F),
    REAL_CONST(-125.732F),
    REAL_CONST(165.771F),
    REAL_CONST(270.508F),
    REAL_CONST(402.100F),
    REAL_CONST(-136.230F),
    REAL_CONST(-182.861F),
    REAL_CONST(-297.119F),
    REAL_CONST(-2.19727F),
    REAL_CONST(66.4063F),
    REAL_CONST(83.2520F),
    REAL_CONST(-12.9395F),
    REAL_CONST(-64.6973F),
    REAL_CONST(-130.615F),
    REAL_CONST(119.385F),
    REAL_CONST(205.811F),
    REAL_CONST(316.895F),
    REAL_CONST(-29.2969F),
    REAL_CONST(-117.676F),
    REAL_CONST(-251.953F),
    REAL_CONST(154.297F),
    REAL_CONST(132.568F),
    REAL_CONST(99.6094F),
    REAL_CONST(43.7012F),
    REAL_CONST(74.7070F),
    REAL_CONST(-128.418F),
    REAL_CONST(274.414F),
    REAL_CONST(357.422F),
    REAL_CONST(547.852F),
    REAL_CONST(-101.807F),
    REAL_CONST(-191.895F),
    REAL_CONST(-381.348F),
    REAL_CONST(-54.6875F),
    REAL_CONST(-93.7500F),
    REAL_CONST(333.008F),
    REAL_CONST(-92.0410F),
    REAL_CONST(-112.061F),
    REAL_CONST(-6.10352F),
    REAL_CONST(93.9941F),
    REAL_CONST(119.385F),
    REAL_CONST(530.762F),
    REAL_CONST(-81.0547F),
    REAL_CONST(-158.936F),
    REAL_CONST(-202.393F),
    REAL_CONST(132.813F),
    REAL_CONST(135.010F),
    REAL_CONST(14.8926F),
    REAL_CONST(5.37109F),
    REAL_CONST(-27.5879F),
    REAL_CONST(-21.7285F),
    REAL_CONST(275.391F),
    REAL_CONST(421.143F),
    REAL_CONST(372.070F),
    REAL_CONST(-52.7344F),
    REAL_CONST(-91.0645F),
    REAL_CONST(-403.564F),
    REAL_CONST(39.3066F),
    REAL_CONST(77.1484F),
    REAL_CONST(221.680F),
    REAL_CONST(-40.2832F),
    REAL_CONST(-54.1992F),
    REAL_CONST(-16.3574F),
    REAL_CONST(332.520F),
    REAL_CONST(286.865F),
    REAL_CONST(192.627F),
    REAL_CONST(17.8223F),
    REAL_CONST(-61.5234F),
    REAL_CONST(-187.256F),
    REAL_CONST(180.176F),
    REAL_CONST(227.539F),
    REAL_CONST(150.391F),
    REAL_CONST(88.3789F),
    REAL_CONST(60.0586F),
    REAL_CONST(-30.7617F),
    REAL_CONST(192.139F),
    REAL_CONST(647.949F),
    REAL_CONST(739.014F),
    REAL_CONST(-168.701F),
    REAL_CONST(-270.020F),
    REAL_CONST(-534.668F),
    REAL_CONST(-137.939F),
    REAL_CONST(-143.555F),
    REAL_CONST(127.930F),
    REAL_CONST(-144.043F),
    REAL_CONST(-239.014F),
    REAL_CONST(-119.629F),
    REAL_CONST(-64.2090F),
    REAL_CONST(96.9238F),
    REAL_CONST(239.746F),
    REAL_CONST(-140.869F),
    REAL_CONST(-204.346F),
    REAL_CONST(-230.713F),
    REAL_CONST(-5.37109F),
    REAL_CONST(106.201F),
    REAL_CONST(-11.9629F),
    REAL_CONST(-46.3867F),
    REAL_CONST(-28.8086F),
    REAL_CONST(-153.564F),
    REAL_CONST(-21.4844F),
    REAL_CONST(302.734F),
    REAL_CONST(369.385F),
    REAL_CONST(-155.273F),
    REAL_CONST(-256.592F),
    REAL_CONST(-248.779F),
    REAL_CONST(-71.0449F),
    REAL_CONST(46.1426F),
    REAL_CONST(63.2324F),
    REAL_CONST(-62.7441F),
    REAL_CONST(-114.746F),
    REAL_CONST(-153.564F),
    REAL_CONST(35.4004F),
    REAL_CONST(230.713F),
    REAL_CONST(218.262F),
    REAL_CONST(-79.5898F),
    REAL_CONST(-88.8672F),
    REAL_CONST(-267.090F),
    REAL_CONST(132.568F),
    REAL_CONST(63.4766F),
    REAL_CONST(153.809F),
    REAL_CONST(-49.3164F),
    REAL_CONST(46.1426F),
    REAL_CONST(-51.0254F),
    REAL_CONST(87.1582F),
    REAL_CONST(336.670F),
    REAL_CONST(510.498F),
    REAL_CONST(-138.916F),
    REAL_CONST(-262.451F),
    REAL_CONST(-353.760F),
    REAL_CONST(-174.316F),
    REAL_CONST(-58.3496F),
    REAL_CONST(224.365F),
    REAL_CONST(-102.539F),
    REAL_CONST(-172.119F),
    REAL_CONST(-20.5078F),
    REAL_CONST(-26.6113F),
    REAL_CONST(-27.8320F),
    REAL_CONST(587.646F),
    REAL_CONST(-100.830F),
    REAL_CONST(-129.150F),
    REAL_CONST(-287.354F),
    REAL_CONST(117.676F),
    REAL_CONST(89.8438F),
    REAL_CONST(31.9824F),
    REAL_CONST(-45.4102F),
    REAL_CONST(-17.5781F),
    REAL_CONST(-31.9824F),
    REAL_CONST(210.205F),
    REAL_CONST(306.396F),
    REAL_CONST(297.852F),
    REAL_CONST(-149.170F),
    REAL_CONST(-160.645F),
    REAL_CONST(-327.393F),
    REAL_CONST(55.4199F),
    REAL_CONST(-29.5410F),
    REAL_CONST(154.053F),
    REAL_CONST(-42.9688F),
    REAL_CONST(-119.385F),
    REAL_CONST(-53.2227F),
    REAL_CONST(181.885F),
    REAL_CONST(286.865F),
    REAL_CONST(233.643F),
    REAL_CONST(-78.3691F),
    REAL_CONST(-36.1328F),
    REAL_CONST(-228.516F),
    REAL_CONST(163.818F),
    REAL_CONST(235.840F),
    REAL_CONST(52.7344F),
    REAL_CONST(83.0078F),
    REAL_CONST(-0.732422F),
    REAL_CONST(-34.9121F),
    REAL_CONST(114.502F),
    REAL_CONST(451.172F),
    REAL_CONST(594.971F),
    REAL_CONST(-177.979F),
    REAL_CONST(-234.619F),
    REAL_CONST(-410.889F),
    REAL_CONST(-52.0020F),
    REAL_CONST(-62.0117F),
    REAL_CONST(78.3691F),
    REAL_CONST(-124.756F),
    REAL_CONST(-106.934F),
    REAL_CONST(-127.197F),
    REAL_CONST(-30.7617F),
    REAL_CONST(177.002F),
    REAL_CONST(220.459F),
    REAL_CONST(-83.0078F),
    REAL_CONST(-167.236F),
    REAL_CONST(-251.953F),
    REAL_CONST(77.1484F),
    REAL_CONST(117.188F),
    REAL_CONST(4.88281F),
    REAL_CONST(5.61523F),
    REAL_CONST(-21.7285F),
    REAL_CONST(-134.521F),
    REAL_CONST(86.1816F),
    REAL_CONST(256.592F),
    REAL_CONST(436.768F),
    REAL_CONST(-132.813F),
    REAL_CONST(-184.814F),
    REAL_CONST(-333.008F),
    REAL_CONST(72.7539F),
    REAL_CONST(-6.10352F),
    REAL_CONST(106.445F),
    REAL_CONST(-24.4141F),
    REAL_CONST(-95.7031F),
    REAL_CONST(-126.709F),
    REAL_CONST(114.014F),
    REAL_CONST(184.082F),
    REAL_CONST(263.184F),
    REAL_CONST(-51.2695F),
    REAL_CONST(-97.1680F),
    REAL_CONST(-263.184F),
    REAL_CONST(151.367F),
    REAL_CONST(160.645F),
    REAL_CONST(153.809F),
    REAL_CONST(8.05664F),
    REAL_CONST(35.8887F),
    REAL_CONST(-43.4570F),
    REAL_CONST(224.854F),
    REAL_CONST(411.865F),
    REAL_CONST(468.994F),
    REAL_CONST(-79.3457F),
    REAL_CONST(-128.906F),
    REAL_CONST(-482.910F),
    REAL_CONST(0.488281F),
    REAL_CONST(-69.5801F),
    REAL_CONST(222.168F),
    REAL_CONST(-90.5762F),
    REAL_CONST(-119.629F),
    REAL_CONST(-56.1523F),
    REAL_CONST(0.000000F),
    REAL_CONST(145.752F),
    REAL_CONST(490.723F),
    REAL_CONST(-121.094F),
    REAL_CONST(-96.4355F),
    REAL_CONST(-203.613F),
    REAL_CONST(9.03320F),
    REAL_CONST(230.713F),
    REAL_CONST(59.8145F),
    REAL_CONST(44.1895F),
    REAL_CONST(-39.0625F),
    REAL_CONST(-35.1563F),
    REAL_CONST(361.572F),
    REAL_CONST(335.205F),
    REAL_CONST(331.299F),
    REAL_CONST(-86.6699F),
    REAL_CONST(-146.729F),
    REAL_CONST(-310.059F),
    REAL_CONST(72.7539F),
    REAL_CONST(78.6133F),
    REAL_CONST(164.063F),
    REAL_CONST(-47.1191F),
    REAL_CONST(-82.0313F),
    REAL_CONST(18.7988F),
    REAL_CONST(265.869F),
    REAL_CONST(374.268F),
    REAL_CONST(225.098F),
    REAL_CONST(43.2129F),
    REAL_CONST(-9.52148F),
    REAL_CONST(-274.658F),
    REAL_CONST(243.164F),
    REAL_CONST(190.674F),
    REAL_CONST(130.859F),
    REAL_CONST(111.328F),
    REAL_CONST(89.3555F),
    REAL_CONST(-105.469F),
    REAL_CONST(345.459F),
    REAL_CONST(595.703F),
    REAL_CONST(556.396F),
    REAL_CONST(-113.770F),
    REAL_CONST(-185.059F),
    REAL_CONST(-567.627F),
    REAL_CONST(-73.9746F),
    REAL_CONST(-124.268F),
    REAL_CONST(94.4824F),
    REAL_CONST(-177.490F),
    REAL_CONST(-135.986F),
    REAL_CONST(16.1133F),
    REAL_CONST(-35.4004F),
    REAL_CONST(156.982F),
    REAL_CONST(304.688F),
    REAL_CONST(-132.813F),
    REAL_CONST(-165.039F),
    REAL_CONST(-223.633F),
    REAL_CONST(-54.9316F),
    REAL_CONST(210.449F),
    REAL_CONST(143.555F),
    REAL_CONST(-37.1094F),
    REAL_CONST(9.76563F),
    REAL_CONST(-130.127F),
    REAL_CONST(103.271F),
    REAL_CONST(347.412F),
    REAL_CONST(380.371F),
    REAL_CONST(-139.648F),
    REAL_CONST(-205.811F),
    REAL_CONST(-279.541F),
    REAL_CONST(-31.2500F),
    REAL_CONST(20.7520F),
    REAL_CONST(112.549F),
    REAL_CONST(-58.1055F),
    REAL_CONST(-62.7441F),
    REAL_CONST(-142.578F),
    REAL_CONST(147.705F),
    REAL_CONST(182.617F),
    REAL_CONST(210.205F),
    REAL_CONST(5.85938F),
    REAL_CONST(-49.3164F),
    REAL_CONST(-343.994F),
    REAL_CONST(194.580F),
    REAL_CONST(118.896F),
    REAL_CONST(73.9746F),
    REAL_CONST(-44.1895F),
    REAL_CONST(88.8672F),
    REAL_CONST(-44.4336F),
    REAL_CONST(150.391F),
    REAL_CONST(336.426F),
    REAL_CONST(718.262F),
    REAL_CONST(-120.605F),
    REAL_CONST(-208.008F),
    REAL_CONST(-351.807F),
    REAL_CONST(-71.2891F),
    REAL_CONST(14.8926F),
    REAL_CONST(198.242F),
    REAL_CONST(-20.5078F),
    REAL_CONST(-176.514F),
    REAL_CONST(-44.4336F),
    REAL_CONST(135.498F),
    REAL_CONST(129.883F),
    REAL_CONST(367.676F),
    REAL_CONST(-89.1113F),
    REAL_CONST(-120.361F),
    REAL_CONST(-258.057F),
    REAL_CONST(200.684F),
    REAL_CONST(143.555F),
    REAL_CONST(2.68555F),
    REAL_CONST(-3.41797F),
    REAL_CONST(-4.39453F),
    REAL_CONST(-56.1523F),
    REAL_CONST(244.385F),
    REAL_CONST(342.041F),
    REAL_CONST(354.248F),
    REAL_CONST(-115.723F),
    REAL_CONST(-138.916F),
    REAL_CONST(-315.430F),
    REAL_CONST(73.7305F),
    REAL_CONST(15.1367F),
    REAL_CONST(259.277F),
    REAL_CONST(-17.0898F),
    REAL_CONST(-91.7969F),
    REAL_CONST(-54.1992F),
    REAL_CONST(239.746F),
    REAL_CONST(237.793F),
    REAL_CONST(280.518F),
    REAL_CONST(-47.8516F),
    REAL_CONST(-57.1289F),
    REAL_CONST(-194.092F),
    REAL_CONST(116.943F),
    REAL_CONST(268.066F),
    REAL_CONST(121.826F),
    REAL_CONST(88.3789F),
    REAL_CONST(14.1602F),
    REAL_CONST(17.0898F),
    REAL_CONST(280.029F),
    REAL_CONST(505.127F),
    REAL_CONST(697.510F),
    REAL_CONST(-118.896F),
    REAL_CONST(-214.355F),
    REAL_CONST(-445.313F),
    REAL_CONST(17.8223F),
    REAL_CONST(-70.3125F),
    REAL_CONST(84.9609F),
    REAL_CONST(-87.4023F),
    REAL_CONST(-122.070F),
    REAL_CONST(-124.023F),
    REAL_CONST(48.5840F),
    REAL_CONST(176.025F),
    REAL_CONST(303.223F),
    REAL_CONST(-19.0430F),
    REAL_CONST(-170.166F),
    REAL_CONST(-194.092F),
    REAL_CONST(88.1348F),
    REAL_CONST(130.859F),
    REAL_CONST(47.8516F),
    REAL_CONST(91.3086F),
    REAL_CONST(26.8555F),
    REAL_CONST(-179.443F),
    REAL_CONST(206.787F),
    REAL_CONST(256.592F),
    REAL_CONST(462.891F),
    REAL_CONST(-89.3555F),
    REAL_CONST(-174.072F),
    REAL_CONST(-288.574F),
    REAL_CONST(76.9043F),
    REAL_CONST(78.1250F),
    REAL_CONST(104.736F),
    REAL_CONST(17.5781F),
    REAL_CONST(-52.4902F),
    REAL_CONST(-109.863F),
    REAL_CONST(185.303F),
    REAL_CONST(216.309F),
    REAL_CONST(332.764F),
    REAL_CONST(-7.32422F),
    REAL_CONST(-104.492F),
    REAL_CONST(-203.613F),
    REAL_CONST(210.205F),
    REAL_CONST(153.076F),
    REAL_CONST(194.336F),
    REAL_CONST(28.8086F),
    REAL_CONST(114.258F),
    REAL_CONST(-68.1152F),
    REAL_CONST(330.811F),
    REAL_CONST(459.717F),
    REAL_CONST(462.158F),
    REAL_CONST(-45.8984F),
    REAL_CONST(-156.738F),
    REAL_CONST(-393.555F),
    REAL_CONST(15.3809F),
    REAL_CONST(-42.7246F),
    REAL_CONST(292.480F),
    REAL_CONST(-102.051F),
    REAL_CONST(-51.5137F),
    REAL_CONST(12.4512F),
    REAL_CONST(101.074F),
    REAL_CONST(143.311F),
    REAL_CONST(635.010F),
    REAL_CONST(-57.1289F),
    REAL_CONST(-135.986F),
    REAL_CONST(-209.473F),
    REAL_CONST(103.516F),
    REAL_CONST(217.041F),
    REAL_CONST(54.1992F),
    REAL_CONST(33.2031F),
    REAL_CONST(-24.6582F),
    REAL_CONST(20.2637F),
    REAL_CONST(344.971F),
    REAL_CONST(556.152F),
    REAL_CONST(337.646F),
    REAL_CONST(-20.5078F),
    REAL_CONST(-108.643F),
    REAL_CONST(-339.111F),
    REAL_CONST(101.074F),
    REAL_CONST(76.4160F),
    REAL_CONST(255.127F),
    REAL_CONST(7.08008F),
    REAL_CONST(-83.7402F),
    REAL_CONST(15.8691F),
    REAL_CONST(378.906F),
    REAL_CONST(402.100F),
    REAL_CONST(239.258F),
    REAL_CONST(44.6777F),
    REAL_CONST(-22.2168F),
    REAL_CONST(-202.393F),
    REAL_CONST(310.791F),
    REAL_CONST(344.971F),
    REAL_CONST(87.8906F),
    REAL_CONST(135.010F),
    REAL_CONST(66.4063F),
    REAL_CONST(-26.1230F),
    REAL_CONST(387.451F),
    REAL_CONST(768.799F),
    REAL_CONST(635.498F)
};

/*
 * Quantization tables for split_MQ of 2 sets of LSFs in a 20 ms frame.
 */
#define DICO1_SIZE_5 128
#define DICO2_SIZE_5 256
#define DICO3_SIZE_5 256
#define DICO4_SIZE_5 256
#define DICO5_SIZE_5 64
static const real_32_t dico1_lsf_5[DICO1_SIZE_5 * 4] =
{
   REAL_CONST(-110.107F),
   REAL_CONST(-260.010F),
   REAL_CONST(-129.150F),
   REAL_CONST(-318.604F),
   REAL_CONST(-109.863F),
   REAL_CONST(-184.570F),
   REAL_CONST(-121.338F),
   REAL_CONST(-210.693F),
   REAL_CONST(-93.7500F),
   REAL_CONST(-151.123F),
   REAL_CONST(-100.830F),
   REAL_CONST(-163.330F),
   REAL_CONST(-77.3926F),
   REAL_CONST(-131.348F),
   REAL_CONST(-80.8105F),
   REAL_CONST(-135.742F),
   REAL_CONST(-101.074F),
   REAL_CONST(-124.023F),
   REAL_CONST(-103.516F),
   REAL_CONST(-92.2852F),
   REAL_CONST(-66.8945F),
   REAL_CONST(-79.1016F),
   REAL_CONST(-105.957F),
   REAL_CONST(-149.902F),
   REAL_CONST(-55.1758F),
   REAL_CONST(-122.070F),
   REAL_CONST(-56.6406F),
   REAL_CONST(-125.488F),
   REAL_CONST(-64.2090F),
   REAL_CONST(-92.0410F),
   REAL_CONST(-72.7539F),
   REAL_CONST(-100.098F),
   REAL_CONST(-36.8652F),
   REAL_CONST(-173.340F),
   REAL_CONST(-42.4805F),
   REAL_CONST(-199.707F),
   REAL_CONST(-36.3770F),
   REAL_CONST(-100.586F),
   REAL_CONST(-38.0859F),
   REAL_CONST(-104.736F),
   REAL_CONST(-70.3125F),
   REAL_CONST(-112.793F),
   REAL_CONST(-45.4102F),
   REAL_CONST(-49.5605F),
   REAL_CONST(-41.5039F),
   REAL_CONST(-73.7305F),
   REAL_CONST(-46.6309F),
   REAL_CONST(-78.3691F),
   REAL_CONST(-31.9824F),
   REAL_CONST(-35.8887F),
   REAL_CONST(-72.5098F),
   REAL_CONST(-96.4355F),
   REAL_CONST(-55.6641F),
   REAL_CONST(-52.2461F),
   REAL_CONST(-59.8145F),
   REAL_CONST(-46.8750F),
   REAL_CONST(-16.3574F),
   REAL_CONST(-77.1484F),
   REAL_CONST(-17.3340F),
   REAL_CONST(-79.8340F),
   REAL_CONST(-25.3906F),
   REAL_CONST(-50.0488F),
   REAL_CONST(-22.9492F),
   REAL_CONST(-44.6777F),
   REAL_CONST(-34.9121F),
   REAL_CONST(-9.27734F),
   REAL_CONST(-47.1191F),
   REAL_CONST(-23.1934F),
   REAL_CONST(3.90625F),
   REAL_CONST(-18.5547F),
   REAL_CONST(-30.2734F),
   REAL_CONST(-60.5469F),
   REAL_CONST(5.61523F),
   REAL_CONST(-57.8613F),
   REAL_CONST(5.85938F),
   REAL_CONST(-59.5703F),
   REAL_CONST(4.39453F),
   REAL_CONST(-33.2031F),
   REAL_CONST(10.7422F),
   REAL_CONST(-27.0996F),
   REAL_CONST(-8.05664F),
   REAL_CONST(-5.85938F),
   REAL_CONST(-6.10352F),
   REAL_CONST(0.000000F),
   REAL_CONST(36.3770F),
   REAL_CONST(4.63867F),
   REAL_CONST(5.61523F),
   REAL_CONST(-34.9121F),
   REAL_CONST(38.5742F),
   REAL_CONST(-41.2598F),
   REAL_CONST(42.4805F),
   REAL_CONST(-44.1895F),
   REAL_CONST(32.4707F),
   REAL_CONST(-13.4277F),
   REAL_CONST(40.2832F),
   REAL_CONST(-6.34766F),
   REAL_CONST(27.0996F),
   REAL_CONST(20.5078F),
   REAL_CONST(23.9258F),
   REAL_CONST(18.3105F),
   REAL_CONST(21.2402F),
   REAL_CONST(44.6777F),
   REAL_CONST(-28.0762F),
   REAL_CONST(-2.68555F),
   REAL_CONST(-1.95313F),
   REAL_CONST(31.7383F),
   REAL_CONST(2.68555F),
   REAL_CONST(41.5039F),
   REAL_CONST(62.0117F),
   REAL_CONST(18.7988F),
   REAL_CONST(50.0488F),
   REAL_CONST(4.15039F),
   REAL_CONST(44.6777F),
   REAL_CONST(27.3438F),
   REAL_CONST(63.9648F),
   REAL_CONST(47.3633F),
   REAL_CONST(49.3164F),
   REAL_CONST(70.0684F),
   REAL_CONST(23.1934F),
   REAL_CONST(46.1426F),
   REAL_CONST(-10.2539F),
   REAL_CONST(-25.6348F),
   REAL_CONST(57.1289F),
   REAL_CONST(43.7012F),
   REAL_CONST(9.52148F),
   REAL_CONST(45.4102F),
   REAL_CONST(39.7949F),
   REAL_CONST(84.2285F),
   REAL_CONST(81.0547F),
   REAL_CONST(48.5840F),
   REAL_CONST(72.9980F),
   REAL_CONST(39.3066F),
   REAL_CONST(-13.1836F),
   REAL_CONST(69.5801F),
   REAL_CONST(-19.0430F),
   REAL_CONST(68.6035F),
   REAL_CONST(-32.4707F),
   REAL_CONST(34.4238F),
   REAL_CONST(-44.4336F),
   REAL_CONST(27.0996F),
   REAL_CONST(60.7910F),
   REAL_CONST(83.2520F),
   REAL_CONST(66.1621F),
   REAL_CONST(88.8672F),
   REAL_CONST(22.7051F),
   REAL_CONST(98.3887F),
   REAL_CONST(18.3105F),
   REAL_CONST(95.4590F),
   REAL_CONST(22.4609F),
   REAL_CONST(124.512F),
   REAL_CONST(-33.6914F),
   REAL_CONST(53.7109F),
   REAL_CONST(-45.1660F),
   REAL_CONST(-7.08008F),
   REAL_CONST(-8.30078F),
   REAL_CONST(88.1348F),
   REAL_CONST(-28.0762F),
   REAL_CONST(78.1250F),
   REAL_CONST(0.732422F),
   REAL_CONST(135.254F),
   REAL_CONST(24.1699F),
   REAL_CONST(69.8242F),
   REAL_CONST(53.2227F),
   REAL_CONST(144.287F),
   REAL_CONST(-59.8145F),
   REAL_CONST(99.1211F),
   REAL_CONST(-65.4297F),
   REAL_CONST(110.596F),
   REAL_CONST(0.000000F),
   REAL_CONST(141.602F),
   REAL_CONST(6.10352F),
   REAL_CONST(147.949F),
   REAL_CONST(67.1387F),
   REAL_CONST(129.883F),
   REAL_CONST(36.1328F),
   REAL_CONST(109.863F),
   REAL_CONST(-17.8223F),
   REAL_CONST(180.420F),
   REAL_CONST(-69.5801F),
   REAL_CONST(126.465F),
   REAL_CONST(-70.3125F),
   REAL_CONST(22.9492F),
   REAL_CONST(-49.5605F),
   REAL_CONST(164.551F),
   REAL_CONST(-34.1797F),
   REAL_CONST(-18.0664F),
   REAL_CONST(50.0488F),
   REAL_CONST(174.316F),
   REAL_CONST(-27.8320F),
   REAL_CONST(72.9980F),
   REAL_CONST(42.9688F),
   REAL_CONST(225.342F),
   REAL_CONST(44.4336F),
   REAL_CONST(135.986F),
   REAL_CONST(58.5938F),
   REAL_CONST(172.119F),
   REAL_CONST(-3.90625F),
   REAL_CONST(125.244F),
   REAL_CONST(118.408F),
   REAL_CONST(144.775F),
   REAL_CONST(71.5332F),
   REAL_CONST(93.7500F),
   REAL_CONST(110.107F),
   REAL_CONST(150.635F),
   REAL_CONST(-9.27734F),
   REAL_CONST(12.2070F),
   REAL_CONST(137.451F),
   REAL_CONST(129.150F),
   REAL_CONST(73.9746F),
   REAL_CONST(51.0254F),
   REAL_CONST(112.061F),
   REAL_CONST(88.6230F),
   REAL_CONST(105.713F),
   REAL_CONST(110.352F),
   REAL_CONST(109.863F),
   REAL_CONST(110.840F),
   REAL_CONST(89.5996F),
   REAL_CONST(147.949F),
   REAL_CONST(116.455F),
   REAL_CONST(180.908F),
   REAL_CONST(105.469F),
   REAL_CONST(86.1816F),
   REAL_CONST(89.8438F),
   REAL_CONST(65.1855F),
   REAL_CONST(88.1348F),
   REAL_CONST(174.805F),
   REAL_CONST(66.6504F),
   REAL_CONST(142.334F),
   REAL_CONST(110.596F),
   REAL_CONST(40.5273F),
   REAL_CONST(124.512F),
   REAL_CONST(41.9922F),
   REAL_CONST(49.0723F),
   REAL_CONST(153.564F),
   REAL_CONST(66.8945F),
   REAL_CONST(46.6309F),
   REAL_CONST(138.672F),
   REAL_CONST(156.006F),
   REAL_CONST(73.7305F),
   REAL_CONST(72.7539F),
   REAL_CONST(154.785F),
   REAL_CONST(94.4824F),
   REAL_CONST(156.982F),
   REAL_CONST(85.4492F),
   REAL_CONST(143.311F),
   REAL_CONST(136.719F),
   REAL_CONST(149.414F),
   REAL_CONST(137.939F),
   REAL_CONST(146.484F),
   REAL_CONST(192.383F),
   REAL_CONST(118.896F),
   REAL_CONST(164.063F),
   REAL_CONST(125.000F),
   REAL_CONST(247.803F),
   REAL_CONST(78.3691F),
   REAL_CONST(81.2988F),
   REAL_CONST(87.1582F),
   REAL_CONST(208.496F),
   REAL_CONST(-30.5176F),
   REAL_CONST(100.830F),
   REAL_CONST(115.723F),
   REAL_CONST(173.828F),
   REAL_CONST(4.15039F),
   REAL_CONST(-36.8652F),
   REAL_CONST(137.695F),
   REAL_CONST(69.5801F),
   REAL_CONST(65.9180F),
   REAL_CONST(-58.8379F),
   REAL_CONST(237.061F),
   REAL_CONST(217.041F),
   REAL_CONST(119.385F),
   REAL_CONST(53.7109F),
   REAL_CONST(124.512F),
   REAL_CONST(218.750F),
   REAL_CONST(134.033F),
   REAL_CONST(225.586F),
   REAL_CONST(79.8340F),
   REAL_CONST(201.416F),
   REAL_CONST(70.8008F),
   REAL_CONST(222.412F),
   REAL_CONST(131.836F),
   REAL_CONST(270.508F),
   REAL_CONST(38.5742F),
   REAL_CONST(196.533F),
   REAL_CONST(48.5840F),
   REAL_CONST(233.643F),
   REAL_CONST(124.756F),
   REAL_CONST(178.223F),
   REAL_CONST(24.4141F),
   REAL_CONST(213.379F),
   REAL_CONST(3.17383F),
   REAL_CONST(193.115F),
   REAL_CONST(106.201F),
   REAL_CONST(154.297F),
   REAL_CONST(165.039F),
   REAL_CONST(237.305F),
   REAL_CONST(60.7910F),
   REAL_CONST(219.727F),
   REAL_CONST(114.014F),
   REAL_CONST(297.363F),
   REAL_CONST(190.674F),
   REAL_CONST(262.207F),
   REAL_CONST(142.822F),
   REAL_CONST(191.650F),
   REAL_CONST(-5.61523F),
   REAL_CONST(163.330F),
   REAL_CONST(65.1855F),
   REAL_CONST(254.639F),
   REAL_CONST(151.123F),
   REAL_CONST(264.648F),
   REAL_CONST(150.146F),
   REAL_CONST(279.541F),
   REAL_CONST(151.855F),
   REAL_CONST(220.947F),
   REAL_CONST(223.633F),
   REAL_CONST(256.104F),
   REAL_CONST(19.5313F),
   REAL_CONST(80.8105F),
   REAL_CONST(142.578F),
   REAL_CONST(262.451F),
   REAL_CONST(21.7285F),
   REAL_CONST(156.006F),
   REAL_CONST(241.211F),
   REAL_CONST(234.619F),
   REAL_CONST(187.988F),
   REAL_CONST(175.781F),
   REAL_CONST(194.824F),
   REAL_CONST(170.654F),
   REAL_CONST(120.117F),
   REAL_CONST(109.131F),
   REAL_CONST(219.482F),
   REAL_CONST(153.076F),
   REAL_CONST(66.1621F),
   REAL_CONST(290.039F),
   REAL_CONST(177.002F),
   REAL_CONST(325.439F),
   REAL_CONST(21.2402F),
   REAL_CONST(147.217F),
   REAL_CONST(203.125F),
   REAL_CONST(391.357F),
   REAL_CONST(150.391F),
   REAL_CONST(275.146F),
   REAL_CONST(217.285F),
   REAL_CONST(367.432F),
   REAL_CONST(244.141F),
   REAL_CONST(282.227F),
   REAL_CONST(211.426F),
   REAL_CONST(246.338F),
   REAL_CONST(242.920F),
   REAL_CONST(201.904F),
   REAL_CONST(280.518F),
   REAL_CONST(209.473F),
   REAL_CONST(199.463F),
   REAL_CONST(354.004F),
   REAL_CONST(188.721F),
   REAL_CONST(322.266F),
   REAL_CONST(122.070F),
   REAL_CONST(339.111F),
   REAL_CONST(76.1719F),
   REAL_CONST(281.494F),
   REAL_CONST(-4.88281F),
   REAL_CONST(264.648F),
   REAL_CONST(15.6250F),
   REAL_CONST(313.232F),
   REAL_CONST(0.488281F),
   REAL_CONST(286.133F),
   REAL_CONST(97.4121F),
   REAL_CONST(456.299F),
   REAL_CONST(125.488F),
   REAL_CONST(416.504F),
   REAL_CONST(122.559F),
   REAL_CONST(399.414F),
   REAL_CONST(216.309F),
   REAL_CONST(371.582F),
   REAL_CONST(101.563F),
   REAL_CONST(146.484F),
   REAL_CONST(276.123F),
   REAL_CONST(329.590F),
   REAL_CONST(311.279F),
   REAL_CONST(339.355F),
   REAL_CONST(217.041F),
   REAL_CONST(438.232F),
   REAL_CONST(223.145F),
   REAL_CONST(431.152F),
   REAL_CONST(55.4199F),
   REAL_CONST(288.818F),
   REAL_CONST(305.176F),
   REAL_CONST(445.801F),
   REAL_CONST(123.291F),
   REAL_CONST(452.637F),
   REAL_CONST(224.365F),
   REAL_CONST(574.463F),
   REAL_CONST(-48.5840F),
   REAL_CONST(105.225F),
   REAL_CONST(37.1094F),
   REAL_CONST(423.584F),
   REAL_CONST(-52.0020F),
   REAL_CONST(-6.83594F),
   REAL_CONST(95.7031F),
   REAL_CONST(325.684F),
   REAL_CONST(-37.3535F),
   REAL_CONST(-12.6953F),
   REAL_CONST(238.770F),
   REAL_CONST(281.006F),
   REAL_CONST(-78.8574F),
   REAL_CONST(-97.6563F),
   REAL_CONST(198.486F),
   REAL_CONST(415.771F),
   REAL_CONST(-33.2031F),
   REAL_CONST(20.5078F),
   REAL_CONST(353.760F),
   REAL_CONST(491.943F),
   REAL_CONST(-80.8105F),
   REAL_CONST(-34.9121F),
   REAL_CONST(-33.4473F),
   REAL_CONST(291.016F),
   REAL_CONST(-62.5000F),
   REAL_CONST(130.371F),
   REAL_CONST(-38.3301F),
   REAL_CONST(251.709F),
   REAL_CONST(-74.9512F),
   REAL_CONST(-107.178F),
   REAL_CONST(132.324F),
   REAL_CONST(178.467F),
   REAL_CONST(-80.3223F),
   REAL_CONST(-102.539F),
   REAL_CONST(-23.6816F),
   REAL_CONST(150.391F),
   REAL_CONST(-88.3789F),
   REAL_CONST(-41.0156F),
   REAL_CONST(-78.6133F),
   REAL_CONST(89.3555F),
   REAL_CONST(-60.3027F),
   REAL_CONST(-26.8555F),
   REAL_CONST(-51.5137F),
   REAL_CONST(21.7285F),
   REAL_CONST(-47.8516F),
   REAL_CONST(-75.4395F),
   REAL_CONST(4.88281F),
   REAL_CONST(14.4043F),
   REAL_CONST(-88.8672F),
   REAL_CONST(-113.037F),
   REAL_CONST(-69.8242F),
   REAL_CONST(21.7285F),
   REAL_CONST(-82.0313F),
   REAL_CONST(42.7246F),
   REAL_CONST(-105.469F),
   REAL_CONST(34.4238F),
   REAL_CONST(-92.5293F),
   REAL_CONST(-46.3867F),
   REAL_CONST(-105.957F),
   REAL_CONST(-47.8516F),
   REAL_CONST(-19.2871F),
   REAL_CONST(36.6211F),
   REAL_CONST(-67.8711F),
   REAL_CONST(-55.4199F),
   REAL_CONST(-68.3594F),
   REAL_CONST(40.5273F),
   REAL_CONST(-135.498F),
   REAL_CONST(-103.027F),
   REAL_CONST(-37.8418F),
   REAL_CONST(132.080F),
   REAL_CONST(-89.3555F),
   REAL_CONST(13.1836F),
   REAL_CONST(-7.08008F),
   REAL_CONST(-20.2637F),
   REAL_CONST(-73.4863F),
   REAL_CONST(-188.965F),
   REAL_CONST(45.4102F),
   REAL_CONST(153.320F),
   REAL_CONST(-96.9238F),
   REAL_CONST(-64.4531F),
   REAL_CONST(59.0820F),
   REAL_CONST(71.5332F),
   REAL_CONST(-48.0957F),
   REAL_CONST(-142.822F),
   REAL_CONST(30.2734F),
   REAL_CONST(100.098F),
   REAL_CONST(12.9395F),
   REAL_CONST(-32.4707F),
   REAL_CONST(2.44141F),
   REAL_CONST(83.0078F),
   REAL_CONST(-139.160F),
   REAL_CONST(-260.010F),
   REAL_CONST(15.8691F),
   REAL_CONST(-108.887F),
   REAL_CONST(16.6016F),
   REAL_CONST(-120.361F),
   REAL_CONST(93.5059F),
   REAL_CONST(228.760F),
   REAL_CONST(-87.1582F),
   REAL_CONST(-173.584F),
   REAL_CONST(-87.6465F),
   REAL_CONST(-61.0352F),
   REAL_CONST(-165.283F),
   REAL_CONST(-260.742F),
   REAL_CONST(71.2891F),
   REAL_CONST(-6.34766F),
   REAL_CONST(88.6230F),
   REAL_CONST(1.46484F),
   REAL_CONST(148.193F),
   REAL_CONST(320.557F),
   REAL_CONST(-31.0059F),
   REAL_CONST(-2.44141F),
   REAL_CONST(369.385F),
   REAL_CONST(460.449F),
   REAL_CONST(174.072F),
   REAL_CONST(237.305F),
   REAL_CONST(358.643F),
   REAL_CONST(532.471F),
   REAL_CONST(352.295F),
   REAL_CONST(492.188F)
};

static const real_32_t dico2_lsf_5[DICO2_SIZE_5 * 4] =
{
   REAL_CONST(-398.193F),
   REAL_CONST(-390.625F),
   REAL_CONST(-438.477F),
   REAL_CONST(-559.082F),
   REAL_CONST(-250.732F),
   REAL_CONST(-432.129F),
   REAL_CONST(-268.555F),
   REAL_CONST(-494.385F),
   REAL_CONST(-311.768F),
   REAL_CONST(-338.867F),
   REAL_CONST(-333.740F),
   REAL_CONST(-374.512F),
   REAL_CONST(-231.201F),
   REAL_CONST(-356.689F),
   REAL_CONST(-237.305F),
   REAL_CONST(-372.070F),
   REAL_CONST(-243.896F),
   REAL_CONST(-298.340F),
   REAL_CONST(-249.023F),
   REAL_CONST(-286.133F),
   REAL_CONST(-198.975F),
   REAL_CONST(-240.967F),
   REAL_CONST(-242.188F),
   REAL_CONST(-334.717F),
   REAL_CONST(-296.875F),
   REAL_CONST(-245.605F),
   REAL_CONST(-314.697F),
   REAL_CONST(-267.090F),
   REAL_CONST(-181.641F),
   REAL_CONST(-309.570F),
   REAL_CONST(-184.326F),
   REAL_CONST(-315.674F),
   REAL_CONST(-210.449F),
   REAL_CONST(-225.342F),
   REAL_CONST(-220.947F),
   REAL_CONST(-240.234F),
   REAL_CONST(-165.527F),
   REAL_CONST(-256.592F),
   REAL_CONST(-167.236F),
   REAL_CONST(-256.348F),
   REAL_CONST(-265.381F),
   REAL_CONST(-240.479F),
   REAL_CONST(-259.277F),
   REAL_CONST(-165.771F),
   REAL_CONST(-241.455F),
   REAL_CONST(-156.494F),
   REAL_CONST(-275.146F),
   REAL_CONST(-238.281F),
   REAL_CONST(-186.035F),
   REAL_CONST(-159.668F),
   REAL_CONST(-217.285F),
   REAL_CONST(-196.777F),
   REAL_CONST(-203.369F),
   REAL_CONST(-266.357F),
   REAL_CONST(-172.363F),
   REAL_CONST(-153.564F),
   REAL_CONST(-151.611F),
   REAL_CONST(-196.777F),
   REAL_CONST(-156.250F),
   REAL_CONST(-198.242F),
   REAL_CONST(-189.209F),
   REAL_CONST(-154.785F),
   REAL_CONST(-190.186F),
   REAL_CONST(-132.568F),
   REAL_CONST(-243.164F),
   REAL_CONST(-137.939F),
   REAL_CONST(-262.451F),
   REAL_CONST(-141.602F),
   REAL_CONST(-133.301F),
   REAL_CONST(-149.170F),
   REAL_CONST(-139.648F),
   REAL_CONST(-151.123F),
   REAL_CONST(-185.547F),
   REAL_CONST(-70.8008F),
   REAL_CONST(-214.600F),
   REAL_CONST(-128.418F),
   REAL_CONST(-200.928F),
   REAL_CONST(-112.793F),
   REAL_CONST(-194.092F),
   REAL_CONST(-61.7676F),
   REAL_CONST(-135.010F),
   REAL_CONST(-101.318F),
   REAL_CONST(-143.799F),
   REAL_CONST(-107.178F),
   REAL_CONST(-130.127F),
   REAL_CONST(-83.0078F),
   REAL_CONST(-168.945F),
   REAL_CONST(-228.271F),
   REAL_CONST(-123.291F),
   REAL_CONST(-188.477F),
   REAL_CONST(-171.387F),
   REAL_CONST(-276.123F),
   REAL_CONST(-64.2090F),
   REAL_CONST(-74.7070F),
   REAL_CONST(-237.061F),
   REAL_CONST(-117.920F),
   REAL_CONST(-108.643F),
   REAL_CONST(-18.0664F),
   REAL_CONST(-135.498F),
   REAL_CONST(-133.789F),
   REAL_CONST(-149.902F),
   REAL_CONST(-31.4941F),
   REAL_CONST(-169.189F),
   REAL_CONST(-57.1289F),
   REAL_CONST(-96.6797F),
   REAL_CONST(-60.0586F),
   REAL_CONST(-115.967F),
   REAL_CONST(-61.0352F),
   REAL_CONST(-64.6973F),
   REAL_CONST(-98.6328F),
   REAL_CONST(-91.7969F),
   REAL_CONST(-125.488F),
   REAL_CONST(-101.807F),
   REAL_CONST(-124.512F),
   REAL_CONST(-73.2422F),
   REAL_CONST(-76.4160F),
   REAL_CONST(-81.5430F),
   REAL_CONST(-162.109F),
   REAL_CONST(-113.037F),
   REAL_CONST(-198.730F),
   REAL_CONST(-94.2383F),
   REAL_CONST(-171.875F),
   REAL_CONST(-82.2754F),
   REAL_CONST(-150.146F),
   REAL_CONST(-57.1289F),
   REAL_CONST(-49.0723F),
   REAL_CONST(-56.8848F),
   REAL_CONST(-58.3496F),
   REAL_CONST(-40.7715F),
   REAL_CONST(-138.428F),
   REAL_CONST(-49.5605F),
   REAL_CONST(-151.123F),
   REAL_CONST(-35.8887F),
   REAL_CONST(-101.318F),
   REAL_CONST(-28.0762F),
   REAL_CONST(-85.9375F),
   REAL_CONST(-40.5273F),
   REAL_CONST(-183.105F),
   REAL_CONST(-41.7480F),
   REAL_CONST(-185.791F),
   REAL_CONST(-65.9180F),
   REAL_CONST(-214.600F),
   REAL_CONST(-64.4531F),
   REAL_CONST(-220.459F),
   REAL_CONST(-89.5996F),
   REAL_CONST(-181.641F),
   REAL_CONST(10.4980F),
   REAL_CONST(-115.967F),
   REAL_CONST(3.41797F),
   REAL_CONST(-159.424F),
   REAL_CONST(10.4980F),
   REAL_CONST(-163.574F),
   REAL_CONST(2.68555F),
   REAL_CONST(-109.375F),
   REAL_CONST(-14.4043F),
   REAL_CONST(-127.197F),
   REAL_CONST(-30.7617F),
   REAL_CONST(-29.0527F),
   REAL_CONST(-37.8418F),
   REAL_CONST(-149.658F),
   REAL_CONST(-10.2539F),
   REAL_CONST(-210.693F),
   REAL_CONST(-6.59180F),
   REAL_CONST(-227.295F),
   REAL_CONST(33.2031F),
   REAL_CONST(-117.920F),
   REAL_CONST(44.6777F),
   REAL_CONST(-114.258F),
   REAL_CONST(13.4277F),
   REAL_CONST(-72.7539F),
   REAL_CONST(13.4277F),
   REAL_CONST(-74.2188F),
   REAL_CONST(76.4160F),
   REAL_CONST(-148.682F),
   REAL_CONST(76.4160F),
   REAL_CONST(-175.781F),
   REAL_CONST(78.6133F),
   REAL_CONST(-40.7715F),
   REAL_CONST(24.4141F),
   REAL_CONST(-132.080F),
   REAL_CONST(-0.732422F),
   REAL_CONST(-29.0527F),
   REAL_CONST(-27.0996F),
   REAL_CONST(-45.6543F),
   REAL_CONST(56.8848F),
   REAL_CONST(-57.6172F),
   REAL_CONST(63.4766F),
   REAL_CONST(-57.1289F),
   REAL_CONST(6.34766F),
   REAL_CONST(-40.2832F),
   REAL_CONST(32.7148F),
   REAL_CONST(-10.9863F),
   REAL_CONST(-9.76563F),
   REAL_CONST(-134.033F),
   REAL_CONST(87.8906F),
   REAL_CONST(-49.5605F),
   REAL_CONST(92.2852F),
   REAL_CONST(-94.7266F),
   REAL_CONST(109.863F),
   REAL_CONST(-93.5059F),
   REAL_CONST(67.1387F),
   REAL_CONST(4.88281F),
   REAL_CONST(44.4336F),
   REAL_CONST(-25.1465F),
   REAL_CONST(60.0586F),
   REAL_CONST(-27.0996F),
   REAL_CONST(105.225F),
   REAL_CONST(9.03320F),
   REAL_CONST(112.793F),
   REAL_CONST(-35.6445F),
   REAL_CONST(118.896F),
   REAL_CONST(-38.3301F),
   REAL_CONST(-69.3359F),
   REAL_CONST(-14.4043F),
   REAL_CONST(122.803F),
   REAL_CONST(-44.9219F),
   REAL_CONST(5.85938F),
   REAL_CONST(12.9395F),
   REAL_CONST(-0.732422F),
   REAL_CONST(13.1836F),
   REAL_CONST(29.7852F),
   REAL_CONST(63.2324F),
   REAL_CONST(81.2988F),
   REAL_CONST(16.1133F),
   REAL_CONST(118.164F),
   REAL_CONST(25.3906F),
   REAL_CONST(106.445F),
   REAL_CONST(16.6016F),
   REAL_CONST(47.6074F),
   REAL_CONST(28.3203F),
   REAL_CONST(46.3867F),
   REAL_CONST(50.2930F),
   REAL_CONST(65.6738F),
   REAL_CONST(-2.19727F),
   REAL_CONST(117.676F),
   REAL_CONST(85.9375F),
   REAL_CONST(93.2617F),
   REAL_CONST(69.5801F),
   REAL_CONST(97.4121F),
   REAL_CONST(67.6270F),
   REAL_CONST(110.352F),
   REAL_CONST(62.5000F),
   REAL_CONST(16.8457F),
   REAL_CONST(45.4102F),
   REAL_CONST(3.17383F),
   REAL_CONST(72.5098F),
   REAL_CONST(-3.17383F),
   REAL_CONST(63.2324F),
   REAL_CONST(-23.1934F),
   REAL_CONST(7.32422F),
   REAL_CONST(13.6719F),
   REAL_CONST(96.1914F),
   REAL_CONST(47.8516F),
   REAL_CONST(103.760F),
   REAL_CONST(50.0488F),
   REAL_CONST(111.328F),
   REAL_CONST(68.6035F),
   REAL_CONST(140.869F),
   REAL_CONST(3.66211F),
   REAL_CONST(46.6309F),
   REAL_CONST(91.5527F),
   REAL_CONST(70.8008F),
   REAL_CONST(99.3652F),
   REAL_CONST(140.625F),
   REAL_CONST(-13.6719F),
   REAL_CONST(55.4199F),
   REAL_CONST(132.813F),
   REAL_CONST(98.8770F),
   REAL_CONST(0.000000F),
   REAL_CONST(134.033F),
   REAL_CONST(-22.4609F),
   REAL_CONST(128.906F),
   REAL_CONST(-55.9082F),
   REAL_CONST(85.6934F),
   REAL_CONST(-59.8145F),
   REAL_CONST(82.5195F),
   REAL_CONST(-88.3789F),
   REAL_CONST(106.201F),
   REAL_CONST(40.7715F),
   REAL_CONST(128.662F),
   REAL_CONST(-18.3105F),
   REAL_CONST(73.7305F),
   REAL_CONST(22.2168F),
   REAL_CONST(201.172F),
   REAL_CONST(31.4941F),
   REAL_CONST(146.240F),
   REAL_CONST(121.094F),
   REAL_CONST(165.771F),
   REAL_CONST(45.4102F),
   REAL_CONST(182.861F),
   REAL_CONST(37.3535F),
   REAL_CONST(179.932F),
   REAL_CONST(-68.6035F),
   REAL_CONST(146.484F),
   REAL_CONST(-84.9609F),
   REAL_CONST(150.146F),
   REAL_CONST(-57.6172F),
   REAL_CONST(187.744F),
   REAL_CONST(10.0098F),
   REAL_CONST(215.088F),
   REAL_CONST(9.27734F),
   REAL_CONST(217.285F),
   REAL_CONST(-53.7109F),
   REAL_CONST(205.322F),
   REAL_CONST(-87.1582F),
   REAL_CONST(215.576F),
   REAL_CONST(-95.9473F),
   REAL_CONST(220.459F),
   REAL_CONST(-154.785F),
   REAL_CONST(115.723F),
   REAL_CONST(-108.398F),
   REAL_CONST(207.520F),
   REAL_CONST(-42.7246F),
   REAL_CONST(165.527F),
   REAL_CONST(-120.361F),
   REAL_CONST(59.0820F),
   REAL_CONST(-126.709F),
   REAL_CONST(191.650F),
   REAL_CONST(-174.316F),
   REAL_CONST(142.090F),
   REAL_CONST(-132.080F),
   REAL_CONST(89.3555F),
   REAL_CONST(-132.568F),
   REAL_CONST(105.957F),
   REAL_CONST(-145.752F),
   REAL_CONST(122.070F),
   REAL_CONST(-186.768F),
   REAL_CONST(54.1992F),
   REAL_CONST(-171.387F),
   REAL_CONST(223.877F),
   REAL_CONST(-181.396F),
   REAL_CONST(234.863F),
   REAL_CONST(-212.158F),
   REAL_CONST(122.314F),
   REAL_CONST(-219.482F),
   REAL_CONST(133.789F),
   REAL_CONST(-92.5293F),
   REAL_CONST(48.8281F),
   REAL_CONST(-106.201F),
   REAL_CONST(38.3301F),
   REAL_CONST(-199.951F),
   REAL_CONST(52.2461F),
   REAL_CONST(-210.205F),
   REAL_CONST(38.3301F),
   REAL_CONST(-149.902F),
   REAL_CONST(9.76563F),
   REAL_CONST(-154.297F),
   REAL_CONST(22.9492F),
   REAL_CONST(-215.576F),
   REAL_CONST(-13.1836F),
   REAL_CONST(-180.908F),
   REAL_CONST(125.977F),
   REAL_CONST(-122.314F),
   REAL_CONST(72.7539F),
   REAL_CONST(-149.902F),
   REAL_CONST(-41.7480F),
   REAL_CONST(-212.402F),
   REAL_CONST(-39.3066F),
   REAL_CONST(-211.182F),
   REAL_CONST(-5.61523F),
   REAL_CONST(-199.707F),
   REAL_CONST(22.7051F),
   REAL_CONST(-247.803F),
   REAL_CONST(-65.1855F),
   REAL_CONST(-161.621F),
   REAL_CONST(-87.6465F),
   REAL_CONST(-134.033F),
   REAL_CONST(0.488281F),
   REAL_CONST(-107.910F),
   REAL_CONST(-29.5410F),
   REAL_CONST(-92.0410F),
   REAL_CONST(0.000000F),
   REAL_CONST(-55.4199F),
   REAL_CONST(8.05664F),
   REAL_CONST(-101.074F),
   REAL_CONST(-30.7617F),
   REAL_CONST(-31.4941F),
   REAL_CONST(51.7578F),
   REAL_CONST(-228.027F),
   REAL_CONST(8.30078F),
   REAL_CONST(-264.160F),
   REAL_CONST(-68.8477F),
   REAL_CONST(-273.193F),
   REAL_CONST(-65.4297F),
   REAL_CONST(-173.340F),
   REAL_CONST(-201.416F),
   REAL_CONST(-102.539F),
   REAL_CONST(-46.6309F),
   REAL_CONST(-262.695F),
   REAL_CONST(-226.563F),
   REAL_CONST(-223.877F),
   REAL_CONST(-22.7051F),
   REAL_CONST(-153.320F),
   REAL_CONST(-87.4023F),
   REAL_CONST(23.6816F),
   REAL_CONST(1.70898F),
   REAL_CONST(-50.2930F),
   REAL_CONST(-95.9473F),
   REAL_CONST(-24.6582F),
   REAL_CONST(5.85938F),
   REAL_CONST(-49.5605F),
   REAL_CONST(9.27734F),
   REAL_CONST(-41.0156F),
   REAL_CONST(20.2637F),
   REAL_CONST(-146.240F),
   REAL_CONST(-103.271F),
   REAL_CONST(-68.1152F),
   REAL_CONST(104.004F),
   REAL_CONST(-170.898F),
   REAL_CONST(28.8086F),
   REAL_CONST(-18.3105F),
   REAL_CONST(50.2930F),
   REAL_CONST(-239.502F),
   REAL_CONST(-164.307F),
   REAL_CONST(-166.016F),
   REAL_CONST(101.807F),
   REAL_CONST(-89.5996F),
   REAL_CONST(9.03320F),
   REAL_CONST(-68.1152F),
   REAL_CONST(115.723F),
   REAL_CONST(-31.4941F),
   REAL_CONST(-77.6367F),
   REAL_CONST(77.8809F),
   REAL_CONST(72.2656F),
   REAL_CONST(-152.832F),
   REAL_CONST(-9.52148F),
   REAL_CONST(83.7402F),
   REAL_CONST(146.973F),
   REAL_CONST(-169.922F),
   REAL_CONST(-9.52148F),
   REAL_CONST(-73.9746F),
   REAL_CONST(229.492F),
   REAL_CONST(25.3906F),
   REAL_CONST(56.8848F),
   REAL_CONST(-92.7734F),
   REAL_CONST(33.4473F),
   REAL_CONST(-8.78906F),
   REAL_CONST(65.6738F),
   REAL_CONST(-18.3105F),
   REAL_CONST(-52.2461F),
   REAL_CONST(29.2969F),
   REAL_CONST(10.4980F),
   REAL_CONST(-129.150F),
   REAL_CONST(-116.455F),
   REAL_CONST(112.061F),
   REAL_CONST(40.0391F),
   REAL_CONST(-49.3164F),
   REAL_CONST(-55.9082F),
   REAL_CONST(-11.9629F),
   REAL_CONST(-40.7715F),
   REAL_CONST(148.682F),
   REAL_CONST(193.359F),
   REAL_CONST(23.9258F),
   REAL_CONST(-53.7109F),
   REAL_CONST(223.389F),
   REAL_CONST(36.1328F),
   REAL_CONST(71.5332F),
   REAL_CONST(69.0918F),
   REAL_CONST(212.158F),
   REAL_CONST(22.2168F),
   REAL_CONST(140.381F),
   REAL_CONST(96.1914F),
   REAL_CONST(79.5898F),
   REAL_CONST(-19.0430F),
   REAL_CONST(175.049F),
   REAL_CONST(16.3574F),
   REAL_CONST(89.1113F),
   REAL_CONST(-78.8574F),
   REAL_CONST(150.391F),
   REAL_CONST(-8.78906F),
   REAL_CONST(178.467F),
   REAL_CONST(6.59180F),
   REAL_CONST(151.123F),
   REAL_CONST(58.1055F),
   REAL_CONST(154.297F),
   REAL_CONST(66.6504F),
   REAL_CONST(109.375F),
   REAL_CONST(24.1699F),
   REAL_CONST(195.557F),
   REAL_CONST(116.211F),
   REAL_CONST(212.158F),
   REAL_CONST(66.6504F),
   REAL_CONST(167.236F),
   REAL_CONST(15.6250F),
   REAL_CONST(192.627F),
   REAL_CONST(17.5781F),
   REAL_CONST(249.268F),
   REAL_CONST(52.9785F),
   REAL_CONST(193.604F),
   REAL_CONST(112.061F),
   REAL_CONST(179.199F),
   REAL_CONST(87.8906F),
   REAL_CONST(157.715F),
   REAL_CONST(117.188F),
   REAL_CONST(87.8906F),
   REAL_CONST(78.6133F),
   REAL_CONST(104.736F),
   REAL_CONST(113.281F),
   REAL_CONST(155.762F),
   REAL_CONST(104.980F),
   REAL_CONST(184.570F),
   REAL_CONST(88.6230F),
   REAL_CONST(244.141F),
   REAL_CONST(98.6328F),
   REAL_CONST(166.748F),
   REAL_CONST(128.906F),
   REAL_CONST(146.973F),
   REAL_CONST(150.146F),
   REAL_CONST(159.912F),
   REAL_CONST(100.830F),
   REAL_CONST(230.957F),
   REAL_CONST(167.725F),
   REAL_CONST(228.760F),
   REAL_CONST(146.973F),
   REAL_CONST(220.703F),
   REAL_CONST(147.461F),
   REAL_CONST(135.498F),
   REAL_CONST(179.932F),
   REAL_CONST(191.895F),
   REAL_CONST(161.621F),
   REAL_CONST(114.014F),
   REAL_CONST(159.668F),
   REAL_CONST(88.3789F),
   REAL_CONST(143.799F),
   REAL_CONST(226.807F),
   REAL_CONST(173.340F),
   REAL_CONST(121.582F),
   REAL_CONST(116.699F),
   REAL_CONST(101.318F),
   REAL_CONST(102.539F),
   REAL_CONST(169.189F),
   REAL_CONST(215.576F),
   REAL_CONST(198.486F),
   REAL_CONST(166.748F),
   REAL_CONST(190.674F),
   REAL_CONST(225.830F),
   REAL_CONST(222.900F),
   REAL_CONST(229.248F),
   REAL_CONST(177.246F),
   REAL_CONST(178.711F),
   REAL_CONST(119.873F),
   REAL_CONST(208.252F),
   REAL_CONST(129.639F),
   REAL_CONST(231.445F),
   REAL_CONST(179.199F),
   REAL_CONST(235.107F),
   REAL_CONST(76.9043F),
   REAL_CONST(197.266F),
   REAL_CONST(185.791F),
   REAL_CONST(184.326F),
   REAL_CONST(279.297F),
   REAL_CONST(185.547F),
   REAL_CONST(159.912F),
   REAL_CONST(262.695F),
   REAL_CONST(201.660F),
   REAL_CONST(258.057F),
   REAL_CONST(266.357F),
   REAL_CONST(204.590F),
   REAL_CONST(244.873F),
   REAL_CONST(197.266F),
   REAL_CONST(255.615F),
   REAL_CONST(276.611F),
   REAL_CONST(160.889F),
   REAL_CONST(268.799F),
   REAL_CONST(242.188F),
   REAL_CONST(256.348F),
   REAL_CONST(262.207F),
   REAL_CONST(262.451F),
   REAL_CONST(237.061F),
   REAL_CONST(169.434F),
   REAL_CONST(299.316F),
   REAL_CONST(257.324F),
   REAL_CONST(139.404F),
   REAL_CONST(205.322F),
   REAL_CONST(215.820F),
   REAL_CONST(342.773F),
   REAL_CONST(336.670F),
   REAL_CONST(267.578F),
   REAL_CONST(263.672F),
   REAL_CONST(210.205F),
   REAL_CONST(300.537F),
   REAL_CONST(179.443F),
   REAL_CONST(313.477F),
   REAL_CONST(185.547F),
   REAL_CONST(310.547F),
   REAL_CONST(241.943F),
   REAL_CONST(333.740F),
   REAL_CONST(257.080F),
   REAL_CONST(306.885F),
   REAL_CONST(170.898F),
   REAL_CONST(256.348F),
   REAL_CONST(130.371F),
   REAL_CONST(241.211F),
   REAL_CONST(110.596F),
   REAL_CONST(308.594F),
   REAL_CONST(146.240F),
   REAL_CONST(278.320F),
   REAL_CONST(165.771F),
   REAL_CONST(395.752F),
   REAL_CONST(198.975F),
   REAL_CONST(337.891F),
   REAL_CONST(127.197F),
   REAL_CONST(321.533F),
   REAL_CONST(95.9473F),
   REAL_CONST(381.836F),
   REAL_CONST(196.533F),
   REAL_CONST(353.516F),
   REAL_CONST(167.480F),
   REAL_CONST(260.742F),
   REAL_CONST(158.203F),
   REAL_CONST(213.623F),
   REAL_CONST(74.9512F),
   REAL_CONST(264.404F),
   REAL_CONST(88.1348F),
   REAL_CONST(255.615F),
   REAL_CONST(77.3926F),
   REAL_CONST(345.947F),
   REAL_CONST(235.352F),
   REAL_CONST(164.795F),
   REAL_CONST(139.404F),
   REAL_CONST(281.250F),
   REAL_CONST(19.2871F),
   REAL_CONST(271.973F),
   REAL_CONST(-11.4746F),
   REAL_CONST(373.535F),
   REAL_CONST(75.9277F),
   REAL_CONST(420.166F),
   REAL_CONST(76.6602F),
   REAL_CONST(284.668F),
   REAL_CONST(168.213F),
   REAL_CONST(125.488F),
   REAL_CONST(-22.9492F),
   REAL_CONST(85.2051F),
   REAL_CONST(68.8477F),
   REAL_CONST(344.727F),
   REAL_CONST(80.0781F),
   REAL_CONST(250.244F),
   REAL_CONST(118.896F),
   REAL_CONST(-15.8691F),
   REAL_CONST(13.9160F),
   REAL_CONST(196.533F),
   REAL_CONST(236.816F),
   REAL_CONST(8.78906F),
   REAL_CONST(15.1367F),
   REAL_CONST(187.744F),
   REAL_CONST(-64.2090F),
   REAL_CONST(193.115F),
   REAL_CONST(-84.4727F),
   REAL_CONST(155.518F),
   REAL_CONST(170.654F),
   REAL_CONST(-33.4473F),
   REAL_CONST(151.367F),
   REAL_CONST(130.371F),
   REAL_CONST(132.080F),
   REAL_CONST(-179.443F),
   REAL_CONST(47.3633F),
   REAL_CONST(173.584F),
   REAL_CONST(73.2422F),
   REAL_CONST(-65.4297F),
   REAL_CONST(-210.693F),
   REAL_CONST(226.074F),
   REAL_CONST(187.744F),
   REAL_CONST(-172.852F),
   REAL_CONST(-104.492F),
   REAL_CONST(123.535F),
   REAL_CONST(42.4805F),
   REAL_CONST(-217.773F),
   REAL_CONST(-153.809F),
   REAL_CONST(106.201F),
   REAL_CONST(133.545F),
   REAL_CONST(-350.342F),
   REAL_CONST(-62.9883F),
   REAL_CONST(151.611F),
   REAL_CONST(114.990F),
   REAL_CONST(-248.535F),
   REAL_CONST(-333.984F),
   REAL_CONST(-95.9473F),
   REAL_CONST(127.197F),
   REAL_CONST(-224.609F),
   REAL_CONST(-167.480F),
   REAL_CONST(-6.10352F),
   REAL_CONST(4.88281F),
   REAL_CONST(-239.746F),
   REAL_CONST(-282.227F),
   REAL_CONST(83.0078F),
   REAL_CONST(2.19727F),
   REAL_CONST(-380.371F),
   REAL_CONST(-277.100F),
   REAL_CONST(-85.9375F),
   REAL_CONST(11.7188F),
   REAL_CONST(-385.498F),
   REAL_CONST(-98.1445F),
   REAL_CONST(-216.553F),
   REAL_CONST(1.46484F),
   REAL_CONST(-282.227F),
   REAL_CONST(-216.797F),
   REAL_CONST(-133.789F),
   REAL_CONST(-85.9375F),
   REAL_CONST(-401.123F),
   REAL_CONST(-285.156F),
   REAL_CONST(-38.8184F),
   REAL_CONST(148.926F),
   REAL_CONST(-494.141F),
   REAL_CONST(-235.107F),
   REAL_CONST(-54.9316F),
   REAL_CONST(47.1191F),
   REAL_CONST(-404.297F),
   REAL_CONST(-478.516F),
   REAL_CONST(-59.8145F),
   REAL_CONST(-120.361F),
   REAL_CONST(-235.352F),
   REAL_CONST(-410.156F),
   REAL_CONST(-228.516F),
   REAL_CONST(-155.029F),
   REAL_CONST(-317.139F),
   REAL_CONST(-425.781F),
   REAL_CONST(-338.867F),
   REAL_CONST(-147.461F),
   REAL_CONST(-375.977F),
   REAL_CONST(-203.857F),
   REAL_CONST(-341.064F),
   REAL_CONST(-32.9590F),
   REAL_CONST(-387.695F),
   REAL_CONST(-70.8008F),
   REAL_CONST(-407.715F),
   REAL_CONST(-173.828F),
   REAL_CONST(-490.967F),
   REAL_CONST(-398.438F),
   REAL_CONST(-406.006F),
   REAL_CONST(-6.59180F),
   REAL_CONST(-551.270F),
   REAL_CONST(-197.998F),
   REAL_CONST(-282.471F),
   REAL_CONST(44.9219F),
   REAL_CONST(-308.838F),
   REAL_CONST(46.1426F),
   REAL_CONST(-333.740F),
   REAL_CONST(143.066F),
   REAL_CONST(-490.967F),
   REAL_CONST(49.0723F),
   REAL_CONST(-192.871F),
   REAL_CONST(173.828F),
   REAL_CONST(-295.410F),
   REAL_CONST(0.732422F),
   REAL_CONST(-252.197F),
   REAL_CONST(197.266F),
   REAL_CONST(-305.420F),
   REAL_CONST(202.637F),
   REAL_CONST(-27.0996F),
   REAL_CONST(155.029F),
   REAL_CONST(-399.414F),
   REAL_CONST(109.131F),
   REAL_CONST(-113.037F),
   REAL_CONST(-231.689F),
   REAL_CONST(-108.643F),
   REAL_CONST(-226.563F),
   REAL_CONST(-123.047F),
   REAL_CONST(-283.691F),
   REAL_CONST(-122.314F),
   REAL_CONST(-295.654F),
   REAL_CONST(35.1563F),
   REAL_CONST(-85.6934F),
   REAL_CONST(-90.8203F),
   REAL_CONST(-256.836F),
   REAL_CONST(-69.0918F),
   REAL_CONST(-258.545F),
   REAL_CONST(-68.1152F),
   REAL_CONST(-274.170F),
   REAL_CONST(-140.381F),
   REAL_CONST(-351.074F),
   REAL_CONST(-143.311F),
   REAL_CONST(-394.043F),
   REAL_CONST(-228.271F),
   REAL_CONST(-240.234F),
   REAL_CONST(55.9082F),
   REAL_CONST(168.457F),
   REAL_CONST(-224.854F),
   REAL_CONST(-175.537F),
   REAL_CONST(-98.3887F),
   REAL_CONST(332.520F),
   REAL_CONST(-167.236F),
   REAL_CONST(-113.525F),
   REAL_CONST(213.379F),
   REAL_CONST(96.9238F),
   REAL_CONST(-124.268F),
   REAL_CONST(-11.2305F),
   REAL_CONST(77.3926F),
   REAL_CONST(325.684F),
   REAL_CONST(-118.408F),
   REAL_CONST(111.328F),
   REAL_CONST(198.486F),
   REAL_CONST(107.178F),
   REAL_CONST(-100.342F),
   REAL_CONST(82.7637F),
   REAL_CONST(219.238F),
   REAL_CONST(260.498F),
   REAL_CONST(-103.760F),
   REAL_CONST(11.2305F),
   REAL_CONST(351.807F),
   REAL_CONST(121.338F),
   REAL_CONST(-221.924F),
   REAL_CONST(-195.313F),
   REAL_CONST(357.666F),
   REAL_CONST(255.371F),
   REAL_CONST(-62.0117F),
   REAL_CONST(-78.3691F),
   REAL_CONST(349.121F),
   REAL_CONST(284.424F),
   REAL_CONST(16.6016F),
   REAL_CONST(85.4492F),
   REAL_CONST(252.441F),
   REAL_CONST(162.598F),
   REAL_CONST(90.3320F),
   REAL_CONST(2.68555F),
   REAL_CONST(320.068F),
   REAL_CONST(192.871F),
   REAL_CONST(34.9121F),
   REAL_CONST(56.6406F),
   REAL_CONST(254.150F),
   REAL_CONST(381.348F),
   REAL_CONST(-27.8320F),
   REAL_CONST(161.865F),
   REAL_CONST(394.531F),
   REAL_CONST(263.184F),
   REAL_CONST(110.840F),
   REAL_CONST(141.357F),
   REAL_CONST(311.279F),
   REAL_CONST(253.906F),
   REAL_CONST(-18.5547F),
   REAL_CONST(221.924F),
   REAL_CONST(183.594F),
   REAL_CONST(260.498F),
   REAL_CONST(37.3535F),
   REAL_CONST(125.000F),
   REAL_CONST(84.9609F),
   REAL_CONST(296.387F),
   REAL_CONST(149.902F),
   REAL_CONST(93.9941F),
   REAL_CONST(449.951F),
   REAL_CONST(197.266F),
   REAL_CONST(65.6738F),
   REAL_CONST(252.441F),
   REAL_CONST(49.5605F),
   REAL_CONST(265.137F),
   REAL_CONST(159.180F),
   REAL_CONST(248.291F),
   REAL_CONST(435.303F),
   REAL_CONST(275.879F),
   REAL_CONST(104.736F),
   REAL_CONST(323.975F),
   REAL_CONST(94.4824F),
   REAL_CONST(337.891F),
   REAL_CONST(-11.9629F),
   REAL_CONST(288.818F),
   REAL_CONST(-17.5781F),
   REAL_CONST(296.631F),
   REAL_CONST(-101.563F),
   REAL_CONST(244.385F),
   REAL_CONST(132.813F),
   REAL_CONST(427.002F),
   REAL_CONST(-85.9375F),
   REAL_CONST(298.584F),
   REAL_CONST(-122.559F),
   REAL_CONST(292.725F),
   REAL_CONST(-143.799F),
   REAL_CONST(138.916F),
   REAL_CONST(-55.4199F),
   REAL_CONST(397.949F),
   REAL_CONST(-34.6680F),
   REAL_CONST(385.254F),
   REAL_CONST(-56.1523F),
   REAL_CONST(418.701F),
   REAL_CONST(-174.316F),
   REAL_CONST(314.453F),
   REAL_CONST(-204.590F),
   REAL_CONST(341.309F),
   REAL_CONST(276.123F),
   REAL_CONST(331.299F),
   REAL_CONST(-50.7813F),
   REAL_CONST(300.781F),
   REAL_CONST(106.689F),
   REAL_CONST(235.596F),
   REAL_CONST(-226.807F),
   REAL_CONST(199.707F),
   REAL_CONST(197.998F),
   REAL_CONST(344.238F),
   REAL_CONST(209.717F),
   REAL_CONST(367.920F),
   REAL_CONST(40.0391F),
   REAL_CONST(295.898F),
   REAL_CONST(338.623F),
   REAL_CONST(437.744F),
   REAL_CONST(118.164F),
   REAL_CONST(457.520F),
   REAL_CONST(111.328F),
   REAL_CONST(503.662F),
   REAL_CONST(243.164F),
   REAL_CONST(285.645F),
   REAL_CONST(323.730F),
   REAL_CONST(342.285F),
   REAL_CONST(321.289F),
   REAL_CONST(332.031F),
   REAL_CONST(277.100F),
   REAL_CONST(308.105F),
   REAL_CONST(301.270F),
   REAL_CONST(395.020F),
   REAL_CONST(332.275F),
   REAL_CONST(431.641F),
   REAL_CONST(346.924F),
   REAL_CONST(299.561F),
   REAL_CONST(386.719F),
   REAL_CONST(328.857F),
   REAL_CONST(208.496F),
   REAL_CONST(164.063F),
   REAL_CONST(411.377F),
   REAL_CONST(382.324F),
   REAL_CONST(278.076F),
   REAL_CONST(310.059F),
   REAL_CONST(492.188F),
   REAL_CONST(445.557F),
   REAL_CONST(432.861F),
   REAL_CONST(385.986F),
   REAL_CONST(374.023F),
   REAL_CONST(356.445F),
   REAL_CONST(363.037F),
   REAL_CONST(230.957F),
   REAL_CONST(405.029F),
   REAL_CONST(249.268F),
   REAL_CONST(425.781F),
   REAL_CONST(295.898F),
   REAL_CONST(339.844F),
   REAL_CONST(238.525F),
   REAL_CONST(432.617F),
   REAL_CONST(283.447F),
   REAL_CONST(445.801F),
   REAL_CONST(284.180F),
   REAL_CONST(419.434F),
   REAL_CONST(348.877F),
   REAL_CONST(481.689F),
   REAL_CONST(388.428F),
   REAL_CONST(289.307F),
   REAL_CONST(210.938F),
   REAL_CONST(520.508F),
   REAL_CONST(259.033F),
   REAL_CONST(439.209F),
   REAL_CONST(198.730F),
   REAL_CONST(448.730F),
   REAL_CONST(184.814F),
   REAL_CONST(513.672F),
   REAL_CONST(321.045F),
   REAL_CONST(501.465F),
   REAL_CONST(307.129F),
   REAL_CONST(515.869F),
   REAL_CONST(223.389F),
   REAL_CONST(569.092F),
   REAL_CONST(227.051F),
   REAL_CONST(358.154F),
   REAL_CONST(280.029F),
   REAL_CONST(632.324F),
   REAL_CONST(351.318F),
   REAL_CONST(548.096F),
   REAL_CONST(425.781F),
   REAL_CONST(510.254F),
   REAL_CONST(395.508F),
   REAL_CONST(575.684F),
   REAL_CONST(354.980F),
   REAL_CONST(650.879F),
   REAL_CONST(367.676F),
   REAL_CONST(458.008F),
   REAL_CONST(448.486F),
   REAL_CONST(505.371F),
   REAL_CONST(482.178F),
   REAL_CONST(424.561F),
   REAL_CONST(385.010F),
   REAL_CONST(166.504F),
   REAL_CONST(314.697F),
   REAL_CONST(386.719F),
   REAL_CONST(499.268F),
   REAL_CONST(354.980F),
   REAL_CONST(512.207F),
   REAL_CONST(609.863F),
   REAL_CONST(489.258F),
   REAL_CONST(661.865F),
   REAL_CONST(504.395F),
   REAL_CONST(177.246F),
   REAL_CONST(387.695F),
   REAL_CONST(672.852F),
   REAL_CONST(570.313F),
   REAL_CONST(55.6641F),
   REAL_CONST(206.787F),
   REAL_CONST(599.609F),
   REAL_CONST(405.029F),
   REAL_CONST(8.78906F),
   REAL_CONST(73.4863F),
   REAL_CONST(474.121F),
   REAL_CONST(477.783F),
   REAL_CONST(-108.887F),
   REAL_CONST(-23.4375F),
   REAL_CONST(525.879F),
   REAL_CONST(340.820F),
   REAL_CONST(374.268F),
   REAL_CONST(268.799F),
   REAL_CONST(3.41797F),
   REAL_CONST(148.438F),
   REAL_CONST(-225.342F),
   REAL_CONST(-178.711F),
   REAL_CONST(337.646F),
   REAL_CONST(483.887F),
   REAL_CONST(328.369F),
   REAL_CONST(232.422F),
   REAL_CONST(-166.016F),
   REAL_CONST(78.3691F),
   REAL_CONST(312.744F),
   REAL_CONST(309.570F),
   REAL_CONST(-389.160F),
   REAL_CONST(89.1113F),
   REAL_CONST(229.736F),
   REAL_CONST(230.957F),
   REAL_CONST(-424.072F),
   REAL_CONST(-200.684F),
   REAL_CONST(579.590F),
   REAL_CONST(680.420F),
   REAL_CONST(444.580F),
   REAL_CONST(680.664F)
};

static const real_32_t dico3_lsf_5[DICO3_SIZE_5 * 4] =
{
   REAL_CONST(-442.383F),
   REAL_CONST(-555.420F),
   REAL_CONST(-458.740F),
   REAL_CONST(-619.385F),
   REAL_CONST(-400.391F),
   REAL_CONST(-451.172F),
   REAL_CONST(-413.818F),
   REAL_CONST(-489.258F),
   REAL_CONST(-297.852F),
   REAL_CONST(-466.797F),
   REAL_CONST(-298.096F),
   REAL_CONST(-514.160F),
   REAL_CONST(-380.615F),
   REAL_CONST(-387.695F),
   REAL_CONST(-384.033F),
   REAL_CONST(-379.883F),
   REAL_CONST(-291.748F),
   REAL_CONST(-394.287F),
   REAL_CONST(-298.828F),
   REAL_CONST(-421.631F),
   REAL_CONST(-331.787F),
   REAL_CONST(-281.006F),
   REAL_CONST(-394.531F),
   REAL_CONST(-475.586F),
   REAL_CONST(-311.035F),
   REAL_CONST(-339.600F),
   REAL_CONST(-318.604F),
   REAL_CONST(-342.529F),
   REAL_CONST(-392.334F),
   REAL_CONST(-287.842F),
   REAL_CONST(-409.180F),
   REAL_CONST(-320.068F),
   REAL_CONST(-352.295F),
   REAL_CONST(-360.840F),
   REAL_CONST(-333.740F),
   REAL_CONST(-219.238F),
   REAL_CONST(-306.641F),
   REAL_CONST(-258.545F),
   REAL_CONST(-324.951F),
   REAL_CONST(-276.855F),
   REAL_CONST(-239.746F),
   REAL_CONST(-276.611F),
   REAL_CONST(-280.518F),
   REAL_CONST(-367.188F),
   REAL_CONST(-263.672F),
   REAL_CONST(-319.336F),
   REAL_CONST(-249.023F),
   REAL_CONST(-288.818F),
   REAL_CONST(-239.258F),
   REAL_CONST(-362.793F),
   REAL_CONST(-236.084F),
   REAL_CONST(-364.990F),
   REAL_CONST(-241.211F),
   REAL_CONST(-225.098F),
   REAL_CONST(-255.615F),
   REAL_CONST(-262.939F),
   REAL_CONST(-204.590F),
   REAL_CONST(-287.842F),
   REAL_CONST(-209.473F),
   REAL_CONST(-298.340F),
   REAL_CONST(-276.123F),
   REAL_CONST(-254.150F),
   REAL_CONST(-259.766F),
   REAL_CONST(-187.256F),
   REAL_CONST(-212.891F),
   REAL_CONST(-282.471F),
   REAL_CONST(-171.143F),
   REAL_CONST(-214.844F),
   REAL_CONST(-172.363F),
   REAL_CONST(-221.191F),
   REAL_CONST(-188.965F),
   REAL_CONST(-248.047F),
   REAL_CONST(-141.113F),
   REAL_CONST(-263.672F),
   REAL_CONST(-195.557F),
   REAL_CONST(-360.840F),
   REAL_CONST(-144.287F),
   REAL_CONST(-271.240F),
   REAL_CONST(-144.531F),
   REAL_CONST(-279.785F),
   REAL_CONST(-174.072F),
   REAL_CONST(-338.867F),
   REAL_CONST(-156.250F),
   REAL_CONST(-335.938F),
   REAL_CONST(-145.752F),
   REAL_CONST(-258.545F),
   REAL_CONST(-101.563F),
   REAL_CONST(-220.459F),
   REAL_CONST(-167.480F),
   REAL_CONST(-203.125F),
   REAL_CONST(-161.377F),
   REAL_CONST(-172.852F),
   REAL_CONST(-108.398F),
   REAL_CONST(-211.914F),
   REAL_CONST(-119.629F),
   REAL_CONST(-224.854F),
   REAL_CONST(-91.3086F),
   REAL_CONST(-189.453F),
   REAL_CONST(-151.123F),
   REAL_CONST(-285.645F),
   REAL_CONST(-142.822F),
   REAL_CONST(-134.033F),
   REAL_CONST(-187.744F),
   REAL_CONST(-194.092F),
   REAL_CONST(-106.201F),
   REAL_CONST(-160.889F),
   REAL_CONST(-129.395F),
   REAL_CONST(-180.908F),
   REAL_CONST(-121.582F),
   REAL_CONST(-204.346F),
   REAL_CONST(-87.1582F),
   REAL_CONST(-145.752F),
   REAL_CONST(-68.1152F),
   REAL_CONST(-212.646F),
   REAL_CONST(-59.3262F),
   REAL_CONST(-216.553F),
   REAL_CONST(-68.8477F),
   REAL_CONST(-162.354F),
   REAL_CONST(-68.3594F),
   REAL_CONST(-162.842F),
   REAL_CONST(-40.2832F),
   REAL_CONST(-136.719F),
   REAL_CONST(-96.1914F),
   REAL_CONST(-220.459F),
   REAL_CONST(-88.3789F),
   REAL_CONST(-100.098F),
   REAL_CONST(-109.375F),
   REAL_CONST(-142.334F),
   REAL_CONST(-99.8535F),
   REAL_CONST(-140.137F),
   REAL_CONST(-76.4160F),
   REAL_CONST(-87.1582F),
   REAL_CONST(-155.518F),
   REAL_CONST(-133.789F),
   REAL_CONST(-139.160F),
   REAL_CONST(-106.445F),
   REAL_CONST(-218.750F),
   REAL_CONST(-123.047F),
   REAL_CONST(-93.2617F),
   REAL_CONST(-184.814F),
   REAL_CONST(-14.1602F),
   REAL_CONST(-117.432F),
   REAL_CONST(-40.2832F),
   REAL_CONST(-150.879F),
   REAL_CONST(-46.6309F),
   REAL_CONST(-91.3086F),
   REAL_CONST(-57.1289F),
   REAL_CONST(-93.2617F),
   REAL_CONST(-54.1992F),
   REAL_CONST(-166.748F),
   REAL_CONST(-6.10352F),
   REAL_CONST(-117.188F),
   REAL_CONST(-102.051F),
   REAL_CONST(-87.6465F),
   REAL_CONST(-178.223F),
   REAL_CONST(-86.1816F),
   REAL_CONST(-79.1016F),
   REAL_CONST(-38.3301F),
   REAL_CONST(-105.469F),
   REAL_CONST(-78.6133F),
   REAL_CONST(-96.1914F),
   REAL_CONST(-73.9746F),
   REAL_CONST(-69.3359F),
   REAL_CONST(-25.3906F),
   REAL_CONST(-146.729F),
   REAL_CONST(-70.5566F),
   REAL_CONST(-135.742F),
   REAL_CONST(-47.8516F),
   REAL_CONST(-143.555F),
   REAL_CONST(-36.6211F),
   REAL_CONST(-160.889F),
   REAL_CONST(-148.438F),
   REAL_CONST(-115.479F),
   REAL_CONST(-5.85938F),
   REAL_CONST(-16.6016F),
   REAL_CONST(-109.375F),
   REAL_CONST(-115.723F),
   REAL_CONST(-1.95313F),
   REAL_CONST(-123.535F),
   REAL_CONST(-10.9863F),
   REAL_CONST(-182.617F),
   REAL_CONST(-44.9219F),
   REAL_CONST(-206.055F),
   REAL_CONST(-61.5234F),
   REAL_CONST(-219.971F),
   REAL_CONST(-22.2168F),
   REAL_CONST(-142.578F),
   REAL_CONST(-23.6816F),
   REAL_CONST(-159.180F),
   REAL_CONST(33.6914F),
   REAL_CONST(-186.523F),
   REAL_CONST(-31.9824F),
   REAL_CONST(-165.527F),
   REAL_CONST(-2.92969F),
   REAL_CONST(-163.574F),
   REAL_CONST(40.2832F),
   REAL_CONST(-63.2324F),
   REAL_CONST(-0.732422F),
   REAL_CONST(-205.078F),
   REAL_CONST(-26.1230F),
   REAL_CONST(-221.924F),
   REAL_CONST(9.03320F),
   REAL_CONST(-242.188F),
   REAL_CONST(10.7422F),
   REAL_CONST(-208.496F),
   REAL_CONST(-101.318F),
   REAL_CONST(-204.834F),
   REAL_CONST(3.17383F),
   REAL_CONST(-244.385F),
   REAL_CONST(-66.1621F),
   REAL_CONST(-250.488F),
   REAL_CONST(-75.4395F),
   REAL_CONST(-194.824F),
   REAL_CONST(-116.699F),
   REAL_CONST(-203.125F),
   REAL_CONST(-119.141F),
   REAL_CONST(-230.225F),
   REAL_CONST(41.0156F),
   REAL_CONST(-271.484F),
   REAL_CONST(-94.4824F),
   REAL_CONST(-289.307F),
   REAL_CONST(-24.6582F),
   REAL_CONST(-288.818F),
   REAL_CONST(-9.76563F),
   REAL_CONST(-229.736F),
   REAL_CONST(-77.1484F),
   REAL_CONST(-251.465F),
   REAL_CONST(-187.988F),
   REAL_CONST(-254.883F),
   REAL_CONST(-152.588F),
   REAL_CONST(-263.916F),
   REAL_CONST(-131.348F),
   REAL_CONST(-298.828F),
   REAL_CONST(-72.9980F),
   REAL_CONST(-320.313F),
   REAL_CONST(-106.445F),
   REAL_CONST(-292.236F),
   REAL_CONST(-161.865F),
   REAL_CONST(-284.912F),
   REAL_CONST(-39.3066F),
   REAL_CONST(-296.875F),
   REAL_CONST(-168.457F),
   REAL_CONST(-302.002F),
   REAL_CONST(-202.881F),
   REAL_CONST(-349.609F),
   REAL_CONST(-175.781F),
   REAL_CONST(-342.529F),
   REAL_CONST(-120.361F),
   REAL_CONST(-219.238F),
   REAL_CONST(-180.664F),
   REAL_CONST(-225.098F),
   REAL_CONST(-195.557F),
   REAL_CONST(-269.043F),
   REAL_CONST(-98.1445F),
   REAL_CONST(-385.498F),
   REAL_CONST(-235.352F),
   REAL_CONST(-259.033F),
   REAL_CONST(-155.762F),
   REAL_CONST(-309.814F),
   REAL_CONST(-351.074F),
   REAL_CONST(-365.967F),
   REAL_CONST(-228.027F),
   REAL_CONST(-366.699F),
   REAL_CONST(-218.506F),
   REAL_CONST(-390.137F),
   REAL_CONST(-137.695F),
   REAL_CONST(-420.654F),
   REAL_CONST(-175.049F),
   REAL_CONST(-147.949F),
   REAL_CONST(-145.752F),
   REAL_CONST(-284.668F),
   REAL_CONST(-264.893F),
   REAL_CONST(-334.229F),
   REAL_CONST(-114.258F),
   REAL_CONST(-475.098F),
   REAL_CONST(-364.502F),
   REAL_CONST(-448.730F),
   REAL_CONST(-232.666F),
   REAL_CONST(-471.680F),
   REAL_CONST(-227.295F),
   REAL_CONST(-365.967F),
   REAL_CONST(-45.8984F),
   REAL_CONST(-399.170F),
   REAL_CONST(-102.783F),
   REAL_CONST(-355.713F),
   REAL_CONST(-82.5195F),
   REAL_CONST(-353.516F),
   REAL_CONST(-5.37109F),
   REAL_CONST(-474.121F),
   REAL_CONST(-103.027F),
   REAL_CONST(-489.746F),
   REAL_CONST(-60.7910F),
   REAL_CONST(-121.094F),
   REAL_CONST(-27.8320F),
   REAL_CONST(-466.309F),
   REAL_CONST(-184.326F),
   REAL_CONST(-314.697F),
   REAL_CONST(42.4805F),
   REAL_CONST(-354.248F),
   REAL_CONST(-26.6113F),
   REAL_CONST(-117.676F),
   REAL_CONST(-62.7441F),
   REAL_CONST(-298.096F),
   REAL_CONST(-124.023F),
   REAL_CONST(-394.775F),
   REAL_CONST(36.8652F),
   REAL_CONST(-413.574F),
   REAL_CONST(50.7813F),
   REAL_CONST(-159.668F),
   REAL_CONST(26.1230F),
   REAL_CONST(-403.076F),
   REAL_CONST(7.08008F),
   REAL_CONST(-278.564F),
   REAL_CONST(68.1152F),
   REAL_CONST(-296.631F),
   REAL_CONST(74.7070F),
   REAL_CONST(-299.805F),
   REAL_CONST(-123.535F),
   REAL_CONST(-178.223F),
   REAL_CONST(-42.7246F),
   REAL_CONST(-301.758F),
   REAL_CONST(-24.6582F),
   REAL_CONST(-236.572F),
   REAL_CONST(134.521F),
   REAL_CONST(-212.402F),
   REAL_CONST(67.8711F),
   REAL_CONST(-200.928F),
   REAL_CONST(76.9043F),
   REAL_CONST(-137.451F),
   REAL_CONST(91.7969F),
   REAL_CONST(-256.592F),
   REAL_CONST(55.6641F),
   REAL_CONST(-123.779F),
   REAL_CONST(68.3594F),
   REAL_CONST(-146.240F),
   REAL_CONST(68.6035F),
   REAL_CONST(-185.059F),
   REAL_CONST(61.7676F),
   REAL_CONST(-74.4629F),
   REAL_CONST(92.5293F),
   REAL_CONST(-184.326F),
   REAL_CONST(-32.7148F),
   REAL_CONST(-149.170F),
   REAL_CONST(161.133F),
   REAL_CONST(-201.172F),
   REAL_CONST(130.859F),
   REAL_CONST(-199.463F),
   REAL_CONST(157.715F),
   REAL_CONST(-100.830F),
   REAL_CONST(11.9629F),
   REAL_CONST(-83.2520F),
   REAL_CONST(43.2129F),
   REAL_CONST(-110.596F),
   REAL_CONST(128.418F),
   REAL_CONST(-117.676F),
   REAL_CONST(143.799F),
   REAL_CONST(-17.3340F),
   REAL_CONST(82.7637F),
   REAL_CONST(-160.400F),
   REAL_CONST(64.4531F),
   REAL_CONST(-59.5703F),
   REAL_CONST(72.0215F),
   REAL_CONST(-57.8613F),
   REAL_CONST(76.9043F),
   REAL_CONST(-94.4824F),
   REAL_CONST(138.916F),
   REAL_CONST(-123.535F),
   REAL_CONST(-2.19727F),
   REAL_CONST(-92.0410F),
   REAL_CONST(3.41797F),
   REAL_CONST(-39.0625F),
   REAL_CONST(161.377F),
   REAL_CONST(-52.7344F),
   REAL_CONST(9.76563F),
   REAL_CONST(-75.1953F),
   REAL_CONST(-11.2305F),
   REAL_CONST(23.1934F),
   REAL_CONST(52.2461F),
   REAL_CONST(-59.0820F),
   REAL_CONST(40.7715F),
   REAL_CONST(-20.9961F),
   REAL_CONST(46.8750F),
   REAL_CONST(-13.6719F),
   REAL_CONST(6.59180F),
   REAL_CONST(-18.5547F),
   REAL_CONST(7.56836F),
   REAL_CONST(8.78906F),
   REAL_CONST(75.4395F),
   REAL_CONST(-25.8789F),
   REAL_CONST(-44.4336F),
   REAL_CONST(-27.5879F),
   REAL_CONST(18.0664F),
   REAL_CONST(-107.666F),
   REAL_CONST(-5.37109F),
   REAL_CONST(5.61523F),
   REAL_CONST(33.9355F),
   REAL_CONST(19.7754F),
   REAL_CONST(-2.68555F),
   REAL_CONST(10.7422F),
   REAL_CONST(3.66211F),
   REAL_CONST(-21.2402F),
   REAL_CONST(-33.4473F),
   REAL_CONST(-28.8086F),
   REAL_CONST(-50.5371F),
   REAL_CONST(-38.5742F),
   REAL_CONST(-14.1602F),
   REAL_CONST(66.4063F),
   REAL_CONST(-22.4609F),
   REAL_CONST(-38.0859F),
   REAL_CONST(-107.666F),
   REAL_CONST(1.95313F),
   REAL_CONST(-33.2031F),
   REAL_CONST(31.2500F),
   REAL_CONST(-53.9551F),
   REAL_CONST(24.6582F),
   REAL_CONST(-53.2227F),
   REAL_CONST(9.76563F),
   REAL_CONST(-48.0957F),
   REAL_CONST(-18.5547F),
   REAL_CONST(-111.328F),
   REAL_CONST(2.19727F),
   REAL_CONST(-108.643F),
   REAL_CONST(8.05664F),
   REAL_CONST(-103.271F),
   REAL_CONST(55.1758F),
   REAL_CONST(14.6484F),
   REAL_CONST(17.8223F),
   REAL_CONST(-54.1992F),
   REAL_CONST(38.0859F),
   REAL_CONST(-97.4121F),
   REAL_CONST(68.3594F),
   REAL_CONST(-77.6367F),
   REAL_CONST(59.8145F),
   REAL_CONST(-83.2520F),
   REAL_CONST(40.5273F),
   REAL_CONST(-121.826F),
   REAL_CONST(82.7637F),
   REAL_CONST(-46.3867F),
   REAL_CONST(79.8340F),
   REAL_CONST(-53.4668F),
   REAL_CONST(79.3457F),
   REAL_CONST(-33.4473F),
   REAL_CONST(-21.7285F),
   REAL_CONST(-145.508F),
   REAL_CONST(24.4141F),
   REAL_CONST(-153.076F),
   REAL_CONST(35.1563F),
   REAL_CONST(-165.283F),
   REAL_CONST(118.896F),
   REAL_CONST(6.83594F),
   REAL_CONST(61.5234F),
   REAL_CONST(-95.4590F),
   REAL_CONST(52.2461F),
   REAL_CONST(-10.0098F),
   REAL_CONST(68.8477F),
   REAL_CONST(-6.83594F),
   REAL_CONST(24.1699F),
   REAL_CONST(-69.8242F),
   REAL_CONST(80.8105F),
   REAL_CONST(11.9629F),
   REAL_CONST(112.061F),
   REAL_CONST(-94.7266F),
   REAL_CONST(137.939F),
   REAL_CONST(-90.0879F),
   REAL_CONST(106.445F),
   REAL_CONST(6.83594F),
   REAL_CONST(82.0313F),
   REAL_CONST(-2.19727F),
   REAL_CONST(96.9238F),
   REAL_CONST(-40.7715F),
   REAL_CONST(150.879F),
   REAL_CONST(8.30078F),
   REAL_CONST(145.508F),
   REAL_CONST(-4.15039F),
   REAL_CONST(136.963F),
   REAL_CONST(-34.1797F),
   REAL_CONST(72.9980F),
   REAL_CONST(19.2871F),
   REAL_CONST(127.441F),
   REAL_CONST(30.5176F),
   REAL_CONST(49.5605F),
   REAL_CONST(0.488281F),
   REAL_CONST(59.5703F),
   REAL_CONST(70.3125F),
   REAL_CONST(62.2559F),
   REAL_CONST(51.5137F),
   REAL_CONST(42.7246F),
   REAL_CONST(20.0195F),
   REAL_CONST(145.508F),
   REAL_CONST(45.6543F),
   REAL_CONST(126.221F),
   REAL_CONST(26.3672F),
   REAL_CONST(93.0176F),
   REAL_CONST(62.2559F),
   REAL_CONST(89.1113F),
   REAL_CONST(72.5098F),
   REAL_CONST(121.338F),
   REAL_CONST(85.9375F),
   REAL_CONST(79.8340F),
   REAL_CONST(-20.0195F),
   REAL_CONST(6.10352F),
   REAL_CONST(51.2695F),
   REAL_CONST(90.5762F),
   REAL_CONST(59.8145F),
   REAL_CONST(63.7207F),
   REAL_CONST(0.732422F),
   REAL_CONST(133.057F),
   REAL_CONST(109.619F),
   REAL_CONST(34.1797F),
   REAL_CONST(71.7773F),
   REAL_CONST(10.7422F),
   REAL_CONST(72.0215F),
   REAL_CONST(51.7578F),
   REAL_CONST(84.7168F),
   REAL_CONST(59.5703F),
   REAL_CONST(120.605F),
   REAL_CONST(80.8105F),
   REAL_CONST(128.906F),
   REAL_CONST(49.0723F),
   REAL_CONST(74.9512F),
   REAL_CONST(85.2051F),
   REAL_CONST(100.342F),
   REAL_CONST(149.658F),
   REAL_CONST(69.3359F),
   REAL_CONST(149.902F),
   REAL_CONST(100.830F),
   REAL_CONST(113.281F),
   REAL_CONST(78.6133F),
   REAL_CONST(152.344F),
   REAL_CONST(96.9238F),
   REAL_CONST(23.6816F),
   REAL_CONST(48.8281F),
   REAL_CONST(-39.0625F),
   REAL_CONST(93.7500F),
   REAL_CONST(36.3770F),
   REAL_CONST(88.3789F),
   REAL_CONST(120.850F),
   REAL_CONST(128.174F),
   REAL_CONST(65.6738F),
   REAL_CONST(142.822F),
   REAL_CONST(8.05664F),
   REAL_CONST(119.873F),
   REAL_CONST(-29.5410F),
   REAL_CONST(105.713F),
   REAL_CONST(104.248F),
   REAL_CONST(149.170F),
   REAL_CONST(121.582F),
   REAL_CONST(125.977F),
   REAL_CONST(41.7480F),
   REAL_CONST(108.154F),
   REAL_CONST(121.338F),
   REAL_CONST(162.598F),
   REAL_CONST(107.422F),
   REAL_CONST(67.1387F),
   REAL_CONST(138.184F),
   REAL_CONST(140.381F),
   REAL_CONST(35.6445F),
   REAL_CONST(156.006F),
   REAL_CONST(37.8418F),
   REAL_CONST(163.574F),
   REAL_CONST(-8.05664F),
   REAL_CONST(42.2363F),
   REAL_CONST(51.7578F),
   REAL_CONST(169.922F),
   REAL_CONST(-40.5273F),
   REAL_CONST(146.729F),
   REAL_CONST(-46.6309F),
   REAL_CONST(169.678F),
   REAL_CONST(-119.385F),
   REAL_CONST(122.803F),
   REAL_CONST(42.7246F),
   REAL_CONST(181.152F),
   REAL_CONST(52.2461F),
   REAL_CONST(116.211F),
   REAL_CONST(90.8203F),
   REAL_CONST(264.404F),
   REAL_CONST(141.113F),
   REAL_CONST(129.395F),
   REAL_CONST(143.066F),
   REAL_CONST(189.697F),
   REAL_CONST(103.760F),
   REAL_CONST(213.379F),
   REAL_CONST(76.9043F),
   REAL_CONST(205.322F),
   REAL_CONST(91.3086F),
   REAL_CONST(207.031F),
   REAL_CONST(-40.2832F),
   REAL_CONST(137.939F),
   REAL_CONST(8.54492F),
   REAL_CONST(241.943F),
   REAL_CONST(-9.52148F),
   REAL_CONST(259.277F),
   REAL_CONST(80.3223F),
   REAL_CONST(173.828F),
   REAL_CONST(191.895F),
   REAL_CONST(205.078F),
   REAL_CONST(157.471F),
   REAL_CONST(194.092F),
   REAL_CONST(161.377F),
   REAL_CONST(165.039F),
   REAL_CONST(139.404F),
   REAL_CONST(224.121F),
   REAL_CONST(154.297F),
   REAL_CONST(263.428F),
   REAL_CONST(164.307F),
   REAL_CONST(199.463F),
   REAL_CONST(77.6367F),
   REAL_CONST(94.7266F),
   REAL_CONST(213.379F),
   REAL_CONST(247.070F),
   REAL_CONST(137.695F),
   REAL_CONST(207.031F),
   REAL_CONST(214.844F),
   REAL_CONST(151.367F),
   REAL_CONST(135.986F),
   REAL_CONST(116.943F),
   REAL_CONST(163.818F),
   REAL_CONST(110.596F),
   REAL_CONST(168.945F),
   REAL_CONST(114.258F),
   REAL_CONST(205.078F),
   REAL_CONST(156.738F),
   REAL_CONST(206.055F),
   REAL_CONST(157.471F),
   REAL_CONST(123.535F),
   REAL_CONST(104.492F),
   REAL_CONST(218.994F),
   REAL_CONST(138.428F),
   REAL_CONST(204.346F),
   REAL_CONST(94.4824F),
   REAL_CONST(234.863F),
   REAL_CONST(121.826F),
   REAL_CONST(168.701F),
   REAL_CONST(136.963F),
   REAL_CONST(229.248F),
   REAL_CONST(226.074F),
   REAL_CONST(191.162F),
   REAL_CONST(72.2656F),
   REAL_CONST(192.871F),
   REAL_CONST(65.4297F),
   REAL_CONST(250.977F),
   REAL_CONST(129.395F),
   REAL_CONST(213.379F),
   REAL_CONST(80.3223F),
   REAL_CONST(133.789F),
   REAL_CONST(34.9121F),
   REAL_CONST(164.795F),
   REAL_CONST(71.0449F),
   REAL_CONST(122.803F),
   REAL_CONST(16.1133F),
   REAL_CONST(254.150F),
   REAL_CONST(87.6465F),
   REAL_CONST(191.895F),
   REAL_CONST(23.6816F),
   REAL_CONST(196.533F),
   REAL_CONST(8.05664F),
   REAL_CONST(204.346F),
   REAL_CONST(114.746F),
   REAL_CONST(124.756F),
   REAL_CONST(11.9629F),
   REAL_CONST(266.602F),
   REAL_CONST(79.8340F),
   REAL_CONST(286.621F),
   REAL_CONST(78.8574F),
   REAL_CONST(0.732422F),
   REAL_CONST(59.0820F),
   REAL_CONST(212.891F),
   REAL_CONST(115.723F),
   REAL_CONST(168.213F),
   REAL_CONST(104.736F),
   REAL_CONST(324.463F),
   REAL_CONST(165.527F),
   REAL_CONST(254.395F),
   REAL_CONST(151.367F),
   REAL_CONST(270.752F),
   REAL_CONST(162.109F),
   REAL_CONST(78.3691F),
   REAL_CONST(47.1191F),
   REAL_CONST(217.041F),
   REAL_CONST(231.934F),
   REAL_CONST(281.494F),
   REAL_CONST(213.379F),
   REAL_CONST(218.018F),
   REAL_CONST(155.029F),
   REAL_CONST(214.111F),
   REAL_CONST(210.449F),
   REAL_CONST(231.445F),
   REAL_CONST(222.900F),
   REAL_CONST(315.674F),
   REAL_CONST(162.354F),
   REAL_CONST(322.266F),
   REAL_CONST(156.006F),
   REAL_CONST(243.408F),
   REAL_CONST(193.604F),
   REAL_CONST(342.285F),
   REAL_CONST(251.465F),
   REAL_CONST(287.109F),
   REAL_CONST(247.070F),
   REAL_CONST(270.996F),
   REAL_CONST(234.131F),
   REAL_CONST(344.238F),
   REAL_CONST(225.830F),
   REAL_CONST(342.529F),
   REAL_CONST(223.389F),
   REAL_CONST(132.568F),
   REAL_CONST(210.449F),
   REAL_CONST(272.461F),
   REAL_CONST(298.340F),
   REAL_CONST(203.857F),
   REAL_CONST(290.527F),
   REAL_CONST(203.857F),
   REAL_CONST(290.527F),
   REAL_CONST(234.131F),
   REAL_CONST(280.273F),
   REAL_CONST(280.029F),
   REAL_CONST(335.938F),
   REAL_CONST(317.383F),
   REAL_CONST(291.260F),
   REAL_CONST(345.459F),
   REAL_CONST(300.537F),
   REAL_CONST(325.928F),
   REAL_CONST(327.393F),
   REAL_CONST(182.129F),
   REAL_CONST(266.602F),
   REAL_CONST(417.725F),
   REAL_CONST(313.232F),
   REAL_CONST(339.111F),
   REAL_CONST(261.963F),
   REAL_CONST(325.684F),
   REAL_CONST(382.324F),
   REAL_CONST(281.494F),
   REAL_CONST(360.107F),
   REAL_CONST(401.611F),
   REAL_CONST(277.588F),
   REAL_CONST(445.557F),
   REAL_CONST(297.852F),
   REAL_CONST(257.813F),
   REAL_CONST(337.402F),
   REAL_CONST(371.338F),
   REAL_CONST(422.363F),
   REAL_CONST(398.438F),
   REAL_CONST(377.197F),
   REAL_CONST(395.508F),
   REAL_CONST(376.465F),
   REAL_CONST(208.740F),
   REAL_CONST(389.648F),
   REAL_CONST(211.182F),
   REAL_CONST(406.982F),
   REAL_CONST(169.189F),
   REAL_CONST(216.064F),
   REAL_CONST(418.945F),
   REAL_CONST(370.850F),
   REAL_CONST(284.912F),
   REAL_CONST(316.406F),
   REAL_CONST(539.307F),
   REAL_CONST(429.688F),
   REAL_CONST(476.563F),
   REAL_CONST(364.502F),
   REAL_CONST(493.164F),
   REAL_CONST(361.816F),
   REAL_CONST(374.512F),
   REAL_CONST(455.566F),
   REAL_CONST(413.574F),
   REAL_CONST(490.234F),
   REAL_CONST(382.324F),
   REAL_CONST(182.617F),
   REAL_CONST(429.932F),
   REAL_CONST(201.416F),
   REAL_CONST(71.7773F),
   REAL_CONST(339.844F),
   REAL_CONST(264.648F),
   REAL_CONST(502.441F),
   REAL_CONST(151.611F),
   REAL_CONST(321.045F),
   REAL_CONST(89.1113F),
   REAL_CONST(314.209F),
   REAL_CONST(48.3398F),
   REAL_CONST(250.977F),
   REAL_CONST(119.141F),
   REAL_CONST(343.750F),
   REAL_CONST(60.7910F),
   REAL_CONST(98.3887F),
   REAL_CONST(247.559F),
   REAL_CONST(381.104F),
   REAL_CONST(79.1016F),
   REAL_CONST(88.6230F),
   REAL_CONST(401.611F),
   REAL_CONST(254.883F),
   REAL_CONST(47.1191F),
   REAL_CONST(89.5996F),
   REAL_CONST(496.582F),
   REAL_CONST(453.857F),
   REAL_CONST(-61.2793F),
   REAL_CONST(141.357F),
   REAL_CONST(183.105F),
   REAL_CONST(242.676F),
   REAL_CONST(-59.3262F),
   REAL_CONST(7.32422F),
   REAL_CONST(323.486F),
   REAL_CONST(214.600F),
   REAL_CONST(-6.83594F),
   REAL_CONST(-41.2598F),
   REAL_CONST(152.344F),
   REAL_CONST(223.877F),
   REAL_CONST(-110.596F),
   REAL_CONST(38.8184F),
   REAL_CONST(45.4102F),
   REAL_CONST(334.473F),
   REAL_CONST(-149.902F),
   REAL_CONST(1.46484F),
   REAL_CONST(131.104F),
   REAL_CONST(95.7031F),
   REAL_CONST(-22.9492F),
   REAL_CONST(-71.0449F),
   REAL_CONST(190.674F),
   REAL_CONST(55.9082F),
   REAL_CONST(-31.2500F),
   REAL_CONST(-72.7539F),
   REAL_CONST(59.8145F),
   REAL_CONST(119.873F),
   REAL_CONST(-171.143F),
   REAL_CONST(-158.203F),
   REAL_CONST(237.305F),
   REAL_CONST(192.627F),
   REAL_CONST(-122.314F),
   REAL_CONST(-156.250F),
   REAL_CONST(43.4570F),
   REAL_CONST(62.2559F),
   REAL_CONST(-89.1113F),
   REAL_CONST(-95.2148F),
   REAL_CONST(-62.2559F),
   REAL_CONST(77.3926F),
   REAL_CONST(-233.887F),
   REAL_CONST(-71.7773F),
   REAL_CONST(-46.6309F),
   REAL_CONST(55.6641F),
   REAL_CONST(-189.209F),
   REAL_CONST(-109.131F),
   REAL_CONST(38.3301F),
   REAL_CONST(-57.8613F),
   REAL_CONST(-160.400F),
   REAL_CONST(-175.781F),
   REAL_CONST(-99.3652F),
   REAL_CONST(22.4609F),
   REAL_CONST(-28.5645F),
   REAL_CONST(-149.170F),
   REAL_CONST(81.5430F),
   REAL_CONST(-56.1523F),
   REAL_CONST(-165.771F),
   REAL_CONST(-264.648F),
   REAL_CONST(-35.1563F),
   REAL_CONST(-77.3926F),
   REAL_CONST(-219.971F),
   REAL_CONST(-210.205F),
   REAL_CONST(-180.176F),
   REAL_CONST(-87.8906F),
   REAL_CONST(-20.7520F),
   REAL_CONST(-177.490F),
   REAL_CONST(-21.9727F),
   REAL_CONST(-192.139F),
   REAL_CONST(24.4141F),
   REAL_CONST(-5.37109F),
   REAL_CONST(-95.4590F),
   REAL_CONST(-64.2090F),
   REAL_CONST(-13.6719F),
   REAL_CONST(-17.8223F),
   REAL_CONST(-82.2754F),
   REAL_CONST(-184.082F),
   REAL_CONST(1.22070F),
   REAL_CONST(-46.1426F),
   REAL_CONST(-172.363F),
   REAL_CONST(-152.344F),
   REAL_CONST(21.7285F),
   REAL_CONST(-83.9844F),
   REAL_CONST(-32.9590F),
   REAL_CONST(-271.729F),
   REAL_CONST(-86.1816F),
   REAL_CONST(-57.8613F),
   REAL_CONST(-166.992F),
   REAL_CONST(-277.100F),
   REAL_CONST(-67.1387F),
   REAL_CONST(-269.043F),
   REAL_CONST(-65.6738F),
   REAL_CONST(-293.701F),
   REAL_CONST(37.1094F),
   REAL_CONST(35.4004F),
   REAL_CONST(-176.270F),
   REAL_CONST(-300.781F),
   REAL_CONST(11.9629F),
   REAL_CONST(19.5313F),
   REAL_CONST(-304.688F),
   REAL_CONST(-189.453F),
   REAL_CONST(-60.5469F),
   REAL_CONST(95.4590F),
   REAL_CONST(-178.711F),
   REAL_CONST(-133.545F),
   REAL_CONST(114.502F),
   REAL_CONST(53.2227F),
   REAL_CONST(-62.2559F),
   REAL_CONST(-210.938F),
   REAL_CONST(16.8457F),
   REAL_CONST(89.3555F),
   REAL_CONST(-40.5273F),
   REAL_CONST(-118.408F),
   REAL_CONST(-167.969F),
   REAL_CONST(46.6309F),
   REAL_CONST(-295.898F),
   REAL_CONST(-291.992F),
   REAL_CONST(-41.5039F),
   REAL_CONST(-41.2598F),
   REAL_CONST(-319.336F),
   REAL_CONST(-398.193F),
   REAL_CONST(78.3691F),
   REAL_CONST(114.746F),
   REAL_CONST(-346.436F),
   REAL_CONST(-303.467F),
   REAL_CONST(-15.6250F),
   REAL_CONST(66.4063F),
   REAL_CONST(-332.275F),
   REAL_CONST(-60.5469F),
   REAL_CONST(120.117F),
   REAL_CONST(137.939F),
   REAL_CONST(-176.025F),
   REAL_CONST(-148.682F),
   REAL_CONST(47.6074F),
   REAL_CONST(118.408F),
   REAL_CONST(-139.893F),
   REAL_CONST(-32.4707F),
   REAL_CONST(104.248F),
   REAL_CONST(49.3164F),
   REAL_CONST(-41.7480F),
   REAL_CONST(-28.8086F),
   REAL_CONST(48.5840F),
   REAL_CONST(140.381F),
   REAL_CONST(0.488281F),
   REAL_CONST(-7.56836F),
   REAL_CONST(169.434F),
   REAL_CONST(184.326F),
   REAL_CONST(-333.496F),
   REAL_CONST(-9.52148F),
   REAL_CONST(134.766F),
   REAL_CONST(135.986F),
   REAL_CONST(-119.385F),
   REAL_CONST(66.1621F),
   REAL_CONST(166.016F),
   REAL_CONST(131.104F),
   REAL_CONST(3.17383F),
   REAL_CONST(-110.596F),
   REAL_CONST(208.740F),
   REAL_CONST(232.910F),
   REAL_CONST(-32.4707F),
   REAL_CONST(-12.6953F),
   REAL_CONST(-19.7754F),
   REAL_CONST(180.176F),
   REAL_CONST(-285.400F),
   REAL_CONST(155.518F),
   REAL_CONST(257.568F),
   REAL_CONST(258.545F),
   REAL_CONST(-23.1934F),
   REAL_CONST(165.039F),
   REAL_CONST(307.373F),
   REAL_CONST(263.916F),
   REAL_CONST(119.385F),
   REAL_CONST(74.4629F),
   REAL_CONST(-109.619F),
   REAL_CONST(232.910F),
   REAL_CONST(-130.371F),
   REAL_CONST(243.164F),
   REAL_CONST(-236.572F),
   REAL_CONST(211.426F),
   REAL_CONST(-258.301F),
   REAL_CONST(258.545F),
   REAL_CONST(-315.918F),
   REAL_CONST(150.879F),
   REAL_CONST(-345.703F),
   REAL_CONST(150.635F),
   REAL_CONST(-111.816F),
   REAL_CONST(333.496F),
   REAL_CONST(-38.8184F),
   REAL_CONST(444.580F),
   REAL_CONST(-188.965F),
   REAL_CONST(-128.906F),
   REAL_CONST(-3.41797F),
   REAL_CONST(270.996F),
   REAL_CONST(-293.457F),
   REAL_CONST(-219.971F),
   REAL_CONST(-188.477F),
   REAL_CONST(105.713F),
   REAL_CONST(-306.641F),
   REAL_CONST(-306.396F),
   REAL_CONST(-246.826F),
   REAL_CONST(-73.7305F),
   REAL_CONST(-146.973F),
   REAL_CONST(-142.822F),
   REAL_CONST(-185.303F),
   REAL_CONST(-395.020F),
   REAL_CONST(-185.547F),
   REAL_CONST(-378.174F),
   REAL_CONST(-205.078F),
   REAL_CONST(-468.994F),
   REAL_CONST(-199.219F),
   REAL_CONST(-131.592F),
   REAL_CONST(-431.885F),
   REAL_CONST(-545.654F),
   REAL_CONST(-55.4199F),
   REAL_CONST(-8.78906F),
   REAL_CONST(-496.582F),
   REAL_CONST(-447.021F),
   REAL_CONST(-514.404F),
   REAL_CONST(-274.902F),
   REAL_CONST(-603.271F),
   REAL_CONST(-443.359F),
   REAL_CONST(-358.887F),
   REAL_CONST(61.5234F),
   REAL_CONST(-659.424F),
   REAL_CONST(-101.318F),
   REAL_CONST(-139.404F),
   REAL_CONST(-114.014F),
   REAL_CONST(368.408F),
   REAL_CONST(379.395F),
   REAL_CONST(532.227F),
   REAL_CONST(482.178F),
   REAL_CONST(567.871F),
   REAL_CONST(493.164F)
};

static const real_32_t dico4_lsf_5[DICO4_SIZE_5 * 4] =
{
   REAL_CONST(-453.369F),
   REAL_CONST(-410.400F),
   REAL_CONST(-453.369F),
   REAL_CONST(-428.467F),
   REAL_CONST(-501.953F),
   REAL_CONST(-280.762F),
   REAL_CONST(-520.996F),
   REAL_CONST(-403.809F),
   REAL_CONST(-395.264F),
   REAL_CONST(-268.311F),
   REAL_CONST(-416.016F),
   REAL_CONST(-276.123F),
   REAL_CONST(-328.369F),
   REAL_CONST(-392.578F),
   REAL_CONST(-331.787F),
   REAL_CONST(-399.902F),
   REAL_CONST(-326.660F),
   REAL_CONST(-315.674F),
   REAL_CONST(-323.486F),
   REAL_CONST(-308.838F),
   REAL_CONST(-406.250F),
   REAL_CONST(-402.588F),
   REAL_CONST(-363.037F),
   REAL_CONST(-207.764F),
   REAL_CONST(-328.613F),
   REAL_CONST(-447.266F),
   REAL_CONST(-344.971F),
   REAL_CONST(-534.180F),
   REAL_CONST(-312.988F),
   REAL_CONST(-166.260F),
   REAL_CONST(-435.791F),
   REAL_CONST(-402.588F),
   REAL_CONST(-235.840F),
   REAL_CONST(-264.160F),
   REAL_CONST(-288.818F),
   REAL_CONST(-409.180F),
   REAL_CONST(-257.324F),
   REAL_CONST(-261.963F),
   REAL_CONST(-278.809F),
   REAL_CONST(-282.715F),
   REAL_CONST(-294.678F),
   REAL_CONST(-181.641F),
   REAL_CONST(-311.035F),
   REAL_CONST(-243.408F),
   REAL_CONST(-228.027F),
   REAL_CONST(-337.646F),
   REAL_CONST(-226.318F),
   REAL_CONST(-345.703F),
   REAL_CONST(-246.582F),
   REAL_CONST(-318.604F),
   REAL_CONST(-191.162F),
   REAL_CONST(-233.154F),
   REAL_CONST(-256.104F),
   REAL_CONST(-219.727F),
   REAL_CONST(-242.432F),
   REAL_CONST(-199.463F),
   REAL_CONST(-179.932F),
   REAL_CONST(-200.928F),
   REAL_CONST(-237.305F),
   REAL_CONST(-290.283F),
   REAL_CONST(-180.176F),
   REAL_CONST(-267.090F),
   REAL_CONST(-180.176F),
   REAL_CONST(-281.738F),
   REAL_CONST(-191.406F),
   REAL_CONST(-195.557F),
   REAL_CONST(-197.754F),
   REAL_CONST(-191.895F),
   REAL_CONST(-217.773F),
   REAL_CONST(-126.953F),
   REAL_CONST(-244.141F),
   REAL_CONST(-199.707F),
   REAL_CONST(-157.227F),
   REAL_CONST(-235.596F),
   REAL_CONST(-140.869F),
   REAL_CONST(-215.332F),
   REAL_CONST(-132.080F),
   REAL_CONST(-169.434F),
   REAL_CONST(-163.818F),
   REAL_CONST(-223.877F),
   REAL_CONST(-145.264F),
   REAL_CONST(-156.738F),
   REAL_CONST(-157.715F),
   REAL_CONST(-150.146F),
   REAL_CONST(-233.398F),
   REAL_CONST(-151.611F),
   REAL_CONST(-225.830F),
   REAL_CONST(-125.732F),
   REAL_CONST(-177.490F),
   REAL_CONST(-117.920F),
   REAL_CONST(-198.975F),
   REAL_CONST(-118.408F),
   REAL_CONST(-205.078F),
   REAL_CONST(-141.113F),
   REAL_CONST(-107.422F),
   REAL_CONST(-174.072F),
   REAL_CONST(-141.113F),
   REAL_CONST(-79.3457F),
   REAL_CONST(-160.400F),
   REAL_CONST(-163.574F),
   REAL_CONST(-94.2383F),
   REAL_CONST(-139.160F),
   REAL_CONST(-107.666F),
   REAL_CONST(-162.598F),
   REAL_CONST(-125.488F),
   REAL_CONST(-192.139F),
   REAL_CONST(-95.7031F),
   REAL_CONST(-129.150F),
   REAL_CONST(-127.441F),
   REAL_CONST(-110.596F),
   REAL_CONST(-118.896F),
   REAL_CONST(-103.271F),
   REAL_CONST(-150.391F),
   REAL_CONST(-142.822F),
   REAL_CONST(-150.635F),
   REAL_CONST(-38.3301F),
   REAL_CONST(-161.621F),
   REAL_CONST(-65.4297F),
   REAL_CONST(-166.016F),
   REAL_CONST(-84.9609F),
   REAL_CONST(-78.6133F),
   REAL_CONST(-78.8574F),
   REAL_CONST(-154.297F),
   REAL_CONST(-108.398F),
   REAL_CONST(-74.2188F),
   REAL_CONST(-104.980F),
   REAL_CONST(-81.0547F),
   REAL_CONST(-111.816F),
   REAL_CONST(-67.6270F),
   REAL_CONST(-114.258F),
   REAL_CONST(-160.889F),
   REAL_CONST(-193.604F),
   REAL_CONST(-77.8809F),
   REAL_CONST(-155.273F),
   REAL_CONST(-55.4199F),
   REAL_CONST(-135.254F),
   REAL_CONST(-91.0645F),
   REAL_CONST(-84.7168F),
   REAL_CONST(-81.5430F),
   REAL_CONST(-51.2695F),
   REAL_CONST(-111.328F),
   REAL_CONST(-46.8750F),
   REAL_CONST(-129.395F),
   REAL_CONST(-59.0820F),
   REAL_CONST(-52.7344F),
   REAL_CONST(-48.3398F),
   REAL_CONST(-89.3555F),
   REAL_CONST(-90.3320F),
   REAL_CONST(-82.5195F),
   REAL_CONST(-39.3066F),
   REAL_CONST(-99.8535F),
   REAL_CONST(-182.617F),
   REAL_CONST(-26.1230F),
   REAL_CONST(-92.7734F),
   REAL_CONST(-71.7773F),
   REAL_CONST(-156.982F),
   REAL_CONST(-54.4434F),
   REAL_CONST(-162.354F),
   REAL_CONST(-57.1289F),
   REAL_CONST(-180.908F),
   REAL_CONST(-34.4238F),
   REAL_CONST(-121.094F),
   REAL_CONST(-31.7383F),
   REAL_CONST(-124.512F),
   REAL_CONST(-33.9355F),
   REAL_CONST(-79.8340F),
   REAL_CONST(-41.9922F),
   REAL_CONST(-74.4629F),
   REAL_CONST(-74.7070F),
   REAL_CONST(-141.602F),
   REAL_CONST(-40.0391F),
   REAL_CONST(-64.2090F),
   REAL_CONST(-63.9648F),
   REAL_CONST(-41.9922F),
   REAL_CONST(-16.3574F),
   REAL_CONST(-98.1445F),
   REAL_CONST(7.56836F),
   REAL_CONST(-89.3555F),
   REAL_CONST(-2.44141F),
   REAL_CONST(-106.445F),
   REAL_CONST(-20.9961F),
   REAL_CONST(-128.662F),
   REAL_CONST(17.3340F),
   REAL_CONST(-92.0410F),
   REAL_CONST(-5.37109F),
   REAL_CONST(-148.682F),
   REAL_CONST(-2.92969F),
   REAL_CONST(-165.527F),
   REAL_CONST(-16.3574F),
   REAL_CONST(-77.8809F),
   REAL_CONST(15.3809F),
   REAL_CONST(-46.6309F),
   REAL_CONST(8.54492F),
   REAL_CONST(-44.1895F),
   REAL_CONST(-9.52148F),
   REAL_CONST(-59.0820F),
   REAL_CONST(30.7617F),
   REAL_CONST(-40.7715F),
   REAL_CONST(-34.1797F),
   REAL_CONST(-132.813F),
   REAL_CONST(37.8418F),
   REAL_CONST(-72.5098F),
   REAL_CONST(42.4805F),
   REAL_CONST(-72.5098F),
   REAL_CONST(9.27734F),
   REAL_CONST(-1.95313F),
   REAL_CONST(28.5645F),
   REAL_CONST(-92.7734F),
   REAL_CONST(48.0957F),
   REAL_CONST(-110.352F),
   REAL_CONST(58.5938F),
   REAL_CONST(-127.441F),
   REAL_CONST(54.4434F),
   REAL_CONST(-25.1465F),
   REAL_CONST(26.8555F),
   REAL_CONST(-45.6543F),
   REAL_CONST(21.2402F),
   REAL_CONST(-37.8418F),
   REAL_CONST(41.2598F),
   REAL_CONST(-11.4746F),
   REAL_CONST(38.3301F),
   REAL_CONST(6.34766F),
   REAL_CONST(-20.2637F),
   REAL_CONST(-24.4141F),
   REAL_CONST(31.2500F),
   REAL_CONST(19.5313F),
   REAL_CONST(51.0254F),
   REAL_CONST(-15.1367F),
   REAL_CONST(1.46484F),
   REAL_CONST(1.70898F),
   REAL_CONST(5.37109F),
   REAL_CONST(1.22070F),
   REAL_CONST(77.6367F),
   REAL_CONST(-4.88281F),
   REAL_CONST(60.5469F),
   REAL_CONST(-10.9863F),
   REAL_CONST(-48.8281F),
   REAL_CONST(-15.3809F),
   REAL_CONST(38.0859F),
   REAL_CONST(-16.8457F),
   REAL_CONST(61.0352F),
   REAL_CONST(-44.6777F),
   REAL_CONST(90.0879F),
   REAL_CONST(-30.7617F),
   REAL_CONST(-27.5879F),
   REAL_CONST(-18.5547F),
   REAL_CONST(-34.6680F),
   REAL_CONST(-29.7852F),
   REAL_CONST(-15.6250F),
   REAL_CONST(-62.0117F),
   REAL_CONST(-7.56836F),
   REAL_CONST(8.54492F),
   REAL_CONST(-43.2129F),
   REAL_CONST(-17.3340F),
   REAL_CONST(-1.70898F),
   REAL_CONST(41.7480F),
   REAL_CONST(22.7051F),
   REAL_CONST(6.59180F),
   REAL_CONST(26.3672F),
   REAL_CONST(51.7578F),
   REAL_CONST(-80.5664F),
   REAL_CONST(-51.0254F),
   REAL_CONST(-30.0293F),
   REAL_CONST(-17.0898F),
   REAL_CONST(-68.1152F),
   REAL_CONST(23.1934F),
   REAL_CONST(-23.4375F),
   REAL_CONST(4.88281F),
   REAL_CONST(-45.8984F),
   REAL_CONST(-14.8926F),
   REAL_CONST(-76.6602F),
   REAL_CONST(21.2402F),
   REAL_CONST(-73.2422F),
   REAL_CONST(-19.0430F),
   REAL_CONST(-86.4258F),
   REAL_CONST(-32.7148F),
   REAL_CONST(2.68555F),
   REAL_CONST(29.7852F),
   REAL_CONST(-34.1797F),
   REAL_CONST(29.7852F),
   REAL_CONST(-67.1387F),
   REAL_CONST(37.1094F),
   REAL_CONST(-71.5332F),
   REAL_CONST(34.1797F),
   REAL_CONST(-20.0195F),
   REAL_CONST(33.6914F),
   REAL_CONST(-78.3691F),
   REAL_CONST(-27.0996F),
   REAL_CONST(-117.188F),
   REAL_CONST(-38.0859F),
   REAL_CONST(-87.6465F),
   REAL_CONST(18.5547F),
   REAL_CONST(-62.0117F),
   REAL_CONST(-9.76563F),
   REAL_CONST(-155.029F),
   REAL_CONST(-23.4375F),
   REAL_CONST(-127.441F),
   REAL_CONST(19.2871F),
   REAL_CONST(-123.779F),
   REAL_CONST(1.95313F),
   REAL_CONST(-65.4297F),
   REAL_CONST(73.9746F),
   REAL_CONST(-131.592F),
   REAL_CONST(16.6016F),
   REAL_CONST(-108.887F),
   REAL_CONST(14.8926F),
   REAL_CONST(-127.441F),
   REAL_CONST(74.7070F),
   REAL_CONST(27.0996F),
   REAL_CONST(46.1426F),
   REAL_CONST(-106.201F),
   REAL_CONST(29.7852F),
   REAL_CONST(-92.5293F),
   REAL_CONST(40.5273F),
   REAL_CONST(-139.404F),
   REAL_CONST(-97.1680F),
   REAL_CONST(-154.297F),
   REAL_CONST(-18.0664F),
   REAL_CONST(-182.373F),
   REAL_CONST(-23.1934F),
   REAL_CONST(-111.084F),
   REAL_CONST(47.3633F),
   REAL_CONST(-232.422F),
   REAL_CONST(20.2637F),
   REAL_CONST(-194.824F),
   REAL_CONST(46.8750F),
   REAL_CONST(-184.326F),
   REAL_CONST(46.8750F),
   REAL_CONST(-190.674F),
   REAL_CONST(-39.5508F),
   REAL_CONST(-151.123F),
   REAL_CONST(57.1289F),
   REAL_CONST(-161.865F),
   REAL_CONST(-72.5098F),
   REAL_CONST(-119.141F),
   REAL_CONST(-26.6113F),
   REAL_CONST(-235.352F),
   REAL_CONST(-32.2266F),
   REAL_CONST(-204.590F),
   REAL_CONST(-16.6016F),
   REAL_CONST(-205.811F),
   REAL_CONST(14.1602F),
   REAL_CONST(-271.484F),
   REAL_CONST(-20.9961F),
   REAL_CONST(-196.533F),
   REAL_CONST(-72.9980F),
   REAL_CONST(-230.469F),
   REAL_CONST(-61.7676F),
   REAL_CONST(-189.941F),
   REAL_CONST(-12.2070F),
   REAL_CONST(-235.596F),
   REAL_CONST(-134.033F),
   REAL_CONST(-85.9375F),
   REAL_CONST(-23.9258F),
   REAL_CONST(-242.188F),
   REAL_CONST(-83.7402F),
   REAL_CONST(-272.705F),
   REAL_CONST(-76.9043F),
   REAL_CONST(-272.705F),
   REAL_CONST(-74.9512F),
   REAL_CONST(-281.982F),
   REAL_CONST(-91.3086F),
   REAL_CONST(-155.518F),
   REAL_CONST(-56.1523F),
   REAL_CONST(-284.668F),
   REAL_CONST(-10.4980F),
   REAL_CONST(-317.139F),
   REAL_CONST(-24.4141F),
   REAL_CONST(-225.830F),
   REAL_CONST(-95.9473F),
   REAL_CONST(-311.035F),
   REAL_CONST(-146.484F),
   REAL_CONST(-168.213F),
   REAL_CONST(-31.7383F),
   REAL_CONST(-361.084F),
   REAL_CONST(-76.1719F),
   REAL_CONST(-322.510F),
   REAL_CONST(-62.0117F),
   REAL_CONST(-357.422F),
   REAL_CONST(-107.910F),
   REAL_CONST(-315.430F),
   REAL_CONST(-149.658F),
   REAL_CONST(-307.861F),
   REAL_CONST(-122.803F),
   REAL_CONST(-366.455F),
   REAL_CONST(-89.8438F),
   REAL_CONST(-322.754F),
   REAL_CONST(6.34766F),
   REAL_CONST(-349.609F),
   REAL_CONST(-16.1133F),
   REAL_CONST(-425.537F),
   REAL_CONST(-39.3066F),
   REAL_CONST(-401.367F),
   REAL_CONST(-114.014F),
   REAL_CONST(-429.688F),
   REAL_CONST(-133.789F),
   REAL_CONST(-340.088F),
   REAL_CONST(-138.672F),
   REAL_CONST(-379.883F),
   REAL_CONST(-212.646F),
   REAL_CONST(-364.990F),
   REAL_CONST(-252.441F),
   REAL_CONST(-338.623F),
   REAL_CONST(-139.404F),
   REAL_CONST(-468.018F),
   REAL_CONST(-128.906F),
   REAL_CONST(-435.303F),
   REAL_CONST(-30.0293F),
   REAL_CONST(-463.135F),
   REAL_CONST(-56.3965F),
   REAL_CONST(-501.465F),
   REAL_CONST(-78.8574F),
   REAL_CONST(-500.977F),
   REAL_CONST(-221.191F),
   REAL_CONST(-482.422F),
   REAL_CONST(-138.428F),
   REAL_CONST(-468.018F),
   REAL_CONST(-151.367F),
   REAL_CONST(-499.756F),
   REAL_CONST(-241.455F),
   REAL_CONST(-262.939F),
   REAL_CONST(-90.3320F),
   REAL_CONST(-495.850F),
   REAL_CONST(-171.875F),
   REAL_CONST(-574.951F),
   REAL_CONST(-182.861F),
   REAL_CONST(-668.945F),
   REAL_CONST(-265.869F),
   REAL_CONST(-466.064F),
   REAL_CONST(38.8184F),
   REAL_CONST(-491.211F),
   REAL_CONST(60.5469F),
   REAL_CONST(-152.832F),
   REAL_CONST(-30.0293F),
   REAL_CONST(-571.045F),
   REAL_CONST(-234.863F),
   REAL_CONST(-163.330F),
   REAL_CONST(-99.6094F),
   REAL_CONST(-336.670F),
   REAL_CONST(-286.621F),
   REAL_CONST(-110.352F),
   REAL_CONST(-88.8672F),
   REAL_CONST(-254.883F),
   REAL_CONST(-179.443F),
   REAL_CONST(-32.2266F),
   REAL_CONST(44.6777F),
   REAL_CONST(-395.508F),
   REAL_CONST(-183.594F),
   REAL_CONST(-133.545F),
   REAL_CONST(-74.9512F),
   REAL_CONST(-189.697F),
   REAL_CONST(-307.861F),
   REAL_CONST(-23.9258F),
   REAL_CONST(10.0098F),
   REAL_CONST(-214.844F),
   REAL_CONST(-266.357F),
   REAL_CONST(-62.7441F),
   REAL_CONST(23.6816F),
   REAL_CONST(-391.113F),
   REAL_CONST(-447.510F),
   REAL_CONST(7.56836F),
   REAL_CONST(-6.34766F),
   REAL_CONST(-157.227F),
   REAL_CONST(-136.963F),
   REAL_CONST(-43.9453F),
   REAL_CONST(-133.301F),
   REAL_CONST(-93.9941F),
   REAL_CONST(-267.334F),
   REAL_CONST(-100.098F),
   REAL_CONST(-195.801F),
   REAL_CONST(-101.074F),
   REAL_CONST(-201.904F),
   REAL_CONST(-111.572F),
   REAL_CONST(-236.816F),
   REAL_CONST(-119.629F),
   REAL_CONST(-270.752F),
   REAL_CONST(-52.4902F),
   REAL_CONST(-223.633F),
   REAL_CONST(-35.1563F),
   REAL_CONST(-228.760F),
   REAL_CONST(-120.361F),
   REAL_CONST(-309.814F),
   REAL_CONST(-126.221F),
   REAL_CONST(-367.920F),
   REAL_CONST(44.1895F),
   REAL_CONST(24.6582F),
   REAL_CONST(-81.0547F),
   REAL_CONST(-217.041F),
   REAL_CONST(-204.102F),
   REAL_CONST(-228.760F),
   REAL_CONST(-136.475F),
   REAL_CONST(-104.736F),
   REAL_CONST(-153.564F),
   REAL_CONST(-133.545F),
   REAL_CONST(-44.6777F),
   REAL_CONST(-82.2754F),
   REAL_CONST(-133.057F),
   REAL_CONST(-20.0195F),
   REAL_CONST(-61.0352F),
   REAL_CONST(-69.8242F),
   REAL_CONST(1.22070F),
   REAL_CONST(-32.2266F),
   REAL_CONST(-84.9609F),
   REAL_CONST(-61.5234F),
   REAL_CONST(-71.5332F),
   REAL_CONST(-115.234F),
   REAL_CONST(-38.5742F),
   REAL_CONST(24.4141F),
   REAL_CONST(-7.08008F),
   REAL_CONST(48.0957F),
   REAL_CONST(-57.6172F),
   REAL_CONST(-103.516F),
   REAL_CONST(-210.205F),
   REAL_CONST(-52.0020F),
   REAL_CONST(-34.1797F),
   REAL_CONST(-1.70898F),
   REAL_CONST(-104.248F),
   REAL_CONST(-108.154F),
   REAL_CONST(45.6543F),
   REAL_CONST(-23.6816F),
   REAL_CONST(-166.992F),
   REAL_CONST(-179.688F),
   REAL_CONST(-71.5332F),
   REAL_CONST(62.9883F),
   REAL_CONST(-89.8438F),
   REAL_CONST(-37.1094F),
   REAL_CONST(-36.6211F),
   REAL_CONST(95.7031F),
   REAL_CONST(-148.682F),
   REAL_CONST(42.7246F),
   REAL_CONST(-34.6680F),
   REAL_CONST(72.9980F),
   REAL_CONST(-33.6914F),
   REAL_CONST(37.1094F),
   REAL_CONST(-29.0527F),
   REAL_CONST(80.3223F),
   REAL_CONST(-118.652F),
   REAL_CONST(-12.6953F),
   REAL_CONST(71.5332F),
   REAL_CONST(48.3398F),
   REAL_CONST(-44.6777F),
   REAL_CONST(28.5645F),
   REAL_CONST(42.7246F),
   REAL_CONST(80.8105F),
   REAL_CONST(-14.1602F),
   REAL_CONST(-66.8945F),
   REAL_CONST(56.3965F),
   REAL_CONST(73.2422F),
   REAL_CONST(-70.3125F),
   REAL_CONST(80.5664F),
   REAL_CONST(-74.4629F),
   REAL_CONST(90.8203F),
   REAL_CONST(-27.0996F),
   REAL_CONST(99.8535F),
   REAL_CONST(-2.19727F),
   REAL_CONST(103.271F),
   REAL_CONST(20.2637F),
   REAL_CONST(62.5000F),
   REAL_CONST(16.3574F),
   REAL_CONST(89.5996F),
   REAL_CONST(-4.63867F),
   REAL_CONST(60.5469F),
   REAL_CONST(22.2168F),
   REAL_CONST(27.5879F),
   REAL_CONST(-8.54492F),
   REAL_CONST(99.1211F),
   REAL_CONST(-46.6309F),
   REAL_CONST(37.5977F),
   REAL_CONST(58.1055F),
   REAL_CONST(72.2656F),
   REAL_CONST(1.22070F),
   REAL_CONST(48.0957F),
   REAL_CONST(34.4238F),
   REAL_CONST(53.9551F),
   REAL_CONST(76.4160F),
   REAL_CONST(48.3398F),
   REAL_CONST(51.5137F),
   REAL_CONST(102.783F),
   REAL_CONST(59.5703F),
   REAL_CONST(81.5430F),
   REAL_CONST(21.4844F),
   REAL_CONST(104.004F),
   REAL_CONST(-59.3262F),
   REAL_CONST(110.840F),
   REAL_CONST(49.3164F),
   REAL_CONST(134.766F),
   REAL_CONST(-1.22070F),
   REAL_CONST(98.3887F),
   REAL_CONST(71.0449F),
   REAL_CONST(45.1660F),
   REAL_CONST(53.4668F),
   REAL_CONST(73.4863F),
   REAL_CONST(61.2793F),
   REAL_CONST(33.6914F),
   REAL_CONST(31.2500F),
   REAL_CONST(16.8457F),
   REAL_CONST(48.0957F),
   REAL_CONST(70.3125F),
   REAL_CONST(-34.1797F),
   REAL_CONST(-14.8926F),
   REAL_CONST(45.8984F),
   REAL_CONST(88.1348F),
   REAL_CONST(48.0957F),
   REAL_CONST(145.996F),
   REAL_CONST(107.910F),
   REAL_CONST(66.6504F),
   REAL_CONST(70.8008F),
   REAL_CONST(34.9121F),
   REAL_CONST(115.234F),
   REAL_CONST(117.676F),
   REAL_CONST(38.3301F),
   REAL_CONST(90.3320F),
   REAL_CONST(101.318F),
   REAL_CONST(78.3691F),
   REAL_CONST(90.8203F),
   REAL_CONST(93.9941F),
   REAL_CONST(98.1445F),
   REAL_CONST(134.766F),
   REAL_CONST(37.8418F),
   REAL_CONST(5.85938F),
   REAL_CONST(134.277F),
   REAL_CONST(64.2090F),
   REAL_CONST(-2.68555F),
   REAL_CONST(5.12695F),
   REAL_CONST(87.8906F),
   REAL_CONST(55.4199F),
   REAL_CONST(35.8887F),
   REAL_CONST(-62.0117F),
   REAL_CONST(103.516F),
   REAL_CONST(23.6816F),
   REAL_CONST(89.3555F),
   REAL_CONST(-3.17383F),
   REAL_CONST(91.5527F),
   REAL_CONST(34.4238F),
   REAL_CONST(109.619F),
   REAL_CONST(56.6406F),
   REAL_CONST(96.6797F),
   REAL_CONST(123.779F),
   REAL_CONST(115.723F),
   REAL_CONST(66.4063F),
   REAL_CONST(171.143F),
   REAL_CONST(79.1016F),
   REAL_CONST(88.3789F),
   REAL_CONST(-11.4746F),
   REAL_CONST(143.311F),
   REAL_CONST(36.1328F),
   REAL_CONST(132.568F),
   REAL_CONST(16.8457F),
   REAL_CONST(97.6563F),
   REAL_CONST(-12.4512F),
   REAL_CONST(136.963F),
   REAL_CONST(14.4043F),
   REAL_CONST(53.7109F),
   REAL_CONST(-2.44141F),
   REAL_CONST(85.9375F),
   REAL_CONST(35.8887F),
   REAL_CONST(50.2930F),
   REAL_CONST(51.5137F),
   REAL_CONST(159.424F),
   REAL_CONST(45.1660F),
   REAL_CONST(137.451F),
   REAL_CONST(72.5098F),
   REAL_CONST(137.939F),
   REAL_CONST(69.3359F),
   REAL_CONST(145.020F),
   REAL_CONST(29.5410F),
   REAL_CONST(187.012F),
   REAL_CONST(46.8750F),
   REAL_CONST(97.1680F),
   REAL_CONST(28.8086F),
   REAL_CONST(156.738F),
   REAL_CONST(105.957F),
   REAL_CONST(56.8848F),
   REAL_CONST(64.4531F),
   REAL_CONST(117.432F),
   REAL_CONST(114.014F),
   REAL_CONST(31.4941F),
   REAL_CONST(-40.2832F),
   REAL_CONST(170.654F),
   REAL_CONST(58.3496F),
   REAL_CONST(21.9727F),
   REAL_CONST(6.34766F),
   REAL_CONST(83.4961F),
   REAL_CONST(115.723F),
   REAL_CONST(-13.4277F),
   REAL_CONST(6.59180F),
   REAL_CONST(94.7266F),
   REAL_CONST(22.9492F),
   REAL_CONST(-41.9922F),
   REAL_CONST(0.000000F),
   REAL_CONST(177.002F),
   REAL_CONST(92.5293F),
   REAL_CONST(-14.6484F),
   REAL_CONST(82.2754F),
   REAL_CONST(90.3320F),
   REAL_CONST(113.525F),
   REAL_CONST(23.1934F),
   REAL_CONST(77.8809F),
   REAL_CONST(196.777F),
   REAL_CONST(145.264F),
   REAL_CONST(19.0430F),
   REAL_CONST(63.4766F),
   REAL_CONST(121.338F),
   REAL_CONST(207.764F),
   REAL_CONST(51.2695F),
   REAL_CONST(136.719F),
   REAL_CONST(111.816F),
   REAL_CONST(140.137F),
   REAL_CONST(-113.281F),
   REAL_CONST(49.3164F),
   REAL_CONST(121.338F),
   REAL_CONST(152.588F),
   REAL_CONST(-49.3164F),
   REAL_CONST(37.1094F),
   REAL_CONST(11.7188F),
   REAL_CONST(173.828F),
   REAL_CONST(-4.88281F),
   REAL_CONST(138.184F),
   REAL_CONST(24.4141F),
   REAL_CONST(174.561F),
   REAL_CONST(111.084F),
   REAL_CONST(114.258F),
   REAL_CONST(100.342F),
   REAL_CONST(147.705F),
   REAL_CONST(77.8809F),
   REAL_CONST(157.715F),
   REAL_CONST(47.6074F),
   REAL_CONST(150.146F),
   REAL_CONST(97.9004F),
   REAL_CONST(131.348F),
   REAL_CONST(166.016F),
   REAL_CONST(180.420F),
   REAL_CONST(49.0723F),
   REAL_CONST(162.842F),
   REAL_CONST(105.957F),
   REAL_CONST(232.910F),
   REAL_CONST(110.840F),
   REAL_CONST(103.760F),
   REAL_CONST(157.715F),
   REAL_CONST(119.873F),
   REAL_CONST(147.949F),
   REAL_CONST(166.260F),
   REAL_CONST(101.563F),
   REAL_CONST(124.023F),
   REAL_CONST(121.338F),
   REAL_CONST(200.684F),
   REAL_CONST(104.004F),
   REAL_CONST(198.975F),
   REAL_CONST(161.133F),
   REAL_CONST(157.959F),
   REAL_CONST(153.320F),
   REAL_CONST(174.805F),
   REAL_CONST(170.166F),
   REAL_CONST(113.770F),
   REAL_CONST(150.879F),
   REAL_CONST(111.572F),
   REAL_CONST(167.236F),
   REAL_CONST(112.305F),
   REAL_CONST(89.1113F),
   REAL_CONST(75.4395F),
   REAL_CONST(176.025F),
   REAL_CONST(138.428F),
   REAL_CONST(204.102F),
   REAL_CONST(146.729F),
   REAL_CONST(148.682F),
   REAL_CONST(73.2422F),
   REAL_CONST(201.416F),
   REAL_CONST(112.061F),
   REAL_CONST(230.225F),
   REAL_CONST(167.725F),
   REAL_CONST(166.260F),
   REAL_CONST(130.127F),
   REAL_CONST(223.389F),
   REAL_CONST(145.996F),
   REAL_CONST(144.287F),
   REAL_CONST(59.3262F),
   REAL_CONST(213.867F),
   REAL_CONST(110.107F),
   REAL_CONST(213.379F),
   REAL_CONST(102.539F),
   REAL_CONST(191.895F),
   REAL_CONST(77.3926F),
   REAL_CONST(178.711F),
   REAL_CONST(53.7109F),
   REAL_CONST(225.098F),
   REAL_CONST(77.3926F),
   REAL_CONST(270.508F),
   REAL_CONST(89.5996F),
   REAL_CONST(129.639F),
   REAL_CONST(113.770F),
   REAL_CONST(250.977F),
   REAL_CONST(158.447F),
   REAL_CONST(257.080F),
   REAL_CONST(150.146F),
   REAL_CONST(252.441F),
   REAL_CONST(135.010F),
   REAL_CONST(202.393F),
   REAL_CONST(146.973F),
   REAL_CONST(249.268F),
   REAL_CONST(195.068F),
   REAL_CONST(226.318F),
   REAL_CONST(196.045F),
   REAL_CONST(214.355F),
   REAL_CONST(186.279F),
   REAL_CONST(195.068F),
   REAL_CONST(121.094F),
   REAL_CONST(335.205F),
   REAL_CONST(188.721F),
   REAL_CONST(142.822F),
   REAL_CONST(187.988F),
   REAL_CONST(196.045F),
   REAL_CONST(227.051F),
   REAL_CONST(268.311F),
   REAL_CONST(193.604F),
   REAL_CONST(298.340F),
   REAL_CONST(210.449F),
   REAL_CONST(295.166F),
   REAL_CONST(218.506F),
   REAL_CONST(250.244F),
   REAL_CONST(177.490F),
   REAL_CONST(188.477F),
   REAL_CONST(206.299F),
   REAL_CONST(286.133F),
   REAL_CONST(272.217F),
   REAL_CONST(211.670F),
   REAL_CONST(249.268F),
   REAL_CONST(202.637F),
   REAL_CONST(247.314F),
   REAL_CONST(205.322F),
   REAL_CONST(222.168F),
   REAL_CONST(123.535F),
   REAL_CONST(171.631F),
   REAL_CONST(302.490F),
   REAL_CONST(262.939F),
   REAL_CONST(151.367F),
   REAL_CONST(199.951F),
   REAL_CONST(291.992F),
   REAL_CONST(264.404F),
   REAL_CONST(281.982F),
   REAL_CONST(263.916F),
   REAL_CONST(278.809F),
   REAL_CONST(221.436F),
   REAL_CONST(377.686F),
   REAL_CONST(273.682F),
   REAL_CONST(319.580F),
   REAL_CONST(158.203F),
   REAL_CONST(327.881F),
   REAL_CONST(149.414F),
   REAL_CONST(362.305F),
   REAL_CONST(241.211F),
   REAL_CONST(361.084F),
   REAL_CONST(228.760F),
   REAL_CONST(240.479F),
   REAL_CONST(324.219F),
   REAL_CONST(233.154F),
   REAL_CONST(327.393F),
   REAL_CONST(104.736F),
   REAL_CONST(222.168F),
   REAL_CONST(205.322F),
   REAL_CONST(326.660F),
   REAL_CONST(137.695F),
   REAL_CONST(287.842F),
   REAL_CONST(100.586F),
   REAL_CONST(282.227F),
   REAL_CONST(348.389F),
   REAL_CONST(322.266F),
   REAL_CONST(350.098F),
   REAL_CONST(324.707F),
   REAL_CONST(156.250F),
   REAL_CONST(185.547F),
   REAL_CONST(421.387F),
   REAL_CONST(344.238F),
   REAL_CONST(46.3867F),
   REAL_CONST(135.498F),
   REAL_CONST(261.963F),
   REAL_CONST(245.361F),
   REAL_CONST(104.004F),
   REAL_CONST(62.7441F),
   REAL_CONST(204.834F),
   REAL_CONST(239.258F),
   REAL_CONST(57.3730F),
   REAL_CONST(56.3965F),
   REAL_CONST(371.094F),
   REAL_CONST(284.912F),
   REAL_CONST(26.6113F),
   REAL_CONST(71.5332F),
   REAL_CONST(247.559F),
   REAL_CONST(383.057F),
   REAL_CONST(74.4629F),
   REAL_CONST(34.6680F),
   REAL_CONST(280.273F),
   REAL_CONST(131.592F),
   REAL_CONST(-71.0449F),
   REAL_CONST(-26.3672F),
   REAL_CONST(296.143F),
   REAL_CONST(237.305F),
   REAL_CONST(5.37109F),
   REAL_CONST(-52.7344F),
   REAL_CONST(162.842F),
   REAL_CONST(202.148F),
   REAL_CONST(-117.676F),
   REAL_CONST(106.934F),
   REAL_CONST(110.596F),
   REAL_CONST(349.365F),
   REAL_CONST(-141.846F),
   REAL_CONST(-103.027F),
   REAL_CONST(192.627F),
   REAL_CONST(94.4824F),
   REAL_CONST(-87.4023F),
   REAL_CONST(-110.840F),
   REAL_CONST(42.4805F),
   REAL_CONST(190.430F),
   REAL_CONST(-8.78906F),
   REAL_CONST(-90.8203F),
   REAL_CONST(95.2148F),
   REAL_CONST(-32.7148F),
   REAL_CONST(-153.564F),
   REAL_CONST(39.0625F),
   REAL_CONST(-74.7070F),
   REAL_CONST(183.350F),
   REAL_CONST(-307.129F),
   REAL_CONST(-80.8105F),
   REAL_CONST(43.2129F),
   REAL_CONST(127.441F),
   REAL_CONST(-60.5469F),
   REAL_CONST(140.137F),
   REAL_CONST(-61.2793F),
   REAL_CONST(156.006F),
   REAL_CONST(-129.639F),
   REAL_CONST(99.3652F),
   REAL_CONST(-145.508F),
   REAL_CONST(96.1914F),
   REAL_CONST(-102.295F),
   REAL_CONST(192.627F),
   REAL_CONST(-150.635F),
   REAL_CONST(195.557F),
   REAL_CONST(-240.723F),
   REAL_CONST(97.4121F),
   REAL_CONST(-209.229F),
   REAL_CONST(177.490F),
   REAL_CONST(-1.70898F),
   REAL_CONST(126.465F),
   REAL_CONST(-171.631F),
   REAL_CONST(75.6836F),
   REAL_CONST(-279.053F),
   REAL_CONST(-5.85938F),
   REAL_CONST(-244.629F),
   REAL_CONST(70.0684F),
   REAL_CONST(-234.375F),
   REAL_CONST(88.6230F),
   REAL_CONST(-317.139F),
   REAL_CONST(76.1719F),
   REAL_CONST(-374.512F),
   REAL_CONST(59.8145F),
   REAL_CONST(-380.127F),
   REAL_CONST(74.4629F),
   REAL_CONST(6.83594F),
   REAL_CONST(37.3535F),
   REAL_CONST(-209.717F),
   REAL_CONST(-42.7246F),
   REAL_CONST(-8.05664F),
   REAL_CONST(81.0547F),
   REAL_CONST(-341.309F),
   REAL_CONST(-37.5977F),
   REAL_CONST(51.7578F),
   REAL_CONST(100.098F),
   REAL_CONST(-144.775F),
   REAL_CONST(-48.0957F),
   REAL_CONST(-266.602F),
   REAL_CONST(-171.875F),
   REAL_CONST(-220.703F),
   REAL_CONST(-15.8691F),
   REAL_CONST(68.8477F),
   REAL_CONST(89.5996F),
   REAL_CONST(-224.121F),
   REAL_CONST(-167.480F),
   REAL_CONST(84.2285F),
   REAL_CONST(22.7051F),
   REAL_CONST(-62.9883F),
   REAL_CONST(-87.1582F),
   REAL_CONST(169.922F),
   REAL_CONST(157.227F),
   REAL_CONST(-169.189F),
   REAL_CONST(-6.83594F),
   REAL_CONST(109.375F),
   REAL_CONST(120.361F),
   REAL_CONST(-66.6504F),
   REAL_CONST(47.1191F),
   REAL_CONST(128.662F),
   REAL_CONST(133.301F),
   REAL_CONST(-59.3262F),
   REAL_CONST(-125.244F),
   REAL_CONST(93.7500F),
   REAL_CONST(-33.2031F),
   REAL_CONST(66.6504F),
   REAL_CONST(-86.1816F),
   REAL_CONST(125.000F),
   REAL_CONST(-34.6680F),
   REAL_CONST(131.104F),
   REAL_CONST(-48.3398F),
   REAL_CONST(229.736F),
   REAL_CONST(183.105F),
   REAL_CONST(20.2637F),
   REAL_CONST(60.5469F),
   REAL_CONST(141.113F),
   REAL_CONST(210.205F),
   REAL_CONST(-13.6719F),
   REAL_CONST(144.531F),
   REAL_CONST(205.566F),
   REAL_CONST(10.7422F),
   REAL_CONST(217.773F),
   REAL_CONST(5.85938F),
   REAL_CONST(8.05664F),
   REAL_CONST(217.285F),
   REAL_CONST(-3.90625F),
   REAL_CONST(239.746F),
   REAL_CONST(202.881F),
   REAL_CONST(341.309F),
   REAL_CONST(374.756F),
   REAL_CONST(463.379F),
   REAL_CONST(418.945F),
   REAL_CONST(335.938F),
   REAL_CONST(475.586F),
   REAL_CONST(357.666F)
};

static const real_32_t dico5_lsf_5[DICO5_SIZE_5 * 4] =
{
   REAL_CONST(-244.629F),
   REAL_CONST(-226.807F),
   REAL_CONST(-267.578F),
   REAL_CONST(-293.701F),
   REAL_CONST(-156.494F),
   REAL_CONST(-227.295F),
   REAL_CONST(-147.461F),
   REAL_CONST(-234.619F),
   REAL_CONST(-190.186F),
   REAL_CONST(-164.307F),
   REAL_CONST(-203.857F),
   REAL_CONST(-192.383F),
   REAL_CONST(-101.563F),
   REAL_CONST(-162.109F),
   REAL_CONST(-111.816F),
   REAL_CONST(-187.012F),
   REAL_CONST(-159.180F),
   REAL_CONST(-127.197F),
   REAL_CONST(-161.621F),
   REAL_CONST(-120.850F),
   REAL_CONST(-249.756F),
   REAL_CONST(-124.268F),
   REAL_CONST(-249.756F),
   REAL_CONST(-104.492F),
   REAL_CONST(-108.398F),
   REAL_CONST(-134.766F),
   REAL_CONST(-89.8438F),
   REAL_CONST(-109.619F),
   REAL_CONST(-116.943F),
   REAL_CONST(-51.5137F),
   REAL_CONST(-257.324F),
   REAL_CONST(-220.459F),
   REAL_CONST(-77.1484F),
   REAL_CONST(-60.7910F),
   REAL_CONST(-138.916F),
   REAL_CONST(-144.287F),
   REAL_CONST(-138.916F),
   REAL_CONST(-67.1387F),
   REAL_CONST(-132.080F),
   REAL_CONST(-46.6309F),
   REAL_CONST(-174.805F),
   REAL_CONST(-45.8984F),
   REAL_CONST(-205.566F),
   REAL_CONST(-64.4531F),
   REAL_CONST(-81.2988F),
   REAL_CONST(-60.5469F),
   REAL_CONST(-77.6367F),
   REAL_CONST(-55.6641F),
   REAL_CONST(-67.1387F),
   REAL_CONST(0.244141F),
   REAL_CONST(-138.428F),
   REAL_CONST(-55.6641F),
   REAL_CONST(-28.0762F),
   REAL_CONST(-53.9551F),
   REAL_CONST(-58.1055F),
   REAL_CONST(-91.3086F),
   REAL_CONST(-48.0957F),
   REAL_CONST(-123.779F),
   REAL_CONST(-54.1992F),
   REAL_CONST(-141.357F),
   REAL_CONST(-62.9883F),
   REAL_CONST(-105.469F),
   REAL_CONST(-14.8926F),
   REAL_CONST(-59.5703F),
   REAL_CONST(-84.2285F),
   REAL_CONST(0.488281F),
   REAL_CONST(-82.5195F),
   REAL_CONST(9.52148F),
   REAL_CONST(-52.4902F),
   REAL_CONST(-41.2598F),
   REAL_CONST(-14.1602F),
   REAL_CONST(0.000000F),
   REAL_CONST(-13.6719F),
   REAL_CONST(-1.46484F),
   REAL_CONST(-49.5605F),
   REAL_CONST(-31.9824F),
   REAL_CONST(0.244141F),
   REAL_CONST(-45.4102F),
   REAL_CONST(-1.22070F),
   REAL_CONST(-51.5137F),
   REAL_CONST(1.46484F),
   REAL_CONST(-92.7734F),
   REAL_CONST(2.68555F),
   REAL_CONST(-102.051F),
   REAL_CONST(-28.3203F),
   REAL_CONST(31.9824F),
   REAL_CONST(-32.7148F),
   REAL_CONST(27.5879F),
   REAL_CONST(21.7285F),
   REAL_CONST(-0.976563F),
   REAL_CONST(17.3340F),
   REAL_CONST(-0.488281F),
   REAL_CONST(-4.63867F),
   REAL_CONST(-46.8750F),
   REAL_CONST(63.9648F),
   REAL_CONST(5.85938F),
   REAL_CONST(46.1426F),
   REAL_CONST(36.8652F),
   REAL_CONST(-32.4707F),
   REAL_CONST(-26.6113F),
   REAL_CONST(45.4102F),
   REAL_CONST(-37.3535F),
   REAL_CONST(40.5273F),
   REAL_CONST(-53.4668F),
   REAL_CONST(9.03320F),
   REAL_CONST(33.9355F),
   REAL_CONST(47.1191F),
   REAL_CONST(41.7480F),
   REAL_CONST(82.2754F),
   REAL_CONST(30.2734F),
   REAL_CONST(38.5742F),
   REAL_CONST(-14.8926F),
   REAL_CONST(34.4238F),
   REAL_CONST(55.1758F),
   REAL_CONST(-3.17383F),
   REAL_CONST(46.3867F),
   REAL_CONST(56.3965F),
   REAL_CONST(8.30078F),
   REAL_CONST(86.4258F),
   REAL_CONST(26.6113F),
   REAL_CONST(77.1484F),
   REAL_CONST(49.0723F),
   REAL_CONST(59.5703F),
   REAL_CONST(40.0391F),
   REAL_CONST(80.5664F),
   REAL_CONST(-20.7520F),
   REAL_CONST(95.2148F),
   REAL_CONST(-20.5078F),
   REAL_CONST(62.0117F),
   REAL_CONST(79.8340F),
   REAL_CONST(62.7441F),
   REAL_CONST(81.7871F),
   REAL_CONST(119.873F),
   REAL_CONST(35.8887F),
   REAL_CONST(116.211F),
   REAL_CONST(25.6348F),
   REAL_CONST(13.1836F),
   REAL_CONST(18.7988F),
   REAL_CONST(106.689F),
   REAL_CONST(90.3320F),
   REAL_CONST(102.783F),
   REAL_CONST(76.6602F),
   REAL_CONST(109.619F),
   REAL_CONST(83.4961F),
   REAL_CONST(80.3223F),
   REAL_CONST(30.7617F),
   REAL_CONST(164.307F),
   REAL_CONST(71.2891F),
   REAL_CONST(139.404F),
   REAL_CONST(94.7266F),
   REAL_CONST(59.3262F),
   REAL_CONST(47.1191F),
   REAL_CONST(159.424F),
   REAL_CONST(78.1250F),
   REAL_CONST(151.611F),
   REAL_CONST(68.3594F),
   REAL_CONST(47.3633F),
   REAL_CONST(92.7734F),
   REAL_CONST(126.221F),
   REAL_CONST(141.846F),
   REAL_CONST(10.9863F),
   REAL_CONST(78.8574F),
   REAL_CONST(27.0996F),
   REAL_CONST(103.027F),
   REAL_CONST(119.385F),
   REAL_CONST(96.4355F),
   REAL_CONST(179.199F),
   REAL_CONST(130.371F),
   REAL_CONST(151.855F),
   REAL_CONST(133.301F),
   REAL_CONST(118.652F),
   REAL_CONST(122.559F),
   REAL_CONST(77.6367F),
   REAL_CONST(139.648F),
   REAL_CONST(46.1426F),
   REAL_CONST(134.277F),
   REAL_CONST(93.9941F),
   REAL_CONST(103.027F),
   REAL_CONST(-38.3301F),
   REAL_CONST(37.3535F),
   REAL_CONST(-30.5176F),
   REAL_CONST(93.2617F),
   REAL_CONST(-48.0957F),
   REAL_CONST(94.2383F),
   REAL_CONST(-64.2090F),
   REAL_CONST(81.5430F),
   REAL_CONST(55.6641F),
   REAL_CONST(170.166F),
   REAL_CONST(-45.8984F),
   REAL_CONST(0.244141F),
   REAL_CONST(12.4512F),
   REAL_CONST(72.5098F),
   REAL_CONST(-123.779F),
   REAL_CONST(52.0020F),
   REAL_CONST(-91.7969F),
   REAL_CONST(96.9238F),
   REAL_CONST(-5.85938F),
   REAL_CONST(62.2559F),
   REAL_CONST(-133.545F),
   REAL_CONST(21.7285F),
   REAL_CONST(-122.559F),
   REAL_CONST(-22.9492F),
   REAL_CONST(94.4824F),
   REAL_CONST(43.7012F),
   REAL_CONST(-151.367F),
   REAL_CONST(16.6016F),
   REAL_CONST(-166.992F),
   REAL_CONST(27.3438F),
   REAL_CONST(-156.738F),
   REAL_CONST(-85.4492F),
   REAL_CONST(-63.4766F),
   REAL_CONST(41.9922F),
   REAL_CONST(-106.934F),
   REAL_CONST(-79.1016F),
   REAL_CONST(64.4531F),
   REAL_CONST(158.203F),
   REAL_CONST(-235.352F),
   REAL_CONST(-0.976563F),
   REAL_CONST(-273.682F),
   REAL_CONST(1.70898F),
   REAL_CONST(-32.7148F),
   REAL_CONST(32.7148F),
   REAL_CONST(-276.611F),
   REAL_CONST(-74.7070F),
   REAL_CONST(34.9121F),
   REAL_CONST(23.4375F),
   REAL_CONST(-102.539F),
   REAL_CONST(-121.338F),
   REAL_CONST(-298.096F),
   REAL_CONST(-85.4492F),
   REAL_CONST(-372.803F),
   REAL_CONST(-167.236F),
   REAL_CONST(-39.3066F),
   REAL_CONST(17.5781F),
   REAL_CONST(213.135F),
   REAL_CONST(168.701F),
   REAL_CONST(178.711F),
   REAL_CONST(69.0918F),
   REAL_CONST(224.854F),
   REAL_CONST(86.1816F),
   REAL_CONST(81.5430F),
   REAL_CONST(115.967F),
   REAL_CONST(267.334F),
   REAL_CONST(200.439F),
   REAL_CONST(210.938F),
   REAL_CONST(127.930F),
   REAL_CONST(205.811F),
   REAL_CONST(121.338F),
   REAL_CONST(174.316F),
   REAL_CONST(173.584F),
   REAL_CONST(192.383F),
   REAL_CONST(183.105F),
   REAL_CONST(262.695F),
   REAL_CONST(174.316F),
   REAL_CONST(293.945F),
   REAL_CONST(183.838F)
};

/* Table for MR475 gain */
#define MR475_VQ_SIZE 256

/* The table contains the following data:
 *
 *    g_pitch(0)         // for sub-
 *    g_fac(0)           // frame 0 and 2
 *    g_pitch(1)         // for sub-
 *    g_fac(1)           // frame 1 and 3
 *
 */
static const Float32 table_gain_MR475[MR475_VQ_SIZE * 4] =
{
0.049561F, 0.031250F,
0.033081F, 0.034180F,
0.175354F, 0.277100F,
0.138306F, 0.830566F,
0.126160F, 0.137451F,
0.773743F, 0.157959F,
0.252197F, 0.438965F,
0.341858F, 1.290283F,
0.469299F, 0.091309F,
0.227966F, 0.107666F,
0.666016F, 0.644043F,
0.720642F, 0.608887F,
1.250610F, 0.194580F,
0.318481F, 0.164795F,
0.410400F, 2.039551F,
0.322388F, 0.414063F,
0.090820F, 0.104492F,
0.359009F, 0.110352F,
0.325439F, 0.994141F,
0.218689F, 0.309570F,
0.150696F, 0.219971F,
0.970093F, 0.245361F,
0.914429F, 0.798584F,
0.630554F, 1.186035F,
0.221863F, 0.493408F,
0.158447F, 0.203857F,
0.754395F, 1.194336F,
0.744995F, 0.416016F,
0.819824F, 0.391602F,
0.556519F, 0.571533F,
0.242188F, 0.375488F,
0.334412F, 2.425781F,
0.231628F, 0.101807F,
0.082947F, 0.101074F,
0.222168F, 0.383057F,
0.487976F, 0.864502F,
0.696106F, 0.157471F,
0.521973F, 0.155029F,
0.247559F, 0.336182F,
1.013672F, 1.495117F,
0.697021F, 0.170898F,
0.122498F, 0.148193F,
0.757751F, 0.385254F,
0.678650F, 1.136230F,
0.834961F, 0.416992F,
0.731812F, 0.300049F,
0.488037F, 1.781494F,
0.807556F, 1.395264F,
0.148193F, 0.282959F,
0.126526F, 0.473877F,
0.379517F, 1.494385F,
0.216431F, 0.440430F,
0.544739F, 0.439941F,
0.529724F, 0.385742F,
0.850525F, 0.873047F,
0.812561F, 1.522705F,
0.374878F, 0.275879F,
0.365845F, 0.423340F,
0.863098F, 1.138184F,
0.687927F, 0.810791F,
0.746216F, 0.378662F,
0.850281F, 0.736084F,
0.310120F, 2.554688F,
0.576416F, 1.637207F,
0.103088F, 0.166748F,
0.087646F, 0.318848F,
0.440186F, 0.960205F,
0.249146F, 0.662354F,
0.475647F, 0.171875F,
0.919800F, 0.195801F,
0.384460F, 1.272461F,
0.264709F, 1.307861F,
0.407471F, 0.132080F,
0.369995F, 0.152832F,
0.833191F, 0.903320F,
0.701782F, 0.587891F,
0.986084F, 0.174805F,
0.743225F, 0.183350F,
0.492249F, 2.804932F,
0.385376F, 0.550781F,
0.272583F, 0.121094F,
0.445129F, 0.127686F,
0.623352F, 0.935791F,
0.512329F, 0.741455F,
0.512878F, 0.235840F,
0.868408F, 0.458984F,
0.531189F, 1.320557F,
1.000671F, 1.187256F,
0.452881F, 0.483154F,
0.371643F, 0.300293F,
0.571960F, 1.073730F,
0.888550F, 0.821045F,
0.827576F, 0.701416F,
0.803406F, 0.357666F,
0.337769F, 0.409668F,
0.801880F, 3.606201F,
0.447876F, 0.146484F,
0.080444F, 0.133789F,
0.259521F, 0.864014F,
0.613037F, 0.577148F,
0.646179F, 0.151855F,
0.798828F, 0.163330F,
0.862183F, 0.860840F,
0.307556F, 2.388672F,
0.936157F, 0.151123F,
0.190125F, 0.144043F,
1.003540F, 0.735596F,
0.948608F, 1.017578F,
0.948303F, 0.393311F,
0.940247F, 0.299805F,
0.977966F, 2.270264F,
0.459839F, 1.214844F,
0.121460F, 0.296143F,
0.698669F, 0.282471F,
0.763672F, 1.347412F,
0.578308F, 0.645508F,
0.470947F, 0.496582F,
0.810547F, 0.546631F,
0.977234F, 1.243408F,
0.492310F, 1.650635F,
0.615417F, 0.344971F,
0.305298F, 0.572998F,
0.764343F, 1.458740F,
0.923218F, 0.707764F,
1.114746F, 0.558838F,
0.966003F, 0.616943F,
0.992737F, 2.503418F,
0.894226F, 2.763428F,
0.109680F, 0.082275F,
0.190125F, 0.096924F,
0.214233F, 0.714844F,
0.280273F, 0.651855F,
0.458923F, 0.153320F,
0.696716F, 0.160156F,
0.362915F, 0.594482F,
0.399414F, 1.798584F,
0.502808F, 0.202393F,
0.244141F, 0.210693F,
0.612305F, 0.608398F,
0.980042F, 0.866943F,
1.111084F, 0.257324F,
0.372498F, 0.354980F,
0.359131F, 1.928711F,
1.144531F, 0.846680F,
0.113770F, 0.132813F,
0.561401F, 0.166748F,
0.709412F, 1.015625F,
0.280396F, 0.401367F,
0.192749F, 0.282471F,
0.973694F, 0.625000F,
0.753723F, 0.911377F,
1.063232F, 1.284180F,
0.372681F, 0.489258F,
0.178040F, 0.425293F,
1.005066F, 1.283447F,
1.024597F, 0.410156F,
1.050110F, 0.429443F,
0.291321F, 0.788818F,
0.450806F, 1.473389F,
0.875366F, 2.444336F,
0.246277F, 0.107910F,
0.255981F, 0.111816F,
0.562378F, 0.547363F,
0.453308F, 1.029541F,
0.784912F, 0.195557F,
0.682739F, 0.201416F,
0.771973F, 0.508789F,
0.790771F, 1.600098F,
0.580139F, 0.243164F,
0.404602F, 0.240479F,
0.643127F, 0.610840F,
0.933167F, 1.222168F,
0.769165F, 0.501709F,
0.945068F, 0.403564F,
0.988403F, 1.689697F,
0.868591F, 1.413574F,
0.160278F, 0.202148F,
0.342712F, 0.411621F,
0.833923F, 1.410645F,
0.223877F, 0.379395F,
0.690491F, 0.642822F,
0.596313F, 0.356201F,
0.854675F, 1.155518F,
0.970276F, 1.535889F,
0.383179F, 0.456543F,
0.482788F, 0.557861F,
1.036255F, 1.115967F,
1.011719F, 0.939697F,
0.930664F, 0.564209F,
0.977966F, 0.791992F,
0.882507F, 4.347656F,
0.723083F, 0.674561F,
0.120911F, 0.343506F,
0.085449F, 0.213867F,
0.264587F, 0.865967F,
0.268005F, 1.027832F,
0.329895F, 0.166016F,
1.065735F, 0.190674F,
0.396790F, 1.249512F,
0.493835F, 1.874268F,
0.448914F, 0.193848F,
0.508606F, 0.288574F,
0.918030F, 0.771484F,
0.911133F, 0.741943F,
1.246399F, 0.214844F,
0.887756F, 0.208008F,
0.752991F, 3.590820F,
0.421387F, 0.468750F,
0.257874F, 0.227783F,
0.501587F, 0.265381F,
0.650574F, 0.997070F,
0.615356F, 1.106689F,
0.166931F, 0.205078F,
1.260803F, 0.263916F,
1.019958F, 1.456543F,
0.968811F, 1.117676F,
0.663513F, 0.628418F,
0.230286F, 0.284668F,
0.886169F, 0.987305F,
1.263367F, 0.641357F,
0.928894F, 0.667480F,
0.932251F, 0.533691F,
0.381897F, 0.787598F,
0.801086F, 4.755859F,
0.439209F, 0.227051F,
0.150269F, 0.395020F,
0.275574F, 0.754883F,
0.845459F, 1.044189F,
0.638428F, 0.203369F,
1.058289F, 0.197754F,
1.030945F, 0.558838F,
0.948853F, 2.006104F,
0.830261F, 0.411133F,
0.195129F, 0.447754F,
0.973389F, 0.688477F,
0.965088F, 1.300537F,
1.037964F, 0.595215F,
1.024658F, 0.323730F,
0.956482F, 1.991211F,
0.715698F, 2.088867F,
0.229614F, 0.501221F,
0.583679F, 0.321533F,
0.827698F, 1.657715F,
0.746277F, 0.472656F,
0.499268F, 0.866699F,
0.810974F, 0.434082F,
0.994812F, 1.611084F,
0.994324F, 1.894043F,
0.520081F, 0.622803F,
0.440979F, 0.645752F,
1.115051F, 1.828369F,
1.030579F, 0.548828F,
1.091431F, 0.704102F,
1.053772F, 0.812500F,
0.574768F, 4.922363F,
0.673950F, 2.031250F,
0.078491F, 0.151367F,
0.087341F, 0.142334F,
0.365784F, 0.558838F,
0.242798F, 0.885254F,
0.313965F, 0.183594F,
0.818420F, 0.202637F,
0.338928F, 0.698242F,
0.718018F, 1.442383F,
0.655334F, 0.136719F,
0.332397F, 0.137695F,
0.813049F, 0.734375F,
0.729126F, 0.899170F,
1.213806F, 0.194824F,
0.599670F, 0.177734F,
0.833923F, 2.135742F,
0.451111F, 0.745361F,
0.153503F, 0.189941F,
0.369263F, 0.203369F,
0.394836F, 1.238770F,
0.506897F, 0.601318F,
0.374817F, 0.455322F,
0.934326F, 0.308105F,
0.879395F, 1.110107F,
0.833923F, 1.102295F,
0.191467F, 0.728271F,
0.151306F, 0.307373F,
0.920898F, 1.134521F,
0.938843F, 0.636475F,
0.884521F, 0.583984F,
0.760620F, 0.619385F,
0.460144F, 0.719971F,
0.787903F, 2.944336F,
0.333740F, 0.166992F,
0.191711F, 0.176270F,
0.310120F, 0.311035F,
0.777100F, 1.025391F,
0.933960F, 0.166260F,
0.477234F, 0.144531F,
0.398804F, 0.493408F,
1.005737F, 2.133057F,
0.815674F, 0.215332F,
0.329407F, 0.219482F,
0.894531F, 0.531738F,
0.899719F, 1.031982F,
0.870972F, 0.316895F,
0.850159F, 0.495361F,
0.944641F, 1.826660F,
0.965271F, 1.116211F,
0.153870F, 0.491455F,
0.308960F, 0.440430F,
0.314880F, 1.606934F,
0.435181F, 0.878174F,
0.666504F, 0.393311F,
0.715881F, 0.416992F,
1.031677F, 0.843506F,
0.992920F, 1.621094F,
0.567993F, 0.245850F,
0.571838F, 0.514160F,
1.170776F, 1.229736F,
0.759338F, 1.042236F,
0.971619F, 0.325195F,
0.937317F, 0.857422F,
0.726196F, 3.452393F,
0.982727F, 1.673340F,
0.122681F, 0.179932F,
0.230652F, 0.210205F,
0.699097F, 0.703125F,
0.217529F, 0.864258F,
0.552795F, 0.302979F,
0.756287F, 0.218750F,
0.521606F, 1.130127F,
0.705627F, 1.410156F,
0.496155F, 0.143799F,
0.501587F, 0.143555F,
1.143066F, 0.916748F,
0.791809F, 0.768799F,
0.960022F, 0.185059F,
1.015259F, 0.184082F,
0.929077F, 2.719238F,
0.968689F, 0.539063F,
0.285217F, 0.148926F,
0.623657F, 0.165527F,
0.931213F, 1.012207F,
0.349670F, 0.812256F,
0.511292F, 0.407715F,
1.212280F, 0.566650F,
0.942993F, 1.345459F,
0.857788F, 1.338135F,
0.349609F, 0.705078F,
0.462646F, 0.328613F,
0.877930F, 1.300049F,
0.990967F, 0.964355F,
0.922729F, 0.914063F,
0.934204F, 0.350342F,
0.890930F, 0.993652F,
0.750793F, 3.832031F,
0.464905F, 0.414795F,
0.132446F, 0.215820F,
0.272156F, 1.114990F,
1.104370F, 0.807129F,
0.777710F, 0.198975F,
0.911011F, 0.221436F,
0.916504F, 1.045166F,
0.947144F, 2.042969F,
1.098267F, 0.265381F,
0.143921F, 0.211182F,
0.993713F, 0.924561F,
0.956970F, 1.122070F,
0.998291F, 0.374512F,
1.012207F, 0.539551F,
1.027405F, 2.367432F,
0.972229F, 1.101807F,
0.200012F, 0.264893F,
0.588562F, 0.533936F,
0.730774F, 1.481445F,
0.561462F, 1.089355F,
0.546570F, 0.397705F,
0.627991F, 0.747559F,
1.005920F, 1.258545F,
0.943970F, 1.725098F,
0.834839F, 0.620850F,
0.321838F, 0.555908F,
1.022095F, 1.516846F,
1.016541F, 0.832031F,
1.239258F, 0.821045F,
1.140625F, 0.484619F,
0.864990F, 3.141357F,
0.924927F, 3.833740F,
0.273010F, 0.249023F,
0.102600F, 0.216309F,
0.263123F, 1.050049F,
0.546387F, 0.892822F,
0.359680F, 0.280029F,
0.710876F, 0.354492F,
0.969604F, 0.543701F,
0.279663F, 1.622070F,
0.422913F, 0.294189F,
0.379639F, 0.195068F,
0.757751F, 0.832275F,
0.974609F, 0.946533F,
1.212097F, 0.514893F,
0.591370F, 0.522705F,
0.899780F, 2.155762F,
0.883789F, 0.634521F,
0.110901F, 0.302246F,
0.474304F, 0.198486F,
1.164490F, 1.076660F,
0.338989F, 0.503906F,
0.225037F, 0.694336F,
1.064148F, 0.550781F,
1.019104F, 1.095215F,
0.988708F, 1.315430F,
0.489990F, 0.674561F,
0.207825F, 0.517334F,
1.063599F, 1.337158F,
0.836060F, 0.680176F,
1.213318F, 0.664063F,
0.555298F, 0.947266F,
1.109131F, 1.179932F,
1.058105F, 2.980225F,
0.312256F, 0.243164F,
0.301208F, 0.241211F,
0.603516F, 0.752197F,
0.367065F, 1.311279F,
0.969299F, 0.406982F,
0.513000F, 0.288818F,
0.920837F, 0.577637F,
1.207092F, 1.709473F,
0.730164F, 0.381348F,
0.444275F, 0.275391F,
1.028992F, 0.374023F,
0.962036F, 1.313721F,
0.897705F, 0.504150F,
1.227112F, 0.526123F,
1.047241F, 2.012939F,
1.093201F, 1.542480F,
0.333679F, 0.367188F,
0.250244F, 0.628418F,
1.063293F, 1.662598F,
0.346252F, 0.705078F,
1.015381F, 0.825684F,
0.547791F, 0.447021F,
1.230408F, 1.156494F,
1.193237F, 1.780762F,
0.406372F, 0.678955F,
0.700195F, 0.810791F,
1.183899F, 1.233887F,
1.152222F, 1.152832F,
1.003357F, 0.579346F,
1.246948F, 1.070801F,
0.692932F, 6.476074F,
0.707581F, 0.749023F,
0.174927F, 0.382324F,
0.311768F, 0.261230F,
0.586792F, 1.199951F,
0.301453F, 0.863281F,
0.460266F, 0.214355F,
1.264465F, 0.207764F,
0.423462F, 1.072998F,
1.025330F, 1.887939F,
0.618713F, 0.248779F,
0.600891F, 0.235352F,
0.945679F, 0.965576F,
0.943542F, 0.837402F,
1.151306F, 0.239746F,
1.228027F, 0.235107F,
1.030029F, 3.146240F,
0.874878F, 1.025391F,
0.402771F, 0.297852F,
0.562866F, 0.198730F,
1.034058F, 1.253418F,
0.345520F, 1.195801F,
0.334961F, 0.438965F,
1.236450F, 0.967285F,
1.037903F, 1.508301F,
1.094299F, 1.447510F,
0.571594F, 0.834961F,
0.456177F, 0.481201F,
1.192444F, 1.263916F,
1.159851F, 0.733887F,
1.004272F, 0.924805F,
0.980835F, 0.577881F,
0.528809F, 0.669678F,
0.576477F, 6.435059F,
0.662598F, 0.314209F,
0.216980F, 0.246338F,
0.342163F, 0.884277F,
1.187317F, 1.345703F,
0.760071F, 0.194580F,
1.259399F, 0.222412F,
0.941589F, 0.748535F,
1.039856F, 2.508545F,
1.152527F, 0.642822F,
0.238831F, 0.309570F,
1.191345F, 0.822998F,
1.101807F, 1.276855F,
1.177429F, 0.409668F,
1.190674F, 0.774414F,
1.103027F, 2.625488F,
1.014709F, 1.671143F,
0.191284F, 0.561035F,
0.663391F, 0.594971F,
0.950928F, 1.687744F,
0.768860F, 0.825439F,
0.678467F, 0.804932F,
1.023071F, 0.591797F,
1.150696F, 1.639404F,
1.048035F, 2.413818F,
0.777771F, 0.635986F,
0.545471F, 0.766602F,
1.161682F, 1.895508F,
1.119812F, 0.947266F,
1.249695F, 0.898926F,
1.196411F, 0.825195F,
0.796143F, 4.729736F,
0.642456F, 5.645508F,

};

/*
 *    g_pitch        ,
 *    g_fac          , (g_code = g_code0*g_fac),
 */
/* table used in 'high' rates: MR67 MR74 MR102 */
#define VQ_SIZE_HIGHRATES 128
static const Float32 table_highrates[VQ_SIZE_HIGHRATES * 2] =
{
   /*g_pit,    g_fac,   */
   0.0352173F,   0.161621F,
   0.0491943F,   0.448242F,
   0.189758F,   0.256836F,
   0.255188F,   0.338623F,
   0.144836F,   0.347900F,
   0.198242F,   0.484619F,
   0.111511F,   0.566406F,
   0.0574341F,   0.809082F,
   0.143494F,   0.726807F,
   0.220703F,   0.590820F,
   0.210632F,   0.755859F,
   0.180359F,   1.05005F,
   0.112793F,   1.09863F,
   0.237061F,   1.32227F,
   0.0724487F,   1.76025F,
   0.188171F,   2.19727F,
   0.450684F,   0.215576F,
   0.363892F,   0.367676F,
   0.314636F,   0.520996F,
   0.484863F,   0.490479F,
   0.397156F,   0.549316F,
   0.468140F,   0.671875F,
   0.363281F,   0.736328F,
   0.298950F,   0.918945F,
   0.426575F,   0.875977F,
   0.498901F,   0.971191F,
   0.370117F,   1.07520F,
   0.470520F,   1.24194F,
   0.337097F,   1.46997F,
   0.474182F,   1.73975F,
   0.369873F,   1.93799F,
   0.341431F,   2.80444F,
   0.645813F,   0.331055F,
   0.552307F,   0.389893F,
   0.597778F,   0.496826F,
   0.546021F,   0.589600F,
   0.628418F,   0.630859F,
   0.574158F,   0.667480F,
   0.531006F,   0.785645F,
   0.595520F,   0.828857F,
   0.621155F,   0.950195F,
   0.559692F,   1.10547F,
   0.619629F,   1.22168F,
   0.556274F,   1.40015F,
   0.640869F,   1.52979F,
   0.617065F,   1.86304F,
   0.539795F,   2.13062F,
   0.546631F,   3.05078F,
   0.788818F,   0.238281F,
   0.697937F,   0.428467F,
   0.740845F,   0.568359F,
   0.695068F,   0.578125F,
   0.653076F,   0.748047F,
   0.752686F,   0.698486F,
   0.715454F,   0.812256F,
   0.687866F,   0.903320F,
   0.662903F,   1.07739F,
   0.737427F,   1.10669F,
   0.688660F,   1.27075F,
   0.729980F,   1.53931F,
   0.681580F,   1.83936F,
   0.740234F,   2.03345F,
   0.669495F,   2.63110F,
   0.628662F,   4.24219F,
   0.848328F,   0.410400F,
   0.767822F,   0.499268F,
   0.809631F,   0.595459F,
   0.856506F,   0.729736F,
   0.821045F,   0.756348F,
   0.756592F,   0.893066F,
   0.824585F,   0.922852F,
   0.786133F,   1.04297F,
   0.825989F,   1.18677F,
   0.773132F,   1.33228F,
   0.845581F,   1.49072F,
   0.795349F,   1.58276F,
   0.827454F,   1.88501F,
   0.790833F,   2.27319F,
   0.837036F,   2.82007F,
   0.768494F,   3.71240F,
   0.922424F,   0.375977F,
   0.919922F,   0.569580F,
   0.886658F,   0.613037F,
   0.896729F,   0.781006F,
   0.938843F,   0.869141F,
   0.862610F,   0.966797F,
   0.921753F,   1.03418F,
   0.874756F,   1.17773F,
   0.906128F,   1.33081F,
   0.934204F,   1.48511F,
   0.874573F,   1.68164F,
   0.919189F,   1.87720F,
   0.879272F,   2.30127F,
   0.939148F,   2.37817F,
   0.904785F,   3.48413F,
   0.830078F,   6.08862F,
   1.00073F,   0.480713F,
   1.02643F,   0.691406F,
   0.959045F,   0.694092F,
   0.982910F,   0.814453F,
   1.00000F,   0.967529F,
   1.03394F,   1.11792F,
   0.958923F,   1.12280F,
   0.990112F,   1.33008F,
   1.02734F,   1.55811F,
   0.960999F,   1.74341F,
   0.996460F,   1.82349F,
   1.01385F,   2.10547F,
   1.03931F,   2.54346F,
   0.970764F,   2.88501F,
   1.03015F,   3.58643F,
   1.00800F,   5.09521F,
   1.10730F,   0.508545F,
   1.18414F,   0.775879F,
   1.06860F,   0.836426F,
   1.22400F,   0.983154F,
   1.10284F,   1.03735F,
   1.15674F,   1.23682F,
   1.08099F,   1.31885F,
   1.21063F,   1.51172F,
   1.09558F,   1.71240F,
   1.30115F,   1.92310F,
   1.09314F,   2.26782F,
   1.16846F,   2.26807F,
   1.25226F,   2.77856F,
   1.10321F,   3.53638F,
   1.22064F,   4.36572F,
   1.15002F,   7.99902F
};


/* table used in 'low' rates: MR475, MR515, MR59 */
#define VQ_SIZE_LOWRATES 64
static const Float32 table_lowrates[VQ_SIZE_LOWRATES * 2] =
{
   /*g_pit,    g_fac */
   0.659973F,   7.01978F,
   1.25000F,   0.679932F,
   1.14996F,   1.60986F,
   0.379944F,   1.80981F,
   1.04999F,   2.54980F,
   1.31995F,   0.309814F,
   1.28998F,   1.07983F,
   0.689941F,   0.379883F,
   1.15997F,   3.12988F,
   1.06000F,   0.609863F,
   1.08997F,   1.17993F,
   0.609985F,   0.609863F,
   1.06995F,   1.91992F,
   0.869995F,   0.459961F,
   0.969971F,   0.769775F,
   0.409973F,   0.439941F,
   1.10999F,   4.92993F,
   1.09998F,   0.739990F,
   1.01996F,   1.42993F,
   0.539978F,   0.979980F,
   0.969971F,   2.18994F,
   1.09998F,   0.339844F,
   1.01996F,   1.00000F,
   0.500000F,   0.159912F,
   0.929993F,   3.39990F,
   0.869995F,   0.759766F,
   0.859985F,   1.13989F,
   0.329956F,   0.659912F,
   0.819946F,   1.59985F,
   0.759949F,   0.219971F,
   0.759949F,   0.649902F,
   0.229980F,   0.159912F,
   0.899963F,   5.73999F,
   1.16998F,   0.599854F,
   1.22998F,   1.23999F,
   0.419983F,   1.00000F,
   1.25000F,   2.08984F,
   1.19995F,   0.179932F,
   1.15997F,   1.03979F,
   0.479980F,   0.509766F,
   0.699951F,   3.00000F,
   0.969971F,   0.359863F,
   0.959961F,   1.12988F,
   0.559998F,   0.349854F,
   0.979980F,   1.70996F,
   0.904968F,   0.179932F,
   0.919983F,   0.549805F,
   0.309998F,   0.299805F,
   0.809998F,   4.22998F,
   1.00995F,   0.569824F,
   0.919983F,   1.41992F,
   0.239990F,   0.899902F,
   0.869995F,   2.09985F,
   1.02997F,   0.189941F,
   0.919983F,   0.929932F,
   0.369995F,   0.149902F,
   0.569946F,   2.25977F,
   0.809998F,   0.429932F,
   0.809998F,   0.859863F,
   0.149963F,   0.479980F,
   0.699951F,   1.34985F,
   0.639954F,   0.179932F,
   0.709961F,   0.779785F,
   0.0899658F,   0.189941F
};


#define DTX_VQ_SIZE 47
static const Word32 qua_gain_code_MR122[NB_QUA_CODE+VQ_SIZE_HIGHRATES+VQ_SIZE_LOWRATES+(MR475_VQ_SIZE*2)+DTX_VQ_SIZE+1] =
{
      - 3776,
      - 3394,
      - 3005,
      - 2615,
      - 2345,
      - 2138,
      - 1932,
      - 1726,
      - 1518,
      - 1314,
      - 1106,
      - 900,
      - 694,
      - 487,
      - 281,
      - 75,
      133,
      339,
      545,
      752,
      958,
      1165,
      1371,
      1577,
      1784,
      1991,
      2197,
      2404,
      2673,
      3060,
      3448,
      3836,
      /* high_rates */
      - 2692,
      - 1185,
      - 2008,
      - 1600,
      - 1560,
      - 1070,
      - 840,
      - 313,
      - 471,
      - 777,
      - 414,
      72,
      139,
      413,
      835,
      1163,
      - 2267,
      - 1478,
      - 963,
      - 1052,
      - 885,
      - 588,
      - 452,
      - 125,
      - 196,
      - 43,
      107,
      320,
      569,
      818,
      977,
      1523,
      - 1633,
      - 1391,
      - 1033,
      - 780,
      - 681,
      - 597,
      - 356,
      - 277,
      - 75,
      148,
      296,
      497,
      628,
      919,
      1117,
      1648,
      - 2119,
      - 1252,
      - 835,
      - 810,
      - 429,
      - 530,
      - 307,
      - 150,
      110,
      150,
      354,
      637,
      900,
      1049,
      1429,
      2135,
      - 1316,
      - 1026,
      - 766,
      - 465,
      - 413,
      - 167,
      - 119,
      62,
      253,
      424,
      590,
      678,
      937,
      1213,
      1532,
      1938,
      - 1445,
      - 832,
      - 723,
      - 365,
      - 207,
      - 50,
      50,
      242,
      422,
      584,
      768,
      930,
      1231,
      1280,
      1844,
      2669,
      - 1082,
      - 545,
      - 539,
      - 303,
      - 49,
      165,
      171,
      421,
      655,
      821,
      888,
      1100,
      1379,
      1565,
      1887,
      2406,
      - 999,
      - 375,
      - 264,
      - 25,
      54,
      314,
      409,
      610,
      795,
      966,
      1210,
      1210,
      1510,
      1866,
      2177,
      3072,
      /* low_rates */
      2879,
      - 570,
      703,
      876,
      1383,
      - 1731,
      113,
      - 1430,
      1686,
      - 731,
      244,
      - 731,
      964,
      - 1147,
      - 387,
      - 1213,
      2357,
      - 445,
      528,
      - 30,
      1158,
      - 1594,
      0,
      - 2708,
      1808,
      - 406,
      193,
      - 614,
      694,
      - 2237,
      - 637,
      - 2708,
      2582,
      - 755,
      318,
      0,
      1089,
      - 2534,
      58,
      - 995,
      1623,
      - 1510,
      180,
      - 1552,
      793,
      - 2534,
      - 884,
      - 1780,
      2131,
      - 831,
      518,
      - 156,
      1096,
      - 2454,
      - 107,
      - 2804,
      1204,
      - 1247,
      - 223,
      - 1084,
      443,
      - 2534,
      - 367,
      - 2454,
      /* MR475 */
      - 5120,
      - 4988,
      - 1896,
      - 274,
      - 2932,
      - 2726,
      - 1216,
      376,
      - 3536,
      - 3293,
      - 650,
      - 733,
      - 2418,
      - 2664,
      1053,
      - 1303,
      - 3337,
      - 3256,
      - 9,
      - 1732,
      - 2237,
      - 2076,
      - 332,
      252,
      - 1044,
      - 2350,
      262,
      - 1296,
      - 1385,
      - 827,
      - 1447,
      1309,
      - 3375,
      - 3386,
      - 1418,
      - 215,
      - 2731,
      - 2754,
      - 1610,
      594,
      - 2610,
      - 2821,
      - 1409,
      189,
      - 1292,
      - 1779,
      853,
      492,
      - 1865,
      - 1103,
      593,
      - 1211,
      - 1213,
      - 1407,
      - 201,
      621,
      - 1903,
      - 1270,
      191,
      - 310,
      - 1435,
      - 453,
      1386,
      728,
      - 2646,
      - 1689,
      - 60,
      - 609,
      - 2602,
      - 2409,
      356,
      396,
      - 2991,
      - 2775,
      - 150,
      - 785,
      - 2577,
      - 2506,
      1524,
      - 881,
      - 3119,
      - 3041,
      - 98,
      - 442,
      - 2134,
      - 1151,
      411,
      254,
      - 1075,
      - 1777,
      105,
      - 291,
      - 524,
      - 1519,
      - 1318,
      1895,
      - 2838,
      - 2972,
      - 216,
      - 812,
      - 2785,
      - 2677,
      - 221,
      1286,
      - 2792,
      - 2863,
      - 454,
      26,
      - 1379,
      - 1780,
      1211,
      287,
      - 1798,
      - 1868,
      440,
      - 647,
      - 1034,
      - 892,
      322,
      740,
      - 1572,
      - 823,
      558,
      - 511,
      - 860,
      - 714,
      1356,
      1502,
      - 3690,
      - 3448,
      - 496,
      - 632,
      - 2770,
      - 2706,
      - 768,
      867,
      - 2360,
      - 2301,
      - 734,
      - 211,
      - 2005,
      - 1530,
      970,
      - 246,
      - 2982,
      - 2646,
      23,
      - 1349,
      - 1868,
      - 694,
      - 137,
      369,
      - 1056,
      - 1263,
      369,
      - 1317,
      - 1249,
      - 351,
      572,
      1320,
      - 3289,
      - 3237,
      - 890,
      43,
      - 2411,
      - 2367,
      - 998,
      694,
      - 2089,
      - 2105,
      - 728,
      296,
      - 1019,
      - 1341,
      775,
      511,
      - 2362,
      - 1311,
      508,
      - 1432,
      - 653,
      - 1525,
      214,
      634,
      - 1158,
      - 862,
      162,
      - 92,
      - 846,
      - 345,
      2171,
      - 582,
      - 1579,
      - 2279,
      - 213,
      40,
      - 2653,
      - 2448,
      329,
      928,
      - 2424,
      - 1836,
      - 383,
      - 441,
      - 2272,
      - 2320,
      1888,
      - 1119,
      - 2186,
      - 1960,
      - 4,
      150,
      - 2341,
      - 1968,
      555,
      164,
      - 686,
      - 1856,
      - 19,
      - 656,
      - 597,
      - 928,
      - 353,
      2304,
      - 2190,
      - 1372,
      - 416,
      64,
      - 2353,
      - 2394,
      - 860,
      1028,
      - 1313,
      - 1187,
      - 551,
      388,
      - 767,
      - 1666,
      1017,
      1088,
      - 1020,
      - 1676,
      747,
      - 1107,
      - 211,
      - 1233,
      704,
      943,
      - 700,
      - 646,
      891,
      - 886,
      - 518,
      - 307,
      2354,
      1047,
      - 2789,
      - 2880,
      - 860,
      - 180,
      - 2504,
      - 2358,
      - 531,
      541,
      - 2940,
      - 2929,
      - 456,
      - 157,
      - 2416,
      - 2552,
      1121,
      - 434,
      - 2454,
      - 2353,
      316,
      - 752,
      - 1162,
      - 1739,
      154,
      144,
      - 469,
      - 1743,
      186,
      - 668,
      - 795,
      - 708,
      - 485,
      1595,
      - 2644,
      - 2564,
      - 1725,
      37,
      - 2651,
      - 2858,
      - 1044,
      1119,
      - 2269,
      - 2240,
      - 933,
      47,
      - 1698,
      - 1038,
      890,
      162,
      - 1049,
      - 1211,
      701,
      - 192,
      - 1379,
      - 1292,
      - 251,
      714,
      - 2073,
      - 983,
      305,
      61,
      - 1660,
      - 227,
      1830,
      760,
      - 2534,
      - 2304,
      - 520,
      - 216,
      - 1764,
      - 2245,
      181,
      508,
      - 2865,
      - 2868,
      - 128,
      - 389,
      - 2492,
      - 2500,
      1478,
      - 913,
      - 2813,
      - 2657,
      18,
      - 307,
      - 1326,
      - 839,
      438,
      430,
      - 516,
      - 1644,
      388,
      - 54,
      - 133,
      - 1550,
      - 9,
      1985,
      - 1300,
      - 2265,
      161,
      - 317,
      - 2385,
      - 2227,
      65,
      1055,
      - 1960,
      - 2297,
      - 116,
      170,
      - 1451,
      - 912,
      1273,
      143,
      - 1963,
      - 927,
      581,
      126,
      - 1362,
      - 430,
      340,
      806,
      - 704,
      - 868,
      615,
      - 272,
      - 291,
      - 1070,
      1691,
      1985,
      - 2054,
      - 2262,
      72,
      - 168,
      - 1881,
      - 1532,
      - 900,
      715,
      - 1808,
      - 2415,
      - 271,
      - 81,
      - 981,
      - 959,
      1135,
      - 672,
      - 1768,
      - 2389,
      109,
      - 1013,
      - 539,
      - 881,
      134,
      405,
      - 582,
      - 974,
      429,
      - 569,
      - 605,
      - 80,
      244,
      1613,
      - 2089,
      - 2101,
      - 421,
      400,
      - 1328,
      - 1835,
      - 811,
      792,
      - 1424,
      - 1905,
      - 1453,
      403,
      - 1012,
      - 949,
      1033,
      640,
      - 1480,
      - 686,
      751,
      - 516,
      - 283,
      - 1190,
      215,
      852,
      - 572,
      - 310,
      310,
      210,
      - 806,
      101,
      2760,
      - 427,
      - 1420,
      - 1983,
      269,
      - 217,
      - 2275,
      - 2321,
      104,
      939,
      - 2055,
      - 2137,
      - 52,
      - 262,
      - 2110,
      - 2139,
      1693,
      37,
      - 1789,
      - 2387,
      334,
      264,
      - 1216,
      - 49,
      607,
      546,
      - 267,
      - 1081,
      346,
      - 457,
      - 116,
      - 810,
      - 592,
      2750,
      - 1710,
      - 2070,
      - 182,
      439,
      - 2418,
      - 2221,
      - 428,
      1359,
      - 653,
      - 1732,
      - 288,
      361,
      - 1318,
      - 378,
      1426,
      759,
      - 854,
      - 767,
      773,
      - 283,
      - 321,
      - 775,
      730,
      1302,
      - 669,
      - 393,
      945,
      - 80,
      - 158,
      - 284,
      2295,
      2557,
      /* dtx */
      - 1921,
      - 1878,
      - 1836,
      - 1793,
      - 1751,
      - 1708,
      - 1666,
      - 1623,
      - 1581,
      - 1538,
      - 1495,
      - 1453,
      - 1410,
      - 1368,
      - 1325,
      - 1283,
      - 1240,
      - 1198,
      - 1155,
      - 1113,
      - 1070,
      - 1028,
      - 985,
      - 943,
      - 900,
      - 858,
      - 815,
      - 773,
      - 730,
      - 688,
      - 645,
      - 602,
      - 560,
      - 517,
      - 475,
      - 432,
      - 390,
      - 347,
      - 305,
      - 262,
      - 220,
      - 177,
      - 135,
      - 92,
      - 50,
      - 7,
      0,
      /* init value */
      - 2381
};


static const Word32 qua_gain_code[NB_QUA_CODE+VQ_SIZE_HIGHRATES+VQ_SIZE_LOWRATES+(MR475_VQ_SIZE*2)+DTX_VQ_SIZE+3] =
{
      - 22731,
      - 20428,
      - 18088,
      - 15739,
      - 14113,
      - 12867,
      - 11629,
      - 10387,
      - 9139,
      - 7906,
      - 6656,
      - 5416,
      - 4173,
      - 2931,
      - 1688,
      - 445,
      801,
      2044,
      3285,
      4530,
      5772,
      7016,
      8259,
      9501,
      10745,
      11988,
      13231,
      14474,
      16096,
      18429,
      20763,
      23097,
      /* high rates */
      - 16214,
      - 7135,
      - 12086,
      - 9629,
      - 9394,
      - 6442,
      - 5056,
      - 1885,
      - 2838,
      - 4681,
      - 2490,
      434,
      836,
      2484,
      5030,
      7002,
      - 13647,
      - 8900,
      - 5800,
      - 6335,
      - 5327,
      - 3537,
      - 2724,
      - 751,
      - 1177,
      - 260,
      645,
      1928,
      3426,
      4926,
      5885,
      9172,
      - 9831,
      - 8380,
      - 6220,
      - 4700,
      - 4099,
      - 3595,
      - 2144,
      - 1669,
      - 454,
      891,
      1781,
      2993,
      3782,
      5534,
      6728,
      9921,
      - 12753,
      - 7539,
      - 5024,
      - 4872,
      - 2580,
      - 3192,
      - 1848,
      - 904,
      663,
      902,
      2132,
      3837,
      5420,
      6312,
      8604,
      12853,
      - 7921,
      - 6179,
      - 4610,
      - 2802,
      - 2482,
      - 1006,
      - 713,
      374,
      1523,
      2552,
      3551,
      4084,
      5639,
      7304,
      9221,
      11667,
      - 8700,
      - 5007,
      - 4352,
      - 2197,
      - 1247,
      - 300,
      298,
      1454,
      2542,
      3518,
      4623,
      5602,
      7413,
      7706,
      11102,
      16067,
      - 6517,
      - 3283,
      - 3248,
      - 1825,
      - 294,
      992,
      1030,
      2537,
      3945,
      4944,
      5343,
      6622,
      8303,
      9423,
      11360,
      14483,
      - 6013,
      - 2257,
      - 1589,
      - 151,
      326,
      1890,
      2461,
      3676,
      4784,
      5816,
      7283,
      7284,
      9089,
      11234,
      13108,
      18494,
      /* low_rates */
      17333,
      - 3431,
      4235,
      5276,
      8325,
      - 10422,
      683,
      - 8609,
      10148,
      - 4398,
      1472,
      - 4398,
      5802,
      - 6907,
      - 2327,
      - 7303,
      14189,
      - 2678,
      3181,
      - 180,
      6972,
      - 9599,
      0,
      - 16305,
      10884,
      - 2444,
      1165,
      - 3697,
      4180,
      - 13468,
      - 3833,
      - 16305,
      15543,
      - 4546,
      1913,
      0,
      6556,
      - 15255,
      347,
      - 5993,
      9771,
      - 9090,
      1086,
      - 9341,
      4772,
      - 15255,
      - 5321,
      - 10714,
      12827,
      - 5002,
      3118,
      - 938,
      6598,
      - 14774,
      - 646,
      - 16879,
      7251,
      - 7508,
      - 1343,
      - 6529,
      2668,
      - 15255,
      - 2212,
      - 14774,
      /* MR475 */
      - 30825,
      - 30028,
      - 11416,
      - 1652,
      - 17651,
      - 16414,
      - 7323,
      2266,
      - 21289,
      - 19823,
      - 3914,
      - 4413,
      - 14560,
      - 16037,
      6338,
      - 7842,
      - 20089,
      - 19604,
      - 53,
      - 10430,
      - 13469,
      - 12497,
      - 2001,
      1517,
      - 6283,
      - 14145,
      1579,
      - 7801,
      - 8339,
      - 4977,
      - 8713,
      7881,
      - 20321,
      - 20385,
      - 8535,
      - 1296,
      - 16442,
      - 16581,
      - 9696,
      3577,
      - 15714,
      - 16981,
      - 8484,
      1135,
      - 7780,
      - 10708,
      5136,
      2962,
      - 11229,
      - 6643,
      3572,
      - 7294,
      - 7304,
      - 8473,
      - 1208,
      3739,
      - 11455,
      - 7646,
      1150,
      - 1866,
      - 8638,
      - 2726,
      8342,
      4384,
      - 15933,
      - 10167,
      - 362,
      - 3665,
      - 15663,
      - 14504,
      2142,
      2387,
      - 18006,
      - 16707,
      - 905,
      - 4726,
      - 15513,
      - 15088,
      9173,
      - 5305,
      - 18778,
      - 18307,
      - 591,
      - 2661,
      - 12849,
      - 6927,
      2472,
      1527,
      - 6470,
      - 10701,
      632,
      - 1754,
      - 3155,
      - 9145,
      - 7938,
      11408,
      - 17085,
      - 17891,
      - 1301,
      - 4889,
      - 16764,
      - 16117,
      - 1333,
      7744,
      - 16808,
      - 17234,
      - 2732,
      154,
      - 8300,
      - 10715,
      7291,
      1731,
      - 10824,
      - 11244,
      2652,
      - 3894,
      - 6227,
      - 5372,
      1937,
      4457,
      - 9466,
      - 4954,
      3358,
      - 3075,
      - 5176,
      - 4297,
      8162,
      9040,
      - 22215,
      - 20758,
      - 2986,
      - 3807,
      - 16679,
      - 16291,
      - 4626,
      5220,
      - 14210,
      - 13852,
      - 4420,
      - 1271,
      - 12073,
      - 9212,
      5842,
      - 1481,
      - 17956,
      - 15933,
      137,
      - 8120,
      - 11244,
      - 4180,
      - 826,
      2224,
      - 6359,
      - 7605,
      2219,
      - 7927,
      - 7518,
      - 2111,
      3447,
      7949,
      - 19803,
      - 19487,
      - 5360,
      259,
      - 14515,
      - 14253,
      - 6011,
      4180,
      - 12577,
      - 12676,
      - 4384,
      1784,
      - 6135,
      - 8071,
      4665,
      3078,
      - 14220,
      - 7896,
      3060,
      - 8621,
      - 3931,
      - 9182,
      1285,
      3816,
      - 6974,
      - 5192,
      975,
      - 554,
      - 5091,
      - 2075,
      13071,
      - 3502,
      - 9504,
      - 13719,
      - 1280,
      244,
      - 15972,
      - 14740,
      1981,
      5587,
      - 14593,
      - 11054,
      - 2308,
      - 2656,
      - 13678,
      - 13966,
      11370,
      - 6739,
      - 13158,
      - 11799,
      - 27,
      901,
      - 14092,
      - 11849,
      3344,
      989,
      - 4132,
      - 11176,
      - 114,
      - 3951,
      - 3596,
      - 5586,
      - 2124,
      13869,
      - 13187,
      - 8262,
      - 2502,
      384,
      - 14166,
      - 14416,
      - 5176,
      6192,
      - 7906,
      - 7147,
      - 3320,
      2336,
      - 4615,
      - 10032,
      6125,
      6551,
      - 6144,
      - 10092,
      4495,
      - 6666,
      - 1273,
      - 7423,
      4241,
      5680,
      - 4212,
      - 3891,
      5366,
      - 5337,
      - 3121,
      - 1847,
      14175,
      6302,
      - 16793,
      - 17341,
      - 5176,
      - 1085,
      - 15076,
      - 14199,
      - 3195,
      3257,
      - 17698,
      - 17635,
      - 2746,
      - 946,
      - 14548,
      - 15365,
      6748,
      - 2615,
      - 14774,
      - 14166,
      1904,
      - 4525,
      - 6998,
      - 10472,
      928,
      865,
      - 2821,
      - 10493,
      1122,
      - 4019,
      - 4785,
      - 4261,
      - 2922,
      9604,
      - 15920,
      - 15438,
      - 10388,
      222,
      - 15959,
      - 17204,
      - 6283,
      6737,
      - 13658,
      - 13488,
      - 5618,
      280,
      - 10222,
      - 6248,
      5358,
      977,
      - 6319,
      - 7294,
      4218,
      - 1156,
      - 8300,
      - 7780,
      - 1514,
      4296,
      - 12479,
      - 5917,
      1839,
      367,
      - 9992,
      - 1369,
      11020,
      4578,
      - 15255,
      - 13873,
      - 3133,
      - 1298,
      - 10621,
      - 13518,
      1087,
      3057,
      - 17250,
      - 17265,
      - 774,
      - 2339,
      - 15006,
      - 15053,
      8896,
      - 5497,
      - 16938,
      - 15998,
      107,
      - 1850,
      - 7980,
      - 5053,
      2639,
      2590,
      - 3108,
      - 9898,
      2333,
      - 323,
      - 800,
      - 9329,
      - 57,
      11948,
      - 7827,
      - 13638,
      967,
      - 1906,
      - 14361,
      - 13410,
      392,
      6353,
      - 11799,
      - 13831,
      - 698,
      1024,
      - 8736,
      - 5489,
      7665,
      861,
      - 11816,
      - 5582,
      3495,
      761,
      - 8201,
      - 2588,
      2045,
      4850,
      - 4240,
      - 5223,
      3705,
      - 1636,
      - 1754,
      - 6443,
      10180,
      11952,
      - 12365,
      - 13618,
      433,
      - 1009,
      - 11322,
      - 9225,
      - 5421,
      4302,
      - 10883,
      - 14537,
      - 1633,
      - 489,
      - 5904,
      - 5771,
      6831,
      - 4047,
      - 10643,
      - 14383,
      656,
      - 6097,
      - 3245,
      - 5305,
      809,
      2438,
      - 3502,
      - 5862,
      2584,
      - 3429,
      - 3642,
      - 482,
      1471,
      9712,
      - 12577,
      - 12649,
      - 2533,
      2410,
      - 7996,
      - 11047,
      - 4882,
      4768,
      - 8575,
      - 11470,
      - 8747,
      2427,
      - 6092,
      - 5713,
      6222,
      3854,
      - 8911,
      - 4132,
      4521,
      - 3108,
      - 1704,
      - 7162,
      1293,
      5132,
      - 3445,
      - 1866,
      1868,
      1264,
      - 4855,
      608,
      16615,
      - 2571,
      - 8552,
      - 11940,
      1620,
      - 1308,
      - 13699,
      - 13976,
      626,
      5652,
      - 12374,
      - 12868,
      - 312,
      - 1579,
      - 12703,
      - 12877,
      10194,
      222,
      - 10773,
      - 14372,
      2009,
      1590,
      - 7323,
      - 296,
      3655,
      3289,
      - 1605,
      - 6506,
      2082,
      - 2752,
      - 696,
      - 4878,
      - 3567,
      16558,
      - 10297,
      - 12462,
      - 1094,
      2640,
      - 14560,
      - 13370,
      - 2577,
      8180,
      - 3931,
      - 10430,
      - 1733,
      2173,
      - 7938,
      - 2274,
      8585,
      4567,
      - 5141,
      - 4619,
      4655,
      - 1707,
      - 1931,
      - 4666,
      4396,
      7837,
      - 4026,
      - 2364,
      5687,
      - 482,
      - 948,
      - 1709,
      13820,
      15394,
      /* dtx */
      - 11560,
      - 11304,
      - 11048,
      - 10792,
      - 10536,
      - 10280,
      - 10024,
      - 9768,
      - 9512,
      - 9256,
      - 9000,
      - 8744,
      - 8488,
      - 8232,
      - 7976,
      - 7720,
      - 7464,
      - 7208,
      - 6952,
      - 6696,
      - 6440,
      - 6184,
      - 5928,
      - 5672,
      - 5416,
      - 5160,
      - 4904,
      - 4648,
      - 4392,
      - 4136,
      - 3880,
      - 3624,
      - 3368,
      - 3112,
      - 2856,
      - 2600,
      - 2344,
      - 2088,
      - 1832,
      - 1576,
      - 1320,
      - 1064,
      - 808,
      - 552,
      - 296,
      - 40,
      0,
      /* init value */
      - 14336,
      /* min */
      - 32767,
      /* max */
      18284

};
/*
 * LP analysis is performed twice per frame using two different asymmetric windows.
 * The second window has its weight concentrated at the fourth subframe
 * and it consists of two parts:
 * the first part is half a Hamming window and
 * the second part is a quarter of a cosine function cycle.
 */
static const real_t window_200_40[240] =
{
   REAL_CONST(0.0800000F),
   REAL_CONST(0.0800570F),
   REAL_CONST(0.0802281F),
   REAL_CONST(0.0805132F),
   REAL_CONST(0.0809123F),
   REAL_CONST(0.0814251F),
   REAL_CONST(0.0820517F),
   REAL_CONST(0.0827919F),
   REAL_CONST(0.0836454F),
   REAL_CONST(0.0846121F),
   REAL_CONST(0.0856917F),
   REAL_CONST(0.0868840F),
   REAL_CONST(0.0881886F),
   REAL_CONST(0.0896053F),
   REAL_CONST(0.0911337F),
   REAL_CONST(0.0927733F),
   REAL_CONST(0.0945239F),
   REAL_CONST(0.0963849F),
   REAL_CONST(0.0983560F),
   REAL_CONST(0.100437F),
   REAL_CONST(0.102626F),
   REAL_CONST(0.104924F),
   REAL_CONST(0.107330F),
   REAL_CONST(0.109843F),
   REAL_CONST(0.112463F),
   REAL_CONST(0.115189F),
   REAL_CONST(0.118020F),
   REAL_CONST(0.120956F),
   REAL_CONST(0.123996F),
   REAL_CONST(0.127139F),
   REAL_CONST(0.130384F),
   REAL_CONST(0.133731F),
   REAL_CONST(0.137178F),
   REAL_CONST(0.140726F),
   REAL_CONST(0.144372F),
   REAL_CONST(0.148117F),
   REAL_CONST(0.151959F),
   REAL_CONST(0.155897F),
   REAL_CONST(0.159930F),
   REAL_CONST(0.164058F),
   REAL_CONST(0.168278F),
   REAL_CONST(0.172591F),
   REAL_CONST(0.176995F),
   REAL_CONST(0.181489F),
   REAL_CONST(0.186072F),
   REAL_CONST(0.190743F),
   REAL_CONST(0.195500F),
   REAL_CONST(0.200343F),
   REAL_CONST(0.205270F),
   REAL_CONST(0.210280F),
   REAL_CONST(0.215372F),
   REAL_CONST(0.220544F),
   REAL_CONST(0.225795F),
   REAL_CONST(0.231125F),
   REAL_CONST(0.236531F),
   REAL_CONST(0.242012F),
   REAL_CONST(0.247567F),
   REAL_CONST(0.253195F),
   REAL_CONST(0.258893F),
   REAL_CONST(0.264662F),
   REAL_CONST(0.270499F),
   REAL_CONST(0.276402F),
   REAL_CONST(0.282371F),
   REAL_CONST(0.288404F),
   REAL_CONST(0.294499F),
   REAL_CONST(0.300655F),
   REAL_CONST(0.306871F),
   REAL_CONST(0.313144F),
   REAL_CONST(0.319473F),
   REAL_CONST(0.325857F),
   REAL_CONST(0.332295F),
   REAL_CONST(0.338783F),
   REAL_CONST(0.345322F),
   REAL_CONST(0.351909F),
   REAL_CONST(0.358543F),
   REAL_CONST(0.365221F),
   REAL_CONST(0.371943F),
   REAL_CONST(0.378707F),
   REAL_CONST(0.385510F),
   REAL_CONST(0.392352F),
   REAL_CONST(0.399231F),
   REAL_CONST(0.406144F),
   REAL_CONST(0.413091F),
   REAL_CONST(0.420069F),
   REAL_CONST(0.427077F),
   REAL_CONST(0.434112F),
   REAL_CONST(0.441175F),
   REAL_CONST(0.448261F),
   REAL_CONST(0.455371F),
   REAL_CONST(0.462501F),
   REAL_CONST(0.469650F),
   REAL_CONST(0.476817F),
   REAL_CONST(0.484000F),
   REAL_CONST(0.491197F),
   REAL_CONST(0.498405F),
   REAL_CONST(0.505624F),
   REAL_CONST(0.512852F),
   REAL_CONST(0.520086F),
   REAL_CONST(0.527325F),
   REAL_CONST(0.534567F),
   REAL_CONST(0.541811F),
   REAL_CONST(0.549054F),
   REAL_CONST(0.556295F),
   REAL_CONST(0.563532F),
   REAL_CONST(0.570763F),
   REAL_CONST(0.577986F),
   REAL_CONST(0.585201F),
   REAL_CONST(0.592403F),
   REAL_CONST(0.599593F),
   REAL_CONST(0.606768F),
   REAL_CONST(0.613927F),
   REAL_CONST(0.621067F),
   REAL_CONST(0.628187F),
   REAL_CONST(0.635285F),
   REAL_CONST(0.642360F),
   REAL_CONST(0.649409F),
   REAL_CONST(0.656431F),
   REAL_CONST(0.663424F),
   REAL_CONST(0.670387F),
   REAL_CONST(0.677317F),
   REAL_CONST(0.684213F),
   REAL_CONST(0.691073F),
   REAL_CONST(0.697896F),
   REAL_CONST(0.704680F),
   REAL_CONST(0.711423F),
   REAL_CONST(0.718124F),
   REAL_CONST(0.724780F),
   REAL_CONST(0.731390F),
   REAL_CONST(0.737953F),
   REAL_CONST(0.744467F),
   REAL_CONST(0.750930F),
   REAL_CONST(0.757341F),
   REAL_CONST(0.763698F),
   REAL_CONST(0.770000F),
   REAL_CONST(0.776245F),
   REAL_CONST(0.782430F),
   REAL_CONST(0.788556F),
   REAL_CONST(0.794620F),
   REAL_CONST(0.800622F),
   REAL_CONST(0.806558F),
   REAL_CONST(0.812428F),
   REAL_CONST(0.818231F),
   REAL_CONST(0.823965F),
   REAL_CONST(0.829628F),
   REAL_CONST(0.835220F),
   REAL_CONST(0.840738F),
   REAL_CONST(0.846182F),
   REAL_CONST(0.851550F),
   REAL_CONST(0.856840F),
   REAL_CONST(0.862052F),
   REAL_CONST(0.867184F),
   REAL_CONST(0.872235F),
   REAL_CONST(0.877204F),
   REAL_CONST(0.882089F),
   REAL_CONST(0.886889F),
   REAL_CONST(0.891603F),
   REAL_CONST(0.896230F),
   REAL_CONST(0.900769F),
   REAL_CONST(0.905218F),
   REAL_CONST(0.909577F),
   REAL_CONST(0.913844F),
   REAL_CONST(0.918018F),
   REAL_CONST(0.922098F),
   REAL_CONST(0.926084F),
   REAL_CONST(0.929974F),
   REAL_CONST(0.933767F),
   REAL_CONST(0.937463F),
   REAL_CONST(0.941060F),
   REAL_CONST(0.944558F),
   REAL_CONST(0.947955F),
   REAL_CONST(0.951251F),
   REAL_CONST(0.954446F),
   REAL_CONST(0.957537F),
   REAL_CONST(0.960525F),
   REAL_CONST(0.963409F),
   REAL_CONST(0.966187F),
   REAL_CONST(0.968860F),
   REAL_CONST(0.971427F),
   REAL_CONST(0.973886F),
   REAL_CONST(0.976238F),
   REAL_CONST(0.978482F),
   REAL_CONST(0.980617F),
   REAL_CONST(0.982643F),
   REAL_CONST(0.984559F),
   REAL_CONST(0.986365F),
   REAL_CONST(0.988060F),
   REAL_CONST(0.989644F),
   REAL_CONST(0.991117F),
   REAL_CONST(0.992478F),
   REAL_CONST(0.993726F),
   REAL_CONST(0.994862F),
   REAL_CONST(0.995885F),
   REAL_CONST(0.996796F),
   REAL_CONST(0.997592F),
   REAL_CONST(0.998276F),
   REAL_CONST(0.998846F),
   REAL_CONST(0.999301F),
   REAL_CONST(0.999644F),
   REAL_CONST(0.999872F),
   REAL_CONST(0.999986F),
   REAL_CONST(1.00000F),
   REAL_CONST(0.999219F),
   REAL_CONST(0.996878F),
   REAL_CONST(0.992981F),
   REAL_CONST(0.987533F),
   REAL_CONST(0.980544F),
   REAL_CONST(0.972023F),
   REAL_CONST(0.961985F),
   REAL_CONST(0.950444F),
   REAL_CONST(0.937420F),
   REAL_CONST(0.922932F),
   REAL_CONST(0.907002F),
   REAL_CONST(0.889657F),
   REAL_CONST(0.870923F),
   REAL_CONST(0.850828F),
   REAL_CONST(0.829406F),
   REAL_CONST(0.806688F),
   REAL_CONST(0.782711F),
   REAL_CONST(0.757511F),
   REAL_CONST(0.731129F),
   REAL_CONST(0.703605F),
   REAL_CONST(0.674983F),
   REAL_CONST(0.645307F),
   REAL_CONST(0.614623F),
   REAL_CONST(0.582980F),
   REAL_CONST(0.550426F),
   REAL_CONST(0.517013F),
   REAL_CONST(0.482792F),
   REAL_CONST(0.447818F),
   REAL_CONST(0.412145F),
   REAL_CONST(0.375828F),
   REAL_CONST(0.338924F),
   REAL_CONST(0.301491F),
   REAL_CONST(0.263587F),
   REAL_CONST(0.225272F),
   REAL_CONST(0.186605F),
   REAL_CONST(0.147647F),
   REAL_CONST(0.108458F),
   REAL_CONST(0.0690994F),
   REAL_CONST(0.0296333F)
};

/*
 * LP analysis is performed twice per frame using two different asymmetric windows.
 * The second window has its weight concentrated at the fourth subframe
 * and it consists of two parts:
 * the first part is half a Hamming window and
 * the second part is a quarter of a cosine function cycle.
 */
static const real_t window_232_8[240] =
{
   REAL_CONST(0.0800000F),
   REAL_CONST(0.0800424F),
   REAL_CONST(0.0801694F),
   REAL_CONST(0.0803812F),
   REAL_CONST(0.0806775F),
   REAL_CONST(0.0810585F),
   REAL_CONST(0.0815240F),
   REAL_CONST(0.0820739F),
   REAL_CONST(0.0827082F),
   REAL_CONST(0.0834267F),
   REAL_CONST(0.0842292F),
   REAL_CONST(0.0851157F),
   REAL_CONST(0.0860859F),
   REAL_CONST(0.0871398F),
   REAL_CONST(0.0882770F),
   REAL_CONST(0.0894975F),
   REAL_CONST(0.0908009F),
   REAL_CONST(0.0921870F),
   REAL_CONST(0.0936556F),
   REAL_CONST(0.0952064F),
   REAL_CONST(0.0968391F),
   REAL_CONST(0.0985534F),
   REAL_CONST(0.100349F),
   REAL_CONST(0.102226F),
   REAL_CONST(0.104183F),
   REAL_CONST(0.106220F),
   REAL_CONST(0.108338F),
   REAL_CONST(0.110534F),
   REAL_CONST(0.112810F),
   REAL_CONST(0.115165F),
   REAL_CONST(0.117598F),
   REAL_CONST(0.120108F),
   REAL_CONST(0.122696F),
   REAL_CONST(0.125361F),
   REAL_CONST(0.128102F),
   REAL_CONST(0.130919F),
   REAL_CONST(0.133812F),
   REAL_CONST(0.136779F),
   REAL_CONST(0.139820F),
   REAL_CONST(0.142935F),
   REAL_CONST(0.146123F),
   REAL_CONST(0.149384F),
   REAL_CONST(0.152717F),
   REAL_CONST(0.156121F),
   REAL_CONST(0.159596F),
   REAL_CONST(0.163140F),
   REAL_CONST(0.166754F),
   REAL_CONST(0.170437F),
   REAL_CONST(0.174188F),
   REAL_CONST(0.178007F),
   REAL_CONST(0.181892F),
   REAL_CONST(0.185843F),
   REAL_CONST(0.189859F),
   REAL_CONST(0.193939F),
   REAL_CONST(0.198084F),
   REAL_CONST(0.202291F),
   REAL_CONST(0.206561F),
   REAL_CONST(0.210892F),
   REAL_CONST(0.215283F),
   REAL_CONST(0.219734F),
   REAL_CONST(0.224245F),
   REAL_CONST(0.228813F),
   REAL_CONST(0.233439F),
   REAL_CONST(0.238121F),
   REAL_CONST(0.242859F),
   REAL_CONST(0.247652F),
   REAL_CONST(0.252498F),
   REAL_CONST(0.257397F),
   REAL_CONST(0.262349F),
   REAL_CONST(0.267351F),
   REAL_CONST(0.272404F),
   REAL_CONST(0.277506F),
   REAL_CONST(0.282656F),
   REAL_CONST(0.287854F),
   REAL_CONST(0.293098F),
   REAL_CONST(0.298388F),
   REAL_CONST(0.303722F),
   REAL_CONST(0.309100F),
   REAL_CONST(0.314520F),
   REAL_CONST(0.319981F),
   REAL_CONST(0.325484F),
   REAL_CONST(0.331025F),
   REAL_CONST(0.336606F),
   REAL_CONST(0.342223F),
   REAL_CONST(0.347877F),
   REAL_CONST(0.353567F),
   REAL_CONST(0.359290F),
   REAL_CONST(0.365048F),
   REAL_CONST(0.370837F),
   REAL_CONST(0.376657F),
   REAL_CONST(0.382508F),
   REAL_CONST(0.388387F),
   REAL_CONST(0.394295F),
   REAL_CONST(0.400229F),
   REAL_CONST(0.406189F),
   REAL_CONST(0.412174F),
   REAL_CONST(0.418182F),
   REAL_CONST(0.424213F),
   REAL_CONST(0.430265F),
   REAL_CONST(0.436337F),
   REAL_CONST(0.442428F),
   REAL_CONST(0.448537F),
   REAL_CONST(0.454663F),
   REAL_CONST(0.460805F),
   REAL_CONST(0.466961F),
   REAL_CONST(0.473131F),
   REAL_CONST(0.479313F),
   REAL_CONST(0.485507F),
   REAL_CONST(0.491710F),
   REAL_CONST(0.497922F),
   REAL_CONST(0.504142F),
   REAL_CONST(0.510369F),
   REAL_CONST(0.516601F),
   REAL_CONST(0.522837F),
   REAL_CONST(0.529077F),
   REAL_CONST(0.535318F),
   REAL_CONST(0.541561F),
   REAL_CONST(0.547803F),
   REAL_CONST(0.554043F),
   REAL_CONST(0.560281F),
   REAL_CONST(0.566516F),
   REAL_CONST(0.572745F),
   REAL_CONST(0.578969F),
   REAL_CONST(0.585185F),
   REAL_CONST(0.591393F),
   REAL_CONST(0.597591F),
   REAL_CONST(0.603779F),
   REAL_CONST(0.609955F),
   REAL_CONST(0.616119F),
   REAL_CONST(0.622268F),
   REAL_CONST(0.628402F),
   REAL_CONST(0.634520F),
   REAL_CONST(0.640620F),
   REAL_CONST(0.646702F),
   REAL_CONST(0.652764F),
   REAL_CONST(0.658805F),
   REAL_CONST(0.664825F),
   REAL_CONST(0.670822F),
   REAL_CONST(0.676794F),
   REAL_CONST(0.682741F),
   REAL_CONST(0.688662F),
   REAL_CONST(0.694556F),
   REAL_CONST(0.700421F),
   REAL_CONST(0.706257F),
   REAL_CONST(0.712062F),
   REAL_CONST(0.717835F),
   REAL_CONST(0.723576F),
   REAL_CONST(0.729282F),
   REAL_CONST(0.734954F),
   REAL_CONST(0.740590F),
   REAL_CONST(0.746189F),
   REAL_CONST(0.751750F),
   REAL_CONST(0.757272F),
   REAL_CONST(0.762755F),
   REAL_CONST(0.768196F),
   REAL_CONST(0.773595F),
   REAL_CONST(0.778951F),
   REAL_CONST(0.784263F),
   REAL_CONST(0.789530F),
   REAL_CONST(0.794751F),
   REAL_CONST(0.799925F),
   REAL_CONST(0.805051F),
   REAL_CONST(0.810129F),
   REAL_CONST(0.815156F),
   REAL_CONST(0.820133F),
   REAL_CONST(0.825059F),
   REAL_CONST(0.829932F),
   REAL_CONST(0.834751F),
   REAL_CONST(0.839517F),
   REAL_CONST(0.844227F),
   REAL_CONST(0.848881F),
   REAL_CONST(0.853478F),
   REAL_CONST(0.858018F),
   REAL_CONST(0.862499F),
   REAL_CONST(0.866920F),
   REAL_CONST(0.871282F),
   REAL_CONST(0.875582F),
   REAL_CONST(0.879820F),
   REAL_CONST(0.883996F),
   REAL_CONST(0.888109F),
   REAL_CONST(0.892157F),
   REAL_CONST(0.896141F),
   REAL_CONST(0.900059F),
   REAL_CONST(0.903911F),
   REAL_CONST(0.907696F),
   REAL_CONST(0.911413F),
   REAL_CONST(0.915061F),
   REAL_CONST(0.918641F),
   REAL_CONST(0.922151F),
   REAL_CONST(0.925590F),
   REAL_CONST(0.928958F),
   REAL_CONST(0.932255F),
   REAL_CONST(0.935480F),
   REAL_CONST(0.938632F),
   REAL_CONST(0.941710F),
   REAL_CONST(0.944714F),
   REAL_CONST(0.947644F),
   REAL_CONST(0.950499F),
   REAL_CONST(0.953278F),
   REAL_CONST(0.955981F),
   REAL_CONST(0.958607F),
   REAL_CONST(0.961157F),
   REAL_CONST(0.963628F),
   REAL_CONST(0.966022F),
   REAL_CONST(0.968338F),
   REAL_CONST(0.970574F),
   REAL_CONST(0.972731F),
   REAL_CONST(0.974809F),
   REAL_CONST(0.976806F),
   REAL_CONST(0.978723F),
   REAL_CONST(0.980559F),
   REAL_CONST(0.982314F),
   REAL_CONST(0.983988F),
   REAL_CONST(0.985579F),
   REAL_CONST(0.987089F),
   REAL_CONST(0.988516F),
   REAL_CONST(0.989861F),
   REAL_CONST(0.991123F),
   REAL_CONST(0.992302F),
   REAL_CONST(0.993398F),
   REAL_CONST(0.994410F),
   REAL_CONST(0.995338F),
   REAL_CONST(0.996183F),
   REAL_CONST(0.996943F),
   REAL_CONST(0.997619F),
   REAL_CONST(0.998212F),
   REAL_CONST(0.998719F),
   REAL_CONST(0.999143F),
   REAL_CONST(0.999481F),
   REAL_CONST(0.999735F),
   REAL_CONST(0.999905F),
   REAL_CONST(0.999989F),
   REAL_CONST(1.00000F),
   REAL_CONST(0.979530F),
   REAL_CONST(0.918958F),
   REAL_CONST(0.820763F),
   REAL_CONST(0.688967F),
   REAL_CONST(0.528964F),
   REAL_CONST(0.347305F),
   REAL_CONST(0.151428F)
};

/*
 * LP analysis is performed twice per frame using two different asymmetric windows.
 * The first window has its weight concentrated at the second subframe
 * and it consists of two halves of Hamming windows with different sizes
 */
static const real_t window_160_80[240] =
{
   REAL_CONST(0.0800000F),
   REAL_CONST(0.0800898F),
   REAL_CONST(0.0803591F),
   REAL_CONST(0.0808079F),
   REAL_CONST(0.0814359F),
   REAL_CONST(0.0822430F),
   REAL_CONST(0.0832287F),
   REAL_CONST(0.0843928F),
   REAL_CONST(0.0857347F),
   REAL_CONST(0.0872539F),
   REAL_CONST(0.0889499F),
   REAL_CONST(0.0908220F),
   REAL_CONST(0.0928695F),
   REAL_CONST(0.0950914F),
   REAL_CONST(0.0974871F),
   REAL_CONST(0.100056F),
   REAL_CONST(0.102796F),
   REAL_CONST(0.105707F),
   REAL_CONST(0.108787F),
   REAL_CONST(0.112036F),
   REAL_CONST(0.115451F),
   REAL_CONST(0.119033F),
   REAL_CONST(0.122779F),
   REAL_CONST(0.126688F),
   REAL_CONST(0.130758F),
   REAL_CONST(0.134988F),
   REAL_CONST(0.139376F),
   REAL_CONST(0.143920F),
   REAL_CONST(0.148619F),
   REAL_CONST(0.153471F),
   REAL_CONST(0.158473F),
   REAL_CONST(0.163625F),
   REAL_CONST(0.168924F),
   REAL_CONST(0.174367F),
   REAL_CONST(0.179953F),
   REAL_CONST(0.185680F),
   REAL_CONST(0.191545F),
   REAL_CONST(0.197546F),
   REAL_CONST(0.203681F),
   REAL_CONST(0.209947F),
   REAL_CONST(0.216342F),
   REAL_CONST(0.222863F),
   REAL_CONST(0.229508F),
   REAL_CONST(0.236274F),
   REAL_CONST(0.243159F),
   REAL_CONST(0.250160F),
   REAL_CONST(0.257273F),
   REAL_CONST(0.264498F),
   REAL_CONST(0.271829F),
   REAL_CONST(0.279266F),
   REAL_CONST(0.286804F),
   REAL_CONST(0.294441F),
   REAL_CONST(0.302174F),
   REAL_CONST(0.310000F),
   REAL_CONST(0.317916F),
   REAL_CONST(0.325918F),
   REAL_CONST(0.334004F),
   REAL_CONST(0.342170F),
   REAL_CONST(0.350414F),
   REAL_CONST(0.358731F),
   REAL_CONST(0.367119F),
   REAL_CONST(0.375575F),
   REAL_CONST(0.384095F),
   REAL_CONST(0.392676F),
   REAL_CONST(0.401314F),
   REAL_CONST(0.410007F),
   REAL_CONST(0.418750F),
   REAL_CONST(0.427540F),
   REAL_CONST(0.436375F),
   REAL_CONST(0.445250F),
   REAL_CONST(0.454162F),
   REAL_CONST(0.463107F),
   REAL_CONST(0.472083F),
   REAL_CONST(0.481085F),
   REAL_CONST(0.490109F),
   REAL_CONST(0.499154F),
   REAL_CONST(0.508214F),
   REAL_CONST(0.517287F),
   REAL_CONST(0.526369F),
   REAL_CONST(0.535456F),
   REAL_CONST(0.544544F),
   REAL_CONST(0.553631F),
   REAL_CONST(0.562713F),
   REAL_CONST(0.571786F),
   REAL_CONST(0.580846F),
   REAL_CONST(0.589891F),
   REAL_CONST(0.598915F),
   REAL_CONST(0.607917F),
   REAL_CONST(0.616893F),
   REAL_CONST(0.625838F),
   REAL_CONST(0.634750F),
   REAL_CONST(0.643625F),
   REAL_CONST(0.652460F),
   REAL_CONST(0.661250F),
   REAL_CONST(0.669993F),
   REAL_CONST(0.678686F),
   REAL_CONST(0.687324F),
   REAL_CONST(0.695905F),
   REAL_CONST(0.704425F),
   REAL_CONST(0.712881F),
   REAL_CONST(0.721269F),
   REAL_CONST(0.729586F),
   REAL_CONST(0.737830F),
   REAL_CONST(0.745996F),
   REAL_CONST(0.754082F),
   REAL_CONST(0.762084F),
   REAL_CONST(0.770000F),
   REAL_CONST(0.777826F),
   REAL_CONST(0.785559F),
   REAL_CONST(0.793196F),
   REAL_CONST(0.800734F),
   REAL_CONST(0.808171F),
   REAL_CONST(0.815502F),
   REAL_CONST(0.822727F),
   REAL_CONST(0.829840F),
   REAL_CONST(0.836841F),
   REAL_CONST(0.843726F),
   REAL_CONST(0.850492F),
   REAL_CONST(0.857137F),
   REAL_CONST(0.863658F),
   REAL_CONST(0.870053F),
   REAL_CONST(0.876319F),
   REAL_CONST(0.882454F),
   REAL_CONST(0.888455F),
   REAL_CONST(0.894320F),
   REAL_CONST(0.900047F),
   REAL_CONST(0.905633F),
   REAL_CONST(0.911076F),
   REAL_CONST(0.916375F),
   REAL_CONST(0.921527F),
   REAL_CONST(0.926529F),
   REAL_CONST(0.931381F),
   REAL_CONST(0.936080F),
   REAL_CONST(0.940624F),
   REAL_CONST(0.945012F),
   REAL_CONST(0.949242F),
   REAL_CONST(0.953312F),
   REAL_CONST(0.957221F),
   REAL_CONST(0.960967F),
   REAL_CONST(0.964549F),
   REAL_CONST(0.967964F),
   REAL_CONST(0.971213F),
   REAL_CONST(0.974293F),
   REAL_CONST(0.977204F),
   REAL_CONST(0.979944F),
   REAL_CONST(0.982513F),
   REAL_CONST(0.984909F),
   REAL_CONST(0.987131F),
   REAL_CONST(0.989178F),
   REAL_CONST(0.991050F),
   REAL_CONST(0.992746F),
   REAL_CONST(0.994265F),
   REAL_CONST(0.995607F),
   REAL_CONST(0.996771F),
   REAL_CONST(0.997757F),
   REAL_CONST(0.998564F),
   REAL_CONST(0.999192F),
   REAL_CONST(0.999641F),
   REAL_CONST(0.999910F),
   REAL_CONST(1.00000F),
   REAL_CONST(1.00000F),
   REAL_CONST(0.999636F),
   REAL_CONST(0.998546F),
   REAL_CONST(0.996730F),
   REAL_CONST(0.994193F),
   REAL_CONST(0.990937F),
   REAL_CONST(0.986968F),
   REAL_CONST(0.982292F),
   REAL_CONST(0.976917F),
   REAL_CONST(0.970851F),
   REAL_CONST(0.964104F),
   REAL_CONST(0.956687F),
   REAL_CONST(0.948610F),
   REAL_CONST(0.939887F),
   REAL_CONST(0.930532F),
   REAL_CONST(0.920560F),
   REAL_CONST(0.909986F),
   REAL_CONST(0.898826F),
   REAL_CONST(0.887100F),
   REAL_CONST(0.874824F),
   REAL_CONST(0.862019F),
   REAL_CONST(0.848705F),
   REAL_CONST(0.834903F),
   REAL_CONST(0.820635F),
   REAL_CONST(0.805922F),
   REAL_CONST(0.790790F),
   REAL_CONST(0.775260F),
   REAL_CONST(0.759359F),
   REAL_CONST(0.743111F),
   REAL_CONST(0.726542F),
   REAL_CONST(0.709677F),
   REAL_CONST(0.692545F),
   REAL_CONST(0.675171F),
   REAL_CONST(0.657584F),
   REAL_CONST(0.639810F),
   REAL_CONST(0.621879F),
   REAL_CONST(0.603818F),
   REAL_CONST(0.585657F),
   REAL_CONST(0.567423F),
   REAL_CONST(0.549146F),
   REAL_CONST(0.530854F),
   REAL_CONST(0.512577F),
   REAL_CONST(0.494343F),
   REAL_CONST(0.476182F),
   REAL_CONST(0.458121F),
   REAL_CONST(0.440190F),
   REAL_CONST(0.422416F),
   REAL_CONST(0.404829F),
   REAL_CONST(0.387455F),
   REAL_CONST(0.370323F),
   REAL_CONST(0.353458F),
   REAL_CONST(0.336889F),
   REAL_CONST(0.320641F),
   REAL_CONST(0.304740F),
   REAL_CONST(0.289210F),
   REAL_CONST(0.274078F),
   REAL_CONST(0.259365F),
   REAL_CONST(0.245097F),
   REAL_CONST(0.231295F),
   REAL_CONST(0.217981F),
   REAL_CONST(0.205176F),
   REAL_CONST(0.192900F),
   REAL_CONST(0.181174F),
   REAL_CONST(0.170014F),
   REAL_CONST(0.159440F),
   REAL_CONST(0.149468F),
   REAL_CONST(0.140113F),
   REAL_CONST(0.131390F),
   REAL_CONST(0.123313F),
   REAL_CONST(0.115896F),
   REAL_CONST(0.109149F),
   REAL_CONST(0.103083F),
   REAL_CONST(0.0977077F),
   REAL_CONST(0.0930321F),
   REAL_CONST(0.0890632F),
   REAL_CONST(0.0858073F),
   REAL_CONST(0.0832696F),
   REAL_CONST(0.0814541F),
   REAL_CONST(0.0803637F),
   REAL_CONST(0.0800000F)
};

/* correlation weights	*/
static const Float32 corrweight[251] =
{
   0.624805F,
   0.625813F,
   0.626820F,
   0.627827F,
   0.628834F,
   0.630024F,
   0.631031F,
   0.632221F,
   0.633229F,
   0.634419F,
   0.635426F,
   0.636616F,
   0.637623F,
   0.638813F,
   0.640034F,
   0.641224F,
   0.642415F,
   0.643605F,
   0.644826F,
   0.646016F,
   0.647206F,
   0.648427F,
   0.649617F,
   0.651021F,
   0.652211F,
   0.653615F,
   0.654805F,
   0.656209F,
   0.657430F,
   0.658834F,
   0.660207F,
   0.661611F,
   0.663015F,
   0.664418F,
   0.665822F,
   0.667226F,
   0.668630F,
   0.670217F,
   0.671621F,
   0.673208F,
   0.674612F,
   0.676229F,
   0.677816F,
   0.679434F,
   0.681021F,
   0.682607F,
   0.684225F,
   0.685812F,
   0.687613F,
   0.689230F,
   0.691031F,
   0.692831F,
   0.694632F,
   0.696432F,
   0.698233F,
   0.700034F,
   0.702017F,
   0.703818F,
   0.705832F,
   0.707816F,
   0.709616F,
   0.711814F,
   0.713828F,
   0.715812F,
   0.718009F,
   0.720237F,
   0.722221F,
   0.724631F,
   0.726829F,
   0.729026F,
   0.731437F,
   0.733818F,
   0.736229F,
   0.738609F,
   0.741234F,
   0.743614F,
   0.746208F,
   0.748833F,
   0.751610F,
   0.754234F,
   0.757012F,
   0.760033F,
   0.762810F,
   0.765831F,
   0.768822F,
   0.772027F,
   0.775018F,
   0.778222F,
   0.781610F,
   0.785028F,
   0.788415F,
   0.792016F,
   0.795618F,
   0.799219F,
   0.803034F,
   0.807031F,
   0.811029F,
   0.815027F,
   0.819239F,
   0.823634F,
   0.828028F,
   0.832636F,
   0.837428F,
   0.842219F,
   0.847224F,
   0.852412F,
   0.857814F,
   0.863216F,
   0.869015F,
   0.874813F,
   0.881039F,
   0.887417F,
   0.894040F,
   0.901028F,
   0.908231F,
   0.915616F,
   0.923429F,
   0.931639F,
   0.940214F,
   0.960021F,
   1.00000F,
   1.00000F,
   1.00000F,
   1.00000F,
   1.00000F,
   1.00000F,
   1.00000F,
   0.960021F,
   0.940214F,
   0.931639F,
   0.923429F,
   0.915616F,
   0.908231F,
   0.901028F,
   0.894040F,
   0.887417F,
   0.881039F,
   0.874813F,
   0.869015F,
   0.863216F,
   0.857814F,
   0.852412F,
   0.847224F,
   0.842219F,
   0.837428F,
   0.832636F,
   0.828028F,
   0.823634F,
   0.819239F,
   0.815027F,
   0.811029F,
   0.807031F,
   0.803034F,
   0.799219F,
   0.795618F,
   0.792016F,
   0.788415F,
   0.785028F,
   0.781610F,
   0.778222F,
   0.775018F,
   0.772027F,
   0.768822F,
   0.765831F,
   0.762810F,
   0.760033F,
   0.757012F,
   0.754234F,
   0.751610F,
   0.748833F,
   0.746208F,
   0.743614F,
   0.741234F,
   0.738609F,
   0.736229F,
   0.733818F,
   0.731437F,
   0.729026F,
   0.726829F,
   0.724631F,
   0.722221F,
   0.720237F,
   0.718009F,
   0.715812F,
   0.713828F,
   0.711814F,
   0.709616F,
   0.707816F,
   0.705832F,
   0.703818F,
   0.702017F,
   0.700034F,
   0.698233F,
   0.696432F,
   0.694632F,
   0.692831F,
   0.691031F,
   0.689230F,
   0.687613F,
   0.685812F,
   0.684225F,
   0.682607F,
   0.681021F,
   0.679434F,
   0.677816F,
   0.676229F,
   0.674612F,
   0.673208F,
   0.671621F,
   0.670217F,
   0.668630F,
   0.667226F,
   0.665822F,
   0.664418F,
   0.663015F,
   0.661611F,
   0.660207F,
   0.658834F,
   0.657430F,
   0.656209F,
   0.654805F,
   0.653615F,
   0.652211F,
   0.651021F,
   0.649617F,
   0.648427F,
   0.647206F,
   0.646016F,
   0.644826F,
   0.643605F,
   0.642415F,
   0.641224F,
   0.640034F,
   0.638813F,
   0.637623F,
   0.636616F,
   0.635426F,
   0.634419F,
   0.633229F,
   0.632221F,
   0.631031F,
   0.630024F,
   0.628834F,
   0.627827F,
   0.626820F,
   0.625813F,
   0.624805F,
   0.623615F,
   0.622608F,
   0.621632F,
   0.620624F
};


const struct
{
   Word8 max_frac_lag; /* lag up to which fractional lags are used */
   Word8 flag3; /* enable 1/3 instead of 1/6 fract. resolution */
   Word8 first_frac; /* first fractional to check */
   Word8 last_frac; /* last fractional to check */
   Word8 delta_int_low; /* integer lag below TO to start search from */
   Word8 delta_int_range; /* integer range around T0 */
   Word8 delta_frc_low; /* fractional below T0 */
   Word8 delta_frc_range; /* fractional range around T0 */
   Word8 pit_min; /* minimum pitch */

} static mode_dep_parm[8] =
{
   /*
    * MR475
    */
   {
      84, 1, - 2, 2, 5, 10, 5, 9, PIT_MIN
   },
   /*
    * MR515
    */
   {
      84, 1, - 2, 2, 5, 10, 5, 9, PIT_MIN
   },
   /*
    * MR59
    */
   {
      84, 1, - 2, 2, 3, 6, 5, 9, PIT_MIN
   },
   /*
    * MR67
    */
   {
      84, 1, - 2, 2, 3, 6, 5, 9, PIT_MIN
   },
   /*
    * MR74
    */
   {
      84, 1, - 2, 2, 3, 6, 5, 9, PIT_MIN
   },
   /*
    * MR795
    */
   {
      84, 1, - 2, 2, 3, 6, 10, 19, PIT_MIN
   },
   /*
    * MR102
    */
   {
      84, 1, - 2, 2, 3, 6, 5, 9, PIT_MIN
   },
   /*
    * MR122
    */
   {
      94, 0, - 3, 3, 3, 6, 5, 9, PIT_MIN_MR122
   }
};

/* table used inbase 2 logharithm computation */
static const Word32 log2_table[33] =
{
   0,
   1455,
   2866,
   4236,
   5568,
   6863,
   8124,
   9352,
   10549,
   11716,
   12855,
   13967,
   15054,
   16117,
   17156,
   18172,
   19167,
   20142,
   21097,
   22033,
   22951,
   23852,
   24735,
   25603,
   26455,
   27291,
   28113,
   28922,
   29716,
   30497,
   31266,
   32023,
   32767
};

/* table used in 2 to the power computation */
static const Word32 pow2_table[33] =
{
   16384,
   16743,
   17109,
   17484,
   17867,
   18258,
   18658,
   19066,
   19484,
   19911,
   20347,
   20792,
   21247,
   21713,
   22188,
   22674,
   23170,
   23678,
   24196,
   24726,
   25268,
   25821,
   26386,
   26964,
   27554,
   28158,
   28774,
   29405,
   30048,
   30706,
   31379,
   32066,
   32767
};


#endif
